/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.ConfiguratorException;
import net.jxta.exception.JxtaError;
import net.jxta.impl.config.Config;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.membership.pse.PSEConfig;
import net.jxta.impl.peergroup.ConfigDialog;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.Configurator;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.TransportAdvertisement;
import net.jxta.util.AwtUtils;
import net.jxta.util.config.PSESecurityConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DefaultConfigurator
implements Configurator {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$peergroup$DefaultConfigurator == null ? (class$net$jxta$impl$peergroup$DefaultConfigurator = DefaultConfigurator.class$("net.jxta.impl.peergroup.DefaultConfigurator")) : class$net$jxta$impl$peergroup$DefaultConfigurator).getName());
    private static final String configFileName = "PlatformConfig";
    private static final String propertiesFileName = "jxta.properties";
    private File jxtaHomeDir;
    private File configFile;
    private File propertiesFile;
    private PlatformConfig advertisement;
    static /* synthetic */ Class class$net$jxta$impl$peergroup$DefaultConfigurator;

    public DefaultConfigurator() {
        this(null);
    }

    public DefaultConfigurator(PlatformConfig config) {
        block20: {
            this.jxtaHomeDir = new File(Config.JXTA_HOME);
            this.configFile = new File(this.jxtaHomeDir, configFileName);
            this.propertiesFile = new File(this.jxtaHomeDir, propertiesFileName);
            this.advertisement = null;
            this.setPlatformConfig(config);
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                try {
                    LOG.info((Object)("JXTA_HOME = " + this.jxtaHomeDir.getCanonicalPath()));
                }
                catch (IOException caught) {
                    LOG.info((Object)("JXTA_HOME (which doesn't seem to exist) = " + this.jxtaHomeDir.getAbsolutePath()));
                }
            }
            if (this.jxtaHomeDir.exists() && !this.jxtaHomeDir.isDirectory()) {
                throw new IllegalArgumentException("'" + Config.JXTA_HOME + "' is not a directory.");
            }
            if (!this.jxtaHomeDir.exists() && !this.jxtaHomeDir.mkdirs()) {
                throw new IllegalStateException("Could not create '" + Config.JXTA_HOME + "'.");
            }
            this.resetFromResource(configFileName, this.configFile);
            this.resetFromResource(propertiesFileName, this.propertiesFile);
            this.load();
            this.adjustLog4JPriority();
            if (this.fixAdvertisement()) {
                BufferedReader in;
                try {
                    AwtUtils.initAsDaemon();
                    ConfigDialog ignore = new ConfigDialog(this.jxtaHomeDir, this.advertisement);
                    ignore.untilDone();
                    break block20;
                }
                catch (Throwable t) {
                    if (t instanceof JxtaError) {
                        throw (JxtaError)t;
                    }
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Could not initialize graphical config dialog", t);
                    }
                    in = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        while (in.ready()) {
                            in.readLine();
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                System.out.println("The window-based configurator does not seem to be usable.");
                System.out.print("Do you want to stop and edit the current configuration ? [no]: ");
                System.out.flush();
                String answer = "no";
                try {
                    answer = in.readLine();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if ("yes".equalsIgnoreCase(answer)) {
                    try {
                        this.save();
                    }
                    catch (ConfiguratorException ce) {
                        LOG.error((Object)"cant' persist configuration", (Throwable)ce);
                    }
                    System.out.println("Exiting; edit the file \"" + this.configFile.getPath() + "\", remove the file \"reconf\", and then launch JXTA again.");
                    throw new JxtaError("Manual Configuration Requested");
                }
                System.out.println("Attempting to continue using the current configuration.");
            }
        }
        this.adjustLog4JPriority();
        this.finishConfig();
        try {
            this.save();
        }
        catch (ConfiguratorException ce) {
            LOG.error((Object)"can't persist configuration", (Throwable)ce);
        }
    }

    public PlatformConfig getPlatformConfig() {
        return this.advertisement;
    }

    public void setPlatformConfig(PlatformConfig config) {
        if (config != null) {
            this.advertisement = config;
        }
    }

    public boolean save() throws ConfiguratorException {
        return this.save(this.configFile);
    }

    public boolean save(File f) throws ConfiguratorException {
        this.saveTo(f);
        return true;
    }

    public void load() {
        this.loadFrom(this.configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetFromResource(String resourceName, File file) {
        block22: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Checkin resource= " + resourceName + " local= " + file.getPath()));
            }
            try {
                if (file.exists()) {
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)(file.getPath() + " already exists"));
                    }
                    return;
                }
                InputStream in = this.getClass().getResourceAsStream("/" + resourceName);
                if (in == null) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)(resourceName + " does not exist"));
                    }
                    return;
                }
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)(resourceName + " reset " + file.getPath()));
                }
                FileOutputStream out = null;
                try {
                    int got;
                    out = new FileOutputStream(file);
                    int bufferSize = 16384;
                    byte[] buffer = new byte[bufferSize];
                    while ((got = in.read(buffer)) != -1) {
                        out.write(buffer, 0, got);
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                    try {
                        if (null != out) {
                            out.close();
                        }
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (IOException ez) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block22;
                LOG.error((Object)("Cannot reset " + resourceName + " from resource."), (Throwable)ez);
            }
        }
    }

    public void setReconfigure(boolean reconfigure) {
        block6: {
            File f = new File(this.jxtaHomeDir, "reconf");
            if (reconfigure) {
                try {
                    new FileOutputStream(f).close();
                }
                catch (Exception ex1) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block6;
                    LOG.error((Object)"Could not create reconfig flag due to exception : ", (Throwable)ex1);
                    LOG.error((Object)"Create the file 'reconf' by hand before retrying.");
                }
            } else {
                try {
                    f.delete();
                }
                catch (Exception ex1) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block6;
                    LOG.error((Object)"Could not remove reconfig flag due to exception : ", (Throwable)ex1);
                    LOG.error((Object)"Delete the file reconfig by hand before retrying.");
                }
            }
        }
    }

    public boolean isReconfigure() {
        try {
            File file = new File(this.jxtaHomeDir, "reconf");
            boolean forceReconfig = file.exists();
            if (forceReconfig && LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Reconfig required - 'reconf' file found");
            }
            return forceReconfig;
        }
        catch (Exception ex1) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Could not check reconfig flag. Assuming it exists.", (Throwable)ex1);
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Reconfig required - error getting 'reconf' file");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFrom(File file) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Reading Platform Config from : " + file.getAbsolutePath()));
        }
        FileInputStream advStream = null;
        try {
            advStream = new FileInputStream(file);
            this.advertisement = (PlatformConfig)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, advStream);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Recovered Platform Config from : " + file.getAbsolutePath()));
            }
        }
        catch (FileNotFoundException e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Platform Config not found : " + file.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Failed to Recover '" + file.getAbsolutePath() + "' due to : "), (Throwable)e);
            }
            try {
                file.delete();
            }
            catch (Exception ex1) {
                JxtaError failure = new JxtaError("Could not remove " + file.getPath() + ". Removed it by hand before retrying");
                LOG.fatal((Object)failure);
                throw failure;
            }
        }
        finally {
            try {
                if (advStream != null) {
                    advStream.close();
                }
                advStream = null;
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTo(File saveFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(saveFile);
            Document aDoc = this.advertisement.getDocument(MimeMediaType.XMLUTF8);
            aDoc.sendToStream(out);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Could not save to : " + saveFile.getAbsolutePath()), (Throwable)e);
            }
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (Exception ignored) {}
            out = null;
        }
    }

    private String parseHttpProxyServer(String proxy) {
        if (proxy.indexOf(";") >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(proxy, ";");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                if (!token.startsWith("http=")) continue;
                return token;
            }
        }
        return proxy;
    }

    private boolean fixAdvertisement() {
        block59: {
            try {
                boolean secureNeedsReconf;
                String winProxy;
                boolean tcpDisabled;
                TCPAdv tcpAdv;
                boolean httpDisabled;
                HTTPAdv httpAdv;
                StructuredDocument tcp;
                StructuredDocument http;
                boolean reconf;
                block56: {
                    Iterator allIntf;
                    InetAddress intfAddr;
                    boolean found;
                    String interfaceAddress;
                    String cfMode;
                    Element param;
                    block54: {
                        reconf = this.isReconfigure();
                        if (this.advertisement == null) {
                            reconf = true;
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)"Reconfig requested - New PlatformConfig Advertisement");
                            }
                            this.advertisement = (PlatformConfig)AdvertisementFactory.newAdvertisement(PlatformConfig.getAdvertisementType());
                            this.advertisement.setDescription("Platform Config Advertisement created by : " + (class$net$jxta$impl$peergroup$DefaultConfigurator == null ? (class$net$jxta$impl$peergroup$DefaultConfigurator = DefaultConfigurator.class$("net.jxta.impl.peergroup.DefaultConfigurator")) : class$net$jxta$impl$peergroup$DefaultConfigurator).getName());
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)"New PlatformConfig Advertisement - Deleting old PSE");
                            }
                            PSEConfig pse = new PSEConfig(this.jxtaHomeDir);
                            pse.erase();
                        }
                        http = (StructuredTextDocument)this.advertisement.getServiceParam(PeerGroup.httpProtoClassID);
                        tcp = (StructuredTextDocument)this.advertisement.getServiceParam(PeerGroup.tcpProtoClassID);
                        httpAdv = null;
                        httpDisabled = false;
                        tcpAdv = null;
                        tcpDisabled = false;
                        if (http != null) {
                            try {
                                httpDisabled = http.getChildren("isOff").hasMoreElements();
                                param = null;
                                Enumeration httpChilds = http.getChildren(TransportAdvertisement.getAdvertisementType());
                                if (httpChilds.hasMoreElements()) {
                                    param = (Element)httpChilds.nextElement();
                                } else {
                                    httpChilds = http.getChildren(HTTPAdv.getAdvertisementType());
                                    if (httpChilds.hasMoreElements()) {
                                        param = (Element)httpChilds.nextElement();
                                    }
                                }
                                httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
                                cfMode = httpAdv.getConfigMode();
                                if (cfMode == null) {
                                    cfMode = "auto";
                                }
                                if ((interfaceAddress = httpAdv.getInterfaceAddress()) == null || interfaceAddress.equals("")) break block54;
                                found = false;
                                try {
                                    intfAddr = InetAddress.getByName(interfaceAddress);
                                    allIntf = IPUtils.getAllLocalAddresses();
                                    while (allIntf.hasNext()) {
                                        if (!intfAddr.equals(allIntf.next())) continue;
                                        found = true;
                                        break;
                                    }
                                }
                                catch (Throwable ignored) {
                                    // empty catch block
                                }
                                if (!found) {
                                    reconf = true;
                                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                        LOG.info((Object)"Reconfig requested - http set to manual config");
                                    }
                                }
                            }
                            catch (Exception advTrouble) {
                                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                    LOG.warn((Object)"Reconfig requested - http advertisement corrupted", (Throwable)advTrouble);
                                }
                                httpAdv = null;
                            }
                        }
                    }
                    if (httpAdv == null) {
                        reconf = true;
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)"Reconfig requested - http advertisement missing");
                        }
                        httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement(HTTPAdv.getAdvertisementType());
                        httpAdv.setProtocol("http");
                        httpAdv.setPort(9700);
                        httpAdv.setProxyEnabled(false);
                        httpAdv.setServerEnabled(false);
                    }
                    if (tcp != null) {
                        try {
                            tcpDisabled = tcp.getChildren("isOff").hasMoreElements();
                            param = null;
                            Enumeration tcpChilds = tcp.getChildren(TransportAdvertisement.getAdvertisementType());
                            if (tcpChilds.hasMoreElements()) {
                                param = (Element)tcpChilds.nextElement();
                            } else {
                                tcpChilds = tcp.getChildren(TCPAdv.getAdvertisementType());
                                if (tcpChilds.hasMoreElements()) {
                                    param = (Element)tcpChilds.nextElement();
                                }
                            }
                            tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
                            cfMode = tcpAdv.getConfigMode();
                            if (cfMode == null) {
                                cfMode = "auto";
                            }
                            if ((interfaceAddress = tcpAdv.getInterfaceAddress()) == null || interfaceAddress.equals("")) break block56;
                            found = false;
                            try {
                                intfAddr = InetAddress.getByName(interfaceAddress);
                                allIntf = IPUtils.getAllLocalAddresses();
                                while (allIntf.hasNext()) {
                                    if (!intfAddr.equals(allIntf.next())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            catch (Throwable ignored) {
                                // empty catch block
                            }
                            if (!found) {
                                reconf = true;
                                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                    LOG.info((Object)"Reconfig requested - tcp set to manual config");
                                }
                            }
                        }
                        catch (Exception advTrouble) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)"Reconfig requested - tcp advertisement corrupted", (Throwable)advTrouble);
                            }
                            tcpAdv = null;
                        }
                    }
                }
                if (tcpAdv == null) {
                    int port;
                    block58: {
                        reconf = true;
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)"Reconfig requested - tcp advertisement missing, making a new one.");
                        }
                        port = 9701;
                        String tcpPort = System.getProperty("jxta.tcp.port");
                        if (tcpPort != null) {
                            try {
                                int propertyPort = Integer.parseInt(tcpPort);
                                if (propertyPort < 65536 && propertyPort >= 0) {
                                    port = propertyPort;
                                } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                    LOG.warn((Object)("Property 'jxta.tcp.port' is not a valid port number : " + propertyPort));
                                }
                            }
                            catch (NumberFormatException ignored) {
                                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block58;
                                LOG.warn((Object)("Property 'jxta.tcp.port' was not an integer : " + tcpPort));
                            }
                        }
                    }
                    tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement(TCPAdv.getAdvertisementType());
                    tcpAdv.setProtocol("TCP");
                    tcpAdv.setPort(port);
                    tcpAdv.setMulticastAddr("224.0.1.85");
                    tcpAdv.setMulticastPort(1234);
                    tcpAdv.setMulticastSize(16384);
                    tcpAdv.setMulticastState(true);
                    tcpAdv.setServer("");
                    tcpAdv.setInterfaceAddress("");
                }
                if ((winProxy = System.getProperty("jxta.proxy")) != null) {
                    String proxyServer = this.parseHttpProxyServer(winProxy);
                    if (proxyServer != null) {
                        httpAdv.setProxyEnabled(true);
                        httpAdv.setProxy(proxyServer.substring(proxyServer.indexOf("=") + 1));
                        String proxyUser = System.getProperty("jxta.proxy.user");
                        String proxyPassword = System.getProperty("jxta.proxy.password");
                        if (proxyUser != null && proxyPassword != null) {
                            char[] proxyPass = proxyPassword.toCharArray();
                            PasswordAuthentication pass = new PasswordAuthentication(proxyUser, proxyPass);
                            Authenticator.setDefault(new ProxyAuthenticator(pass));
                        }
                        System.setProperty("jxta.proxy.user", "");
                        System.setProperty("jxta.proxy.password", "");
                    }
                } else if (httpAdv.getProxy() == null) {
                    httpAdv.setProxy("myProxy.myDomain:8080");
                    httpAdv.setProxyEnabled(false);
                }
                boolean bl = secureNeedsReconf = !PSEConfig.isInitialized(this.jxtaHomeDir);
                if (secureNeedsReconf) {
                    this.advertisement.removeServiceParam(PeerGroup.membershipClassID);
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)"Reconfig requested - PSE wanted config");
                    }
                }
                if (null != System.getProperty("net.jxta.tls.principal") && null != System.getProperty("net.jxta.tls.password")) {
                    secureNeedsReconf = false;
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Bypassing Security config UI");
                    }
                }
                reconf |= secureNeedsReconf;
                StructuredTextDocument proxy = (StructuredTextDocument)this.advertisement.getServiceParam(PeerGroup.proxyClassID);
                if (null == proxy) {
                    proxy = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                    proxy.appendChild(proxy.createElement((Object)"isOff"));
                    this.advertisement.putServiceParam(PeerGroup.proxyClassID, proxy);
                }
                if (!reconf) {
                    return false;
                }
                http = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredDocumentUtils.copyElements(http, http, (StructuredDocument)httpAdv.getDocument(MimeMediaType.XMLUTF8));
                if (httpDisabled) {
                    http.appendChild(http.createElement("isOff"));
                }
                this.advertisement.putServiceParam(PeerGroup.httpProtoClassID, http);
                tcp = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredDocumentUtils.copyElements(tcp, tcp, (StructuredDocument)tcpAdv.getDocument(MimeMediaType.XMLUTF8));
                if (tcpDisabled) {
                    tcp.appendChild(tcp.createElement("isOff"));
                }
                this.advertisement.putServiceParam(PeerGroup.tcpProtoClassID, tcp);
            }
            catch (Exception serious) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block59;
                LOG.warn((Object)"Trouble while fixing advertisement. Hope for the best.", (Throwable)serious);
            }
        }
        return true;
    }

    private boolean finishConfig() {
        if (!PSEConfig.isInitialized(this.jxtaHomeDir)) {
            try {
                PSESecurityConfigurator secConf = new PSESecurityConfigurator(System.getProperty("net.jxta.tls.principal", this.advertisement.getName()), System.getProperty("net.jxta.tls.password"), this.jxtaHomeDir);
                secConf.save(this.advertisement);
            }
            catch (IOException failure) {
                return false;
            }
        }
        return true;
    }

    private void adjustLog4JPriority() {
        if (this.advertisement == null || this.advertisement.getDebugLevel() == null) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Log4J logging preference not set, using defaults");
            }
            return;
        }
        String requestedLevel = this.advertisement.getDebugLevel();
        if ("user default".equals(requestedLevel)) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Log4J [user default] requested, not adjusting logging priority");
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Setting Log4J priority to [" + requestedLevel + "] based on the user's configuration"));
        }
        Logger jxtaLogger = Logger.getLogger((String)"net.jxta");
        jxtaLogger.setLevel(Level.toLevel((String)requestedLevel));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ProxyAuthenticator
    extends Authenticator {
        PasswordAuthentication password = null;

        public ProxyAuthenticator(PasswordAuthentication password) {
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.password;
        }
    }
}

