/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.impl.pipe.PipeRegistrar;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class InputPipeImpl
implements EndpointListener,
InputPipe {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$pipe$InputPipeImpl == null ? (class$net$jxta$impl$pipe$InputPipeImpl = InputPipeImpl.class$("net.jxta.impl.pipe.InputPipeImpl")) : class$net$jxta$impl$pipe$InputPipeImpl).getName());
    protected static final int QUEUESIZE = 100;
    protected PipeRegistrar registrar = null;
    protected PipeAdvertisement pipeAdv = null;
    protected PipeID pipeID = null;
    protected volatile boolean closed = false;
    protected PipeMsgListener listener = null;
    protected UnbiasedQueue queue = null;
    static /* synthetic */ Class class$net$jxta$impl$pipe$InputPipeImpl;

    InputPipeImpl(PipeRegistrar r, PipeAdvertisement adv) throws IOException {
        this(r, adv, null);
    }

    InputPipeImpl(PipeRegistrar r, PipeAdvertisement adv, PipeMsgListener listener) throws IOException {
        this.registrar = r;
        this.pipeAdv = adv;
        this.listener = listener;
        this.pipeID = (PipeID)adv.getPipeID();
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Creating InputPipe for " + this.pipeID + " of type " + adv.getType() + " with " + (null != listener ? "listener" : "queue")));
        }
        if (!this.registrar.register(this)) {
            throw new IOException("Could not register input pipe (already registered) for " + this.pipeID);
        }
        if (listener == null) {
            this.queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue(100, true));
        }
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        if (!this.closed && LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"Pipe is being finalized without being previously closed. This is likely a bug.");
        }
        this.close();
    }

    public Message waitForMessage() throws InterruptedException {
        return this.poll(0);
    }

    public Message poll(int timeout) throws InterruptedException {
        if (this.listener == null) {
            return (Message)this.queue.pop(timeout);
        }
        if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"poll() has no effect in listener mode.");
        }
        return null;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (null == this.listener) {
            this.queue.close();
        }
        if (!this.registrar.forget(this) && LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"close() : pipe was not registered with registrar.");
        }
        this.listener = null;
        this.registrar = null;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("close(): Closed " + this.pipeID));
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        block13: {
            if (this.closed) {
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("processIncomingMessage: received " + msg + " on pipe : " + this.pipeID));
            }
            if (null != this.listener) {
                PipeMsgEvent event = new PipeMsgEvent(this, msg, this.pipeID);
                try {
                    this.listener.pipeMsgEvent(event);
                }
                catch (Throwable ignored) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)("Uncaught Throwable in listener for : " + this.pipeID + "(" + this.listener.getClass().getName() + ")"), ignored);
                    }
                    break block13;
                }
            }
            boolean pushed = false;
            while (!pushed && !this.queue.isClosed()) {
                try {
                    pushed = this.queue.push(msg, 1000L);
                }
                catch (InterruptedException woken) {
                    Thread.interrupted();
                }
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                InputPipeImpl inputPipeImpl = this;
                synchronized (inputPipeImpl) {
                    LOG.debug((Object)("Queued " + msg + " for " + this.pipeID + "\n\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued()));
                }
            }
        }
    }

    public String getType() {
        return this.pipeAdv.getType();
    }

    public ID getPipeID() {
        return this.pipeID;
    }

    public String getName() {
        return this.pipeAdv.getName();
    }

    public PipeAdvertisement getAdvertisement() {
        return this.pipeAdv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

