/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.pipe.NonBlockingOutputPipe;
import net.jxta.impl.pipe.NonBlockingWireOutputPipe;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.impl.pipe.PipeServiceInterface;
import net.jxta.impl.pipe.SecureInputPipeImpl;
import net.jxta.impl.pipe.SecureOutputPipe;
import net.jxta.impl.pipe.UnicastInputPipeImpl;
import net.jxta.impl.pipe.WirePipeImpl;
import net.jxta.impl.util.TimeUtils;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PipeServiceImpl
implements PipeService,
PipeResolver.Listener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$pipe$PipeServiceImpl == null ? (class$net$jxta$impl$pipe$PipeServiceImpl = PipeServiceImpl.class$("net.jxta.impl.pipe.PipeServiceImpl")) : class$net$jxta$impl$pipe$PipeServiceImpl).getName());
    static final long VERIFYINTERVAL = 1200000L;
    private PeerGroup myGroup = null;
    private PipeResolver pipeResolver = null;
    private WirePipeImpl wirePipe = null;
    private PipeService myInterface = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private Map outputPipeListeners = new Hashtable();
    private volatile boolean started = false;
    static /* synthetic */ Class class$net$jxta$impl$pipe$PipeServiceImpl;

    public synchronized Service getInterface() {
        if (null == this.myInterface) {
            this.myInterface = new PipeServiceInterface(this);
        }
        return this.myInterface;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public synchronized void init(PeerGroup pg, ID assignedID, Advertisement impl) {
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.myGroup = pg;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Pipe Service : " + assignedID);
            configInfo.append("\n\tImplementation :");
            configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + this.myGroup.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + this.myGroup.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + this.myGroup.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tVerify Interval : 1200000ms");
            LOG.info((Object)configInfo);
        }
    }

    public synchronized int startApp(String[] args) {
        this.pipeResolver = new PipeResolver(this.myGroup);
        this.wirePipe = new WirePipeImpl(this.myGroup, this.pipeResolver);
        this.wirePipe.startApp(args);
        this.started = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopApp() {
        this.started = false;
        try {
            block8: {
                try {
                    if (this.wirePipe == null) break block8;
                    this.wirePipe.stopApp();
                }
                catch (Throwable failed) {
                    LOG.error((Object)"Failed to stop wire pipe.", failed);
                    Object var3_2 = null;
                    this.wirePipe = null;
                }
            }
            Object var3_1 = null;
            this.wirePipe = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.wirePipe = null;
            throw throwable;
        }
        try {
            block10: {
                try {
                    if (this.pipeResolver == null) break block10;
                    this.pipeResolver.stop();
                }
                catch (Throwable failed) {
                    LOG.error((Object)"Failed to stop pipe resolver.", failed);
                    Object var5_8 = null;
                    this.pipeResolver = null;
                }
            }
            Object var5_7 = null;
            this.pipeResolver = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.pipeResolver = null;
            throw throwable;
        }
        this.myGroup = null;
        this.myInterface = null;
        this.outputPipeListeners.clear();
    }

    public InputPipe createInputPipe(PipeAdvertisement adv) throws IOException {
        return this.createInputPipe(adv, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputPipe createInputPipe(PipeAdvertisement adv, PipeMsgListener listener) throws IOException {
        void var5_9;
        if (!this.started) {
            throw new IllegalStateException("Pipe Service has not been started or has been stopped");
        }
        String type = adv.getType();
        PipeID pipeId = (PipeID)adv.getPipeID();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Create " + type + " InputPipe for " + pipeId));
        }
        Object var5_5 = null;
        if (type.equals("JxtaUnicast")) {
            UnicastInputPipeImpl unicastInputPipeImpl = new UnicastInputPipeImpl(this.pipeResolver, adv, listener);
            return var5_9;
        } else if (type.equals("JxtaUnicastSecure")) {
            SecureInputPipeImpl secureInputPipeImpl = new SecureInputPipeImpl(this.pipeResolver, adv, listener);
            return var5_9;
        } else if (type.equals("JxtaPropagate")) {
            if (this.wirePipe == null) throw new IOException("No propagated pipe servive available");
            InputPipe inputPipe = this.wirePipe.createInputPipe(adv, listener);
            return var5_9;
        } else {
            if (!LOG.isEnabledFor((Priority)Level.ERROR)) throw new IOException("Cannot create pipe for unknown type : " + type);
            LOG.error((Object)("Cannot create pipe for unknown type : " + type));
            throw new IOException("Cannot create pipe for unknown type : " + type);
        }
    }

    public OutputPipe createOutputPipe(PipeAdvertisement pipeAdv, long timeout) throws IOException {
        return this.createOutputPipe(pipeAdv, Collections.EMPTY_SET, timeout);
    }

    public OutputPipe createOutputPipe(PipeAdvertisement pipeAdv, PeerID peerid, long timeout) throws IOException {
        return this.createOutputPipe(pipeAdv, Collections.singleton(peerid), timeout);
    }

    public OutputPipe createOutputPipe(PipeAdvertisement adv, Enumeration resolvablePeers, long timeout) throws IOException {
        HashSet peerSet = new HashSet();
        while (resolvablePeers.hasMoreElements()) {
            peerSet.add(resolvablePeers.nextElement());
        }
        if (peerSet.isEmpty()) {
            throw new IllegalArgumentException("peers enumeration must not be empty");
        }
        return this.createOutputPipe(adv, Collections.unmodifiableSet(peerSet), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OutputPipe createOutputPipe(PipeAdvertisement adv, Set resolvablePeers, long timeout) throws IOException {
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        if (timeout < 0L) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Negative resolve timeouts are deprecated. Using 20000");
            }
            timeout = 20000L;
        }
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(timeout);
        syncListener localListener = new syncListener();
        this.createOutputPipe(adv, resolvablePeers, (OutputPipeListener)localListener);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Waiting synchronously for " + timeout + "ms to resolve OutputPipe for " + adv.getPipeID()));
        }
        try {
            syncListener syncListener2 = localListener;
            synchronized (syncListener2) {
                while (true) {
                    if (null != localListener.event || TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), absoluteTimeOut) >= 0L) {
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 6, 12] lbl17 : MonitorExitStatement: MONITOREXIT : var8_6
                        Object var12_8 = null;
                        this.removeOutputPipeListener(adv.getPipeID().toString(), localListener);
                        break;
                    }
                    try {
                        localListener.wait(1000L);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            this.removeOutputPipeListener(adv.getPipeID().toString(), localListener);
            throw throwable;
        }
        if (null != localListener.event) {
            return localListener.event.getOutputPipe();
        }
        throw new IOException("Output Pipe could not be resolved after " + timeout + "ms.");
    }

    public void createOutputPipe(PipeAdvertisement pipeAdv, OutputPipeListener listener) throws IOException {
        this.createOutputPipe(pipeAdv, Collections.EMPTY_SET, listener);
    }

    public void createOutputPipe(PipeAdvertisement pipeAdv, PeerID peerid, OutputPipeListener listener) throws IOException {
        this.createOutputPipe(pipeAdv, Collections.singleton(peerid), listener);
    }

    public void createOutputPipe(PipeAdvertisement pipeAdv, Set resolvablePeers, OutputPipeListener listener) throws IOException {
        if (!this.started) {
            throw new IllegalStateException("Pipe Service has not been started or has been stopped");
        }
        PipeID pipeId = (PipeID)pipeAdv.getPipeID();
        String type = pipeAdv.getType();
        if (null == type) {
            IllegalArgumentException failed = new IllegalArgumentException("Pipe type was not set");
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)failed, (Throwable)failed);
            }
            throw failed;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Create " + type + " OutputPipe for " + pipeId));
        }
        if ("JxtaPropagate".equals(type)) {
            block16: {
                NonBlockingWireOutputPipe op = null;
                if (this.wirePipe == null) {
                    throw new IOException("No propagated pipe service available");
                }
                op = this.wirePipe.createOutputPipe(pipeAdv, resolvablePeers);
                if (null != op) {
                    OutputPipeEvent newevent = new OutputPipeEvent(this.getInterface(), op, pipeId.toString(), 0);
                    try {
                        listener.outputPipeEvent(newevent);
                    }
                    catch (Throwable ignored) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block16;
                        LOG.error((Object)("Uncaught Throwable in listener for " + pipeId + " (" + listener.getClass().getName() + ")"), ignored);
                    }
                }
            }
            return;
        }
        if ("JxtaUnicast".equals(type) || "JxtaUnicastSecure".equals(type)) {
            InputPipe local;
            this.outputPipeListeners.put(pipeId, new OutputPipeHolder(pipeAdv, resolvablePeers, listener));
            this.pipeResolver.addListener(pipeId, this, 0);
            int queryid = this.pipeResolver.sendPipeQuery(pipeAdv, resolvablePeers, 0);
            if ((resolvablePeers.isEmpty() || resolvablePeers.contains(this.myGroup.getPeerID())) && null != (local = this.pipeResolver.findLocal(pipeId))) {
                if (local.getType().equals(pipeAdv.getType())) {
                    this.pipeResolver.callListener(queryid, pipeId, local.getType(), this.myGroup.getPeerID(), false);
                } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("rejecting local pipe (" + local.getType() + ") because type is not (" + pipeAdv.getType() + ")"));
                }
            }
        } else {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)("createOutputPipe: cannot create pipe for unknown type : " + type));
            }
            throw new IOException("cannot create pipe for unknown type : " + type);
        }
    }

    public Message createMessage() {
        LOG.warn((Object)"Obsoleted, call through the interface object if you want to use this API");
        throw new UnsupportedOperationException("Obsoleted, call through the interface object if you want to use this API");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputPipeListener removeOutputPipeListener(String opID, OutputPipeListener listener) {
        PipeID pipeID;
        if (this.pipeResolver == null) {
            return null;
        }
        try {
            URL aPipeID = IDFactory.jxtaURL(opID);
            pipeID = (PipeID)IDFactory.fromURL(aPipeID);
        }
        catch (MalformedURLException badID) {
            throw new IllegalArgumentException("Bad pipe ID: " + opID);
        }
        catch (UnknownServiceException badID) {
            throw new IllegalArgumentException("Unusable pipe ID: " + opID);
        }
        catch (ClassCastException badID) {
            throw new IllegalArgumentException("id was not a pipe id: " + opID);
        }
        Map map = this.outputPipeListeners;
        synchronized (map) {
            OutputPipeHolder pl = (OutputPipeHolder)this.outputPipeListeners.get(pipeID);
            if (null != pl && pl.listener == listener) {
                this.pipeResolver.removeListener(pipeID, 0);
                this.outputPipeListeners.remove(pipeID);
                return listener;
            }
        }
        return null;
    }

    public boolean pipeResolveEvent(PipeResolver.Event e) {
        block14: {
            try {
                OutputPipeHolder pl = (OutputPipeHolder)this.outputPipeListeners.get(e.getPipeID());
                PeerID peerID = e.getPeerID();
                if (null != pl) {
                    block13: {
                        if (!pl.peers.isEmpty() && !pl.peers.contains(peerID)) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)("Event was for wrong peer '" + peerID + "'. Discarding."));
                            }
                            return false;
                        }
                        String type = pl.adv.getType();
                        NonBlockingOutputPipe op = null;
                        if ("JxtaUnicast".equals(type)) {
                            op = new NonBlockingOutputPipe(this.myGroup, this.pipeResolver, pl.adv, peerID, pl.peers);
                        } else if ("JxtaUnicastSecure".equals(type)) {
                            op = new SecureOutputPipe(this.myGroup, this.pipeResolver, pl.adv, peerID, pl.peers);
                        } else {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)("Could not create output pipe of type '" + type + "'. Discarding."));
                            }
                            return false;
                        }
                        OutputPipeEvent newevent = new OutputPipeEvent(this.getInterface(), op, e.getPipeID().toString(), e.getQueryID());
                        try {
                            pl.listener.outputPipeEvent(newevent);
                        }
                        catch (Throwable ignored) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block13;
                            LOG.error((Object)("Uncaught Throwable in listener for " + e.getPipeID() + "(" + pl.getClass().getName() + ")"), ignored);
                        }
                    }
                    return true;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("No listener for event for " + e.getPipeID()));
                }
            }
            catch (IOException ie) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block14;
                LOG.error((Object)("Error creating output pipe " + e.getPipeID()), (Throwable)ie);
            }
        }
        return false;
    }

    public boolean pipeNAKEvent(PipeResolver.Event e) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class syncListener
    implements OutputPipeListener {
        volatile OutputPipeEvent event = null;

        syncListener() {
        }

        public synchronized void outputPipeEvent(OutputPipeEvent event) {
            if (null == this.event) {
                this.event = event;
                this.notifyAll();
            }
        }
    }

    private static class OutputPipeHolder {
        PipeAdvertisement adv;
        Set peers;
        OutputPipeListener listener;

        OutputPipeHolder(PipeAdvertisement adv, Set peers, OutputPipeListener listener) {
            this.adv = adv;
            this.peers = peers;
            this.listener = listener;
        }
    }
}

