/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.DiscoveryQueryMsg;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DiscoveryQuery
extends DiscoveryQueryMsg {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$DiscoveryQuery == null ? (class$net$jxta$impl$protocol$DiscoveryQuery = DiscoveryQuery.class$("net.jxta.impl.protocol.DiscoveryQuery")) : class$net$jxta$impl$protocol$DiscoveryQuery).getName());
    private static final String typeTag = "Type";
    private static final String peerAdvTag = "PeerAdv";
    private static final String thresholdTag = "Threshold";
    private static final String queryAttrTag = "Attr";
    private static final String queryValueTag = "Value";
    static /* synthetic */ Class class$net$jxta$impl$protocol$DiscoveryQuery;
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public DiscoveryQuery() {
    }

    public DiscoveryQuery(InputStream stream) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, stream);
        this.initialize(doc);
    }

    public DiscoveryQuery(TextElement doc) {
        if (!DiscoveryQueryMsg.getAdvertisementType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.initialize(doc);
    }

    protected boolean handleElement(TextElement elem) {
        if (elem.getName().equals(typeTag)) {
            this.setDiscoveryType(Integer.parseInt(elem.getTextValue()));
            return true;
        }
        if (elem.getName().equals(thresholdTag)) {
            this.setThreshold(Integer.parseInt(elem.getTextValue()));
            return true;
        }
        if (elem.getName().equals(peerAdvTag)) {
            this.setPeerAdv(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(queryAttrTag)) {
            this.setAttr(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(queryValueTag)) {
            this.setValue(elem.getTextValue());
            return true;
        }
        return false;
    }

    protected void initialize(Element root) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = DiscoveryQuery.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        if (!doc.getName().equals(DiscoveryQueryMsg.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.setDiscoveryType(-1);
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
            LOG.warn((Object)("Unhandleded element '" + elem.getName() + "' in " + doc.getName()));
        }
        if (this.getThreshold() <= 0) {
            throw new IllegalArgumentException("Threshold must not be less than zero.");
        }
        if (null == this.getAttr() && null != this.getValue()) {
            throw new IllegalArgumentException("Value specified without attribute.");
        }
        if (0 != this.getDiscoveryType() && 1 != this.getDiscoveryType() && 2 != this.getDiscoveryType()) {
            throw new IllegalArgumentException("Type is not one of the required values.");
        }
    }

    public Document getDocument(MimeMediaType asMimeType) {
        String attr;
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, DiscoveryQueryMsg.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Element e = adv.createElement((Object)typeTag, (Object)Integer.toString(this.getDiscoveryType()));
        adv.appendChild(e);
        int threshold = this.getThreshold();
        if (threshold < 0) {
            throw new IllegalStateException("threshold must be >= 0");
        }
        e = adv.createElement((Object)thresholdTag, (Object)Integer.toString(threshold));
        adv.appendChild(e);
        String peerAdv = this.getPeerAdv();
        if (peerAdv != null && peerAdv.length() > 0) {
            e = adv.createElement((Object)peerAdvTag, (Object)this.getPeerAdv());
            adv.appendChild(e);
        }
        if ((attr = this.getAttr()) != null && attr.length() > 0) {
            e = adv.createElement((Object)queryAttrTag, (Object)attr.trim());
            adv.appendChild(e);
            String value = this.getValue();
            if (value != null && value.length() > 0) {
                e = adv.createElement((Object)queryValueTag, (Object)value.trim());
                adv.appendChild(e);
            } else if (threshold < 0) {
                throw new IllegalStateException("Attribute specified, but no value was specified.");
            }
        }
        return adv;
    }

    public String toString() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

