/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DiscoveryResponse
extends DiscoveryResponseMsg {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$DiscoveryResponse == null ? (class$net$jxta$impl$protocol$DiscoveryResponse = DiscoveryResponse.class$("net.jxta.impl.protocol.DiscoveryResponse")) : class$net$jxta$impl$protocol$DiscoveryResponse).getName());
    private static final String countTag = "Count";
    private static final String expirationTag = "Expiration";
    private static final String peerAdvTag = "PeerAdv";
    private static final String queryAttrTag = "Attr";
    private static final String queryValueTag = "Value";
    private static final String responsesTag = "Response";
    private static final String typeTag = "Type";
    static /* synthetic */ Class class$net$jxta$impl$protocol$DiscoveryResponse;
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public DiscoveryResponse(InputStream stream) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, stream);
        this.readIt(doc);
    }

    public DiscoveryResponse(int count, int type, String peeradv, String attr, String value, Vector responses, Vector expirations) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("DiscoveryResponse.<init>:  response count = " + responses.size()));
        }
        this.setResponseCount(count);
        this.setDiscoveryType(type);
        this.setPeerAdv(peeradv);
        this.setQueryAttr(attr);
        this.setQueryValue(value);
        this.setResponses(responses);
        this.setExpirations(expirations);
    }

    public DiscoveryResponse(Element root) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = DiscoveryResponse.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        String docName = doc.getName();
        if (!DiscoveryResponseMsg.getAdvertisementType().equals(docName)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a " + docName);
        }
        this.readIt(doc);
    }

    public Enumeration getAdvertisements() {
        if (this.responses != null) {
            if (this.advertisements == null) {
                this.parseAdvertisements();
            }
            return this.advertisements.elements();
        }
        return null;
    }

    public Document getDocument(MimeMediaType asMimeType) {
        StructuredTextDocument adv;
        block6: {
            adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, DiscoveryResponseMsg.getAdvertisementType());
            if (adv instanceof Attributable) {
                ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
            }
            TextElement e = adv.createElement(countTag, Integer.toString(this.count));
            adv.appendChild((Element)e);
            e = adv.createElement(typeTag, Integer.toString(this.type));
            adv.appendChild((Element)e);
            e = adv.createElement(peerAdvTag, this.getPeerAdv());
            adv.appendChild((Element)e);
            if (this.attr != null && this.attr.length() > 0) {
                e = adv.createElement(queryAttrTag, this.getQueryAttr());
                adv.appendChild((Element)e);
                if (this.value != null && this.value.length() > 0) {
                    e = adv.createElement(queryValueTag, this.value);
                    adv.appendChild((Element)e);
                }
            }
            Enumeration advs = this.getResponses();
            Enumeration exps = this.getExpirations();
            boolean stream = this.responses.elementAt(0) instanceof InputStream;
            try {
                while (advs.hasMoreElements()) {
                    Long l = (Long)exps.nextElement();
                    e = stream ? adv.createElement(responsesTag, this.streamToString((InputStream)advs.nextElement())) : adv.createElement(responsesTag, (String)advs.nextElement());
                    adv.appendChild((Element)e);
                    ((Attributable)((Object)e)).addAttribute(expirationTag, l.toString());
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block6;
                LOG.debug((Object)"Got an Exception during doc creation ", (Throwable)ex);
            }
        }
        return adv;
    }

    public PeerAdvertisement getPeerAdvertisement() {
        block2: {
            if (this.peeradv == null || this.peerAdvertisement != null) break block2;
            try {
                this.peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, new StringReader(this.peeradv));
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                LOG.debug((Object)"error constructing src peer advertisement", (Throwable)e);
            }
        }
        return this.peerAdvertisement;
    }

    private void parseAdvertisements() {
        if (this.responses == null || this.responses.size() == 0) {
            return;
        }
        this.advertisements = new Vector();
        boolean stream = this.responses.elementAt(0) instanceof ByteArrayInputStream;
        if (this.responses != null) {
            int i = 0;
            while (i < this.responses.size()) {
                block12: {
                    Advertisement adv;
                    if (!stream) {
                        String str = (String)this.responses.elementAt(i);
                        if (str != null) {
                            try {
                                adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, new StringReader(str));
                                this.advertisements.addElement(adv);
                            }
                            catch (Exception e) {
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)"Can not parse Response", (Throwable)e);
                                }
                            }
                        }
                    } else {
                        ByteArrayInputStream bais = (ByteArrayInputStream)this.responses.elementAt(i);
                        if (bais != null) {
                            try {
                                adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, bais);
                                this.advertisements.addElement(adv);
                            }
                            catch (Exception e) {
                                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block12;
                                LOG.debug((Object)"Can not parse Response", (Throwable)e);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        this.setAdvertisements(this.advertisements);
    }

    private void readIt(TextElement doc) {
        Vector<String> res = new Vector<String>();
        Vector<Long> exps = new Vector<Long>();
        try {
            Enumeration elements = doc.getChildren();
            while (elements.hasMoreElements()) {
                long exp;
                TextElement elem = (TextElement)elements.nextElement();
                if (elem.getName().equals(countTag)) {
                    this.count = Integer.parseInt(elem.getTextValue());
                    continue;
                }
                if (elem.getName().equals(typeTag)) {
                    this.type = Integer.parseInt(elem.getTextValue());
                    continue;
                }
                if (elem.getName().equals(peerAdvTag)) {
                    this.setPeerAdv(elem.getTextValue());
                    continue;
                }
                if (elem.getName().equals(queryAttrTag)) {
                    this.setQueryAttr(elem.getTextValue());
                    continue;
                }
                if (elem.getName().equals(queryValueTag)) {
                    this.setQueryValue(elem.getTextValue());
                    continue;
                }
                if (!elem.getName().equals(responsesTag)) continue;
                String aResponse = elem.getTextValue();
                if (null == aResponse) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)"Discarding an empty response tag");
                    continue;
                }
                res.addElement(aResponse);
                Attribute attr = ((Attributable)((Object)elem)).getAttribute(expirationTag);
                if (null == attr) {
                    exps.addElement(new Long(0x6DDD00L));
                    continue;
                }
                String expstr = attr.getValue();
                if (null != expstr) {
                    exp = Long.parseLong(expstr);
                } else {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Received an old-style DiscoveryResponse.\n You received a response from a peer that does \nnot support advertisement aging. \nSetting expiration to DiscoveryService.DEFAULT_EXPIRATION ");
                    }
                    exp = 0x6DDD00L;
                }
                exps.addElement(new Long(exp));
            }
        }
        catch (Exception mye) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Got an Exception during Parse ", (Throwable)mye);
            }
            throw new IllegalStateException("Got an Exception during parse" + mye.getMessage());
        }
        this.setResponses(res);
        this.setExpirations(exps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String streamToString(InputStream is) {
        StringWriter stw;
        block17: {
            int c;
            stw = new StringWriter();
            InputStreamReader reader = new InputStreamReader(is);
            char[] buf = new char[512];
            while ((c = reader.read(buf)) != -1) {
                stw.write(buf, 0, c);
            }
            Object var8_7 = null;
            try {
                is.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                stw.close();
            }
            catch (IOException ignored) {}
            break block17;
            {
                catch (IOException ie) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Got an Exception during stream conversion", (Throwable)ie);
                    }
                    String string = null;
                    Object var8_8 = null;
                    try {
                        is.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    try {
                        stw.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    is.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                try {
                    stw.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return stw.toString();
    }

    public String toString() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

