/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ModuleSpecAdv
extends ModuleSpecAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$ModuleSpecAdv == null ? (class$net$jxta$impl$protocol$ModuleSpecAdv = ModuleSpecAdv.class$("net.jxta.impl.protocol.ModuleSpecAdv")) : class$net$jxta$impl$protocol$ModuleSpecAdv).getName());
    private static final String idTag = "MSID";
    private static final String nameTag = "Name";
    private static final String creatorTag = "Crtr";
    private static final String uriTag = "SURI";
    private static final String versTag = "Vers";
    private static final String descTag = "Desc";
    private static final String paramTag = "Parm";
    private static final String proxyIdTag = "Proxy";
    private static final String authIdTag = "Auth";
    private static final String[] fields = new String[]{"Name", "MSID"};
    static /* synthetic */ Class class$net$jxta$impl$protocol$ModuleSpecAdv;
    static /* synthetic */ Class class$net$jxta$document$XMLElement;

    public ModuleSpecAdv() {
        this.setDescription(null);
        this.setName(null);
        this.setModuleSpecID(null);
        this.setCreator(null);
        this.setSpecURI(null);
        this.setVersion(null);
        this.setDescription(null);
        this.setPipeAdvertisement(null);
        this.setProxySpecID(null);
        this.setAuthSpecID(null);
        this.setParam(null);
    }

    public ModuleSpecAdv(Element root) {
        if (!(class$net$jxta$document$XMLElement == null ? (class$net$jxta$document$XMLElement = ModuleSpecAdv.class$("net.jxta.document.XMLElement")) : class$net$jxta$document$XMLElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(ModuleSpecAdvertisement.getAdvertisementType()) && !ModuleSpecAdvertisement.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        String nm = elem.getName();
        if (nm.equals(nameTag)) {
            this.setName(elem.getTextValue());
            return true;
        }
        if (nm.equals(descTag)) {
            this.setDescription(elem.getTextValue());
            return true;
        }
        if (nm.equals(idTag)) {
            try {
                URL spID = IDFactory.jxtaURL(elem.getTextValue());
                this.setModuleSpecID((ModuleSpecID)IDFactory.fromURL(spID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad spec ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            return true;
        }
        if (nm.equals(creatorTag)) {
            this.setCreator(elem.getTextValue());
            return true;
        }
        if (nm.equals(uriTag)) {
            this.setSpecURI(elem.getTextValue());
            return true;
        }
        if (nm.equals(versTag)) {
            this.setVersion(elem.getTextValue());
            return true;
        }
        if (nm.equals(paramTag)) {
            this.setParam(elem);
            return true;
        }
        if (nm.equals(proxyIdTag)) {
            try {
                URL spID = IDFactory.jxtaURL(elem.getTextValue());
                this.setProxySpecID((ModuleSpecID)IDFactory.fromURL(spID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad proxy spec ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            return true;
        }
        if (nm.equals(authIdTag)) {
            try {
                URL spID = IDFactory.jxtaURL(elem.getTextValue());
                this.setAuthSpecID((ModuleSpecID)IDFactory.fromURL(spID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad authenticator spec ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            return true;
        }
        if (nm.equals(PipeAdvertisement.getAdvertisementType())) {
            try {
                PipeAdvertisement pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(elem);
                this.setPipeAdvertisement(pipeAdv);
            }
            catch (ClassCastException wrongAdv) {
                throw new IllegalArgumentException("Bad pipe advertisement in advertisement");
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        ModuleSpecID tmpId;
        PipeAdvertisement pipeAdv;
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        Element e = adv.createElement(idTag, this.getModuleSpecID().toString());
        adv.appendChild(e);
        e = adv.createElement(nameTag, this.getName());
        adv.appendChild(e);
        e = adv.createElement(creatorTag, this.getCreator());
        adv.appendChild(e);
        e = adv.createElement(uriTag, this.getSpecURI());
        adv.appendChild(e);
        e = adv.createElement(versTag, this.getVersion());
        adv.appendChild(e);
        String description = this.getDescription();
        if (null != description) {
            e = adv.createElement(descTag, description);
            adv.appendChild(e);
        }
        if ((e = this.getParamPriv()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, e, paramTag);
        }
        if ((pipeAdv = this.getPipeAdvertisement()) != null) {
            StructuredTextDocument advDoc = (StructuredTextDocument)pipeAdv.getDocument(encodeAs);
            StructuredDocumentUtils.copyElements(adv, adv, advDoc);
        }
        if ((tmpId = this.getProxySpecID()) != null) {
            e = adv.createElement(proxyIdTag, tmpId.toString());
            adv.appendChild(e);
        }
        if ((tmpId = this.getAuthSpecID()) != null) {
            e = adv.createElement(authIdTag, tmpId.toString());
            adv.appendChild(e);
        }
        return adv;
    }

    public final String[] getIndexFields() {
        return fields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return ModuleSpecAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new ModuleSpecAdv();
        }

        public Advertisement newInstance(Element root) {
            return new ModuleSpecAdv(root);
        }
    }
}

