/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import javax.crypto.EncryptedPrivateKeyInfo;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.peergroup.PeerGroupID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PSEConfigAdv
extends ExtendableAdvertisement {
    private static final String advType = "jxta:PSEConfig";
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$PSEConfigAdv == null ? (class$net$jxta$impl$protocol$PSEConfigAdv = PSEConfigAdv.class$("net.jxta.impl.protocol.PSEConfigAdv")) : class$net$jxta$impl$protocol$PSEConfigAdv).getName());
    private static final String ROOT_CERT_TAG = "RootCert";
    private static final String CERT_TAG = "Certificate";
    private static final String ENCRYPTED_PRIVATE_KEY_TAG = "EncryptedPrivateKey";
    private static final String[] fields = new String[0];
    private Certificate rootCert = null;
    private EncryptedPrivateKeyInfo encryptedPrivateKey = null;
    private String privAlgorithm = null;
    static /* synthetic */ Class class$net$jxta$impl$protocol$PSEConfigAdv;
    static /* synthetic */ Class class$net$jxta$document$XMLElement;

    PSEConfigAdv() {
    }

    PSEConfigAdv(Element root) {
        if (!(class$net$jxta$document$XMLElement == null ? (class$net$jxta$document$XMLElement = PSEConfigAdv.class$("net.jxta.document.XMLElement")) : class$net$jxta$document$XMLElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PSEConfigAdv.getAdvertisementType()) && !PSEConfigAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
        if (null == this.rootCert) {
            throw new IllegalArgumentException("Root Certificate not initialized");
        }
        if (null == this.encryptedPrivateKey) {
            throw new IllegalArgumentException("Private Key not initialized");
        }
    }

    public Object clone() {
        PSEConfigAdv result = new PSEConfigAdv();
        result.encryptedPrivateKey = this.encryptedPrivateKey;
        result.privAlgorithm = this.privAlgorithm;
        result.setRootCert(this.getRootCertificate());
        return result;
    }

    public static String getAdvertisementType() {
        return advType;
    }

    public String getAdvType() {
        return PSEConfigAdv.getAdvertisementType();
    }

    public final String getBaseAdvType() {
        return PSEConfigAdv.getAdvertisementType();
    }

    public ID getID() {
        ByteArrayInputStream data = new ByteArrayInputStream(this.getRootCert().getBytes());
        try {
            return IDFactory.newCodatID(PeerGroupID.worldPeerGroupID, new byte[16], data);
        }
        catch (IOException failed) {
            throw new UndeclaredThrowableException(failed, "Could not generate id");
        }
    }

    public Certificate getRootCertificate() {
        return this.rootCert;
    }

    public String getRootCert() {
        try {
            return PSEUtils.base64Encode(this.rootCert.getEncoded());
        }
        catch (Throwable failed) {
            throw new IllegalStateException("Failed to process root cert");
        }
    }

    public void setRootCert(String newCert) {
        try {
            byte[] cert_der = PSEUtils.base64Decode(newCert);
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            this.setRootCert(cf.generateCertificate(new ByteArrayInputStream(cert_der)));
        }
        catch (Throwable failed) {
            throw new IllegalArgumentException("Failed to process root cert");
        }
    }

    public void setRootCert(Certificate newCert) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("setRootCert : " + newCert));
        }
        this.rootCert = newCert;
        if (null == newCert) {
            this.encryptedPrivateKey = null;
        }
    }

    public PrivateKey getPrivateKey(char[] password) {
        return PSEUtils.pkcs5_Decrypt_pbePrivateKey(password, this.privAlgorithm, this.encryptedPrivateKey);
    }

    public String getEncryptedPrivKey() {
        try {
            return PSEUtils.base64Encode(this.encryptedPrivateKey.getEncoded());
        }
        catch (Throwable failed) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Failed to process private key", failed);
            }
            throw new IllegalStateException("Failed to process private key");
        }
    }

    public void setEncryptedPrivateKey(String newPriv, String algorithm) {
        try {
            byte[] key_der = PSEUtils.base64Decode(newPriv);
            EncryptedPrivateKeyInfo newEncryptedPriv = new EncryptedPrivateKeyInfo(key_der);
            this.setEncryptedPrivateKey(newEncryptedPriv, algorithm);
        }
        catch (Throwable failed) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Failed to process private key", failed);
            }
            throw new IllegalArgumentException("Failed to process private key :" + failed.toString());
        }
    }

    public void setEncryptedPrivateKey(EncryptedPrivateKeyInfo newPriv, String algorithm) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("setPrivateKey : " + newPriv));
        }
        this.encryptedPrivateKey = newPriv;
        this.privAlgorithm = algorithm;
    }

    public void setPrivateKey(char[] password, PrivateKey newPriv) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("setPrivateKey : " + newPriv));
        }
        EncryptedPrivateKeyInfo encypted = PSEUtils.pkcs5_Encrypt_pbePrivateKey(password, newPriv, 500);
        this.setEncryptedPrivateKey(encypted, newPriv.getAlgorithm());
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (ROOT_CERT_TAG.equals(elem.getName())) {
            Enumeration elements = elem.getChildren();
            while (elements.hasMoreElements()) {
                String value;
                XMLElement eachcertelem = (XMLElement)elements.nextElement();
                if (CERT_TAG.equals(eachcertelem.getName())) {
                    value = eachcertelem.getTextValue();
                    if (null == value) {
                        throw new IllegalArgumentException("Empty Cert element");
                    }
                    value = value.trim();
                    this.setRootCert(value);
                    continue;
                }
                if (ENCRYPTED_PRIVATE_KEY_TAG.equals(eachcertelem.getName())) {
                    value = eachcertelem.getTextValue();
                    if (null == value) {
                        throw new IllegalArgumentException("Empty Private Key element");
                    }
                    value = value.trim();
                    Attribute algo = eachcertelem.getAttribute("algorithm");
                    if (null == algo) {
                        throw new IllegalArgumentException("Private Key element must include algorithm attribute");
                    }
                    this.setEncryptedPrivateKey(value, algo.getValue());
                    continue;
                }
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("Unhandled Element: " + eachcertelem.getName()));
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        Element rootcert = adv.createElement(ROOT_CERT_TAG, null);
        adv.appendChild(rootcert);
        String encodedRoot = this.getRootCert();
        if (null == encodedRoot) {
            throw new IllegalStateException("Root Certificate not initialized");
        }
        Element cert = adv.createElement(CERT_TAG, encodedRoot);
        rootcert.appendChild(cert);
        String encodedPrivateKey = this.getEncryptedPrivKey();
        if (null == encodedPrivateKey) {
            throw new IllegalStateException("Private key not initialized");
        }
        Element privatekey = adv.createElement(ENCRYPTED_PRIVATE_KEY_TAG, encodedPrivateKey);
        rootcert.appendChild(privatekey);
        if (privatekey instanceof Attributable) {
            ((Attributable)((Object)privatekey)).addAttribute("algorithm", this.privAlgorithm);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return fields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PSEConfigAdv.advType;
        }

        public Advertisement newInstance() {
            return new PSEConfigAdv();
        }

        public Advertisement newInstance(Element root) {
            return new PSEConfigAdv(root);
        }
    }
}

