/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.TextElement;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.PeerGroupAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PeerGroupAdv
extends PeerGroupAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$RdvAdv == null ? (class$net$jxta$impl$protocol$RdvAdv = PeerGroupAdv.class$("net.jxta.impl.protocol.RdvAdv")) : class$net$jxta$impl$protocol$RdvAdv).getName());
    private static final String nameTag = "Name";
    private static final String gidTag = "GID";
    private static final String descTag = "Desc";
    private static final String msidTag = "MSID";
    private static final String svcTag = "Svc";
    private static final String mcidTag = "MCID";
    private static final String paramTag = "Parm";
    private static final String[] fields = new String[]{"Name", "GID", "Desc"};
    static /* synthetic */ Class class$net$jxta$impl$protocol$RdvAdv;
    static /* synthetic */ Class class$net$jxta$document$XMLElement;

    public PeerGroupAdv() {
        this.setDescription(null);
        this.setName(null);
        this.setModuleSpecID(null);
        this.setPeerGroupID(null);
    }

    public PeerGroupAdv(Element root) {
        if (!(class$net$jxta$document$XMLElement == null ? (class$net$jxta$document$XMLElement = PeerGroupAdv.class$("net.jxta.document.XMLElement")) : class$net$jxta$document$XMLElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PeerGroupAdvertisement.getAdvertisementType()) && !PeerGroupAdvertisement.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(nameTag)) {
            this.setName(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(descTag)) {
            this.setDescription(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(gidTag)) {
            try {
                URL grID = IDFactory.jxtaURL(elem.getTextValue());
                this.setPeerGroupID((PeerGroupID)IDFactory.fromURL(grID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad pipe ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            return true;
        }
        if (elem.getName().equals(msidTag)) {
            try {
                URL specID = IDFactory.jxtaURL(elem.getTextValue());
                this.setModuleSpecID((ModuleSpecID)IDFactory.fromURL(specID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad pipe ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            return true;
        }
        if (elem.getName().equals(svcTag)) {
            Enumeration elems = elem.getChildren();
            String classID = null;
            TextElement param = null;
            while (elems.hasMoreElements()) {
                TextElement e = (TextElement)elems.nextElement();
                if (e.getName().equals(mcidTag)) {
                    classID = e.getTextValue();
                    continue;
                }
                if (!e.getName().equals(paramTag)) continue;
                param = e;
            }
            if (classID != null && param != null) {
                try {
                    this.putServiceParam(IDFactory.fromURL(IDFactory.jxtaURL(classID)), param);
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad pipe ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        Element e = adv.createElement(gidTag, this.getID().toString());
        adv.appendChild(e);
        e = adv.createElement(msidTag, this.getModuleSpecID().toString());
        adv.appendChild(e);
        e = adv.createElement(nameTag, this.getName());
        adv.appendChild(e);
        String description = this.getDescription();
        if (null != description) {
            e = adv.createElement(descTag, description);
            adv.appendChild(e);
        }
        Hashtable serviceParams = this.getServiceParams();
        Enumeration classIds = serviceParams.keys();
        while (classIds.hasMoreElements()) {
            ModuleClassID classId = (ModuleClassID)classIds.nextElement();
            Element s = adv.createElement(svcTag);
            adv.appendChild(s);
            e = adv.createElement(mcidTag, classId.toString());
            s.appendChild(e);
            e = (Element)serviceParams.get(classId);
            StructuredDocumentUtils.copyElements(adv, s, e, paramTag);
        }
        return adv;
    }

    public final String[] getIndexFields() {
        return fields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PeerGroupAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new PeerGroupAdv();
        }

        public Advertisement newInstance(Element root) {
            return new PeerGroupAdv(root);
        }
    }
}

