/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.protocol.PeerInfoResponseMessage;

public class PeerInfoResponseMsg
extends PeerInfoResponseMessage {
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public PeerInfoResponseMsg() {
    }

    public PeerInfoResponseMsg(PeerID spid, PeerID tpid, long uptime, long timestamp) {
        this.setSourcePid(spid);
        this.setTargetPid(tpid);
        this.setUptime(uptime);
        this.setTimestamp(timestamp);
    }

    public PeerInfoResponseMsg(Element root) {
        this.initialize(root);
    }

    public void initialize(Element root) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = PeerInfoResponseMsg.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        this.setSourcePid(null);
        this.setTargetPid(null);
        this.setUptime(0L);
        this.setTimestamp(0L);
        TextElement doc = (TextElement)root;
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            Enumeration elems;
            ID id;
            URL peerid;
            TextElement element2 = (TextElement)elements.nextElement();
            String elementName = element2.getName();
            if (elementName.equals("sourcePid")) {
                try {
                    peerid = IDFactory.jxtaURL(element2.getTextValue());
                    id = IDFactory.fromURL(peerid);
                    if (!(id instanceof PeerID)) {
                        throw new IllegalArgumentException("Bad ID in advertisement, not a PeerID");
                    }
                    this.setSourcePid((PeerID)id);
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad peerid ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (elementName.equals("targetPid")) {
                try {
                    peerid = IDFactory.jxtaURL(element2.getTextValue());
                    id = IDFactory.fromURL(peerid);
                    if (!(id instanceof PeerID)) {
                        throw new IllegalArgumentException("Bad ID in advertisement, not a PeerID");
                    }
                    this.setTargetPid((PeerID)id);
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad peerid ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (elementName.equals("uptime")) {
                this.setUptime(Long.parseLong(element2.getTextValue()));
                continue;
            }
            if (elementName.equals("timestamp")) {
                this.setTimestamp(Long.parseLong(element2.getTextValue()));
                continue;
            }
            if (!elementName.equals("response") || !(elems = element2.getChildren()).hasMoreElements()) continue;
            this.setResponse(StructuredDocumentUtils.copyAsDocument((Element)elems.nextElement()));
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, PeerInfoResponseMessage.getMessageType());
        TextElement e = null;
        if (doc instanceof Attributable) {
            ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        e = doc.createElement("sourcePid", this.getSourcePid().toString());
        doc.appendChild(e);
        e = doc.createElement("targetPid", this.getTargetPid().toString());
        doc.appendChild(e);
        Element response = this.getResponse();
        if (null != response) {
            e = doc.createElement("response");
            doc.appendChild(e);
            StructuredDocumentUtils.copyElements(doc, e, response);
        }
        e = doc.createElement("uptime", String.valueOf(this.getUptime()));
        doc.appendChild(e);
        e = doc.createElement("timestamp", String.valueOf(this.getTimestamp()));
        doc.appendChild(e);
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

