/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeResolverMessage;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PipeResolverMsg
extends PipeResolverMessage {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$PipeResolverMsg == null ? (class$net$jxta$impl$protocol$PipeResolverMsg = PipeResolverMsg.class$("net.jxta.impl.protocol.PipeResolverMsg")) : class$net$jxta$impl$protocol$PipeResolverMsg).getName());
    private static final String MsgTypeTag = "MsgType";
    private static final String PipeIdTag = "PipeId";
    private static final String PipeTypeTag = "Type";
    private static final String PeerIdTag = "Peer";
    private static final String PeerAdvTag = "PeerAdv";
    private static final String FoundTag = "Found";
    private static final String QueryMsgType = "Query";
    private static final String AnswerMsgType = "Answer";
    static /* synthetic */ Class class$net$jxta$impl$protocol$PipeResolverMsg;
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public PipeResolverMsg() {
    }

    public PipeResolverMsg(Element root) {
        this();
        this.initialize(root);
    }

    protected void initialize(Element root) {
        Serializable pipeID;
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = PipeResolverMsg.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        String docName = doc.getName();
        if (!docName.equals(PipeResolverMessage.getMessageType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + docName);
        }
        Enumeration enumeration = doc.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement elem = (TextElement)enumeration.nextElement();
            if (elem.getName().equals(MsgTypeTag)) {
                String msgtype = elem.getTextValue();
                if (msgtype.equals(QueryMsgType)) {
                    this.setMsgType(PipeResolverMessage.MessageType.QUERY);
                    continue;
                }
                if (msgtype.equals(AnswerMsgType)) {
                    this.setMsgType(PipeResolverMessage.MessageType.ANSWER);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected Message Type in parsing.");
            }
            if (elem.getName().equals(PipeIdTag)) {
                try {
                    pipeID = IDFactory.jxtaURL(elem.getTextValue());
                    this.setPipeID(IDFactory.fromURL((URL)pipeID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad pipe ID in message");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable pipe ID in message");
                }
            }
            if (elem.getName().equals(PipeTypeTag)) {
                this.setPipeType(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(PeerIdTag)) {
                try {
                    URL peerID = IDFactory.jxtaURL(elem.getTextValue());
                    this.addPeerID(IDFactory.fromURL(peerID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad peer ID in message");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable peerID in message");
                }
            }
            if (elem.getName().equals(FoundTag)) {
                this.setFound(Boolean.valueOf(elem.getTextValue()));
                continue;
            }
            if (!elem.getName().equals(PeerAdvTag)) continue;
            String peerAdv = elem.getTextValue();
            try {
                this.setInputPeerAdv((PeerAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, new StringReader(peerAdv)));
            }
            catch (IOException caught) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Malformed peer adv in message", (Throwable)caught);
                }
                throw new IllegalArgumentException("Malformed peer adv in message : " + caught.getMessage());
            }
        }
        PipeResolverMessage.MessageType msgType = this.getMsgType();
        if (null == msgType) {
            throw new IllegalArgumentException("Message type was never set!");
        }
        pipeID = this.getPipeID();
        if (null == pipeID || ID.nullID.equals(pipeID) || !(pipeID instanceof PipeID)) {
            throw new IllegalArgumentException("Input Pipe ID not set or invalid");
        }
        if (null == this.getPipeType()) {
            throw new IllegalArgumentException("Pipe type was never set!");
        }
        if (PipeResolverMessage.MessageType.ANSWER.equals(msgType) && this.getPeerIDs().isEmpty()) {
            throw new IllegalArgumentException("An answer without responses is invalid");
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        PipeResolverMessage.MessageType msgType;
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, PipeResolverMessage.getMessageType());
        if (doc instanceof Attributable) {
            ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        if (null == (msgType = this.getMsgType())) {
            throw new IllegalStateException("Message type was never set!");
        }
        ID pipeID = this.getPipeID();
        if (null == pipeID || ID.nullID.equals(pipeID) || !(pipeID instanceof PipeID)) {
            throw new IllegalStateException("Pipe ID not set or invalid.");
        }
        String pipeType = this.getPipeType();
        if (null == pipeType || 0 == pipeType.trim().length()) {
            throw new IllegalStateException("Pipe type was never set or is invalid.");
        }
        TextElement e = null;
        if (PipeResolverMessage.MessageType.QUERY.equals(msgType)) {
            e = doc.createElement(MsgTypeTag, QueryMsgType);
        } else if (PipeResolverMessage.MessageType.ANSWER.equals(msgType)) {
            e = doc.createElement(MsgTypeTag, AnswerMsgType);
        } else {
            throw new IllegalStateException("Unknown message type :" + msgType.toString());
        }
        doc.appendChild((Element)e);
        e = doc.createElement(PipeIdTag, pipeID.toString());
        doc.appendChild((Element)e);
        if (null != pipeType && 0 != pipeType.length()) {
            e = doc.createElement(PipeTypeTag, pipeType);
            doc.appendChild((Element)e);
        }
        Set peers = this.getPeerIDs();
        if (PipeResolverMessage.MessageType.ANSWER.equals(msgType) && peers.isEmpty()) {
            throw new IllegalStateException("An ANSWER message must contain at least one peer as part of the response.");
        }
        Iterator eachPeer = peers.iterator();
        while (eachPeer.hasNext()) {
            ID aPeer = (ID)eachPeer.next();
            e = doc.createElement(PeerIdTag, aPeer.toString());
            doc.appendChild((Element)e);
        }
        if (!PipeResolverMessage.MessageType.QUERY.equals(msgType)) {
            if (PipeResolverMessage.MessageType.ANSWER.equals(msgType)) {
                e = doc.createElement(FoundTag, (this.isFound() ? Boolean.TRUE : Boolean.FALSE).toString());
                doc.appendChild((Element)e);
                PeerAdvertisement peerAdv = this.getInputPeerAdv();
                if (peerAdv != null) {
                    if (!peers.contains(peerAdv.getPeerID())) {
                        throw new IllegalStateException("Provided Peer Advertisement does not refer to one of the peers in the response list.");
                    }
                    StructuredTextDocument asDoc = (StructuredTextDocument)peerAdv.getDocument(MimeMediaType.XMLUTF8);
                    e = doc.createElement(PeerAdvTag, asDoc.toString());
                    doc.appendChild((Element)e);
                }
            } else {
                throw new IllegalStateException("Unknown message type :" + msgType.toString());
            }
        }
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

