/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RdvAdv
extends RdvAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$RdvAdv == null ? (class$net$jxta$impl$protocol$RdvAdv = RdvAdv.class$("net.jxta.impl.protocol.RdvAdv")) : class$net$jxta$impl$protocol$RdvAdv).getName());
    private static final String[] fields = new String[]{"RdvPeerId", "RdvServiceName", "RdvGroupId"};
    static /* synthetic */ Class class$net$jxta$impl$protocol$RdvAdv;
    static /* synthetic */ Class class$net$jxta$document$XMLElement;

    public RdvAdv() {
    }

    public RdvAdv(Element root) {
        if (!(class$net$jxta$document$XMLElement == null ? (class$net$jxta$document$XMLElement = RdvAdv.class$("net.jxta.document.XMLElement")) : class$net$jxta$document$XMLElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(RdvAdvertisement.getAdvertisementType()) && !RdvAdvertisement.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals("RdvGroupId")) {
            try {
                URL groupID = IDFactory.jxtaURL(elem.getTextValue());
                this.setGroupID((PeerGroupID)IDFactory.fromURL(groupID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad group ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            return true;
        }
        if (elem.getName().equals("RdvPeerId")) {
            try {
                URL peerID = IDFactory.jxtaURL(elem.getTextValue());
                this.setPeerID((PeerID)IDFactory.fromURL(peerID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad peer ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            return true;
        }
        if (elem.getName().equals("RdvServiceName")) {
            this.setServiceName(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals("RdvRoute")) {
            Enumeration eachXpt = elem.getChildren();
            while (eachXpt.hasMoreElements()) {
                XMLElement aXpt = (XMLElement)eachXpt.nextElement();
                RouteAdvertisement xptAdv = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                this.setRouteAdv(xptAdv);
            }
            return true;
        }
        if (elem.getName().equals("Name")) {
            this.setName(elem.getTextValue());
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        Element e = adv.createElement("RdvGroupId", this.getGroupID().toString());
        adv.appendChild(e);
        e = adv.createElement("RdvPeerId", this.getPeerID().toString());
        adv.appendChild(e);
        e = adv.createElement("RdvServiceName", this.getServiceName());
        adv.appendChild(e);
        e = adv.createElement("Name", this.getName());
        adv.appendChild(e);
        if (this.getRouteAdv() != null) {
            Element el = adv.createElement("RdvRoute");
            adv.appendChild(el);
            StructuredTextDocument xptDoc = (StructuredTextDocument)this.getRouteAdv().getDocument(encodeAs);
            StructuredDocumentUtils.copyElements(adv, el, xptDoc);
        }
        return adv;
    }

    public final String[] getIndexFields() {
        return fields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return RdvAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new RdvAdv();
        }

        public Advertisement newInstance(Element root) {
            return new RdvAdv(root);
        }
    }
}

