/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.RouteAdvertisement;

public class ResolverResponse
extends ResolverResponseMsg {
    private static final String handlernameTag = "HandlerName";
    private static final String credentialTag = "jxta:Cred";
    private static final String queryIdTag = "QueryID";
    private static final String responseTag = "Response";
    private RouteAdvertisement srcRoute = null;

    public ResolverResponse() {
    }

    public ResolverResponse(String HandlerName, StructuredDocument Credential2, int QueryId, String Response) {
        this();
        this.setHandlerName(HandlerName);
        this.setCredential(Credential2);
        this.setQueryId(QueryId);
        this.setResponse(Response);
    }

    public ResolverResponse(InputStream stream) throws IOException {
        this();
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, stream);
        this.readIt(doc);
    }

    public ResolverResponse(TextElement doc) {
        if (!ResolverResponseMsg.getAdvertisementType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.readIt(doc);
    }

    public void readIt(TextElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(handlernameTag)) {
                this.setHandlerName(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(credentialTag)) {
                this.setCredential(StructuredDocumentUtils.copyAsDocument(elem));
                continue;
            }
            if (elem.getName().equals(queryIdTag)) {
                this.queryid = Integer.parseInt(elem.getTextValue());
                continue;
            }
            if (!elem.getName().equals(responseTag)) continue;
            this.setResponse(elem.getTextValue());
        }
    }

    public Document getDocument(MimeMediaType asMimeType) {
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, ResolverResponseMsg.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        TextElement e = adv.createElement(handlernameTag, this.getHandlerName());
        adv.appendChild((Element)e);
        if (this.getCredential() != null) {
            StructuredDocumentUtils.copyElements(adv, adv, this.getCredential());
        }
        e = adv.createElement(queryIdTag, Integer.toString(this.queryid));
        adv.appendChild((Element)e);
        e = adv.createElement(responseTag, this.getResponse());
        adv.appendChild((Element)e);
        return adv;
    }

    public String toString() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    public void setSrcPeerRoute(RouteAdvertisement route) {
        this.srcRoute = route;
    }

    public RouteAdvertisement getSrcPeerRoute() {
        if (this.srcRoute != null) {
            return (RouteAdvertisement)this.srcRoute.clone();
        }
        return null;
    }
}

