/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import net.jxta.credential.Credential;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ResolverSrdiMsg;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ResolverSrdiMsgImpl
extends ResolverSrdiMsg {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$ResolverSrdiMsgImpl == null ? (class$net$jxta$impl$protocol$ResolverSrdiMsgImpl = ResolverSrdiMsgImpl.class$("net.jxta.impl.protocol.ResolverSrdiMsgImpl")) : class$net$jxta$impl$protocol$ResolverSrdiMsgImpl).getName());
    public static final String handlernameTag = "HandlerName";
    public static final String credentialTag = "jxta:Cred";
    public static final String payloadTag = "Payload";
    private MembershipService membership;
    static /* synthetic */ Class class$net$jxta$impl$protocol$ResolverSrdiMsgImpl;

    public ResolverSrdiMsgImpl() {
    }

    public ResolverSrdiMsgImpl(InputStream stream, PeerGroup group) throws IOException {
        StructuredTextDocument doc;
        block4: {
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, stream);
            if (group != null) {
                this.membership = group.getMembershipService();
                try {
                    Enumeration enumeration = this.membership.getCurrentCredentials();
                    if (enumeration.hasMoreElements()) {
                        this.setCredential((Credential)enumeration.nextElement());
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block4;
                    LOG.error((Object)"failed to get credential", (Throwable)e);
                }
            }
        }
        this.readIt(doc);
    }

    public ResolverSrdiMsgImpl(TextElement doc, PeerGroup group) {
        block5: {
            if (!ResolverSrdiMsg.getMessageType().equals(doc.getName())) {
                throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
            }
            if (group != null) {
                this.membership = group.getMembershipService();
                try {
                    Enumeration enumeration = this.membership.getCurrentCredentials();
                    if (enumeration.hasMoreElements()) {
                        this.setCredential((Credential)enumeration.nextElement());
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block5;
                    LOG.error((Object)"failed to get credential", (Throwable)e);
                }
            }
        }
        this.readIt(doc);
    }

    public ResolverSrdiMsgImpl(String handlerName, PeerGroup group, String payload) {
        block4: {
            if (group != null) {
                this.membership = group.getMembershipService();
                try {
                    Enumeration enumeration = this.membership.getCurrentCredentials();
                    if (enumeration.hasMoreElements()) {
                        this.setCredential((Credential)enumeration.nextElement());
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block4;
                    LOG.error((Object)"failed to get credential", (Throwable)e);
                }
            }
        }
        this.setHandlerName(handlerName);
        this.setPayload(payload);
    }

    public void readIt(TextElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(handlernameTag)) {
                this.setHandlerName(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(credentialTag)) {
                Credential credential;
                block6: {
                    credential = null;
                    if (elem.getTextValue() == null) continue;
                    try {
                        credential = this.membership.makeCredential(elem);
                    }
                    catch (Exception ce) {
                        if (!LOG.isDebugEnabled()) break block6;
                        if (elem != null) {
                            LOG.debug((Object)elem);
                        }
                        LOG.debug((Object)"Got an Exception during credential creation ", (Throwable)ce);
                    }
                }
                this.setCredential(credential);
                continue;
            }
            if (!elem.getName().equals(payloadTag)) continue;
            this.setPayload(elem.getTextValue());
        }
    }

    public Document getDocument(MimeMediaType asMimeType) {
        TextElement e;
        StructuredTextDocument adv;
        block4: {
            adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, ResolverSrdiMsg.getMessageType());
            if (adv instanceof Attributable) {
                ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
            }
            e = adv.createElement(handlernameTag, this.getHandlerName());
            adv.appendChild((Element)e);
            if (this.getCredential() != null) {
                try {
                    StructuredDocumentUtils.copyElements(adv, adv, this.getCredential().getDocument(asMimeType));
                }
                catch (Exception ce) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)"Got an Exception during credential creation ", (Throwable)ce);
                }
            }
        }
        e = adv.createElement(payloadTag, this.getPayload());
        adv.appendChild((Element)e);
        return adv;
    }

    public String toString() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

