/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RouteAdv
extends RouteAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$RouteAdv == null ? (class$net$jxta$impl$protocol$RouteAdv = RouteAdv.class$("net.jxta.impl.protocol.RouteAdv")) : class$net$jxta$impl$protocol$RouteAdv).getName());
    private static final String dstTag = "DstPID";
    private static final String[] fields = new String[]{"DstPID"};
    static /* synthetic */ Class class$net$jxta$impl$protocol$RouteAdv;
    static /* synthetic */ Class class$net$jxta$document$XMLElement;

    public RouteAdv() {
    }

    public RouteAdv(Element root) {
        if (!(class$net$jxta$document$XMLElement == null ? (class$net$jxta$document$XMLElement = RouteAdv.class$("net.jxta.document.XMLElement")) : class$net$jxta$document$XMLElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(RouteAdvertisement.getAdvertisementType()) && !RouteAdvertisement.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
        this.setDestPeerID(this.getDestPeerID());
        if (this.hasALoop()) {
            throw new IllegalArgumentException("Route contains a loop!");
        }
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(dstTag)) {
            try {
                URL pID = IDFactory.jxtaURL(elem.getTextValue());
                this.setDestPeerID((PeerID)IDFactory.fromURL(pID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad PeerID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("ID in advertisement is not a peer id");
            }
            return true;
        }
        if (elem.getName().equals("Dst")) {
            Enumeration eachXpt = elem.getChildren();
            while (eachXpt.hasMoreElements()) {
                TextElement aXpt = (TextElement)eachXpt.nextElement();
                AccessPointAdvertisement xptAdv = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                this.setDest(xptAdv);
            }
            return true;
        }
        if (elem.getName().equals("Hops")) {
            Vector<AccessPointAdvertisement> hops = new Vector<AccessPointAdvertisement>();
            Enumeration eachXpt = elem.getChildren();
            while (eachXpt.hasMoreElements()) {
                TextElement aXpt = (TextElement)eachXpt.nextElement();
                AccessPointAdvertisement xptAdv = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                hops.addElement(xptAdv);
            }
            this.setHops(hops);
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (this.hasALoop()) {
            throw new IllegalStateException("I won't write a doc for a route with a loop");
        }
        PeerID pid = this.getDestPeerID();
        AccessPointAdvertisement dest = this.getDest();
        if (null != pid && null != dest && null != dest.getPeerID() && !pid.equals(dest.getPeerID())) {
            throw new IllegalStateException("Destination peer id and destination access point adv don't refer to the same peer");
        }
        if (null == pid && null != dest) {
            pid = dest.getPeerID();
        }
        if (pid != null) {
            Element e0 = adv.createElement(dstTag, pid.toString());
            adv.appendChild(e0);
        }
        if (dest != null) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setEndpointAddresses(dest.getVectorEndpointAddresses());
            Element e1 = adv.createElement("Dst");
            adv.appendChild(e1);
            StructuredTextDocument xptDoc = (StructuredTextDocument)ap.getDocument(encodeAs);
            StructuredDocumentUtils.copyElements(adv, e1, xptDoc);
        }
        if (this.getHops().hasMoreElements()) {
            Element e2 = adv.createElement("Hops");
            adv.appendChild(e2);
            Enumeration e = this.getHops();
            while (e.hasMoreElements()) {
                AccessPointAdvertisement hop = (AccessPointAdvertisement)e.nextElement();
                if (hop == null) continue;
                StructuredTextDocument xptDoc = (StructuredTextDocument)hop.getDocument(encodeAs);
                StructuredDocumentUtils.copyElements(adv, e2, xptDoc);
            }
        }
        return adv;
    }

    public final String[] getIndexFields() {
        return fields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return RouteAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new RouteAdv();
        }

        public Advertisement newInstance(Element root) {
            return new RouteAdv(root);
        }
    }
}

