/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.protocol.RouteQueryMsg;

public class RouteQuery
extends RouteQueryMsg {
    private static final String destPIDTag = "Dst";
    private static final String srcRouteTag = "Src";
    private static final String badHopTag = "Bad";
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public RouteQuery(PeerID dest, RouteAdvertisement srcRoute, Vector badHops) {
        this.setDestPeerID(dest);
        this.setSrcRoute(srcRoute);
        this.setBadHops(badHops);
    }

    public RouteQuery(Element root) {
        String doctype;
        Attribute itsType;
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = RouteQuery.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        String typedoctype = "";
        if (doc instanceof Attributable && null != (itsType = ((Attributable)((Object)doc)).getAttribute("type"))) {
            typedoctype = itsType.getValue();
        }
        if (!((doctype = doc.getName()).equals(RouteQueryMsg.getAdvertisementType()) || doctype.equals(RouteQueryMsg.getAdvertisementType()) && RouteQueryMsg.getAdvertisementType().equals(typedoctype))) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.readIt(doc);
    }

    private void readIt(TextElement doc) {
        Enumeration elements = doc.getChildren();
        Vector<PeerID> badHops = new Vector<PeerID>();
        while (elements.hasMoreElements()) {
            PeerID pid;
            URL pID;
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(destPIDTag)) {
                try {
                    pID = IDFactory.jxtaURL(elem.getTextValue());
                    if (pID == null) continue;
                    pid = (PeerID)IDFactory.fromURL(pID);
                    this.setDestPeerID(pid);
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad PeerID ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (elem.getName().equals(srcRouteTag)) {
                Enumeration eachXpt = elem.getChildren();
                while (eachXpt.hasMoreElements()) {
                    TextElement aXpt = (TextElement)eachXpt.nextElement();
                    RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                    this.setSrcRoute(route);
                }
                continue;
            }
            if (!elem.getName().equals(badHopTag)) continue;
            try {
                pID = IDFactory.jxtaURL(elem.getTextValue());
                if (pID == null) continue;
                pid = (PeerID)IDFactory.fromURL(pID);
                badHops.add(pid);
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad PeerID ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
        }
        this.setBadHops(badHops);
    }

    public Document getDocument(MimeMediaType asMimeType) {
        RouteAdvertisement route;
        Element e;
        PeerID dest;
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, RouteQueryMsg.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        if ((dest = this.getDestPeerID()) != null) {
            e = adv.createElement((Object)destPIDTag, (Object)dest.toString());
            adv.appendChild(e);
        }
        if ((route = this.getSrcRoute()) != null) {
            e = adv.createElement((Object)srcRouteTag);
            adv.appendChild(e);
            StructuredTextDocument xptDoc = (StructuredTextDocument)route.getDocument(asMimeType);
            StructuredDocumentUtils.copyElements(adv, e, xptDoc);
        }
        Enumeration enumeration = this.getBadHops().elements();
        while (enumeration.hasMoreElements()) {
            e = adv.createElement((Object)badHopTag, (Object)((PeerID)enumeration.nextElement()).toString());
            adv.appendChild(e);
        }
        return adv;
    }

    public String toString() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

