/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.protocol.SrdiMessage;
import org.apache.log4j.Logger;

public class SrdiMessageImpl
extends SrdiMessage {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$SrdiMessageImpl == null ? (class$net$jxta$impl$protocol$SrdiMessageImpl = SrdiMessageImpl.class$("net.jxta.impl.protocol.SrdiMessageImpl")) : class$net$jxta$impl$protocol$SrdiMessageImpl).getName());
    public static final String pidTag = "PID";
    public static final String ttlTag = "ttl";
    public static final String entryTag = "Entry";
    public static final String pKeyTag = "PKey";
    public static final String sKeyTag = "SKey";
    public static final String valTag = "Value";
    public static final String expirationTag = "Expiration";
    static /* synthetic */ Class class$net$jxta$impl$protocol$SrdiMessageImpl;

    public SrdiMessageImpl() {
        Vector entries = new Vector();
        this.ttl = 0;
        this.setEntries(entries);
    }

    public SrdiMessageImpl(InputStream stream) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, stream);
        this.readIt(doc);
    }

    public SrdiMessageImpl(TextElement doc) {
        if (!SrdiMessage.getMessageType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.readIt(doc);
    }

    public SrdiMessageImpl(PeerID peerid, int ttl, String pKey, Vector entries) {
        this.setPeerID(peerid);
        this.ttl = ttl;
        this.setPrimaryKey(pKey);
        this.setEntries(entries);
    }

    public SrdiMessageImpl(PeerID peerid, int ttl, String pKey, String key, String value, long expiration) {
        Vector<SrdiMessage.Entry> entries = new Vector<SrdiMessage.Entry>();
        SrdiMessage.Entry entry = new SrdiMessage.Entry(key, value, expiration);
        entries.addElement(entry);
        this.ttl = ttl;
        this.setPeerID(peerid);
        this.setPrimaryKey(pKey);
        this.setEntries(entries);
    }

    public SrdiMessageImpl(String peerid, int ttl, String pKey, Vector entries) throws MalformedURLException, IllegalArgumentException {
        PeerID pid;
        try {
            pid = (PeerID)IDFactory.fromURL(IDFactory.jxtaURL(peerid));
        }
        catch (MalformedURLException badID) {
            throw new IllegalArgumentException("Invalid PeerID ID in message");
        }
        catch (UnknownServiceException badID) {
            throw new IllegalArgumentException("Unusable ID in message");
        }
        this.setPeerID(pid);
        this.ttl = ttl;
        this.setPrimaryKey(pKey);
        this.setEntries(entries);
    }

    public void readIt(TextElement doc) {
        String key = null;
        String value = null;
        long expiration = 0L;
        Vector<SrdiMessage.Entry> entries = new Vector<SrdiMessage.Entry>();
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(pidTag)) {
                try {
                    URL pID = IDFactory.jxtaURL(elem.getTextValue());
                    this.setPeerID((PeerID)IDFactory.fromURL(pID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Invalid PeerID ID in message");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in message");
                }
            }
            if (elem.getName().equals(pKeyTag)) {
                this.setPrimaryKey(elem.getTextValue());
            }
            if (elem.getName().equals(ttlTag)) {
                this.ttl = Integer.parseInt(elem.getTextValue());
            }
            if (!elem.getName().equals(entryTag)) continue;
            Attribute keyEl = ((Attributable)((Object)elem)).getAttribute(sKeyTag);
            key = keyEl == null ? "NA" : keyEl.getValue();
            value = elem.getTextValue();
            Attribute expAttr = ((Attributable)((Object)elem)).getAttribute(expirationTag);
            String expstr = expAttr.getValue();
            expiration = expstr != null ? Long.parseLong(expstr) : -1L;
            SrdiMessage.Entry entry = new SrdiMessage.Entry(key, value, expiration);
            entries.addElement(entry);
        }
        this.setEntries(entries);
    }

    public void addEntry(String key, String value, long expiration) {
        Vector entries = this.getEntries();
        entries.addElement(new SrdiMessage.Entry(key, value, expiration));
    }

    public void addEntry(SrdiMessage.Entry entry) {
        Vector entries = this.getEntries();
        entries.addElement(entry);
    }

    public Document getDocument(MimeMediaType encodeAs) {
        TextElement e;
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, SrdiMessage.getMessageType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Vector entries = this.getEntries();
        PeerID peerid = this.getPeerID();
        if (peerid != null) {
            e = adv.createElement(pidTag, peerid.toString());
            adv.appendChild((Element)e);
        }
        if (this.getPrimaryKey() != null) {
            e = adv.createElement(pKeyTag, this.getPrimaryKey());
            adv.appendChild((Element)e);
        }
        if (this.getTTL() > 0) {
            e = adv.createElement(ttlTag, Integer.toString(this.getTTL()));
            adv.appendChild((Element)e);
        }
        int i = 0;
        while (i < entries.size()) {
            SrdiMessage.Entry entry = (SrdiMessage.Entry)entries.elementAt(i);
            if (entry.key != null || entry.value != null) {
                e = adv.createElement(entryTag, entry.value);
                adv.appendChild((Element)e);
                ((Attributable)((Object)e)).addAttribute(expirationTag, Long.toString(entry.expiration));
                ((Attributable)((Object)e)).addAttribute(sKeyTag, entry.key);
            }
            ++i;
        }
        return adv;
    }

    public String toString() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

