/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TCPAdv
extends TransportAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$protocol$TCPAdv == null ? (class$net$jxta$impl$protocol$TCPAdv = TCPAdv.class$("net.jxta.impl.protocol.TCPAdv")) : class$net$jxta$impl$protocol$TCPAdv).getName());
    private int port = -1;
    private String multicastaddr = null;
    private int multicastport = -1;
    private int multicastsize = -1;
    private String server = null;
    private String interfaceAddress = null;
    private String configMode = null;
    private boolean multicastState = true;
    private static final String[] fields = new String[0];
    private boolean serverEnabled = true;
    private boolean clientEnabled = true;
    private boolean publicAddressOnly = false;
    private static final String ClientOffTag = "ClientOff";
    private static final String ServerOffTag = "ServerOff";
    private static final String FlagsTag = "Flags";
    private static final String PublicAddressOnlyAttr = "PublicAddressOnly";
    static /* synthetic */ Class class$net$jxta$impl$protocol$TCPAdv;
    static /* synthetic */ Class class$net$jxta$document$XMLElement;

    public static String getAdvertisementType() {
        return "jxta:TCPTransportAdvertisement";
    }

    public String getAdvType() {
        return TCPAdv.getAdvertisementType();
    }

    private TCPAdv() {
    }

    private TCPAdv(Element root) {
        if (!(class$net$jxta$document$XMLElement == null ? (class$net$jxta$document$XMLElement = TCPAdv.class$("net.jxta.document.XMLElement")) : class$net$jxta$document$XMLElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(TCPAdv.getAdvertisementType()) && !TCPAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Attribute attr = doc.getAttribute(FlagsTag);
        if (attr != null) {
            String options = attr.getValue();
            this.publicAddressOnly = options.indexOf(PublicAddressOnlyAttr) != -1;
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean getMulticastState() {
        return this.multicastState;
    }

    public void setMulticastState(boolean multicastState) {
        this.multicastState = multicastState;
    }

    public String getMulticastAddr() {
        return this.multicastaddr;
    }

    public void setMulticastAddr(String multicastaddr) {
        this.multicastaddr = multicastaddr;
    }

    public int getMulticastPort() {
        return this.multicastport;
    }

    public void setMulticastPort(int multicastport) {
        this.multicastport = multicastport;
    }

    public int getMulticastSize() {
        return this.multicastsize;
    }

    public void setMulticastSize(int multicastsize) {
        this.multicastsize = multicastsize;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String a) {
        this.server = a;
    }

    public boolean getServerEnabled() {
        return this.serverEnabled;
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    public String getInterfaceAddress() {
        return this.interfaceAddress;
    }

    public void setInterfaceAddress(String ia) {
        this.interfaceAddress = ia;
    }

    public String getConfigMode() {
        return this.configMode;
    }

    public void setConfigMode(String mode) {
        this.configMode = mode;
    }

    public void setServerEnabled(boolean enabled) {
        this.serverEnabled = enabled;
    }

    public void setClientEnabled(boolean enabled) {
        this.clientEnabled = enabled;
    }

    public boolean getPublicAddressOnly() {
        return this.publicAddressOnly;
    }

    public void setPublicAddressOnly(boolean only) {
        this.publicAddressOnly = only;
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals("MulticastOff")) {
            this.setMulticastState(false);
            return true;
        }
        if (elem.getName().equals(ClientOffTag)) {
            this.clientEnabled = false;
            return true;
        }
        if (elem.getName().equals(ServerOffTag)) {
            this.serverEnabled = false;
            return true;
        }
        String value = elem.getTextValue();
        if (elem.getName().equals("Protocol") && null != value) {
            this.setProtocol(value.trim());
            return true;
        }
        if (elem.getName().equals("Port") && null != value) {
            try {
                int thePort = Integer.parseInt(value.trim());
                if (thePort < 0 || thePort > 65535) {
                    throw new IllegalArgumentException("Illegal port value : " + thePort);
                }
                this.setPort(thePort);
            }
            catch (NumberFormatException badPort) {
                throw new IllegalArgumentException("Illegal port value : " + value);
            }
            return true;
        }
        if (elem.getName().equals("MulticastAddr") && null != value) {
            this.setMulticastAddr(value.trim());
            return true;
        }
        if (elem.getName().equals("MulticastPort") && null != value) {
            try {
                int thePort = Integer.parseInt(value.trim());
                if (thePort < 0 || thePort > 65535) {
                    throw new IllegalArgumentException("Illegal port value : " + thePort);
                }
                this.setMulticastPort(thePort);
            }
            catch (NumberFormatException badPort) {
                throw new IllegalArgumentException("Illegal port value : " + value);
            }
            return true;
        }
        if (elem.getName().equals("MulticastSize") && null != value) {
            try {
                int theMulticastSize = Integer.parseInt(value.trim());
                if (theMulticastSize < 0 || theMulticastSize > 1048575) {
                    throw new IllegalArgumentException("Illegal multicast datagram size : " + theMulticastSize);
                }
                this.setMulticastSize(theMulticastSize);
            }
            catch (NumberFormatException badPort) {
                throw new IllegalArgumentException("Illegal multicast datagram size : " + value);
            }
            return true;
        }
        if (elem.getName().equals("Server") && null != value) {
            this.setServer(value.trim());
            return true;
        }
        if (elem.getName().equals("InterfaceAddress") && null != value) {
            this.setInterfaceAddress(value.trim());
            return true;
        }
        if (elem.getName().equals("ConfigMode") && null != value) {
            this.setConfigMode(value.trim());
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        String interfaceAddr;
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (adv instanceof Attributable && this.publicAddressOnly) {
            ((Attributable)((Object)adv)).addAttribute(FlagsTag, PublicAddressOnlyAttr);
        }
        Element e11 = adv.createElement("Protocol", this.getProtocol());
        adv.appendChild(e11);
        Element e12 = adv.createElement("Port", Integer.toString(this.getPort()));
        adv.appendChild(e12);
        if (!this.getMulticastState()) {
            Element e19 = adv.createElement("MulticastOff");
            adv.appendChild(e19);
        }
        Element e13 = adv.createElement("MulticastAddr", this.getMulticastAddr());
        adv.appendChild(e13);
        Element e14 = adv.createElement("MulticastPort", Integer.toString(this.getMulticastPort()));
        adv.appendChild(e14);
        Element e15 = adv.createElement("MulticastSize", Integer.toString(this.getMulticastSize()));
        adv.appendChild(e15);
        String serverAddr = this.getServer();
        if (null != serverAddr && (serverAddr = serverAddr.trim()).length() > 0) {
            Element e16 = adv.createElement("Server", serverAddr);
            adv.appendChild(e16);
        }
        if (null != (interfaceAddr = this.getInterfaceAddress()) && (interfaceAddr = interfaceAddr.trim()).length() > 0) {
            Element e17 = adv.createElement("InterfaceAddress", interfaceAddr);
            adv.appendChild(e17);
        }
        if (this.getConfigMode() != null) {
            Element e18 = adv.createElement("ConfigMode", this.getConfigMode());
            adv.appendChild(e18);
        }
        if (!this.isClientEnabled()) {
            Element e19 = adv.createElement(ClientOffTag);
            adv.appendChild(e19);
        }
        if (!this.isServerEnabled()) {
            Element e20 = adv.createElement(ServerOffTag);
            adv.appendChild(e20);
        }
        return adv;
    }

    public final String[] getIndexFields() {
        return fields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return TCPAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new TCPAdv();
        }

        public Advertisement newInstance(Element root) {
            return new TCPAdv(root);
        }
    }
}

