/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.discovery.DiscoveryService;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.util.endpoint.WeakMessengerCache;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PeerConnection {
    private boolean connected = false;
    private DiscoveryService discovery = null;
    private EndpointService endpoint = null;
    private PeerGroup group = null;
    private String incarnation = null;
    private long lease = 0L;
    private ID peer = null;
    private String peerName = null;
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$PeerConnection == null ? (class$net$jxta$impl$rendezvous$PeerConnection = PeerConnection.class$("net.jxta.impl.rendezvous.PeerConnection")) : class$net$jxta$impl$rendezvous$PeerConnection).getName());
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$PeerConnection;

    public PeerConnection(PeerGroup group, ID peerid, long leaseDuration, String incarnation) {
        this.peer = peerid;
        this.group = group;
        this.connected = true;
        this.incarnation = incarnation;
        this.setLease(leaseDuration);
    }

    public synchronized void setIncarnation(String incarnation) {
        this.incarnation = incarnation;
    }

    public synchronized void setLease(long leaseDuration) {
        this.lease = leaseDuration <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + leaseDuration;
    }

    public synchronized void setPeer(ID peer) {
        this.peer = peer;
    }

    public synchronized String getIncarnation() {
        return this.incarnation;
    }

    public synchronized long getLease() {
        return this.lease;
    }

    public synchronized ID getPeer() {
        return this.peer;
    }

    public synchronized String getPeerName() {
        if (this.peerName != null) {
            return this.peerName;
        }
        if (this.discovery == null) {
            this.discovery = this.group.getDiscoveryService();
        }
        try {
            Enumeration enumeration = this.discovery.getLocalAdvertisements(0, "PID", this.peer.toString());
            if (enumeration.hasMoreElements()) {
                PeerAdvertisement adv = (PeerAdvertisement)enumeration.nextElement();
                this.peerName = adv.getName();
            }
        }
        catch (Exception ez1) {
            this.peerName = null;
            return this.peer.toString();
        }
        return this.peerName;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized void close() {
        this.connected = false;
    }

    public synchronized void connect() {
        this.connected = true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PeerConnection) {
            return this.peer.equals(((PeerConnection)obj).peer);
        }
        return false;
    }

    public void finalize() {
        this.close();
    }

    public int hashCode() {
        return this.peer.hashCode();
    }

    private EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID = null;
        try {
            asID = IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
        }
        catch (MalformedURLException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        catch (UnknownServiceException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return this.mkAddress(asID, serv, parm);
    }

    private EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    public void sendMessage(Message message, String svcName, String svcParam) throws IOException {
        this.sendMessage(null, message, svcName, svcParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(WeakMessengerCache messengerCache, Message message, String svcName, String svcParam) throws IOException {
        if (this.endpoint == null) {
            this.endpoint = this.group.getEndpointService();
        }
        if (!this.isConnected()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("No connection. Dropping message for peer : " + this.peer));
            }
            throw new IOException("PeerConnection is closed. dest peer : " + this.peer);
        }
        EndpointAddress dstAddress = this.mkAddress(this.peer, svcName, svcParam);
        Messenger messenger = null;
        int retries = 0;
        while (retries++ < 2) {
            WeakMessengerCache weakMessengerCache;
            if (messengerCache != null) {
                weakMessengerCache = messengerCache;
                synchronized (weakMessengerCache) {
                    messenger = messengerCache.getMessenger(dstAddress);
                }
                if (messenger != null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if (messenger == null) {
                messenger = this.endpoint.getMessenger(dstAddress);
                if (messenger == null) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("sendMessage failed to obtain messenger to peer : " + this.peer));
                    }
                    throw new IOException("sendMessage failed to obtain messenger to peer : " + this.peer);
                }
                if (messengerCache != null) {
                    weakMessengerCache = messengerCache;
                    synchronized (weakMessengerCache) {
                        messengerCache.putMessenger(messenger);
                    }
                }
            }
            if (messenger == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sendMessage failed to obtain messenger to peer : " + this.peer));
                }
                throw new IOException("sendMessage failed to obtain messenger to peer : " + this.peer);
            }
            try {
                messenger.sendMessage((Message)message.clone());
                return;
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sending message failed. dest peer : " + this.peer), (Throwable)e);
                }
                if (messengerCache == null) continue;
                WeakMessengerCache weakMessengerCache2 = messengerCache;
                synchronized (weakMessengerCache2) {
                    messengerCache.remove(messenger.getDestinationAddress());
                }
            }
        }
        throw new IOException("sendMessage failed to obtain messenger to peer : " + this.peer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

