/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.rendezvous.RendezVousManager;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.util.config.RdvProperties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RdvManager
implements RendezVousManager {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$RdvManager == null ? (class$net$jxta$impl$rendezvous$RdvManager = RdvManager.class$("net.jxta.impl.rendezvous.RdvManager")) : class$net$jxta$impl$rendezvous$RdvManager).getName());
    private PeerGroup group = null;
    private static final long lease = 1200000L;
    private long maxNbOfClients = 200L;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RdvManager;

    public RdvManager(PeerGroup g) {
        this.group = g;
        this.initFromProperties();
    }

    public long requestConnection(Advertisement adv) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"requestConnection: got connection request:");
            LOG.debug((Object)("    peer = " + ((PeerAdvertisement)adv).getPeerID()));
            LOG.debug((Object)"   lease = 20 minutes");
        }
        if (this.allowConnection(((PeerAdvertisement)adv).getPeerID())) {
            return 1200000L;
        }
        return 0L;
    }

    private boolean allowConnection(PeerID clientID) {
        if (clientID == null) {
            return false;
        }
        RendezVousService rendezvous = this.group.getRendezVousService();
        Vector clients = rendezvous.getConnectedPeerIDs();
        long nbOfClients = 0L;
        if (clients != null) {
            nbOfClients = clients.size();
        }
        return nbOfClients < this.maxNbOfClients;
    }

    private void initFromProperties() {
        block2: {
            try {
                RdvProperties prop = new RdvProperties();
                this.maxNbOfClients = prop.getRdvManagerMaxClients();
            }
            catch (NumberFormatException ez) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block2;
                LOG.warn((Object)"RdvManager property is corrupted.");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

