/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import java.util.Hashtable;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.rendezvous.RendezVousMonitor;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.util.config.RdvProperties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RdvMonitor
implements RendezVousMonitor,
RendezvousListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$RdvMonitor == null ? (class$net$jxta$impl$rendezvous$RdvMonitor = RdvMonitor.class$("net.jxta.impl.rendezvous.RdvMonitor")) : class$net$jxta$impl$rendezvous$RdvMonitor).getName());
    private static final long WATCHDOG_PERIOD = 10000L;
    private static final long ADDEVENT_DELAY = 3000L;
    private static final int MIN_CHOICE_PVSIZE = 4;
    private static final long MAX_CHOICE_DELAY = 12000L;
    private long LEASE_MARGIN = 300000L;
    private long CHALLENGE_TIMEOUT = 90000L;
    private long DEFAULT_LEASE = 1200000L;
    private PeerGroup group = null;
    private Timer timer = null;
    private Random random = null;
    private RendezVousServiceImpl rendezvous = null;
    private boolean connected = false;
    private PeerAdvertisement lastPeerAdv = null;
    private int lastModCount = 0;
    private long rdvLeaseDeadline = 0L;
    private volatile PeerID rdvID = null;
    private volatile Hashtable pendingConnections = new Hashtable();
    private TimerTask currentTask = null;
    private long watchdogStartDate = 0L;
    private long nextAddEvent = 0L;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RdvMonitor;

    public RdvMonitor(PeerGroup g, RendezVousServiceImpl rendezvous) {
        this.group = g;
        this.rendezvous = rendezvous;
        this.random = new Random();
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new TimerThreadNamer("RdvMonitor Timer for " + this.group.getPeerGroupID()), 0L);
        this.connected = false;
        this.lastPeerAdv = g.getPeerAdvertisement();
        this.lastModCount = this.lastPeerAdv.getModCount();
        this.watchdogStartDate = 0L;
        this.initFromProperties();
        Vector rpv = rendezvous.getLocalWalkView();
        if (rpv != null) {
            Object peerId = null;
            int rpvSize = rpv.size();
            long choiceDelay = 12000L - (long)rpvSize * 3000L;
            if (choiceDelay < 0L) {
                choiceDelay = 0L;
            }
            this.watchdogStartDate = TimeUtils.toAbsoluteTimeMillis(choiceDelay);
            this.currentTask = new TimerTask(){

                public void run() {
                    RdvMonitor.this.tick();
                }
            };
            this.timer.schedule(this.currentTask, choiceDelay, 10000L);
        }
        rendezvous.addListener(this);
    }

    public void connected(PeerID peer, long lease) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("connected: new lease from:\n  group = " + this.group.getPeerGroupID() + "\n   peer = " + peer + "\n  lease = " + lease));
        }
        this.rdvID = peer;
        long localLease = 0L;
        localLease = lease <= 0L ? this.DEFAULT_LEASE : Math.min(lease, this.DEFAULT_LEASE);
        this.rdvLeaseDeadline = TimeUtils.toAbsoluteTimeMillis(localLease);
        this.closeAllPendingConnections();
        this.connected = true;
    }

    public void disconnected(PeerID peer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("disconnected from RendezVous\n  group = " + this.group.getPeerGroupID() + "\n peerId = " + peer.toString()));
        }
        this.connected = false;
        this.rdvID = null;
        this.rdvLeaseDeadline = 0L;
    }

    public void discovered(Advertisement adv) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"discovered: got new RendezVousService advertisement.");
        }
    }

    private void gcPending() {
        Connect[] allPending = this.pendingConnections.values().toArray(new Connect[0]);
        int i = allPending.length;
        while (i-- > 0) {
            if (!allPending[i].isExpired()) continue;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("pending is expired for: " + allPending[i].getPeerId()));
            }
            this.pendingConnections.remove(allPending[i].getPeerId());
            allPending[i].close();
            this.rendezvous.challengeRendezVous(allPending[i].getPeerId(), -1L);
        }
    }

    private void tick() {
        block3: {
            try {
                this.gcPending();
                if (this.connected) {
                    this.checkRdv();
                    break block3;
                }
                this.connectRdv();
            }
            catch (Throwable t) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)("Uncaught throwable in thread :" + Thread.currentThread().getName()), t);
            }
        }
    }

    public void rendezvousEvent(RendezvousEvent event) {
        switch (event.getType()) {
            case 10: {
                try {
                    long choiceDelay;
                    if (this.connected) break;
                    if (this.watchdogStartDate == 0L) {
                        choiceDelay = 12000L;
                        this.watchdogStartDate = TimeUtils.toAbsoluteTimeMillis(choiceDelay);
                    } else {
                        choiceDelay = TimeUtils.toRelativeTimeMillis(this.watchdogStartDate);
                    }
                    if (choiceDelay <= 0L) {
                        if (TimeUtils.toRelativeTimeMillis(this.nextAddEvent) > 0L) break;
                        this.nextAddEvent = TimeUtils.toAbsoluteTimeMillis(3000L);
                        choiceDelay = 0L;
                    } else {
                        this.watchdogStartDate -= 3000L;
                    }
                    if (this.currentTask != null) {
                        this.currentTask.cancel();
                    }
                    this.currentTask = new TimerTask(){

                        public void run() {
                            RdvMonitor.this.tick();
                        }
                    };
                    this.timer.schedule(this.currentTask, choiceDelay, 10000L);
                }
                catch (Exception anything) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break;
                    LOG.warn((Object)"Event not processed", (Throwable)anything);
                }
                break;
            }
        }
    }

    private void checkRdv() {
        block6: {
            PeerAdvertisement currPeerAdv = this.group.getPeerAdvertisement();
            int currModCount = currPeerAdv.getModCount();
            PeerID currRdvID = this.rdvID;
            if (currRdvID == null) {
                return;
            }
            if (this.lastPeerAdv != currPeerAdv || this.lastModCount != currModCount) {
                this.lastPeerAdv = currPeerAdv;
                this.lastModCount = currModCount;
                this.rdvLeaseDeadline = TimeUtils.toAbsoluteTimeMillis(this.CHALLENGE_TIMEOUT);
                this.rendezvous.challengeRendezVous(currRdvID, this.CHALLENGE_TIMEOUT);
            }
            try {
                long leaseRemaining = TimeUtils.toRelativeTimeMillis(this.rdvLeaseDeadline);
                if (leaseRemaining <= this.LEASE_MARGIN) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"rdv renew lease.");
                    }
                    this.rendezvous.reconnectToRendezVous(currRdvID);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block6;
                LOG.debug((Object)"rdv renewal failed.", (Throwable)e);
            }
        }
    }

    private void connectRdv() {
        block3: {
            this.lastPeerAdv = this.group.getPeerAdvertisement();
            this.lastModCount = this.lastPeerAdv.getModCount();
            try {
                PeerID peerId = this.getRandomRdv();
                if (peerId == null) {
                    return;
                }
                this.connectToRendezVous(peerId);
            }
            catch (Exception ez) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block3;
                LOG.debug((Object)"rdv connection failed.", (Throwable)ez);
            }
        }
    }

    private PeerID getRandomRdv() {
        Vector rpv = this.rendezvous.getLocalWalkView();
        if (rpv == null) {
            return null;
        }
        PeerID peerId = null;
        for (int rpvSize = rpv.size(); rpvSize > 0; --rpvSize) {
            int target = this.random.nextInt(rpvSize);
            RdvAdvertisement adv = (RdvAdvertisement)rpv.remove(target);
            peerId = adv.getPeerID();
            Connect connect = (Connect)this.pendingConnections.get(peerId);
            if (connect != null && connect.busy()) continue;
            return peerId;
        }
        return null;
    }

    private void connectToRendezVous(PeerID peerId) {
        Connect connect = (Connect)this.pendingConnections.get(peerId);
        if (connect == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Trying : " + peerId));
            }
            connect = new Connect(this, peerId, this.rendezvous);
            this.pendingConnections.put(peerId, connect);
        } else if (connect.busy()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Skipping : " + peerId));
            }
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Retrying : " + peerId));
            }
            connect.tryAgain();
        }
    }

    private EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID = null;
        try {
            asID = IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
        }
        catch (MalformedURLException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        catch (UnknownServiceException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return this.mkAddress(asID, serv, parm);
    }

    private EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    public void close() {
        this.rendezvous.removeListener(this);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.currentTask = null;
        this.closeAllPendingConnections();
    }

    /*
     * Unable to fully structure code
     */
    private void closeAllPendingConnections() {
        grabit = this.pendingConnections;
        this.pendingConnections = new Hashtable<K, V>();
        connections = grabit.elements();
        if (connections != null && connections.hasMoreElements()) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            try {
                conn = (Connect)connections.nextElement();
                Connect.access$300(conn);
                continue;
            }
            catch (Exception ez1) {
                // empty catch block
            }
lbl12:
            // 3 sources

            ** while (connections.hasMoreElements())
        }
lbl13:
        // 1 sources

    }

    private void initFromProperties() {
        block2: {
            try {
                RdvProperties prop = new RdvProperties();
                this.LEASE_MARGIN = prop.getRdvMonitorLeaseMargin();
                this.DEFAULT_LEASE = prop.getRdvMonitorDefaultLease();
            }
            catch (NumberFormatException ez) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block2;
                LOG.warn((Object)"RdvManager property is corrupted.");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Connect
    implements Runnable {
        private RendezVousServiceImpl rdvService = null;
        private RdvMonitor monitor = null;
        private PeerID peer = null;
        private Thread thread = null;
        private long expiresAt = 0L;

        Connect(RdvMonitor monitor, PeerID peer, RendezVousServiceImpl rdvService) {
            this.rdvService = rdvService;
            this.monitor = monitor;
            this.peer = peer;
            this.expiresAt = TimeUtils.toAbsoluteTimeMillis(RdvMonitor.this.CHALLENGE_TIMEOUT);
            this.tryAgain();
        }

        private void tryAgain() {
            this.thread = new Thread((Runnable)this, "RdvMonitor connection to " + this.peer.toString());
            this.thread.setDaemon(true);
            this.thread.start();
            Thread.yield();
        }

        private boolean isExpired() {
            return TimeUtils.toRelativeTimeMillis(this.expiresAt) < 0L;
        }

        private boolean busy() {
            return this.thread != null;
        }

        public void run() {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("  Connecting to " + this.peer.toString()));
            }
            this.rdvService.reconnectToRendezVous(this.peer);
            this.thread = null;
        }

        private void close() {
            block4: {
                if (this.thread != null) {
                    try {
                        this.thread.interrupt();
                    }
                    catch (Exception ez) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block4;
                        LOG.debug((Object)"Cannot interrupt thread", (Throwable)ez);
                    }
                }
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Pending Connection closed: " + this.peer));
            }
        }

        private PeerID getPeerId() {
            return this.peer;
        }
    }
}

