/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLElement;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RendezVousPropagateMessage {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$RendezVousPropagateMessage == null ? (class$net$jxta$impl$rendezvous$RendezVousPropagateMessage = RendezVousPropagateMessage.class$("net.jxta.impl.rendezvous.RendezVousPropagateMessage")) : class$net$jxta$impl$rendezvous$RendezVousPropagateMessage).getName());
    public static final String MSG_NAME = "jxta:RendezVousPropagateMessage";
    public static final String TTLTag = "TTL";
    public static final String PathTag = "Path";
    public static final String DestSNameTag = "DestSName";
    public static final String DestSParamTag = "DestSParam";
    public static final String MsgIdTag = "MessageId";
    public static final String Name = "RendezVousPropagate";
    private Vector path = null;
    private int TTL = Integer.MIN_VALUE;
    private String destSName = null;
    private String destSParam = null;
    private UUID msgId = null;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RendezVousPropagateMessage;
    static /* synthetic */ Class class$net$jxta$document$XMLElement;

    public RendezVousPropagateMessage() {
        this.path = new Vector();
    }

    public RendezVousPropagateMessage(InputStream ip) throws IOException {
        this(StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, ip));
    }

    public RendezVousPropagateMessage(Element root) {
        this();
        if (!(class$net$jxta$document$XMLElement == null ? (class$net$jxta$document$XMLElement = RendezVousPropagateMessage.class$("net.jxta.document.XMLElement")) : class$net$jxta$document$XMLElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(MSG_NAME) && !MSG_NAME.equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
        if (Integer.MIN_VALUE == this.getTTL()) {
            throw new IllegalArgumentException("TTL value not specified");
        }
        if (null == this.destSName) {
            throw new IllegalArgumentException("destination service name uninitialized");
        }
        if (null == this.destSParam) {
            throw new IllegalArgumentException("destination service param uninitialized");
        }
        if (null == this.msgId) {
            throw new IllegalArgumentException("message id uninitialized");
        }
    }

    protected boolean handleElement(Element raw) {
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(TTLTag)) {
            this.TTL = Integer.parseInt(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(PathTag)) {
            this.addToPath(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(DestSNameTag)) {
            this.destSName = elem.getTextValue();
            return true;
        }
        if (elem.getName().equals(DestSParamTag)) {
            this.destSParam = elem.getTextValue();
            return true;
        }
        if (elem.getName().equals(MsgIdTag)) {
            try {
                this.msgId = new UUID(elem.getTextValue());
            }
            catch (IllegalArgumentException iae) {
                try {
                    this.msgId = UUIDFactory.newHashUUID(Long.parseLong(elem.getTextValue()), 0L);
                }
                catch (NumberFormatException notanumber) {
                    this.msgId = UUIDFactory.newHashUUID(elem.getTextValue().hashCode(), 0L);
                }
            }
            return true;
        }
        return false;
    }

    public Vector getPath() {
        return this.path;
    }

    public void addToPath(String e) {
        this.path.addElement(e);
    }

    public boolean hasInPath(String e) {
        return this.path.contains(e);
    }

    public void setPath(Vector p) {
        this.path = p;
    }

    public int getTTL() {
        return this.TTL;
    }

    public void setTTL(int t) {
        this.TTL = t;
    }

    public void setMsgId(UUID id) {
        this.msgId = id;
    }

    public UUID getMsgId() {
        return this.msgId;
    }

    public String getDestSName() {
        return this.destSName;
    }

    public void setDestSName(String sName) {
        this.destSName = sName;
    }

    public String getDestSParam() {
        return this.destSParam;
    }

    public void setDestSParam(String sParam) {
        this.destSParam = sParam;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        if (this.getTTL() <= 0) {
            throw new IllegalStateException("TTL value < 1");
        }
        if (null == this.destSName) {
            throw new IllegalStateException("destination service name uninitialized");
        }
        if (null == this.destSParam) {
            throw new IllegalStateException("destination service param uninitialized");
        }
        if (null == this.msgId) {
            throw new IllegalStateException("message id uninitialized");
        }
        StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(encodeAs, MSG_NAME);
        if (doc instanceof Attributable) {
            ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Element e = null;
        e = doc.createElement(TTLTag, Integer.toString(this.TTL));
        doc.appendChild(e);
        e = doc.createElement(DestSNameTag, this.destSName);
        doc.appendChild(e);
        e = doc.createElement(DestSParamTag, this.destSParam);
        doc.appendChild(e);
        if (this.path != null) {
            int i = 0;
            while (i < this.path.size()) {
                e = doc.createElement(PathTag, (String)this.path.elementAt(i));
                doc.appendChild(e);
                ++i;
            }
        }
        e = doc.createElement(MsgIdTag, this.msgId.toString());
        doc.appendChild(e);
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

