/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.config.Config;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.rendezvous.RdvManager;
import net.jxta.impl.rendezvous.RdvMonitor;
import net.jxta.impl.rendezvous.RendezVousServiceInterface;
import net.jxta.impl.rendezvous.RendezVousServiceProvider;
import net.jxta.impl.rendezvous.edge.EdgePeerRdvService;
import net.jxta.impl.rendezvous.rdv.RdvPeerRdvService;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMonitor;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.impl.rendezvous.rpv.PeerViewEvent;
import net.jxta.impl.rendezvous.rpv.PeerViewListener;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.JxtaLoader;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.rendezvous.RendezVousManager;
import net.jxta.rendezvous.RendezVousMonitor;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RendezVousServiceImpl
implements RendezVousService,
PeerViewListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$RendezVousServiceImpl == null ? (class$net$jxta$impl$rendezvous$RendezVousServiceImpl = RendezVousServiceImpl.class$("net.jxta.impl.rendezvous.RendezVousServiceImpl")) : class$net$jxta$impl$rendezvous$RendezVousServiceImpl).getName());
    public static final String PROPERTIES_FILENAME = Config.JXTA_HOME + "jxta.properties";
    public static final String PROP_RDV_WATCHDOG = "Rdv.Rdv-Watchdog";
    private PeerGroup group = null;
    private PeerGroup advGroup = null;
    private ID assignedID = null;
    protected boolean configIsRendezvous = false;
    protected boolean autoRendezvous = false;
    private String[] savedArgs = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private RendezVousServiceProvider provider = null;
    private ConfigParams confAdv = null;
    protected Vector applisteners = new Vector();
    protected Hashtable listeners = new Hashtable();
    protected RendezVousMonitor monitor = null;
    private Timer timer = null;
    private long rdv_watchdog_delay = 300000L;
    private static final double DEMOTION_FACTOR = 0.05;
    private static final long DEMOTION_MIN_PEERVIEW_COUNT = 5L;
    private static final long DEMOTION_MIN_CLIENT_COUNT = 3L;
    protected static final int MaxNbOfStoredIds = 1000;
    protected Vector msgIds = new Vector(1000);
    public static final String IncarnationTag = "RdvIncarn";
    private String incarnationTagName = null;
    private Random random = new Random();
    private RendezvousServiceMonitor rendezvousServiceMonitor;
    private Boolean rdvProviderSwitchLock = Boolean.FALSE;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RendezVousServiceImpl;

    public Service getInterface() {
        return new RendezVousServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(PeerGroup g, ID assignedID, Advertisement impl) {
        StructuredTextDocument params;
        this.confAdv = g.getConfigAdvertisement();
        this.group = g;
        this.assignedID = assignedID;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.incarnationTagName = IncarnationTag + this.group.getPeerGroupID().getUniqueValue().toString();
        try {
            this.advGroup = ((RefPeerGroup)g).getParentGroup();
        }
        catch (Exception ez) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Cannot get parent group: no advertising group", (Throwable)ez);
            }
            this.advGroup = null;
        }
        if (this.advGroup == null) {
            this.advGroup = this.group;
        }
        if (this.confAdv != null && (params = (StructuredTextDocument)this.confAdv.getServiceParam(assignedID)) != null) {
            Enumeration param = params.getChildren("Rdv");
            this.configIsRendezvous = param.hasMoreElements() && "true".equals(((TextElement)param.nextElement()).getTextValue());
            param = params.getChildren("AutoRdv");
            this.autoRendezvous = param.hasMoreElements() && "true".equals(((TextElement)param.nextElement()).getTextValue());
        }
        this.initFromProperties();
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring RendezVous Service : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + this.group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + this.group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + this.group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tAdvertising group : " + this.group.getPeerGroupName() + " [" + this.group.getPeerGroupID() + "]");
            configInfo.append("\n\t\tRendezVous : " + this.configIsRendezvous);
            configInfo.append("\n\t\tAuto RendezVous : " + this.autoRendezvous);
            configInfo.append("\n\t\tRendezVous Watchdog Delay : " + this.rdv_watchdog_delay);
            LOG.info((Object)configInfo);
        }
        Boolean bl = this.rdvProviderSwitchLock;
        synchronized (bl) {
            this.rdvProviderSwitchLock = Boolean.TRUE;
            if (this.configIsRendezvous && !PeerGroupID.worldPeerGroupID.equals(this.group.getPeerGroupID())) {
                this.provider = new RdvPeerRdvService(this, this.group, this.advGroup, assignedID, this.confAdv);
                this.provider.setRendezVousManager(new RdvManager(this.group));
            } else {
                this.provider = new EdgePeerRdvService(this, this.group, this.advGroup, assignedID, this.confAdv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startApp(String[] arg) {
        Boolean bl = this.rdvProviderSwitchLock;
        synchronized (bl) {
            if (arg != null) {
                try {
                    this.savedArgs = (String[])arg.clone();
                }
                catch (Exception ez) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Cloning of String array failed: " + ez));
                    }
                    this.savedArgs = arg;
                }
                this.provider.startApp(arg);
            } else {
                this.provider.startApp(null);
            }
            this.rdvProviderSwitchLock = Boolean.FALSE;
        }
        if (this.autoRendezvous && !PeerGroupID.worldPeerGroupID.equals(this.group.getPeerGroupID())) {
            this.startWatchDogTimer();
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Rendezvous Serivce started");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopApp() {
        Boolean bl = this.rdvProviderSwitchLock;
        synchronized (bl) {
            this.rdvProviderSwitchLock = Boolean.TRUE;
            if (this.provider != null) {
                this.provider.stopApp();
                this.provider = null;
            }
        }
        Iterator eachListener = this.listeners.keySet().iterator();
        while (eachListener.hasNext()) {
            String aListener = (String)eachListener.next();
            ((EndpointService)this.group.getEndpointService().getInterface()).removeIncomingMessageListener(aListener, null);
            eachListener.remove();
        }
        if (this.monitor != null && this.monitor instanceof RdvMonitor) {
            ((RdvMonitor)this.monitor).close();
            this.monitor = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.msgIds.clear();
        this.applisteners.clear();
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Rendezvous Serivce stopped");
        }
    }

    public boolean isRendezVous() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.isRendezVous();
        }
        return false;
    }

    public synchronized boolean setAutoStart(boolean auto) {
        boolean old = this.autoRendezvous;
        this.autoRendezvous = auto;
        if (auto && !old) {
            this.startWatchDogTimer();
        } else if (old && !auto) {
            this.stopWatchDogTimer();
        }
        return old;
    }

    public synchronized boolean setAutoStart(boolean auto, long period) {
        this.rdv_watchdog_delay = period;
        return this.setAutoStart(auto);
    }

    public final synchronized RendezVousMonitor setMonitor(RendezVousMonitor handler) {
        RendezVousMonitor old;
        block2: {
            old = this.monitor;
            this.monitor = handler;
            if (old == null) break block2;
            try {
                ((RdvMonitor)old).close();
            }
            catch (Exception ex) {}
        }
        return old;
    }

    private void startWatchDogTimer() {
        block3: {
            try {
                if (this.timer == null) {
                    this.timer = new Timer(true);
                    this.timer.schedule((TimerTask)new TimerThreadNamer("RendezVousServiceImpl Timer for " + this.group.getPeerGroupID()), 0L);
                }
                this.timer.schedule((TimerTask)new RdvWatchdogTask(this), this.rdv_watchdog_delay, this.rdv_watchdog_delay);
            }
            catch (Exception ez) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block3;
                LOG.error((Object)"Cannot set RDV Watchdog timer: ", (Throwable)ez);
            }
        }
    }

    private void stopWatchDogTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void connectToRendezVous(PeerAdvertisement adv) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV Service provider");
        }
        currentProvider.connectToRendezVous(adv);
    }

    public void connectToRendezVous(EndpointAddress addr) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV Service provider");
        }
        currentProvider.connectToRendezVous(addr);
    }

    public void reconnectToRendezVous(ID peer) {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            currentProvider.reconnectToRendezVous(peer);
        }
    }

    public void challengeRendezVous(ID peer, long delay) {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            currentProvider.challengeRendezVous(peer, delay);
        }
    }

    public void disconnectFromRendezVous(ID peerId) {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            currentProvider.disconnectFromRendezVous(peerId);
        }
    }

    public Enumeration getConnectedRendezVous() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.getConnectedRendezVous();
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getDisconnectedRendezVous() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.getDisconnectedRendezVous();
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getConnectedPeers() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.getConnectedPeers();
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Vector getConnectedPeerIDs() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.getConnectedPeerIDs();
        }
        return new Vector();
    }

    public boolean isConnectedToRendezVous() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.isConnectedToRendezVous();
        }
        return false;
    }

    public void sendRendezVousAdv(PeerAdvertisement destPeer, PeerAdvertisement rdv) {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            currentProvider.sendRendezVousAdv(destPeer, rdv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRendezVous(RendezVousManager handler) throws IOException {
        if (this.isRendezVous() || PeerGroupID.worldPeerGroupID.equals(this.group.getPeerGroupID())) {
            return;
        }
        Boolean bl = this.rdvProviderSwitchLock;
        synchronized (bl) {
            if (this.rdvProviderSwitchLock.booleanValue()) {
                IOException failed = new IOException("Currently switching rendezvous configuration. try again later.");
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Failed to stop rendezvous", (Throwable)failed);
                }
                throw failed;
            }
            this.rdvProviderSwitchLock = Boolean.TRUE;
            if (this.provider != null) {
                this.provider.stopApp();
                this.provider = null;
            }
            this.provider = new RdvPeerRdvService(this, this.group, this.advGroup, this.assignedID, this.confAdv);
            this.provider.setRendezVousManager(handler);
            this.provider.startApp(this.savedArgs);
            this.rdvProviderSwitchLock = Boolean.FALSE;
        }
    }

    public void startRendezVous() {
        block3: {
            if (this.isRendezVous()) {
                return;
            }
            try {
                this.startRendezVous(new RdvManager(this.group));
            }
            catch (IOException failed) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block3;
                LOG.error((Object)"Failed to start rendezvous", (Throwable)failed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRendezVous() {
        if (!this.isRendezVous()) {
            return;
        }
        Boolean bl = this.rdvProviderSwitchLock;
        synchronized (bl) {
            if (this.rdvProviderSwitchLock.booleanValue()) {
                IOException failed = new IOException("Currently switching rendezvous configuration. try again later.");
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Failed to stop rendezvous", (Throwable)failed);
                }
            }
            this.rdvProviderSwitchLock = Boolean.TRUE;
            if (this.provider != null) {
                this.provider.stopRendezVous();
                this.provider.stopApp();
                this.provider = null;
            }
            this.provider = new EdgePeerRdvService(this, this.group, this.advGroup, this.assignedID, this.confAdv);
            this.provider.startApp(this.savedArgs);
            this.rdvProviderSwitchLock = Boolean.FALSE;
        }
    }

    public synchronized boolean addPropagateListener(String name, EndpointListener listener) {
        boolean registered;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Add Propagate Listener  name= " + name));
        }
        if (registered = this.group.getEndpointService().addIncomingMessageListener(listener, name, null)) {
            this.listeners.put(name, listener);
        }
        return registered;
    }

    public synchronized EndpointListener getListener(String str) {
        return (EndpointListener)this.listeners.get(str);
    }

    public synchronized EndpointListener removePropagateListener(String name, EndpointListener listener) {
        block4: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Remove Propagate Listener  name= " + name));
            }
            try {
                EndpointService ep = this.group.getEndpointService();
                if (null != ep) {
                    ep.removeIncomingMessageListener(name, null);
                }
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block4;
                LOG.warn((Object)("Could not disconnect listener " + name), (Throwable)ez1);
            }
        }
        return (EndpointListener)this.listeners.remove(name);
    }

    public void propagate(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagate(msg, serviceName, serviceParam, defaultTTL);
    }

    public void propagate(Enumeration destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagate(destPeerIDs, msg, serviceName, serviceParam, defaultTTL);
    }

    public void walk(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.walk(msg, serviceName, serviceParam, defaultTTL);
    }

    public void walk(Vector destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.walk(destPeerIDs, msg, serviceName, serviceParam, defaultTTL);
    }

    public Vector getLocalWalkView() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.getLocalWalkView();
        }
        return new Vector();
    }

    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int defaultTTL, String prunePeer) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagateToNeighbors(msg, serviceName, serviceParam, defaultTTL, prunePeer);
    }

    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int defaultTTL, String prunePeer) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagateInGroup(msg, serviceName, serviceParam, defaultTTL, prunePeer);
    }

    public final void addListener(RendezvousListener listener) {
        this.applisteners.addElement(listener);
    }

    public final boolean removeListener(RendezvousListener listener) {
        return this.applisteners.removeElement(listener);
    }

    public final void generateEvent(int type, ID peer) {
        Iterator<Object> eachListener = Arrays.asList(this.applisteners.toArray()).iterator();
        while (eachListener.hasNext()) {
            RendezvousListener rl = (RendezvousListener)eachListener.next();
            RendezvousEvent newevent = new RendezvousEvent(this.getInterface(), type, peer);
            try {
                rl.rendezvousEvent(newevent);
            }
            catch (Throwable ignored) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                LOG.error((Object)("Uncaught Throwable in listener : (" + rl.getClass().getName() + ")"), ignored);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stopApp();
    }

    public void peerViewEvent(PeerViewEvent event) {
        PeerViewElement el = event.getPeerViewElement();
        PeerID id = el.getRdvAdvertisement().getPeerID();
        this.generateEvent(event.getType(), id);
    }

    public void disconnected(PeerID pid) {
        if (this.monitor != null) {
            this.monitor.disconnected(pid);
        }
        this.generateEvent(7, pid);
    }

    public void connected(PeerID pid, long lease) {
        if (this.monitor != null) {
            this.monitor.connected(pid, lease);
        }
    }

    public void discovered(Advertisement adv) {
        if (this.monitor != null) {
            this.monitor.discovered(adv);
        }
    }

    public void addIncarnation(Message msg, PeerID rdvPeerID, String rdvIncarnation) {
        String tmp = rdvPeerID.toString() + "#" + rdvIncarnation;
        StringMessageElement msge = new StringMessageElement(this.incarnationTagName, tmp, null);
        msg.addMessageElement("jxta", msge);
    }

    public void addIncarnation(Message msg, String rdvIncarnation) {
        if (rdvIncarnation == null) {
            return;
        }
        StringMessageElement msge = new StringMessageElement(this.incarnationTagName, rdvIncarnation, null);
        msg.addMessageElement("jxta", msge);
    }

    public boolean hasIncarnationChanged(Message msg, PeerID targetRdvPeerID, String targetRdvIncarnation) {
        String tmp = this.getIncarnation(msg);
        if (tmp == null) {
            return false;
        }
        int index = tmp.indexOf(35);
        if (index < 0) {
            return false;
        }
        try {
            String rdvId = tmp.substring(0, index);
            String rdvIncarnation = tmp.substring(index + 1);
            return rdvId.equals(targetRdvPeerID.toString()) && !rdvIncarnation.equals(targetRdvIncarnation);
        }
        catch (Exception ez1) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Incarnation filter is corrupted " + ez1));
            }
            return false;
        }
    }

    public String getIncarnation(Message msg) {
        MessageElement me = msg.getMessageElement("jxta", this.incarnationTagName);
        if (me == null) {
            return null;
        }
        return me.toString();
    }

    public String newIncarnation() {
        return Long.toString(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMsgIdRecorded(UUID id) {
        Vector vector = this.msgIds;
        synchronized (vector) {
            boolean found = this.msgIds.contains(id);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("isMsgIsRecorded  id : " + id + " =" + found));
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMsgId(UUID id) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Adding Message ID : " + id));
        }
        Vector vector = this.msgIds;
        synchronized (vector) {
            block9: {
                if (this.isMsgIdRecorded(id)) {
                    return;
                }
                if (this.msgIds.size() >= 1000) {
                    try {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"Message id array full, removing oldest id");
                        }
                        this.msgIds.remove(id);
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block9;
                        LOG.warn((Object)"addMsgId failed to remove oldest element: ", (Throwable)e);
                    }
                }
            }
            this.msgIds.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID createMsgId() {
        Vector vector = this.msgIds;
        synchronized (vector) {
            return UUIDFactory.newSeqUUID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initFromProperties() {
        block15: {
            Properties prop;
            block17: {
                block16: {
                    prop = null;
                    InputStream in = null;
                    try {
                        in = new FileInputStream(PROPERTIES_FILENAME);
                    }
                    catch (FileNotFoundException e) {
                        JxtaLoader loader = this.group.getLoader();
                        in = loader.getResourceAsStream(PROPERTIES_FILENAME);
                    }
                    if (in == null) break block16;
                    prop = new Properties();
                    prop.load(in);
                    Object var6_8 = null;
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                    break block17;
                    {
                        catch (IOException e) {
                            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                                LOG.error((Object)("Error reading " + PROPERTIES_FILENAME), (Throwable)e);
                            }
                            Object var6_9 = null;
                            try {
                                in.close();
                            }
                            catch (IOException ignored) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        try {
                            in.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)(PROPERTIES_FILENAME + " cannot be found"));
                }
                return;
            }
            String val = null;
            val = prop.getProperty(PROP_RDV_WATCHDOG);
            if (val == null) break block15;
            try {
                this.rdv_watchdog_delay = Long.parseLong(val);
            }
            catch (NumberFormatException ez) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block15;
                LOG.warn((Object)("Rdv.Rdv-Watchdog is set to improper value (" + val + ")"));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RdvWatchdogTask
    extends TimerTask {
        private RendezVousServiceImpl rdv = null;

        public RdvWatchdogTask(RendezVousServiceImpl rdv) {
            this.rdv = rdv;
        }

        public synchronized void run() {
            block6: {
                try {
                    boolean isFewClients;
                    if (!this.rdv.isRendezVous()) {
                        Enumeration rdvs = this.rdv.getConnectedRendezVous();
                        if (rdvs.hasMoreElements()) break block6;
                        this.rdv.startRendezVous();
                        break block6;
                    }
                    RdvPeerRdvService rdvPeerRdvService = (RdvPeerRdvService)this.rdv.provider;
                    int numberOfClients = rdvPeerRdvService.getClientCount();
                    int peerViewSize = rdvPeerRdvService.getPeerViewCount();
                    boolean isManyElementsInPeerView = (long)peerViewSize > 5L;
                    boolean bl = isFewClients = (long)numberOfClients < 3L;
                    if (!isManyElementsInPeerView) break block6;
                    if (numberOfClients == 0) {
                        this.rdv.stopRendezVous();
                    } else if (isFewClients && this.rdv.random.nextDouble() < 0.05) {
                        this.rdv.stopRendezVous();
                    }
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block6;
                    LOG.fatal((Object)("Uncaught Throwable in Timer : " + Thread.currentThread().getName()), all);
                }
            }
        }
    }
}

