/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.EndpointServiceInterface;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMeter;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMonitor;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.rendezvous.RendezVousManager;
import net.jxta.util.endpoint.WeakMessengerCache;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class RendezVousServiceProvider
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$RendezVousServiceProvider == null ? (class$net$jxta$impl$rendezvous$RendezVousServiceProvider = RendezVousServiceProvider.class$("net.jxta.impl.rendezvous.RendezVousServiceProvider")) : class$net$jxta$impl$rendezvous$RendezVousServiceProvider).getName());
    public static final long GCDelay = 120000L;
    public static final String ConnectRequest = "Connect";
    public static final String DisconnectRequest = "Disconnect";
    public static final String ConnectedPeerReply = "ConnectedPeer";
    public static final String ConnectedLeaseReply = "ConnectedLease";
    public static final String ConnectedRdvAdvReply = "RdvAdvReply";
    public static final String RdvAdvReply = "RdvAdv";
    protected static final String PropSName = "JxtaPropagate";
    protected EndpointService endpoint = null;
    protected ID assignedID = null;
    protected PeerGroup group = null;
    protected PeerGroup advGroup = null;
    protected String pName = null;
    protected String pParam = null;
    protected String headerName = null;
    protected ID localPeerId = null;
    protected String localPeerAddr = null;
    protected PeerAdvertisement localPeerAdv = null;
    protected String PropPName = null;
    protected ConfigParams confAdv = null;
    protected RendezVousServiceImpl rdvService = null;
    protected RendezvousServiceMonitor rendezvousServiceMonitor = null;
    protected RendezvousMeter rendezvousMeter = null;
    protected WeakMessengerCache messengerCache = new WeakMessengerCache();
    protected Timer GCTimer;
    protected PropagateListener propagateListener = null;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RendezVousServiceProvider;

    protected RendezVousServiceProvider(RendezVousServiceImpl rdvService, PeerGroup g, PeerGroup advGroup, ID assignedID, ConfigParams confAdv) {
        this.confAdv = confAdv;
        this.group = g;
        this.advGroup = advGroup;
        this.assignedID = assignedID;
        this.endpoint = g.getEndpointService();
        this.rdvService = rdvService;
        this.pParam = this.group.getPeerGroupID().getUniqueValue().toString();
        this.pName = assignedID.toString();
        this.endpoint.addIncomingMessageListener(this, this.pName, this.pParam);
        this.PropPName = this.pParam;
        this.headerName = "RendezVousPropagate" + this.pParam;
        this.localPeerId = this.group.getPeerID();
        this.localPeerAddr = "jxta://" + this.localPeerId.getUniqueValue().toString();
        this.localPeerAdv = this.group.getPeerAdvertisement();
    }

    protected int startApp(String[] arg) {
        block2: {
            this.GCTimer = new Timer(true);
            this.GCTimer.schedule((TimerTask)new TimerThreadNamer("Rendezvous Service GC Timer for " + this.group.getPeerGroupID()), 0L);
            this.GCTimer.scheduleAtFixedRate((TimerTask)new GCTask(), 120000L, 120000L);
            this.propagateListener = new PropagateListener();
            try {
                this.endpoint.addIncomingMessageListener(this.propagateListener, PropSName, this.PropPName);
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block2;
                LOG.warn((Object)"Cannot register the propagation listener", (Throwable)ez1);
            }
        }
        return 0;
    }

    protected void stopApp() {
        this.endpoint.removeIncomingMessageListener(this.pName, this.pParam);
        if (this.GCTimer != null) {
            this.GCTimer.cancel();
            this.GCTimer = null;
        }
        if (this.propagateListener != null) {
            this.endpoint.removeIncomingMessageListener(PropSName, this.PropPName);
            this.propagateListener = null;
        }
        this.endpoint = null;
        this.group = null;
        this.advGroup = null;
        this.rdvService = null;
        this.messengerCache.clear();
    }

    public void connectToRendezVous(PeerAdvertisement adv) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"No RendezVousService provider");
        }
        throw new IOException("No RendezVousService provider");
    }

    public abstract void connectToRendezVous(EndpointAddress var1) throws IOException;

    public abstract void reconnectToRendezVous(ID var1);

    public abstract void challengeRendezVous(ID var1, long var2);

    public abstract void disconnectFromRendezVous(ID var1);

    public abstract Enumeration getConnectedRendezVous();

    public abstract Enumeration getDisconnectedRendezVous();

    public abstract void setRendezVousManager(RendezVousManager var1);

    public abstract void stopRendezVous();

    public abstract Enumeration getConnectedPeers();

    public abstract Vector getConnectedPeerIDs();

    public abstract void sendRendezVousAdv(PeerAdvertisement var1, PeerAdvertisement var2);

    public abstract void propagate(Message var1, String var2, String var3, int var4) throws IOException;

    public abstract void propagate(Enumeration var1, Message var2, String var3, String var4, int var5) throws IOException;

    public abstract void propagateToNeighbors(Message var1, String var2, String var3, int var4, String var5) throws IOException;

    public abstract void propagateInGroup(Message var1, String var2, String var3, int var4, String var5) throws IOException;

    public abstract boolean isConnectedToRendezVous();

    public abstract boolean isRendezVous();

    public abstract void walk(Message var1, String var2, String var3, int var4) throws IOException;

    public abstract void walk(Vector var1, Message var2, String var3, String var4, int var5) throws IOException;

    public abstract Vector getLocalWalkView();

    public abstract void gc();

    protected abstract void processReceivedMessage(Message var1, String var2, String var3, EndpointAddress var4, EndpointAddress var5);

    protected abstract boolean isMessageValid(RendezVousPropagateMessage var1);

    public void setRendezvousServiceMonitor(RendezvousServiceMonitor rendezvousServiceMonitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendViaCachedMessenger(EndpointAddress dstAddress, Message msg, OutgoingMessageEventListener listener) {
        Messenger messenger = null;
        int retries = 0;
        while (retries++ < 2) {
            WeakMessengerCache weakMessengerCache;
            try {
                WeakMessengerCache weakMessengerCache2 = this.messengerCache;
                synchronized (weakMessengerCache2) {
                    messenger = this.messengerCache.getMessenger(dstAddress);
                }
                if (messenger == null) {
                    messenger = ((EndpointServiceInterface)this.endpoint).getMessengerQ(dstAddress, null, false);
                    weakMessengerCache = this.messengerCache;
                    synchronized (weakMessengerCache) {
                        this.messengerCache.putMessenger(messenger);
                    }
                }
                if (messenger == null) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Cannot get Messenger for " + dstAddress));
                    }
                    return;
                }
                messenger.sendMessage((Message)msg.clone(), dstAddress.getServiceName(), dstAddress.getServiceParameter(), listener);
                return;
            }
            catch (Exception ez1) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Cannot send messenge to " + dstAddress));
                }
                weakMessengerCache = this.messengerCache;
                synchronized (weakMessengerCache) {
                    this.messengerCache.remove(messenger.getDestinationAddress());
                }
            }
        }
    }

    protected EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID = null;
        try {
            asID = IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
        }
        catch (MalformedURLException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        catch (UnknownServiceException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return RendezVousServiceProvider.mkAddress(asID, serv, parm);
    }

    protected static EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    public final boolean isPeerInPropHeader(Message msg, ID peer) {
        MessageElement elem = msg.getMessageElement("jxta", this.headerName);
        if (elem == null) {
            return false;
        }
        try {
            InputStream ip = elem.getStream();
            if (ip == null) {
                return false;
            }
            RendezVousPropagateMessage propHdr = new RendezVousPropagateMessage(ip);
            return propHdr.hasInPath(peer.toString());
        }
        catch (Exception ez1) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class PropagateListener
    implements EndpointListener {
        public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            MessageElement el = message.getMessageElement("jxta", RendezVousServiceProvider.this.headerName);
            if (el == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Dropping " + message + ". No propagate header."));
                }
                return;
            }
            RendezVousPropagateMessage propHdr = null;
            try {
                propHdr = new RendezVousPropagateMessage(el.getStream());
            }
            catch (Exception neverMind) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Dropping " + message + ". Bad propagate header."), (Throwable)neverMind);
                }
                return;
            }
            if (RendezVousServiceProvider.this.isMessageValid(propHdr)) {
                UUID msgId = propHdr.getMsgId();
                RendezVousServiceProvider.this.rdvService.addMsgId(msgId);
                String sName = propHdr.getDestSName();
                String sParam = propHdr.getDestSParam();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Processing " + message + " for " + sName + "/" + sParam));
                }
                RendezVousServiceProvider.this.processReceivedMessage(message, sName, sParam, srcAddr, dstAddr);
            }
        }
    }

    protected class GCTask
    extends TimerTask {
        public void run() {
            block2: {
                try {
                    RendezVousServiceProvider.this.gc();
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block2;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }
    }
}

