/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.conf;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.SortedSet;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;

public class StaticRdvConf {
    public static final String EDGE_PEER_PROPERTY = "EdgePeer";
    public static final String BOOTSTRAP_ADDRESS_PROPERTY = "BootstrapAddress";
    private PeerGroup group = null;
    private boolean isEdgePeer = true;
    private String[] bootAddr = new String[0];
    private PropertyChangeSupport prop = new PropertyChangeSupport(this);

    public synchronized void initialize(PeerGroup agroup) {
        this.group = agroup;
        this.isEdgePeer = true;
        ArrayList<Object> addrs = new ArrayList<Object>();
        ConfigParams confAdv = this.group.getConfigAdvertisement();
        if (confAdv == null) {
            return;
        }
        boolean isRdv = false;
        StructuredDocument confDoc = confAdv.getServiceParam(PeerGroup.rendezvousClassID);
        if (confDoc == null) {
            return;
        }
        Enumeration enumeration = confDoc.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement te = (TextElement)enumeration.nextElement();
            if ("Rdv".equals(te.getName())) {
                if (!"true".equals(te.getValue())) continue;
                this.setProperty(EDGE_PEER_PROPERTY, Boolean.FALSE);
                isRdv = true;
                continue;
            }
            if (!"Addr".equals(te.getName())) continue;
            addrs.add(te.getValue());
        }
        if (!isRdv) {
            this.setProperty(EDGE_PEER_PROPERTY, Boolean.TRUE);
        }
        this.setProperty(BOOTSTRAP_ADDRESS_PROPERTY, addrs.toArray(this.bootAddr));
    }

    protected synchronized void setProperty(String propertyName, Object value) {
        if (EDGE_PEER_PROPERTY.equals(propertyName)) {
            Boolean newValue = (Boolean)value;
            if (this.isEdgePeer != newValue) {
                Boolean oldValue = new Boolean(this.isEdgePeer);
                this.isEdgePeer = newValue;
                this.prop.firePropertyChange(EDGE_PEER_PROPERTY, oldValue, newValue);
            }
        } else if (BOOTSTRAP_ADDRESS_PROPERTY.equals(propertyName)) {
            String[] newValue = (String[])value;
            boolean equal = true;
            if (this.bootAddr.length == newValue.length) {
                int i = 0;
                while (i < this.bootAddr.length) {
                    if (!this.bootAddr[i].equals(newValue[i])) {
                        equal = false;
                        break;
                    }
                    ++i;
                }
            } else {
                equal = false;
            }
            if (!equal) {
                String[] oldValue = (String[])this.bootAddr.clone();
                this.bootAddr = newValue;
                this.prop.firePropertyChange(BOOTSTRAP_ADDRESS_PROPERTY, oldValue, newValue);
            }
        } else {
            throw new IllegalArgumentException("Unsupported property: " + propertyName);
        }
    }

    public synchronized Object getProperty(String propertyName) {
        if (EDGE_PEER_PROPERTY.equals(propertyName)) {
            return this.isEdgePeer ? Boolean.TRUE : Boolean.FALSE;
        }
        if (BOOTSTRAP_ADDRESS_PROPERTY.equals(propertyName)) {
            return this.bootAddr;
        }
        throw new IllegalArgumentException("Unsupported property: " + propertyName);
    }

    public synchronized void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (property == null) {
            this.prop.addPropertyChangeListener(listener);
        } else {
            this.prop.addPropertyChangeListener(property, listener);
        }
    }

    public synchronized void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        if (property == null) {
            this.prop.removePropertyChangeListener(listener);
        } else {
            this.prop.removePropertyChangeListener(property, listener);
        }
    }

    public void kick(SortedSet rpv) {
    }
}

