/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.edge;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RdvMonitor;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.RendezVousServiceProvider;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousConnectionMeter;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.rendezvous.RendezVousManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EdgePeerRdvService
extends RendezVousServiceProvider {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$edge$EdgePeerRdvService == null ? (class$net$jxta$impl$rendezvous$edge$EdgePeerRdvService = EdgePeerRdvService.class$("net.jxta.impl.rendezvous.edge.EdgePeerRdvService")) : class$net$jxta$impl$rendezvous$edge$EdgePeerRdvService).getName());
    public static final int MaxTTL = 200;
    private static final int MAX_RDV_CONNECTIONS = 1;
    private Vector rendezVous = new Vector();
    private Vector removedRendezVous = new Vector();
    private PeerView rpv = null;
    private boolean closed = false;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$edge$EdgePeerRdvService;

    public EdgePeerRdvService(RendezVousServiceImpl rdvService, PeerGroup g, PeerGroup advGroup, ID assignedID, ConfigParams adv) {
        super(rdvService, g, advGroup, assignedID, adv);
        Attribute flags;
        StructuredTextDocument params;
        boolean isWorldGroup = this.group.getPeerGroupID().equals(PeerGroupID.worldPeerGroupID);
        if (isWorldGroup) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("RendezVousService is initialized for group :" + g.getPeerGroupID() + " as an Edge peer. " + "No walk in the world group."));
            }
            return;
        }
        boolean useOnlySeeds = false;
        if (this.confAdv != null && (params = (StructuredTextDocument)this.confAdv.getServiceParam(assignedID)) != null && params instanceof Attributable && (flags = ((Attributable)((Object)params)).getAttribute("Flags")) != null) {
            String val = flags.getValue();
            useOnlySeeds = val != null && val.indexOf("UseOnlySeeds") != -1;
        }
        this.walkInit(useOnlySeeds);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("RendezVousService is initialized for group :" + g.getPeerGroupID() + " as an Edge peer. " + "UseOnlySeeds = " + useOnlySeeds));
        }
    }

    protected int startApp(String[] arg) {
        super.startApp(arg);
        boolean isWorldGroup = this.group.getPeerGroupID().equals(PeerGroupID.worldPeerGroupID);
        if (!isWorldGroup) {
            this.rdvService.setMonitor(new RdvMonitor(this.group, this.rdvService));
        }
        this.rdvService.generateEvent(9, this.group.getPeerID());
        return 0;
    }

    protected synchronized void stopApp() {
        if (this.closed) {
            return;
        }
        this.disconnectFromAllRendezVous();
        this.rdvService.setMonitor(null);
        if (this.rpv != null) {
            this.rpv.close();
        }
        super.stopApp();
        this.closed = true;
    }

    public boolean isRendezVous() {
        return false;
    }

    public Vector getConnectedPeerIDs() {
        return new Vector();
    }

    public Enumeration getConnectedPeers() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public boolean isConnectedToRendezVous() {
        return this.rendezVous.size() > 0;
    }

    public Enumeration getConnectedRendezVous() {
        ArrayList<ID> result = new ArrayList<ID>();
        Iterator<Object> eachRendezvous = Arrays.asList(this.rendezVous.toArray()).iterator();
        while (eachRendezvous.hasNext()) {
            PeerConnection pConn = (PeerConnection)eachRendezvous.next();
            result.add(pConn.getPeer());
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)(result.size() + " rendezvous connections."));
        }
        return Collections.enumeration(result);
    }

    public Enumeration getDisconnectedRendezVous() {
        ArrayList<ID> result = new ArrayList<ID>();
        Iterator<Object> eachRendezvous = Arrays.asList(this.removedRendezVous.toArray()).iterator();
        while (eachRendezvous.hasNext()) {
            PeerConnection pConn = (PeerConnection)eachRendezvous.next();
            result.add(pConn.getPeer());
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)(result.size() + " rendezvous disconnections."));
        }
        return Collections.enumeration(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connectToRendezVous(PeerAdvertisement adv) throws IOException {
        PeerID peerId;
        block7: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"connectToRendezVous with advertisement");
            }
            if ((peerId = adv.getPeerID()).equals(this.group.getPeerID())) {
                return;
            }
            try {
                this.group.getDiscoveryService().publish(adv, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                LOG.warn((Object)"   publish failed with ", (Throwable)e);
            }
        }
        EndpointMessenger messenger = null;
        try {
            EndpointAddress endpointAddress = RendezVousServiceProvider.mkAddress(peerId, this.pName, this.pParam);
            messenger = this.endpoint.getMessenger(endpointAddress);
            if (messenger == null) {
                throw new IOException("Unable to create endpoint messenger to " + endpointAddress);
            }
            RendezvousConnectionMeter rendezvousConnectionMeter = null;
            this.connectToRendezVous((Messenger)messenger, null, rendezvousConnectionMeter);
            Object var7_7 = null;
            if (messenger == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (messenger == null) throw throwable;
            messenger.close();
            throw throwable;
        }
        messenger.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connectToRendezVous(EndpointAddress addr) throws IOException {
        if (addr == null) {
            if (!LOG.isEnabledFor((Priority)Level.WARN)) throw new IllegalArgumentException("bad endpoint address");
            LOG.warn((Object)"bad endpoint address");
            throw new IllegalArgumentException("bad endpoint address");
        }
        String peerIdStr = addr.getProtocolName() + "://" + addr.getProtocolAddress();
        if (peerIdStr.equals(this.localPeerAddr)) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("connectToRendezVous with EndpointAddress :" + addr));
        }
        EndpointAddress connectAddr = new EndpointAddress(addr, this.pName, this.pParam);
        Messenger messenger = null;
        try {
            try {
                messenger = this.endpoint.getMessenger(connectAddr);
                if (messenger == null) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) throw new IOException("No messenger for " + addr);
                    LOG.debug((Object)("No messenger for " + addr));
                    throw new IOException("No messenger for " + addr);
                }
                RendezvousConnectionMeter rendezvousConnectionMeter = null;
                this.connectToRendezVous(messenger, null, rendezvousConnectionMeter);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) throw new IOException("Could not connect to rendezvous : " + addr);
                LOG.debug((Object)("Could not connect to rendezvous : " + addr), (Throwable)e);
                throw new IOException("Could not connect to rendezvous : " + addr);
            }
            Object var7_7 = null;
            if (messenger == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (messenger == null) throw throwable;
            messenger.close();
            throw throwable;
        }
        messenger.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconnectToRendezVous(ID peer) {
        EndpointMessenger messenger;
        block12: {
            block11: {
                RdvAdvertisement adv;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("reconnectToRendezVous to " + peer));
                }
                if (peer.equals(this.group.getPeerID())) {
                    return;
                }
                RouteAdvertisement ra = null;
                PeerViewElement pve = this.rpv.getPeerViewElement((PeerID)peer);
                if (pve != null && (adv = pve.getRdvAdvertisement()) != null) {
                    ra = adv.getRouteAdv();
                }
                messenger = null;
                try {
                    try {
                        EndpointAddress endpointAddress = RendezVousServiceProvider.mkAddress(peer, this.pName, this.pParam);
                        messenger = this.endpoint.getMessenger(endpointAddress, ra);
                        if (messenger == null) {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Could not get messenger for " + endpointAddress + "; aborting"));
                            }
                            Object var8_7 = null;
                            if (messenger == null) return;
                            break block11;
                        }
                        RendezvousConnectionMeter rendezvousConnectionMeter = null;
                        this.connectToRendezVous((Messenger)messenger, this.getIncarnation((PeerID)peer), rendezvousConnectionMeter);
                        break block12;
                    }
                    catch (Exception e) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"reconnecteRendezVous failed ", (Throwable)e);
                        }
                        Object var8_9 = null;
                        if (messenger == null) return;
                        messenger.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (messenger == null) throw throwable;
                    messenger.close();
                    throw throwable;
                }
            }
            messenger.close();
            return;
        }
        Object var8_8 = null;
        if (messenger == null) return;
        messenger.close();
    }

    private void disconnectFromAllRendezVous() {
        Iterator<Object> eachRendezvous = Arrays.asList(this.rendezVous.toArray()).iterator();
        while (eachRendezvous.hasNext()) {
            try {
                PeerConnection pConn = (PeerConnection)eachRendezvous.next();
                this.disconnectFromRendezVous(pConn.getPeer());
            }
            catch (Exception failed) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)"disconnectFromRendezVous failed ", (Throwable)failed);
            }
        }
    }

    public void challengeRendezVous(ID peer, long delay) {
        if (delay <= 0L) {
            this.removeRdv(peer);
            return;
        }
        Iterator<Object> eachRendezvous = Arrays.asList(this.rendezVous.toArray()).iterator();
        while (eachRendezvous.hasNext()) {
            try {
                PeerConnection pConn = (PeerConnection)eachRendezvous.next();
                if (!pConn.getPeer().equals(peer)) continue;
                pConn.setLease(delay);
                return;
            }
            catch (Exception ez) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)"Challenge failed", (Throwable)ez);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnectFromRendezVous(ID peerId) {
        block8: {
            EndpointMessenger messenger = null;
            try {
                block7: {
                    try {
                        messenger = this.endpoint.getMessenger(RendezVousServiceProvider.mkAddress(peerId, this.pName, this.pParam));
                        if (messenger == null) break block7;
                        this.disconnectFromRendezVous((Messenger)messenger);
                    }
                    catch (Exception e) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Error getting messenger to disconnect from rdv " + peerId), (Throwable)e);
                        }
                        Object var5_4 = null;
                        if (messenger != null) {
                            messenger.close();
                        }
                        break block8;
                    }
                }
                Object var5_3 = null;
                if (messenger == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (messenger != null) {
                    messenger.close();
                }
                throw throwable;
            }
            messenger.close();
        }
        this.removeRdv(peerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendRendezVousAdv(PeerAdvertisement destPeer, PeerAdvertisement rdv) {
        EndpointMessenger messenger;
        block11: {
            block10: {
                block9: {
                    try {
                        this.group.getDiscoveryService().publish(destPeer, 0, 0x6DDD00L, 0x6DDD00L);
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block9;
                        LOG.debug((Object)"publish failed with ", (Throwable)e);
                    }
                }
                messenger = null;
                try {
                    try {
                        messenger = this.endpoint.getMessenger(RendezVousServiceProvider.mkAddress(destPeer.getPeerID(), this.pName, this.pParam));
                        if (messenger == null) {
                            Object var6_5 = null;
                            if (messenger == null) return;
                            break block10;
                        }
                        Message msg = new Message();
                        msg.replaceMessageElement("jxta", new TextDocumentMessageElement("RdvAdv", (TextDocument)rdv.getDocument(MimeMediaType.XMLUTF8), null));
                        messenger.sendMessage(msg);
                        break block11;
                    }
                    catch (Exception e) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"Error during send to rdv ", (Throwable)e);
                        }
                        Object var6_7 = null;
                        if (messenger == null) return;
                        messenger.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (messenger == null) throw throwable;
                    messenger.close();
                    throw throwable;
                }
            }
            messenger.close();
            return;
        }
        Object var6_6 = null;
        if (messenger == null) return;
        messenger.close();
    }

    public void setRendezVousManager(RendezVousManager monitor) {
        throw new UnsupportedOperationException("Not supported by edge");
    }

    public void stopRendezVous() {
        throw new UnsupportedOperationException("Not supported by edge");
    }

    private boolean isAlreadyConnected(ID peer) {
        Iterator<Object> eachRendezvous = Arrays.asList(this.rendezVous.toArray()).iterator();
        while (eachRendezvous.hasNext()) {
            PeerConnection pConn = (PeerConnection)eachRendezvous.next();
            if (!pConn.getPeer().equals(peer)) continue;
            return true;
        }
        return false;
    }

    private void processDisconnectRequest(Message msg) {
        PeerAdvertisement adv = null;
        try {
            adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, msg.getMessageElement("jxta", "Disconnect").getStream());
        }
        catch (Exception e) {
            return;
        }
        if (adv == null) {
            return;
        }
        this.removeRdv(adv.getPeerID());
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("demux for group " + this.group.getPeerGroupID()));
        }
        if (msg.getMessageElement("jxta", "RdvAdv") != null) {
            this.processRdvAdvReply(msg);
        }
        if (msg.getMessageElement("jxta", "ConnectedPeer") != null || msg.getMessageElement("jxta", "RdvAdvReply") != null) {
            this.processConnectedReply(msg);
        }
        if (msg.getMessageElement("jxta", "Disconnect") != null) {
            this.processDisconnectRequest(msg);
        }
    }

    public void processReceivedMessage(Message message, String sName, String sParam, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        EndpointListener listener = this.rdvService.getListener(sName + sParam);
        if (listener != null) {
            EndpointAddress realDst = new EndpointAddress(dstAddr, sName, sParam);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Calling local listener for " + realDst + " with " + message));
            }
            try {
                listener.processIncomingMessage(message, srcAddr, realDst);
            }
            catch (Throwable ignored) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)("Uncaught Throwable during callback of (" + listener + ") to " + realDst), ignored);
                }
            }
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"No local listener - repropagate");
            }
            this.rePropagateInGroup(message);
        }
    }

    public void propagate(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        this.propagateInGroup(msg, serviceName, serviceParam, defaultTTL, null);
    }

    public void propagate(Enumeration destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        if (!this.updatePropHeader(msg, defaultTTL, serviceName, serviceParam)) {
            throw new IOException("Cannot update propagation header");
        }
        int eachPeer = 0;
        while (destPeerIDs.hasMoreElements()) {
            PeerID destPeer = (PeerID)destPeerIDs.nextElement();
            this.sendViaCachedMessenger(RendezVousServiceProvider.mkAddress(destPeer, serviceName, serviceParam), msg, null);
            ++eachPeer;
        }
    }

    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int defaultTTL, String prunePeer) throws IOException {
        if (!this.updatePropHeader(msg, defaultTTL, serviceName, serviceParam)) {
            throw new IOException("Cannot update propagation header");
        }
        this.sendToNetwork(msg, "JxtaPropagate", this.PropPName);
    }

    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int defaultTTL, String prunePeer) throws IOException {
        if (!this.updatePropHeader(msg, defaultTTL, serviceName, serviceParam)) {
            throw new IOException("Cannot update propagation header");
        }
        this.sendToNetwork((Message)msg.clone(), "JxtaPropagate", this.PropPName);
        this.sendToEachRendezVous(msg, "JxtaPropagate", this.PropPName);
    }

    protected void rePropagateInGroup(Message msg) {
        block3: {
            try {
                if (this.updatePropHeader(msg, 200, null, null)) {
                    this.sendToNetwork((Message)msg.clone(), "JxtaPropagate", this.PropPName);
                    this.sendToEachRendezVous(msg, "JxtaPropagate", this.PropPName);
                }
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block3;
                LOG.debug((Object)"Cannot repropagate the message ", (Throwable)ez1);
            }
        }
    }

    private synchronized String getIncarnation(PeerID peer) {
        PeerConnection tmp = new PeerConnection(this.group, peer, 0L, null);
        if (this.rendezVous.contains(tmp)) {
            try {
                int index = this.rendezVous.indexOf(tmp);
                if (index == -1) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("cannot access PeerConnection for " + peer));
                    }
                    return null;
                }
                tmp = (PeerConnection)this.rendezVous.elementAt(index);
                return tmp.getIncarnation();
            }
            catch (Exception ez1) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("cannot access PeerConnection for " + peer), (Throwable)ez1);
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRdv(ID peer, long lease, String incarnation) {
        PeerConnection tmp = new PeerConnection(this.group, peer, lease, incarnation);
        int eventType = 0;
        EdgePeerRdvService edgePeerRdvService = this;
        synchronized (edgePeerRdvService) {
            block13: {
                int index = this.rendezVous.indexOf(tmp);
                if (index != -1) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"   already registered");
                    }
                    try {
                        String knownIncarnation;
                        tmp = (PeerConnection)this.rendezVous.elementAt(index);
                        if (!(incarnation == null || (knownIncarnation = tmp.getIncarnation()) != null && knownIncarnation.equals(incarnation))) {
                            this.disconnectFromRendezVous(peer);
                            return;
                        }
                        if (lease < 0L) {
                            tmp.setLease(Long.MAX_VALUE);
                        } else {
                            tmp.setLease(lease);
                        }
                        eventType = 1;
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Got renewed RDV lease for " + peer));
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"addRdv has failed [1] ", (Throwable)e);
                        }
                        break block13;
                    }
                }
                this.rendezVous.add(tmp);
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Got new RDV leased for " + peer));
                }
            }
        }
        tmp.connect();
        this.rdvService.connected((PeerID)peer, lease);
        this.rdvService.generateEvent(eventType, peer);
        this.removedRendezVous.remove(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRdv(ID peer) {
        PeerConnection tmp = new PeerConnection(this.group, peer, 0L, null);
        EdgePeerRdvService edgePeerRdvService = this;
        synchronized (edgePeerRdvService) {
            int index = this.rendezVous.indexOf(tmp);
            if (index == -1) {
                this.rpv.notifyFailure(peer);
                return;
            }
            ((PeerConnection)this.rendezVous.elementAt(index)).close();
            this.rendezVous.removeElement(tmp);
            this.removedRendezVous.addElement(tmp);
        }
        tmp.close();
        this.rdvService.disconnected((PeerID)peer);
        this.rpv.notifyFailure(peer);
        this.rdvService.generateEvent(4, peer);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Disconnect from RDV " + peer));
        }
    }

    private void connectToRendezVous(Messenger messenger, String incarnation, RendezvousConnectionMeter rendezvousConnectionMeter) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"connectToRendezVous begins");
        }
        if (messenger == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"   messenger is null");
            }
            throw new IOException("   messenger is null");
        }
        Message msg = new Message();
        try {
            Document doc = this.localPeerAdv.getDocument(MimeMediaType.XMLUTF8);
            msg.replaceMessageElement("jxta", new TextDocumentMessageElement("Connect", (TextDocument)doc, null));
            if (incarnation != null) {
                this.rdvService.addIncarnation(msg, incarnation);
            }
            messenger.sendMessage(msg);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"connectToRendezVous failed", (Throwable)e);
            }
            throw new IOException("connectToRendezVous failed : " + e.getMessage());
        }
    }

    private void disconnectFromRendezVous(Messenger messenger) throws IOException {
        if (messenger == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"   messenger is null");
            }
            throw new IOException("   messenger is null");
        }
        Message msg = new Message();
        try {
            Document doc = this.localPeerAdv.getDocument(MimeMediaType.XMLUTF8);
            msg.replaceMessageElement("jxta", new TextDocumentMessageElement("Disconnect", (TextDocument)doc, null));
            messenger.sendMessage(msg);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"disconnectFromRendezVous failed", (Throwable)e);
            }
            throw new IOException("disconnectFromRendezVous failed :" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnectedReply(Message msg) {
        PeerID pId;
        long lease;
        MessageElement elem = msg.getMessageElement("jxta", "RdvAdvReply");
        if (null != elem) {
            InputStream is = null;
            try {
                is = elem.getStream();
                PeerAdvertisement adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, is);
                this.group.getDiscoveryService().publish(adv, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"failed to publish Rendezvous Advertisement", (Throwable)e);
                }
            }
            finally {
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException ignored) {}
                }
                is = null;
            }
        }
        try {
            MessageElement el = msg.getMessageElement("jxta", "ConnectedLease");
            if (el == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"missing lease");
                }
                return;
            }
            lease = Long.parseLong(el.toString());
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"parse lease failed with ", (Throwable)e);
            }
            return;
        }
        MessageElement el = msg.getMessageElement("jxta", "ConnectedPeer");
        if (el == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"missing rdv peer");
            }
            return;
        }
        try {
            URL peerID = IDFactory.jxtaURL(el.toString());
            pId = (PeerID)IDFactory.fromURL(peerID);
        }
        catch (ClassCastException badID) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"RDV ID is not a peer ID");
            }
            return;
        }
        catch (UnknownServiceException badID) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Unusable RDV peer ID");
            }
            return;
        }
        catch (MalformedURLException badID) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Bad RDV peer ID");
            }
            return;
        }
        String incarne = this.rdvService.getIncarnation(msg);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("RDV Connect Request : peer=" + pId + " incarnation='" + incarne + "' lease=" + lease + "ms"));
        }
        if (lease == 0L) {
            this.removeRdv(pId);
        } else if (this.rendezVous.size() < 1 || this.isAlreadyConnected(pId)) {
            this.addRdv(pId, lease, incarne);
        } else {
            LOG.debug((Object)("Ignoring connect response from " + pId));
        }
    }

    private void processRdvAdvReply(Message msg) {
        block2: {
            Advertisement adv = null;
            try {
                adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, msg.getMessageElement("jxta", "RdvAdv").getStream());
                this.rdvService.discovered(adv);
            }
            catch (Exception failed) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                LOG.debug((Object)"Publish Rdv Adv failed", (Throwable)failed);
            }
        }
    }

    private void sendToNetwork(Message msg, String serviceName, String serviceParam) throws IOException {
        this.endpoint.propagate(msg, serviceName, serviceParam);
    }

    private void sendToEachRendezVous(Message msg, String serviceName, String serviceParam) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"sendToEachRendezVous");
        }
        if (this.rendezVous.size() == 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"  no rendezvous");
            }
            return;
        }
        ArrayList<PeerConnection> failed = new ArrayList<PeerConnection>();
        Iterator<Object> eachRendezvous = Arrays.asList(this.rendezVous.toArray()).iterator();
        while (eachRendezvous.hasNext()) {
            PeerConnection pConn = (PeerConnection)eachRendezvous.next();
            try {
                if (!pConn.isConnected()) {
                    failed.add(pConn);
                    continue;
                }
                if (this.isPeerInPropHeader(msg, pConn.getPeer())) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)"This peer has already received this progated message");
                    continue;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("   sendToEachRendezVous - send to : " + pConn.getPeerName()));
                }
                Message tmpMsg = (Message)msg.clone();
                if (pConn.getIncarnation() != null) {
                    this.rdvService.addIncarnation(tmpMsg, pConn.getIncarnation());
                }
                pConn.sendMessage(this.messengerCache, tmpMsg, serviceName, serviceParam);
                if (pConn.isConnected()) continue;
                failed.add(pConn);
            }
            catch (Exception e) {
                failed.add(pConn);
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("Failed sending to " + pConn.getPeer()), (Throwable)e);
            }
        }
        int i = 0;
        while (i < failed.size()) {
            block14: {
                try {
                    PeerConnection pConn = (PeerConnection)failed.get(i);
                    this.removeRdv(pConn.getPeer());
                    pConn.close();
                }
                catch (Exception ez) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block14;
                    LOG.warn((Object)" remove failed PeerConnection failed", (Throwable)ez);
                }
            }
            ++i;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"     done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        PeerConnection pConn;
        Vector<PeerConnection> droppedRdvs = new Vector<PeerConnection>();
        EdgePeerRdvService edgePeerRdvService = this;
        synchronized (edgePeerRdvService) {
            Iterator<Object> eachRendezvous = Arrays.asList(this.rendezVous.toArray()).iterator();
            while (eachRendezvous.hasNext()) {
                pConn = (PeerConnection)eachRendezvous.next();
                try {
                    long time = System.currentTimeMillis();
                    if (pConn.isConnected() && pConn.getLease() >= time) continue;
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("GC RDV: drop " + pConn.getPeer() + "\n\tlease left = " + (pConn.getLease() - time) + "\tconnected= " + pConn.isConnected()));
                    }
                    this.rendezVous.remove(pConn);
                    droppedRdvs.addElement(pConn);
                    this.removedRendezVous.add(pConn);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                    LOG.warn((Object)("gc failed for " + pConn.getPeer()), (Throwable)e);
                }
            }
        }
        if (droppedRdvs.size() > 0) {
            int i = 0;
            while (i < droppedRdvs.size()) {
                block11: {
                    pConn = (PeerConnection)droppedRdvs.elementAt(i);
                    try {
                        this.rdvService.disconnected((PeerID)pConn.getPeer());
                        this.rpv.notifyFailure(pConn.getPeer());
                        pConn.close();
                    }
                    catch (Exception ez) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block11;
                        LOG.warn((Object)("Cannot GC rdv : " + pConn.getPeer()), (Throwable)ez);
                    }
                }
                ++i;
            }
        }
    }

    private boolean updatePropHeader(Message msg, int defaultTTL, String serviceName, String serviceParam) throws IOException {
        RendezVousPropagateMessage propHdr = null;
        if (defaultTTL > 200) {
            defaultTTL = 200;
        }
        try {
            InputStream ip;
            MessageElement elem = msg.getMessageElement("jxta", this.headerName);
            if (elem != null) {
                msg.removeMessageElement(elem);
            }
            if (elem != null && (ip = elem.getStream()) != null) {
                propHdr = new RendezVousPropagateMessage(ip);
                int msgTTL = propHdr.getTTL();
                if (msgTTL > defaultTTL) {
                    msgTTL = defaultTTL;
                }
                if (msgTTL < 2) {
                    return false;
                }
                propHdr.setTTL(--msgTTL);
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Error updating the header", (Throwable)e);
            }
            return false;
        }
        if (propHdr == null) {
            if (defaultTTL < 1) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"TTL < 1 - message is still-born");
                }
                return false;
            }
            propHdr = new RendezVousPropagateMessage();
            propHdr.setTTL(defaultTTL);
            if (serviceName == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"No destination - discard");
                }
                return false;
            }
            propHdr.setDestSName(serviceName);
            propHdr.setDestSParam(serviceParam);
            propHdr.setMsgId(this.rdvService.createMsgId());
            this.rdvService.addMsgId(propHdr.getMsgId());
        }
        propHdr.addToPath(this.localPeerId.toString());
        try {
            msg.replaceMessageElement("jxta", new TextDocumentMessageElement(this.headerName, (TextDocument)propHdr.getDocument(MimeMediaType.XMLUTF8), null));
        }
        catch (IllegalStateException badHdr) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Could not add prop header to message", (Throwable)badHdr);
            }
            return false;
        }
        return true;
    }

    public boolean isMessageValid(RendezVousPropagateMessage propHdr) {
        if (propHdr.getTTL() < 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Dead on arrival");
            }
            return false;
        }
        if (propHdr.hasInPath(this.localPeerId.toString())) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Loopback");
            }
            return false;
        }
        if (this.rdvService.isMsgIdRecorded(propHdr.getMsgId())) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Feedback " + propHdr.getMsgId()));
            }
            return false;
        }
        return true;
    }

    private void walkInit(boolean useOnlySeeds) {
        this.rpv = new PeerView(this.group, this.advGroup, this.pName + this.pParam, false, useOnlySeeds);
        this.rpv.addListener(this.rdvService);
    }

    public void walk(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        this.propagate(msg, serviceName, serviceParam, defaultTTL);
    }

    public void walk(Vector destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        throw new IOException("EdgePeerRdvService does not implement propagation to multiple destinations");
    }

    public Vector getLocalWalkView() {
        Vector<RdvAdvertisement> tmp = new Vector<RdvAdvertisement>();
        if (this.rpv == null) {
            return tmp;
        }
        Iterator peers = this.rpv.getView().iterator();
        while (peers.hasNext()) {
            try {
                PeerViewElement peer = (PeerViewElement)peers.next();
                RdvAdvertisement adv = peer.getRdvAdvertisement();
                tmp.add(adv);
            }
            catch (Exception ez) {
                return tmp;
            }
        }
        return tmp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

