/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.limited;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.protocol.LimitedRangeRdvMsg;
import net.jxta.impl.rendezvous.RdvGreeter;
import net.jxta.impl.rendezvous.RdvWalk;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.LimitedRangeRdvMessage;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LimitedRangeGreeter
extends RdvGreeter
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$limited$LimitedRangeGreeter == null ? (class$net$jxta$impl$rendezvous$limited$LimitedRangeGreeter = LimitedRangeGreeter.class$("net.jxta.impl.rendezvous.limited.LimitedRangeGreeter")) : class$net$jxta$impl$rendezvous$limited$LimitedRangeGreeter).getName());
    public static final String ServiceName = "LR-Greeter";
    private PeerGroup group = null;
    private EndpointService endpoint = null;
    private PeerView rpv = null;
    private RdvWalk walk = null;
    private boolean started = false;
    private String svcName = null;
    private String svcParam = null;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$limited$LimitedRangeGreeter;

    public LimitedRangeGreeter(PeerGroup group, RdvWalk walk) {
        this.rpv = walk.getPeerView();
        this.group = group;
        this.walk = walk;
        this.svcName = ServiceName + group.getPeerGroupID().toString();
        this.svcParam = walk.getServiceName() + walk.getServiceParam();
        this.endpoint = group.getEndpointService();
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Listening on " + this.svcName + "/" + this.svcParam));
        }
        this.endpoint.addIncomingMessageListener(this, this.svcName, this.svcParam);
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.endpoint.removeIncomingMessageListener(this.svcName, this.svcParam);
        this.started = false;
        this.group = null;
        this.endpoint = null;
        this.rpv = null;
        this.walk = null;
        super.stop();
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        EndpointListener listener = this.getEndpointListener();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Limited Range Greeter received a message");
        }
        if (!this.checkMessage(message)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Limited Range Greeter received an invalid message. Dropping it.");
            }
            return;
        }
        if (listener != null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Limited Range Greeter calls listener");
            }
            listener.processIncomingMessage(message, srcAddr, dstAddr);
        }
    }

    private LimitedRangeRdvMessage getRdvMessage(Message msg) {
        InputStream ip = null;
        LimitedRangeRdvMsg rdvMsg = null;
        MessageElement el = msg.getMessageElement("jxta", "LimitedRangeRdvMessage");
        try {
            if (el == null) {
                return null;
            }
            ip = el.getStream();
            if (ip == null) {
                return null;
            }
            rdvMsg = new LimitedRangeRdvMsg(ip);
        }
        catch (Exception ez) {
            return null;
        }
        return rdvMsg;
    }

    private boolean checkMessage(Message msg) {
        LimitedRangeRdvMessage rdvMsg = this.getRdvMessage(msg);
        if (rdvMsg == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Limited Range Greeter received a message without LimitedRangeRdvMessage: invalid.");
            }
            return false;
        }
        if (rdvMsg.getTTL() <= 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Limited Range Greeter received a message with TTL <=0 (TTL= " + rdvMsg.getTTL() + ") : invalid."));
            }
            return false;
        }
        rdvMsg.setTTL(rdvMsg.getTTL() - 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyMessage(Message msg, Message reply) throws IOException {
        LimitedRangeRdvMessage rdvMsg = this.getRdvMessage(msg);
        if (rdvMsg == null) {
            throw new IOException();
        }
        if (rdvMsg.getTTL() <= 0) {
            throw new IOException();
        }
        EndpointAddress destAddr = this.mkAddress(rdvMsg.getSrcPeerID(), rdvMsg.getSrcSvcName(), rdvMsg.getSrcSvcParams());
        if (destAddr == null) {
            throw new IOException();
        }
        Messenger destMessenger = this.endpoint.getMessenger(destAddr);
        if (destMessenger == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("unable to create EndpointService Messenger for " + destAddr.toString()));
            }
            throw new IOException("unable to create EndpointService Messenger for " + destAddr.toString());
        }
        try {
            destMessenger.sendMessage(reply);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            destMessenger.close();
            throw throwable;
        }
        destMessenger.close();
    }

    private EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID = null;
        try {
            asID = IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
        }
        catch (MalformedURLException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        catch (UnknownServiceException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return this.mkAddress(asID, serv, parm);
    }

    private EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

