/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.limited;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.protocol.LimitedRangeRdvMsg;
import net.jxta.impl.rendezvous.RdvWalker;
import net.jxta.impl.rendezvous.limited.LimitedRangeWalk;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.LimitedRangeRdvMessage;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.util.endpoint.WeakMessengerCache;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LimitedRangeWalker
extends RdvWalker {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$limited$LimitedRangeWalker == null ? (class$net$jxta$impl$rendezvous$limited$LimitedRangeWalker = LimitedRangeWalker.class$("net.jxta.impl.rendezvous.limited.LimitedRangeWalker")) : class$net$jxta$impl$rendezvous$limited$LimitedRangeWalker).getName());
    private LimitedRangeWalk walk = null;
    private PeerGroup group = null;
    private PeerView rpv = null;
    private PeerViewElement localpve = null;
    private String svcName = null;
    private String svcParam = null;
    private EndpointService endpoint = null;
    private WeakMessengerCache messengerCache = new WeakMessengerCache();
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$limited$LimitedRangeWalker;

    public LimitedRangeWalker() {
    }

    public LimitedRangeWalker(PeerGroup group, LimitedRangeWalk walk) {
        this.walk = walk;
        this.group = group;
        this.rpv = walk.getPeerView();
        this.localpve = this.rpv.getSelf();
        this.svcName = "LR-Greeter" + group.getPeerGroupID().toString();
        this.svcParam = walk.getServiceName() + walk.getServiceParam();
        this.endpoint = group.getEndpointService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.walk = null;
        this.group = null;
        this.rpv = null;
        this.localpve = null;
        if (this.messengerCache != null) {
            WeakMessengerCache weakMessengerCache = this.messengerCache;
            synchronized (weakMessengerCache) {
                this.messengerCache.clear();
                this.messengerCache = null;
            }
        }
        super.stop();
    }

    public void resendMessage(Message msg) throws IOException {
        LimitedRangeRdvMessage rdvMsg = this.getRdvMessage(msg);
        if (rdvMsg == null) {
            throw new IOException("No LimitedRangeRdvMessage in message");
        }
        this.sendMessage(msg, rdvMsg);
    }

    private void sendMessage(Message msg, LimitedRangeRdvMessage rdvMsg) throws IOException {
        Message newMsg;
        int dir = rdvMsg.getDirection();
        PeerViewElement upPeer = null;
        PeerViewElement downPeer = null;
        if ((dir == 3 || dir == 1) && (upPeer = this.rpv.getUpPeer()) != null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"send UP");
            }
            if (dir == 3) {
                rdvMsg.setDirection(1);
            }
            newMsg = (Message)msg.clone();
            this.updateRdvMessage(newMsg, rdvMsg);
            this.sendToPeer(upPeer, newMsg);
        }
        if ((dir == 3 || dir == 2) && (downPeer = this.rpv.getDownPeer()) != null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"send DOWN");
            }
            if (dir == 3) {
                rdvMsg.setDirection(2);
            }
            newMsg = (Message)msg.clone();
            this.updateRdvMessage(newMsg, rdvMsg);
            this.sendToPeer(downPeer, newMsg);
        }
        if (downPeer == null && upPeer == null) {
            return;
        }
    }

    public void sendMessage(PeerID destPeer, int ttl, PeerID srcPeerID, String srcSvcName, String srcSvcParam, String srcRouteAdv, Message msg) throws IOException {
        LimitedRangeRdvMessage rdvMsg;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"sendMessage() starts");
        }
        if ((rdvMsg = this.getRdvMessage(msg)) == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Creates new RDV message");
            }
            if ((rdvMsg = this.createRdvMessage(srcPeerID, ttl, srcSvcName, srcSvcParam, srcRouteAdv)) == null) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Cannot create RDV message");
                }
                throw new IOException("Cannot create Limited Range RDV message");
            }
        }
        if (ttl < rdvMsg.getTTL()) {
            rdvMsg.setTTL(ttl);
        }
        if (destPeer == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"no destination");
            }
            this.sendMessage(msg, rdvMsg);
        } else {
            this.sendToPeer(destPeer, srcSvcName, srcSvcParam, msg);
        }
    }

    private LimitedRangeRdvMessage createRdvMessage(PeerID srcPeerID, int ttl, String srcSvcName, String srcSvcParam, String srcRouteAdv) {
        LimitedRangeRdvMsg rdvMsg = new LimitedRangeRdvMsg();
        rdvMsg.setTTL(ttl);
        rdvMsg.setDirection(3);
        rdvMsg.setSrcPeerID(srcPeerID.toString());
        rdvMsg.setSrcSvcName(srcSvcName);
        rdvMsg.setSrcSvcParams(srcSvcParam);
        rdvMsg.setSrcRouteAdv(srcRouteAdv);
        return rdvMsg;
    }

    private void updateRdvMessage(Message msg, LimitedRangeRdvMessage rdvMsg) throws IOException {
        TextDocumentMessageElement el = null;
        el = new TextDocumentMessageElement("LimitedRangeRdvMessage", (TextDocument)rdvMsg.getDocument(MimeMediaType.XMLUTF8), null);
        msg.replaceMessageElement("jxta", el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToPeer(PeerID dest, String svcName, String svcParam, Message msg) throws IOException {
        EndpointAddress destAddr = this.mkAddress(dest, svcName, svcParam);
        if (destAddr == null) {
            throw new IOException("Cannot build EndpointAddress");
        }
        Messenger destMessenger = null;
        int retries = 0;
        while (retries++ < 2) {
            WeakMessengerCache weakMessengerCache;
            try {
                WeakMessengerCache weakMessengerCache2 = this.messengerCache;
                synchronized (weakMessengerCache2) {
                    destMessenger = this.messengerCache.getMessenger(destAddr);
                }
                if (destMessenger == null) {
                    destMessenger = this.endpoint.getMessenger(destAddr);
                    weakMessengerCache = this.messengerCache;
                    synchronized (weakMessengerCache) {
                        this.messengerCache.putMessenger(destMessenger);
                    }
                }
                if (destMessenger == null) {
                    this.rpv.notifyFailure(dest);
                    throw new IOException("unable to create EndpointService Messenger for " + destAddr.toString());
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sending walker message to " + dest.toString()));
                }
                destMessenger.sendMessage((Message)msg.clone());
                return;
            }
            catch (Exception ez1) {
                weakMessengerCache = this.messengerCache;
                synchronized (weakMessengerCache) {
                    if (this.messengerCache.containsValue(destMessenger)) {
                        this.messengerCache.remove(destMessenger.getDestinationAddress());
                    }
                }
            }
        }
        this.rpv.notifyFailure(dest);
        throw new IOException("LimitedRangeWalker was not able to send message");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToPeer(PeerViewElement peer, Message msg) throws IOException {
        if (peer == null || msg == null) {
            throw new IOException("sendToPeer: no peer or no msg");
        }
        RdvAdvertisement adv = peer.getRdvAdvertisement();
        if (adv == null) {
            throw new IOException("No peer advertisement");
        }
        RouteAdvertisement routeAdv = adv.getRouteAdv();
        EndpointAddress destAddr = this.mkAddress(adv.getPeerID(), this.svcName, this.svcParam);
        if (destAddr == null) {
            throw new IOException("Cannot build EndpointAddress");
        }
        Messenger destMessenger = null;
        int retries = 0;
        while (retries++ < 2) {
            WeakMessengerCache weakMessengerCache;
            try {
                WeakMessengerCache weakMessengerCache2 = this.messengerCache;
                synchronized (weakMessengerCache2) {
                    destMessenger = this.messengerCache.getMessenger(destAddr);
                }
                if (destMessenger == null) {
                    destMessenger = this.endpoint.getMessenger(destAddr, routeAdv);
                    weakMessengerCache = this.messengerCache;
                    synchronized (weakMessengerCache) {
                        this.messengerCache.putMessenger(destMessenger);
                    }
                }
                if (destMessenger == null) {
                    this.rpv.notifyFailure(adv.getPeerID());
                    throw new IOException("unable to create EndpointService Messenger for " + destAddr.toString());
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sending message " + adv.getName()));
                }
                destMessenger.sendMessage((Message)msg.clone());
                return;
            }
            catch (Exception ez1) {
                weakMessengerCache = this.messengerCache;
                synchronized (weakMessengerCache) {
                    if (this.messengerCache.containsValue(destMessenger)) {
                        this.messengerCache.remove(destMessenger.getDestinationAddress());
                    }
                }
            }
        }
        this.rpv.notifyFailure(adv.getPeerID());
        throw new IOException("LimitedRangeWalker was not able to send message");
    }

    private EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID = null;
        try {
            asID = IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
        }
        catch (MalformedURLException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        catch (UnknownServiceException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return this.mkAddress(asID, serv, parm);
    }

    private EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    private LimitedRangeRdvMessage getRdvMessage(Message msg) {
        InputStream ip = null;
        LimitedRangeRdvMsg rdvMsg = null;
        MessageElement el = msg.getMessageElement("jxta", "LimitedRangeRdvMessage");
        try {
            if (el == null) {
                return null;
            }
            ip = el.getStream();
            if (ip == null) {
                return null;
            }
            rdvMsg = new LimitedRangeRdvMsg(ip);
        }
        catch (Exception ez) {
            return null;
        }
        return rdvMsg;
    }

    private boolean checkMessage(Message msg) {
        LimitedRangeRdvMessage rdvMsg = this.getRdvMessage(msg);
        if (rdvMsg == null) {
            return false;
        }
        if (rdvMsg.getTTL() <= 0) {
            return false;
        }
        rdvMsg.setTTL(rdvMsg.getTTL() - 1);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

