/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rdv;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RdvGreeter;
import net.jxta.impl.rendezvous.RdvWalk;
import net.jxta.impl.rendezvous.RdvWalker;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.RendezVousServiceProvider;
import net.jxta.impl.rendezvous.limited.LimitedRangeWalk;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousConnectionMeter;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.rendezvous.RendezVousManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RdvPeerRdvService
extends RendezVousServiceProvider {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$rdv$RdvPeerRdvService == null ? (class$net$jxta$impl$rendezvous$rdv$RdvPeerRdvService = RdvPeerRdvService.class$("net.jxta.impl.rendezvous.rdv.RdvPeerRdvService")) : class$net$jxta$impl$rendezvous$rdv$RdvPeerRdvService).getName());
    public static final int MaxTTL = 200;
    public static final String RDV_SVC_NAME = "RdvWalkSvcName";
    public static final String RDV_SVC_PARAM = "RdvWalkSvcParam";
    private Vector clients;
    private RendezVousManager manager;
    private boolean stopping;
    private PeerView rpv;
    private RdvWalk walk;
    private RdvGreeter greeter;
    private RdvWalker walker;
    private WalkListener walkListener;
    private String incarnation;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$rdv$RdvPeerRdvService;

    public RdvPeerRdvService(RendezVousServiceImpl rdvService, PeerGroup g, PeerGroup advGroup, ID assignedID, ConfigParams adv) {
        block4: {
            StructuredTextDocument params;
            super(rdvService, g, advGroup, assignedID, adv);
            this.clients = new Vector();
            this.manager = null;
            this.stopping = false;
            this.rpv = null;
            this.walk = null;
            this.greeter = null;
            this.walker = null;
            this.walkListener = null;
            this.incarnation = "no incarnation";
            if (this.confAdv != null && (params = (StructuredTextDocument)this.confAdv.getServiceParam(assignedID)) != null) {
                Enumeration param = params.getChildren("Rdv");
                try {
                    params = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                    TextElement e = params.createElement("Rdv", "true");
                    params.appendChild((Element)e);
                    this.localPeerAdv.putServiceParam(assignedID, params);
                }
                catch (Exception ohwell) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block4;
                    LOG.warn((Object)"Adding service params failed :", (Throwable)ohwell);
                }
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("RDV is initialized for " + g.getPeerGroupID()));
        }
    }

    protected int startApp(String[] arg) {
        super.startApp(arg);
        this.rdvService.setMonitor(null);
        boolean isWorldGroup = this.group.getPeerGroupID().equals(PeerGroupID.worldPeerGroupID);
        if (!isWorldGroup) {
            try {
                this.startRendezVous();
            }
            catch (IOException failed) {
                return -1;
            }
            this.walkInit();
        }
        this.rdvService.generateEvent(8, this.group.getPeerID());
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"RdvPeerRdvService is started");
        }
        return 0;
    }

    protected synchronized void stopApp() {
        this.stopping = true;
        if (this.walkListener != null) {
            this.greeter.setEndpointListener(null);
            this.walkListener = null;
            this.greeter.stop();
            this.greeter = null;
        }
        if (this.rpv != null) {
            this.rpv.removeListener(this.rdvService);
            this.rpv.close();
        }
        if (this.walker != null) {
            this.walker.stop();
            this.walker = null;
        }
        if (this.walk != null) {
            this.walk.stop();
            this.walk = null;
        }
        this.stopRendezVous();
        this.manager = null;
        super.stopApp();
    }

    public void connectToRendezVous(PeerAdvertisement adv) throws IOException {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    public void connectToRendezVous(EndpointAddress addr) throws IOException {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    public void reconnectToRendezVous(ID peer) {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    public void challengeRendezVousLease(ID peer, long timeout) {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    public void challengeRendezVous(ID peer, long delay) {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    public void disconnectFromRendezVous(ID peerId) {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    public boolean isRendezVous() {
        return true;
    }

    public Vector getConnectedPeerIDs() {
        Vector<ID> result = new Vector<ID>();
        Iterator<Object> eachClient = Arrays.asList(this.clients.toArray()).iterator();
        while (eachClient.hasNext()) {
            PeerConnection pConn = (PeerConnection)eachClient.next();
            result.addElement(pConn.getPeer());
        }
        return result;
    }

    public Enumeration getConnectedPeers() {
        return this.getConnectedPeerIDs().elements();
    }

    private void clientIsConnected(String peer) {
        PeerConnection pConn = null;
        boolean toConnect = false;
        Iterator<Object> eachClient = Arrays.asList(this.clients.toArray()).iterator();
        while (eachClient.hasNext()) {
            pConn = (PeerConnection)eachClient.next();
            if (!pConn.getPeer().equals(peer)) continue;
            toConnect = true;
        }
        if (toConnect) {
            pConn.connect();
        }
    }

    public int getClientCount() {
        return this.clients.size();
    }

    public boolean isConnectedToRendezVous() {
        return false;
    }

    public Enumeration getConnectedRendezVous() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getDisconnectedRendezVous() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendRendezVousAdv(PeerAdvertisement destPeer, PeerAdvertisement rdv) {
        EndpointMessenger messenger;
        block11: {
            block10: {
                block9: {
                    try {
                        this.group.getDiscoveryService().publish(destPeer, 0, 0x6DDD00L, 0x6DDD00L);
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block9;
                        LOG.warn((Object)"publish failed with ", (Throwable)e);
                    }
                }
                messenger = null;
                try {
                    try {
                        messenger = this.endpoint.getMessenger(RendezVousServiceProvider.mkAddress(destPeer.getPeerID(), this.pName, this.pParam));
                        if (messenger == null) {
                            Object var6_5 = null;
                            if (messenger == null) return;
                            break block10;
                        }
                        Message msg = new Message();
                        msg.replaceMessageElement("jxta", new TextDocumentMessageElement("RdvAdv", (TextDocument)rdv.getDocument(MimeMediaType.XMLUTF8), null));
                        messenger.sendMessage(msg);
                        break block11;
                    }
                    catch (Exception e) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Error during send to rdv ", (Throwable)e);
                        }
                        Object var6_7 = null;
                        if (messenger == null) return;
                        messenger.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (messenger == null) throw throwable;
                    messenger.close();
                    throw throwable;
                }
            }
            messenger.close();
            return;
        }
        Object var6_6 = null;
        if (messenger == null) return;
        messenger.close();
    }

    private synchronized void startRendezVous() throws IOException {
        block5: {
            if (null == this.manager) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Cannot start -- No RendezvouvManager Specified");
                }
                throw new IOException("Cannot start -- No RendezvouvManager Specified");
            }
            this.incarnation = this.rdvService.newIncarnation();
            try {
                StructuredTextDocument params = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                TextElement e = params.createElement("Rdv", "true");
                params.appendChild((Element)e);
                this.localPeerAdv.putServiceParam(this.assignedID, params);
            }
            catch (Exception ignored) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block5;
                LOG.debug((Object)"Could not add Rdv Params to Peer Advertisement", (Throwable)ignored);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"RendezVousService is started");
        }
    }

    public void setRendezVousManager(RendezVousManager manager) {
        if (null != this.manager) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"RendezvouvManager Already Specified");
            }
            throw new IllegalStateException("RendezvouvManager Already Specified");
        }
        this.manager = manager;
    }

    public synchronized void stopRendezVous() {
        this.disconnectAllClients();
        this.localPeerAdv.removeServiceParam(this.assignedID);
        this.clients.clear();
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"demux");
        }
        if (msg.getMessageElement("jxta", "Connect") != null) {
            this.processConnectRequest(msg);
        }
        if (msg.getMessageElement("jxta", "Disconnect") != null) {
            this.processDisconnectRequest(msg);
        }
        if (msg.getMessageElement("jxta", "RdvAdv") != null) {
            this.processRdvAdvReply(msg);
        }
    }

    public void processReceivedMessage(Message message, String sName, String sParam, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        EndpointListener listener;
        if (this.rdvService.hasIncarnationChanged(message, (PeerID)this.localPeerId, this.incarnation)) {
            this.disconnectFromClient(srcAddr);
        }
        if ((listener = this.rdvService.getListener(sName + sParam)) != null) {
            EndpointAddress realDst = new EndpointAddress(dstAddr, sName, sParam);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Calling local listener for [" + realDst + "] with " + message));
            }
            try {
                listener.processIncomingMessage(message, srcAddr, realDst);
            }
            catch (Throwable ignored) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)("Uncaught Throwable during callback of (" + listener + ") to " + realDst), ignored);
                }
            }
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"No local listener - repropagate");
            }
            this.rePropagateInGroup(message, sName, sParam);
        }
    }

    public void propagate(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        this.propagateInGroup(msg, serviceName, serviceParam, defaultTTL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagate(Enumeration destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        if (destPeerIDs == null || !destPeerIDs.hasMoreElements()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"no destinations");
            }
            return;
        }
        int numPeers = 0;
        try {
            block10: {
                try {
                    if (this.updatePropHeader(msg, defaultTTL, serviceName, serviceParam)) {
                        while (destPeerIDs.hasMoreElements()) {
                            PeerID dest = (PeerID)destPeerIDs.nextElement();
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Sending to client " + dest.toString()));
                            }
                            this.sendToClient(dest, msg, serviceName, serviceParam);
                            ++numPeers;
                        }
                        break block10;
                    }
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block10;
                    LOG.debug((Object)"TTL has expired. Message is dropped");
                }
                catch (Exception ez) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Cannot send message to clients: ", (Throwable)ez);
                    }
                    Object var9_10 = null;
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            throw throwable;
        }
    }

    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int defaultTTL, String prunePeer) throws IOException {
        if (this.updatePropHeader(msg, defaultTTL, serviceName, serviceParam)) {
            boolean successful = this.sendToNetwork(msg, "JxtaPropagate", this.PropPName);
        }
    }

    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int defaultTTL, String prunePeer) throws IOException {
        if (this.updatePropHeader(msg, defaultTTL, serviceName, serviceParam)) {
            this.sendToNetwork((Message)msg.clone(), "JxtaPropagate", this.PropPName);
            this.sendToEachRendezVous((Message)msg.clone(), "JxtaPropagate", this.PropPName);
            this.sendToEachClient(msg, "JxtaPropagate", this.PropPName);
        }
    }

    protected void rePropagateInGroup(Message msg, String sName, String sParam) {
        block3: {
            try {
                if (this.updatePropHeader(msg, 200, null, null)) {
                    this.walk((Message)msg.clone(), sName, sParam, 200);
                }
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block3;
                LOG.debug((Object)"Cannot repropagate the message ", (Throwable)ez1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClient(ID peer, long lease) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"addClient starts");
        }
        Object clientConnectionMeter = null;
        PeerConnection tmp = new PeerConnection(this.group, peer, lease, null);
        int eventType = 2;
        RdvPeerRdvService rdvPeerRdvService = this;
        synchronized (rdvPeerRdvService) {
            block16: {
                if (this.clients.contains(tmp)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"   already registered");
                    }
                    try {
                        int index = this.clients.indexOf(tmp);
                        if (index == -1) {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("addClient: cannot access PeerConnection for " + peer));
                            }
                        } else {
                            tmp = (PeerConnection)this.clients.elementAt(index);
                            if (lease < 0L) {
                                tmp.setLease(Long.MAX_VALUE);
                            } else {
                                tmp.setLease(lease);
                            }
                            eventType = 3;
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Renewed leased for " + peer));
                            }
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"addClient has failed [1] ", (Throwable)e);
                        }
                        break block16;
                    }
                }
                this.clients.addElement(tmp);
            }
        }
        tmp.connect();
        this.rdvService.generateEvent(eventType, peer);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Add client " + peer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(ID peer) {
        PeerConnection tmp = new PeerConnection(this.group, peer, 0L, null);
        RdvPeerRdvService rdvPeerRdvService = this;
        synchronized (rdvPeerRdvService) {
            int index = this.clients.indexOf(tmp);
            if (index == -1) {
                return;
            }
            ((PeerConnection)this.clients.elementAt(index)).close();
            this.clients.removeElement(tmp);
        }
        tmp.close();
        this.rdvService.generateEvent(6, peer);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Remove client " + peer));
        }
    }

    private void connectToRendezVous(Messenger messenger, RendezvousConnectionMeter rendezvousConnectionMeter) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"connectToRendezVous begins");
        }
        if (messenger == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"   messenger is null");
            }
            throw new IOException("   messenger is null");
        }
        Message msg = new Message();
        try {
            try {
                Document doc = this.localPeerAdv.getDocument(MimeMediaType.XMLUTF8);
                msg.replaceMessageElement("jxta", new TextDocumentMessageElement("Connect", (TextDocument)doc, null));
                messenger.sendMessage(msg);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"connectToRendezVous failed", (Throwable)e);
                }
                throw new IOException("connectToRendezVous failed : " + e.getMessage());
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            messenger.close();
            throw throwable;
        }
        messenger.close();
    }

    private void processConnectRequest(Message msg) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"processConnectRequest");
        }
        if (null == this.manager) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot process connect request. No Rendezvous Manger");
            }
            return;
        }
        PeerAdvertisement adv = null;
        try {
            MessageElement elem = msg.getMessageElement("jxta", "Connect");
            adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, elem.getStream());
            msg.removeMessageElement(elem);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"   cannot retrieve advertisment from request", (Throwable)e);
            }
            return;
        }
        if (this.rdvService.hasIncarnationChanged(msg, (PeerID)this.localPeerId, this.incarnation)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"hasIncarnationChanged, disconnecting");
            }
            this.disconnectFromClient(adv.getPeerID());
            return;
        }
        long lease = this.manager.requestConnection(adv);
        if (!this.sendReply(adv.getPeerID(), adv, lease)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("processConnectRequest. Cannot reach client " + adv.getPeerID()));
            }
            return;
        }
        if (lease != 0L) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"  addClient");
            }
            this.addClient(adv.getPeerID(), lease);
        }
    }

    private void processDisconnectRequest(Message msg) {
        PeerAdvertisement adv = null;
        try {
            adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, msg.getMessageElement("jxta", "Disconnect").getStream());
        }
        catch (Exception e) {
            return;
        }
        this.removeClient(adv.getPeerID());
    }

    private void disconnectFromClient(ID peerId) {
        Messenger messenger = null;
        try {
            messenger = this.endpoint.getMessenger(RendezVousServiceProvider.mkAddress(peerId, this.pName, this.pParam));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (messenger == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Error getting messenger to disconnect from client " + peerId));
            }
            return;
        }
        this.sendDisconnect(messenger);
    }

    private void disconnectFromClient(EndpointAddress addr) {
        if (addr == null) {
            return;
        }
        EndpointAddress dstAddr = (EndpointAddress)addr.clone();
        dstAddr.setServiceName(this.pName);
        dstAddr.setServiceParameter(this.pParam);
        Messenger messenger = null;
        try {
            messenger = this.endpoint.getMessenger(dstAddr);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Error getting messenger to disconnect from client " + dstAddr));
            }
            return;
        }
        if (messenger == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Error getting messenger to disconnect from client " + dstAddr));
            }
            return;
        }
        this.sendDisconnect(messenger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendDisconnect(Messenger messenger) {
        Message msg = new Message();
        try {
            try {
                Document doc = this.localPeerAdv.getDocument(MimeMediaType.XMLUTF8);
                msg.replaceMessageElement("jxta", new TextDocumentMessageElement("Disconnect", (TextDocument)doc, null));
                messenger.sendMessage(msg);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"disconnectFromClient failed", (Throwable)e);
                }
                Object var5_6 = null;
                messenger.close();
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            messenger.close();
            throw throwable;
        }
        messenger.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAllClients() {
        Iterator eachConnected = this.getConnectedPeerIDs().iterator();
        while (eachConnected.hasNext()) {
            Object var5_4;
            PeerID peerID = (PeerID)eachConnected.next();
            try {
                try {
                    this.disconnectFromClient(peerID);
                }
                catch (Exception ez1) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"disconnectFromClients failed", (Throwable)ez1);
                    }
                    var5_4 = null;
                    continue;
                }
                var5_4 = null;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                throw throwable;
            }
        }
    }

    private void processRdvAdvReply(Message msg) {
        try {
            Advertisement adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, msg.getMessageElement("jxta", "RdvAdv").getStream());
            this.rdvService.discovered(adv);
        }
        catch (Exception e) {
            return;
        }
    }

    private RouteAdvertisement extractRouteAdv(PeerAdvertisement adv) {
        try {
            TextElement endpParam = (TextElement)((Object)adv.getServiceParam(PeerGroup.endpointClassID));
            if (endpParam == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"getRouteAdv: no Endpoint Params");
                }
                return null;
            }
            Enumeration paramChilds = endpParam.getChildren(RouteAdvertisement.getAdvertisementType());
            Element param = null;
            if (!paramChilds.hasMoreElements()) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"getRouteAdv: no Route Adv in Peer Adv");
                }
                return null;
            }
            param = (Element)paramChilds.nextElement();
            RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param);
            route.setDestPeerID(adv.getPeerID());
            return route;
        }
        catch (Exception e) {
            block6: {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block6;
                LOG.warn((Object)"failed to extract radv", (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendReply(ID peer, PeerAdvertisement adv, long lease) {
        RouteAdvertisement hint;
        block13: {
            this.localPeerAdv = this.group.getPeerAdvertisement();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"sendReply");
            }
            hint = this.extractRouteAdv(adv);
            try {
                this.group.getDiscoveryService().publish(adv, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block13;
                LOG.debug((Object)"   publish failed with ", (Throwable)e);
            }
        }
        EndpointAddress addr = RendezVousServiceProvider.mkAddress(peer, this.pName, this.pParam);
        Messenger messenger = null;
        try {
            messenger = hint == null ? this.endpoint.getMessenger(addr) : this.endpoint.getMessenger(addr, hint);
            if (messenger == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"    no messenger");
                }
                return false;
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"   getting messenger failed with ", (Throwable)e);
            }
            return false;
        }
        Message msg = new Message();
        try {
            block14: {
                try {
                    Document doc = this.localPeerAdv.getDocument(MimeMediaType.XMLUTF8);
                    msg.replaceMessageElement("jxta", new TextDocumentMessageElement("RdvAdvReply", (TextDocument)doc, null));
                    msg.replaceMessageElement("jxta", new StringMessageElement("ConnectedPeer", this.localPeerId.toString(), null));
                    msg.replaceMessageElement("jxta", new StringMessageElement("ConnectedLease", Long.toString(lease), null));
                    this.rdvService.addIncarnation(msg, (PeerID)this.localPeerId, this.incarnation);
                    messenger.sendMessage(msg);
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block14;
                    LOG.debug((Object)"   message sent");
                }
                catch (Exception e) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"  failed with ", (Throwable)e);
                    }
                    boolean bl = false;
                    Object var12_13 = null;
                    messenger.close();
                    return bl;
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            messenger.close();
            throw throwable;
        }
        messenger.close();
        return true;
    }

    private boolean sendToNetwork(Message msg, String serviceName, String queueName) {
        try {
            this.rdvService.addIncarnation(msg, (PeerID)this.localPeerId, this.incarnation);
            this.endpoint.propagate(msg, serviceName, queueName);
            return true;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)e, (Throwable)e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToEachClient(Message msg, String serviceName, String serviceParam) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"sendToEachClient");
        }
        if (this.clients.size() == 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"  no clients");
            }
            return;
        }
        this.rdvService.addIncarnation(msg, (PeerID)this.localPeerId, this.incarnation);
        Vector<PeerConnection> failed = new Vector<PeerConnection>();
        int i = this.clients.size() - 1;
        while (i >= 0) {
            block18: {
                PeerConnection pConn = null;
                try {
                    pConn = (PeerConnection)this.clients.elementAt(i);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("send to client : " + pConn.getPeerName()));
                    }
                    if (this.isPeerInPropHeader(msg, pConn.getPeer())) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("   skipping client : " + pConn.getPeerName()));
                        }
                    } else {
                        Message tmpMsg = (Message)msg.clone();
                        pConn.sendMessage(tmpMsg, serviceName, serviceParam);
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("   sent to : " + pConn.getPeerName()));
                        }
                    }
                }
                catch (Exception e) {
                    failed.addElement(pConn);
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block18;
                    LOG.debug((Object)("   failed sent to : " + pConn.getPeerName()), (Throwable)e);
                }
            }
            --i;
        }
        PeerID peerID = null;
        int i2 = 0;
        while (i2 < failed.size()) {
            Object var10_12;
            try {
                try {
                    PeerConnection pConn = (PeerConnection)failed.elementAt(i2);
                    peerID = (PeerID)pConn.getPeer();
                    this.removeClient(peerID);
                    pConn.close();
                }
                catch (Exception ez) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)" remove failed PeerConnection failed with ", (Throwable)ez);
                    }
                    var10_12 = null;
                }
                var10_12 = null;
            }
            catch (Throwable throwable) {
                var10_12 = null;
                throw throwable;
            }
            ++i2;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"   done");
        }
    }

    private void sendToClient(PeerID destPeerID, Message msg, String serviceName, String serviceParam) {
        if (destPeerID == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"  no destination");
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("sending to " + destPeerID));
        }
        this.rdvService.addIncarnation(msg, (PeerID)this.localPeerId, this.incarnation);
        if (this.isPeerInPropHeader(msg, destPeerID)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("   skipping client : " + destPeerID.toString()));
            }
            return;
        }
        EndpointAddress dstAddress = RendezVousServiceProvider.mkAddress(destPeerID, serviceName, serviceParam);
        this.sendViaCachedMessenger(dstAddress, msg, new OutgoingMessageHandler(this.rdvService, destPeerID));
    }

    private void sendToEachRendezVous(Message msg, String serviceName, String serviceParam) {
        block2: {
            try {
                this.walk(msg, serviceName, serviceParam, 200);
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                LOG.debug((Object)"Cannot initiate a walk:", (Throwable)ez1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gcClients() {
        int i;
        Vector<PeerConnection> droppedClients = new Vector<PeerConnection>();
        PeerConnection pConn = null;
        RdvPeerRdvService rdvPeerRdvService = this;
        synchronized (rdvPeerRdvService) {
            i = 0;
            while (i < this.clients.size()) {
                block12: {
                    try {
                        pConn = (PeerConnection)this.clients.elementAt(i);
                        long time = System.currentTimeMillis();
                        if (!pConn.isConnected() || pConn.getLease() < time) {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("GC CLIENT:    drop= " + pConn.getPeer() + "\n         lease= " + pConn.getLease() + "\n  current time= " + time + "\n     connected= " + pConn.isConnected()));
                            }
                            this.clients.removeElementAt(i);
                            droppedClients.addElement(pConn);
                            --i;
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block12;
                        LOG.error((Object)"gcClient failed ", (Throwable)e);
                    }
                }
                ++i;
            }
        }
        if (droppedClients.size() > 0) {
            i = 0;
            while (i < droppedClients.size()) {
                block13: {
                    try {
                        pConn = (PeerConnection)droppedClients.elementAt(i);
                        this.rdvService.disconnected((PeerID)pConn.getPeer());
                        pConn.close();
                    }
                    catch (Exception ez) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block13;
                        LOG.error((Object)"Cannot GC client peer: ", (Throwable)ez);
                    }
                }
                ++i;
            }
        }
    }

    public void gc() {
        this.gcClients();
    }

    private boolean updatePropHeader(Message msg, int defaultTTL, String serviceName, String serviceParam) throws IOException {
        RendezVousPropagateMessage propHdr = null;
        defaultTTL = Math.min(defaultTTL, 200);
        try {
            InputStream ip;
            MessageElement elem = msg.getMessageElement("jxta", this.headerName);
            if (elem != null) {
                msg.removeMessageElement(elem);
            }
            if (elem != null && (ip = elem.getStream()) != null) {
                propHdr = new RendezVousPropagateMessage(ip);
                int msgTTL = propHdr.getTTL();
                if ((msgTTL = Math.min(msgTTL, defaultTTL)) < 2) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Straightened TTL");
                    }
                    if (defaultTTL < 1) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"TTL < 1 - message not forwarded");
                        }
                        return false;
                    }
                    msgTTL = defaultTTL;
                } else {
                    --msgTTL;
                }
                propHdr.setTTL(msgTTL);
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Error updating the header", (Throwable)e);
            }
            return false;
        }
        if (propHdr == null) {
            if (defaultTTL < 1) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"TTL < 1 - message is still-born");
                }
                return false;
            }
            propHdr = new RendezVousPropagateMessage();
            propHdr.setTTL(defaultTTL);
            if (serviceName == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"No destination - discard");
                }
                return false;
            }
            propHdr.setDestSName(serviceName);
            propHdr.setDestSParam(serviceParam);
            propHdr.setMsgId(this.rdvService.createMsgId());
            this.rdvService.addMsgId(propHdr.getMsgId());
        }
        propHdr.addToPath(this.localPeerId.toString());
        try {
            msg.replaceMessageElement("jxta", new TextDocumentMessageElement(this.headerName, (TextDocument)propHdr.getDocument(MimeMediaType.XMLUTF8), null));
        }
        catch (IllegalStateException badHdr) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Could not add prop header to message", (Throwable)badHdr);
            }
            return false;
        }
        return true;
    }

    public boolean isMessageValid(RendezVousPropagateMessage propHdr) {
        if (propHdr.getTTL() <= 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"isMessageValid - Dead on arrival");
            }
            return false;
        }
        if (propHdr.hasInPath(this.localPeerId.toString())) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"isMessageValid - Loopback");
            }
            return false;
        }
        if (this.rdvService.isMsgIdRecorded(propHdr.getMsgId())) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"isMessageValid - Feedback");
            }
            return false;
        }
        return true;
    }

    private void walkInit() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"WalkInit starts");
        }
        this.rpv = new PeerView(this.group, this.advGroup, this.pName + this.pParam, true, false);
        this.rpv.addListener(this.rdvService);
        this.walk = new LimitedRangeWalk(this.group, this.pName, this.pParam, this.rpv);
        this.greeter = this.walk.getGreeter();
        if (this.greeter == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot get Greeter");
            }
            return;
        }
        this.greeter.start();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Greeter: listening on " + this.pName + "/" + this.pParam));
        }
        this.walker = this.walk.getWalker();
        if (this.walker == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot get Walker");
            }
            return;
        }
        this.endpoint = this.group.getEndpointService();
        this.walkListener = new WalkListener(this.rdvService, this);
        this.greeter.setEndpointListener(this.walkListener);
    }

    public void walk(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("walk initiated\n\tsvc name: " + serviceName + "\tsvc param: " + serviceParam));
        }
        if (this.walker == null) {
            IOException failure = new IOException("Cannot send message with Walker: no walker");
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)failure, (Throwable)failure);
            }
            throw failure;
        }
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_SVC_NAME, serviceName, null));
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_SVC_PARAM, serviceParam, null));
        try {
            this.walker.sendMessage(null, defaultTTL, this.group.getPeerID(), this.pName, this.pParam, null, msg);
        }
        catch (Exception ez) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot send message with Walker: ", (Throwable)ez);
            }
            throw new IOException("Cannot send message with Walker: " + ez);
        }
    }

    public void walk(Vector destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        if (destPeerIDs == null || destPeerIDs.size() == 0) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"No destination");
            }
            throw new IOException("no destination Walker: ");
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("walk initiated for :\n\tsvc name:" + serviceName + "\tsvc params:" + serviceParam));
        }
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_SVC_NAME, serviceName, null));
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_SVC_PARAM, serviceParam, null));
        PeerID dest = null;
        int i = 0;
        while (i < destPeerIDs.size()) {
            try {
                dest = (PeerID)destPeerIDs.elementAt(i);
                Message tmpMsg = (Message)msg.clone();
                this.walker.sendMessage(dest, defaultTTL, this.group.getPeerID(), this.pName, this.pParam, null, tmpMsg);
            }
            catch (Exception ez) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Cannot send message with Walker to: " + dest.toString()), (Throwable)ez);
                }
                throw new IOException("Cannot send message with Walker to: " + dest.toString() + " reason: " + ez);
            }
            ++i;
        }
    }

    public int getPeerViewCount() {
        SortedSet viewElements = this.rpv.getView();
        return viewElements.size();
    }

    public Vector getLocalWalkView() {
        Vector<RdvAdvertisement> tmp = new Vector<RdvAdvertisement>();
        if (null == this.rpv) {
            return tmp;
        }
        Iterator peers = this.rpv.getView().iterator();
        while (peers.hasNext()) {
            try {
                PeerViewElement peer = (PeerViewElement)peers.next();
                RdvAdvertisement adv = peer.getRdvAdvertisement();
                tmp.add(adv);
            }
            catch (Exception ez) {
                return tmp;
            }
        }
        return tmp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class OutgoingMessageHandler
    implements OutgoingMessageEventListener {
        private RendezVousServiceImpl rdvService = null;
        private PeerID peerID = null;

        public OutgoingMessageHandler(RendezVousServiceImpl rdvService, PeerID peerID) {
            this.rdvService = rdvService;
            this.peerID = peerID;
        }

        public void messageSendFailed(OutgoingMessageEvent event) {
            if (event.getFailure() == null) {
                return;
            }
            this.rdvService.disconnected(this.peerID);
            RdvPeerRdvService.this.removeClient(this.peerID);
        }

        public void messageSendSucceeded(OutgoingMessageEvent event) {
        }
    }

    private static class WalkListener
    implements EndpointListener {
        private RendezVousServiceImpl rdvService = null;
        private RdvPeerRdvService rdvProvider = null;

        public WalkListener(RendezVousServiceImpl rdvSrv, RdvPeerRdvService rdvProv) {
            this.rdvService = rdvSrv;
            this.rdvProvider = rdvProv;
        }

        public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            block5: {
                String sName = msg.getMessageElement("jxta", RdvPeerRdvService.RDV_SVC_NAME).toString();
                String sParam = msg.getMessageElement("jxta", RdvPeerRdvService.RDV_SVC_PARAM).toString();
                EndpointListener listener = this.rdvService.getListener(sName + sParam);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Processing " + msg + "\n\tsvc name: " + sName + "\tsvc params: " + sParam));
                }
                if (this.rdvService.hasIncarnationChanged(msg, (PeerID)this.rdvProvider.localPeerId, this.rdvProvider.incarnation)) {
                    this.rdvProvider.disconnectFromClient((EndpointAddress)srcAddr.clone());
                }
                if (listener == null) break block5;
                EndpointAddress realDst = new EndpointAddress(dstAddr, sName, sParam);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Calling listener (" + listener + ") with " + msg));
                }
                try {
                    listener.processIncomingMessage(msg, srcAddr, realDst);
                }
                catch (Throwable ignored) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block5;
                    LOG.error((Object)("Uncaught Throwable during callback of (" + listener + ") to " + realDst), ignored);
                }
            }
        }
    }
}

