/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rpv;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.endpoint.TextMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.config.Config;
import net.jxta.impl.endpoint.relay.RelayClient;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.rendezvous.conf.StaticRdvConf;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.impl.rendezvous.rpv.PeerViewEvent;
import net.jxta.impl.rendezvous.rpv.PeerViewListener;
import net.jxta.impl.rendezvous.rpv.PeerViewStrategy;
import net.jxta.impl.rendezvous.rpv.PeerViewStrategyFactory;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PeerView
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$rpv$PeerView == null ? (class$net$jxta$impl$rendezvous$rpv$PeerView = PeerView.class$("net.jxta.impl.rendezvous.rpv.PeerView")) : class$net$jxta$impl$rendezvous$rpv$PeerView).getName());
    public static final String PROPERTIES_FILENAME = Config.JXTA_HOME + "jxta.properties";
    public static final String SEEDINGRDV_CONN_DELAY_PROPERTY = "peerview.SeedingRdvConnDelay";
    public static final String PROPAGATE_AVERAGE_RESPONSES_PROPERTY = "peerview.PropagateAverageResponses";
    private static final String MESSAGE_NAME = "PeerView.PeerAdv";
    private static final String RESPONSE_NAME = "PeerView.PeerAdv.Response";
    private static final String SERVICE_NAME = "PeerView";
    private static final String EDGE_ELEMENT = "PeerView.EdgePeer";
    private static final String CACHED_ELEMENT = "PeerView.Cached";
    private static final String FAILURE_ELEMENT = "PeerView.Failure";
    private static final String RESPONSEWANTED_ELEMENT = "PeerView.RespWanted";
    private static final String SRCROUTEADV_ELEMENT = "PeerView.SrcRouteAdv";
    private Timer timer;
    private String[] seedHosts;
    private boolean isEdgePeer;
    private static final long DEFAULT_EDGE_PEER_KICK_INTERVAL = 7200L;
    private static final long DEFAULT_RDV_PEER_KICK_INTERVAL = 900L;
    private static final long DEFAULT_BOOTSTRAP_KICK_INTERVAL = 5L;
    private static final long DEFAULT_SEEDING_PERIOD = 5L;
    private static final long WATCHDOG_PERIOD = 30000L;
    private static final long WATCHDOG_GRACE_DELAY = 300000L;
    private static final int MAX_EDGE_PEER_BOOTLEVEL = 4;
    private static final int MAX_RDV_PEER_BOOTLEVEL = 5;
    private int bootLevel;
    private long earliestReseed;
    private volatile boolean closed;
    private static final long DEFAULT_ADV_LOCAL_LIFETIME = 604800000L;
    private static final long DEFAULT_ADV_REMOTE_LIFETIME = 3600000L;
    private static final int DEFAULT_SEEDING_RDVPEERS = 5;
    private Random random;
    private PeerGroup group;
    private EndpointService endpoint;
    private DiscoveryService discovery;
    private PeerGroup advertisingGroup;
    private String serviceName;
    private String uniqueGroupId;
    private PeerViewElement self;
    private Vector rpvListeners;
    private InputPipe wirePipeInputPipe;
    private OutputPipe wirePipeOutputPipe;
    private InputPipe localGroupWirePipeInputPipe;
    private OutputPipe localGroupWirePipeOutputPipe;
    private PeerViewElement upPeer;
    private PeerViewElement downPeer;
    private long lastUpPeerUpdate;
    private long lastDownPeerUpdate;
    private WatchdogTask watchdogTask;
    private boolean probeRelays;
    private long seedingRdvConnDelay;
    private int propagateAverageResponses;
    private PeerViewStrategy replyStrategy;
    private PeerViewStrategy kickRecipientStrategy;
    private PeerViewStrategy kickAdvertisementStrategy;
    private PeerViewStrategy refreshRecipientStrategy;
    private SortedSet localView;
    protected StaticRdvConf config;
    private ChangeListener configListener;
    private ArrayList scheduledTasks;
    private PeerAdvertisement lastPeerAdv;
    private int lastModCount;
    private Hashtable pendingPves;
    private boolean useOnlySeeds;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$rpv$PeerView;

    public PeerView(PeerGroup group, PeerGroup advertisingGroup, String serviceName, boolean isRendezvous, boolean useOnlySeeds) {
        block3: {
            this.seedHosts = new String[0];
            this.isEdgePeer = true;
            this.bootLevel = 0;
            this.earliestReseed = 0L;
            this.closed = false;
            this.random = new Random();
            this.group = null;
            this.endpoint = null;
            this.discovery = null;
            this.advertisingGroup = null;
            this.serviceName = null;
            this.uniqueGroupId = null;
            this.self = null;
            this.rpvListeners = new Vector();
            this.wirePipeInputPipe = null;
            this.wirePipeOutputPipe = null;
            this.localGroupWirePipeInputPipe = null;
            this.localGroupWirePipeOutputPipe = null;
            this.upPeer = null;
            this.downPeer = null;
            this.lastUpPeerUpdate = 0L;
            this.lastDownPeerUpdate = 0L;
            this.watchdogTask = null;
            this.probeRelays = false;
            this.seedingRdvConnDelay = 0L;
            this.propagateAverageResponses = 3;
            this.replyStrategy = PeerViewStrategyFactory.getInstance(2);
            this.kickRecipientStrategy = PeerViewStrategyFactory.getInstance(2);
            this.kickAdvertisementStrategy = PeerViewStrategyFactory.getInstance(2);
            this.refreshRecipientStrategy = PeerViewStrategyFactory.getInstance(3);
            this.localView = new TreeSet();
            this.config = null;
            this.configListener = null;
            this.scheduledTasks = new ArrayList();
            this.lastPeerAdv = null;
            this.lastModCount = -1;
            this.pendingPves = new Hashtable();
            this.useOnlySeeds = false;
            this.group = group;
            this.serviceName = serviceName;
            this.endpoint = group.getEndpointService();
            this.discovery = group.getDiscoveryService();
            this.useOnlySeeds = useOnlySeeds;
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new TimerThreadNamer("PeerView Timer for " + group.getPeerGroupID()), 0L);
            this.initFromProperties();
            this.lastPeerAdv = group.getPeerAdvertisement();
            this.lastModCount = this.lastPeerAdv.getModCount();
            this.advertisingGroup = advertisingGroup != null && advertisingGroup.getPeerGroupID().equals(PeerGroupID.worldPeerGroupID) ? null : advertisingGroup;
            this.uniqueGroupId = group.getPeerGroupID().getUniqueValue().toString();
            this.config = new StaticRdvConf();
            this.configListener = new ChangeListener(this);
            this.config.addPropertyChangeListener(null, this.configListener);
            this.config.initialize(group);
            boolean bl = this.isEdgePeer = !isRendezvous;
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)((this.isEdgePeer ? "Edge " : "Rendezvous ") + "PeerView created for group \"" + group.getPeerGroupName() + ":" + this.uniqueGroupId + "\" service \"" + serviceName + "\""));
            }
            RdvAdvertisement selfAdv = this.createLocalRdvAdvertisement();
            this.self = new PeerViewElement(this, this.endpoint, selfAdv);
            this.endpoint.addIncomingMessageListener(this, SERVICE_NAME, this.uniqueGroupId);
            this.updateStatus(0L);
            this.replyStrategy.initialize(this.localView);
            this.kickRecipientStrategy.initialize(this.localView);
            this.kickAdvertisementStrategy.initialize(this.localView);
            this.refreshRecipientStrategy.initialize(this.localView);
            try {
                KickerTask task = new KickerTask(this);
                this.scheduledTasks.add(task);
                this.timer.schedule((TimerTask)task, 0L);
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"Cannot set timer. RPV will not work.", (Throwable)ez1);
            }
        }
    }

    private void initFromProperties() {
        block13: {
            Properties prop = null;
            FileInputStream in = null;
            try {
                in = new FileInputStream(PROPERTIES_FILENAME);
            }
            catch (Exception ez) {
                // empty catch block
            }
            if (in != null) {
                try {
                    prop = new Properties();
                    prop.load(in);
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)("Error reading " + PROPERTIES_FILENAME));
                    }
                    return;
                }
            } else {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)(PROPERTIES_FILENAME + " cannot be found"));
                }
                return;
            }
            String val = prop.getProperty(SEEDINGRDV_CONN_DELAY_PROPERTY, "0");
            try {
                this.seedingRdvConnDelay = Long.parseLong(val);
            }
            catch (NumberFormatException ez) {
                this.seedingRdvConnDelay = 0L;
            }
            val = prop.getProperty("peerview.ProbeRelays");
            if (val != null && val.equalsIgnoreCase("yes")) {
                this.probeRelays = true;
            }
            if ((val = prop.getProperty(PROPAGATE_AVERAGE_RESPONSES_PROPERTY)) == null) break block13;
            try {
                int nval;
                this.propagateAverageResponses = nval = Integer.parseInt(val);
            }
            catch (NumberFormatException ez) {}
        }
    }

    protected synchronized void removeTask(TimerTask task) {
        this.scheduledTasks.remove(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block17: {
            PeerView peerView = this;
            synchronized (peerView) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            if (!this.isEdgePeer) {
                this.notifyFailureToOthers(this.self);
            }
            if (this.watchdogTask != null) {
                this.watchdogTask.cancel();
                this.watchdogTask = null;
            }
            if (this.config != null) {
                this.config.removePropertyChangeListener(null, this.configListener);
                this.config = null;
                this.configListener = null;
            }
            this.endpoint.removeIncomingMessageListener(SERVICE_NAME, this.uniqueGroupId);
            int i = this.scheduledTasks.size();
            while (i-- > 0) {
                try {
                    TimerTask task = (TimerTask)this.scheduledTasks.get(i);
                    task.cancel();
                    this.scheduledTasks.remove(i);
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                    LOG.warn((Object)"Cannot cancel task: ", (Throwable)ez1);
                }
            }
            try {
                this.scheduledTasks.clear();
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block17;
                LOG.warn((Object)"Cannot clear vector of tasks: ", (Throwable)ez1);
            }
        }
        this.stopListeningWirePipe(this.advertisingGroup);
        this.downPeer = null;
        this.upPeer = null;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.pendingPves != null) {
            Enumeration pves = this.pendingPves.elements();
            while (pves != null && pves.hasMoreElements()) {
                try {
                    PeerViewElement tmpPve = (PeerViewElement)pves.nextElement();
                    tmpPve.close();
                }
                catch (Exception ez1) {
                    // empty catch block
                }
            }
            this.pendingPves.clear();
        }
    }

    protected synchronized PeerViewElement getPendingPve(PeerViewElement pve) {
        block5: {
            if (this.closed) {
                return pve;
            }
            RdvAdvertisement rdvAdv = pve.getRdvAdvertisement();
            if (rdvAdv == null) {
                return pve;
            }
            PeerID pid = pve.getRdvAdvertisement().getPeerID();
            PeerViewElement tmpPve = (PeerViewElement)this.pendingPves.get(pid);
            if (tmpPve != null) {
                return tmpPve;
            }
            try {
                this.pendingPves.put(pid, pve);
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)"Cannot add PVE into pendingPves", (Throwable)ez1);
            }
        }
        return pve;
    }

    protected synchronized void removePendingPve(PeerViewElement pve) {
        if (this.closed) {
            return;
        }
        RdvAdvertisement rdvAdv = pve.getRdvAdvertisement();
        if (rdvAdv == null) {
            return;
        }
        PeerID pid = pve.getRdvAdvertisement().getPeerID();
        this.pendingPves.remove(pid);
    }

    public synchronized long getKickInterval() {
        if (this.getView().size() != 0) {
            this.bootLevel = 0;
            if (this.isEdgePeer) {
                return 7200L;
            }
            return 900L;
        }
        return new Double(Math.pow(new Long(5L).doubleValue(), new Long(this.bootLevel).doubleValue())).longValue();
    }

    private synchronized void incrementBootLevel() {
        this.bootLevel = this.isEdgePeer ? (this.bootLevel >= 4 ? 4 : this.bootLevel + 1) : (this.bootLevel >= 5 ? 5 : this.bootLevel + 1);
    }

    private synchronized int getBootLevel() {
        return this.bootLevel;
    }

    private void seed() {
        if (this.earliestReseed > System.currentTimeMillis()) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Still Seeding...");
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"New Seeding...");
        }
        long iterations = 0L;
        Vector seedRdvs = this.getSeedRdvs();
        while (seedRdvs != null && seedRdvs.size() > 0) {
            this.sendRandomByAddr(seedRdvs, 5, this.seedingRdvConnDelay + 5L * iterations);
            ++iterations;
        }
        if (this.useOnlySeeds) {
            this.earliestReseed = System.currentTimeMillis() + 5L * iterations;
            return;
        }
        Vector rdvs = this.getRdvPeers();
        while (rdvs != null && rdvs.size() > 0) {
            this.sendRandomByAdv(rdvs, 5, 5L * iterations);
            ++iterations;
        }
        this.earliestReseed = System.currentTimeMillis() + 5L * iterations;
        iterations = 2L;
        this.timedSend(this.self, (EndpointAddress)null, false, 5L * iterations);
        iterations = 2L;
        this.scheduleAdvertisingGroupQuery(5L * iterations);
        if (this.probeRelays) {
            iterations = 0L;
            this.scheduleSendQueryToRelays(5L * iterations);
        }
    }

    private Vector getSeedRdvs() {
        Vector<EndpointAddress> rdvs = new Vector<EndpointAddress>();
        int i = 0;
        while (i < this.seedHosts.length) {
            rdvs.addElement(new EndpointAddress(this.seedHosts[i]));
            ++i;
        }
        return rdvs;
    }

    private boolean isSeedRdv(PeerViewElement pve) {
        RdvAdvertisement rdvAdv = pve.getRdvAdvertisement();
        if (rdvAdv == null) {
            return false;
        }
        RouteAdvertisement radv = rdvAdv.getRouteAdv();
        if (radv == null) {
            return false;
        }
        AccessPointAdvertisement apAdv = radv.getDest();
        if (apAdv == null) {
            return false;
        }
        Vector addrVect = apAdv.getVectorEndpointAddresses();
        if (addrVect == null || addrVect.size() == 0) {
            return false;
        }
        addrVect = (Vector)addrVect.clone();
        if (LOG.isEnabledFor((Priority)Level.ERROR) && !(addrVect.elementAt(0) instanceof String)) {
            LOG.error((Object)"AccessPointAdvertisement semantics has changed");
        }
        List<String> seedList = Arrays.asList(this.seedHosts);
        addrVect.retainAll(seedList);
        return addrVect.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet getView() {
        SortedSet sortedSet = this.localView;
        synchronized (sortedSet) {
            return (SortedSet)((TreeSet)this.localView).clone();
        }
    }

    public PeerViewElement getSelf() {
        return this.self;
    }

    protected void updateStatus(long delay) {
        this.timer.schedule((TimerTask)new UpdateStatusTask(this), delay);
    }

    protected void doUpdateStatus() {
        if (this.closed) {
            return;
        }
        if (this.isEdgePeer) {
            this.stopListeningWirePipe(this.advertisingGroup);
            if (this.watchdogTask != null) {
                this.watchdogTask.cancel();
                this.watchdogTask = null;
            }
        } else {
            if (this.watchdogTask == null) {
                this.watchdogTask = new WatchdogTask(this);
                this.timer.schedule((TimerTask)this.watchdogTask, 0L, 30000L);
            }
            this.startListeningWirePipe(this.advertisingGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        PeerViewElement tmppve;
        int viewSize;
        boolean added;
        boolean isNewbie;
        boolean isFromEdge;
        boolean isCached;
        PeerViewElement pve;
        boolean isResponse;
        boolean localIsEdge;
        block52: {
            MessageElement me;
            block51: {
                localIsEdge = this.isEdgePeer;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("received a PeerView message. This peer is " + (localIsEdge ? "Edge Peer" : "Rdv Peer")));
                    LOG.debug((Object)("    group = " + this.group.getPeerID().toString()));
                }
                isResponse = false;
                me = msg.getMessageElement("jxta", MESSAGE_NAME);
                if (me == null) {
                    me = msg.getMessageElement("jxta", RESPONSE_NAME);
                    if (me == null) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"No PeerView.PeerAdv or PeerView.PeerAdv.Response element in incoming Message");
                        }
                        return;
                    }
                    isResponse = true;
                }
                pve = null;
                try {
                    pve = new PeerViewElement(this, this.endpoint, me.getStream());
                }
                catch (IOException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Failed getting stream for me", (Throwable)failed);
                    }
                    return;
                }
                if (this.self.equals(pve)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"received a PeerView message from self. Discard.");
                    }
                    return;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("received a PeerView peerid= " + pve.getRdvAdvertisement().getPeerID().toString()));
                }
                if (msg.getMessageElement("jxta", FAILURE_ELEMENT) != null) {
                    this.notifyFailure(pve, false);
                    return;
                }
                me = msg.getMessageElement("jxta", SRCROUTEADV_ELEMENT);
                if (me != null) {
                    try {
                        Advertisement adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, me.getStream());
                        if (!(adv instanceof RouteAdvertisement)) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)"Advertisement is not a RouteAdvertisement");
                            }
                        } else {
                            pve.setSrcRouteAdvertisement((RouteAdvertisement)adv);
                        }
                    }
                    catch (IOException failed) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block51;
                        LOG.warn((Object)"Failed getting stream for me", (Throwable)failed);
                    }
                }
            }
            me = null;
            isCached = msg.getMessageElement("jxta", CACHED_ELEMENT) != null;
            isFromEdge = msg.getMessageElement("jxta", EDGE_ELEMENT) != null;
            isNewbie = true;
            added = false;
            viewSize = 0;
            PeerViewElement toClose = null;
            SortedSet sortedSet = this.localView;
            synchronized (sortedSet) {
                PeerViewElement iHave;
                SortedSet<PeerViewElement> tail = this.localView.tailSet(pve);
                if (!tail.isEmpty() && (iHave = tail.first()).equals(pve)) {
                    isNewbie = false;
                    toClose = pve;
                    pve = iHave;
                }
                if (!isFromEdge && isNewbie && !isCached && isResponse) {
                    if (pve.getRdvAdvertisement() == null) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Miss-handling of pve: attempt to insert in local view a PVE initialized with an endpoint address");
                        }
                    } else if (!this.useOnlySeeds || this.isSeedRdv(pve)) {
                        this.localView.add(pve);
                        added = true;
                    }
                }
                viewSize = this.localView.size();
            }
            if (added) {
                pve.setPinned(true);
                this.generateEvent(10, pve);
            }
            if (isNewbie) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Received a new peer");
                }
                if (this.discovery != null) {
                    try {
                        RdvAdvertisement rdvAdv = pve.getRdvAdvertisement();
                        if (rdvAdv != null && !isFromEdge) {
                            this.discovery.publish(rdvAdv, 2, 604800000L, 3600000L);
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("RdvAdvertisement Published " + pve));
                            }
                        }
                    }
                    catch (IOException ex) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block52;
                        LOG.warn((Object)("Could not publish " + pve), (Throwable)ex);
                    }
                }
            }
        }
        if (isResponse && !isFromEdge && (added || !isNewbie && !isCached)) {
            this.updateUpAndDownPeers(pve);
        }
        if (!(isCached || localIsEdge || isResponse)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Probed, Responding to " + pve));
            }
            boolean status = this.send(this.self, pve, true);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Response to Type 1 (Respond with self) to: " + pve + " success : " + status));
            }
        }
        if (isCached && isNewbie && (!isResponse || viewSize < 4) || !isCached && isNewbie && !isResponse && !isFromEdge) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Probed by or told of newbie, probing " + pve));
            }
            if (!this.useOnlySeeds) {
                boolean status = this.send(this.self, pve, false);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Type 2 (Probe PVE) : " + pve + " success : " + status));
                }
            }
        }
        if (!isCached && localIsEdge && !isResponse && (tmppve = this.getRandomPVE(pve)) != null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("This edge sending " + tmppve + " to " + pve));
            }
            boolean status = this.send(tmppve, pve, true);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Type 3 (Respond with random pve) to :" + pve + " success : " + status));
            }
        }
        if (!(isCached || localIsEdge || isResponse)) {
            PeerViewElement rpve = this.replyStrategy.next();
            if (rpve == null || pve.equals(rpve)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Probed. Nothing to respond from strategy");
                }
            } else {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Probed. Sending back " + rpve + " to " + pve));
                }
                boolean status = this.send(rpve, pve, true);
                if (LOG.isEnabledFor((Priority)Level.DEBUG) && !status) {
                    LOG.debug((Object)("Type 4  (Respond with a strategized adv) : " + pve + " success : " + status));
                }
            }
        }
    }

    private boolean send(PeerViewElement pve, PeerViewElement dest, boolean response) {
        return this.send(pve, dest, response, false);
    }

    private boolean send(PeerViewElement pve, PeerViewElement dest, boolean response, boolean wantResponse) {
        Message msg = this.makeMessage(pve, response, wantResponse);
        if (msg == null) {
            return false;
        }
        if (dest != null) {
            PeerViewElement pendingDestPve = this.getPendingPve(dest);
            return pendingDestPve.sendMessage(msg, SERVICE_NAME, this.uniqueGroupId);
        }
        try {
            this.endpoint.propagate((Message)msg.clone(), SERVICE_NAME, this.uniqueGroupId);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"sent a propagated message");
            }
        }
        catch (Exception ez) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Could not propagate a msg ", (Throwable)ez);
            }
            return false;
        }
        return true;
    }

    private synchronized void timedSend(PeerViewElement pve, PeerViewElement dest, boolean response, long delay) {
        if (this.closed) {
            return;
        }
        TimedSendTask task = new TimedSendTask(this, dest, pve, response);
        this.scheduledTasks.add(task);
        this.timer.schedule((TimerTask)task, delay * 1000L);
    }

    private synchronized void timedSend(PeerViewElement pve, EndpointAddress destAddr, boolean response, long delay) {
        if (this.closed) {
            return;
        }
        TimedSendTask task = new TimedSendTask(this, destAddr, pve, response);
        this.scheduledTasks.add(task);
        this.timer.schedule((TimerTask)task, delay * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message makeMessage(PeerViewElement content, boolean response, boolean requestResponse) {
        Message msg = new Message();
        TextMessageElement msge = null;
        if (content.equals(this.self)) {
            this.refreshSelf();
        }
        RdvAdvertisement padv = content.getRdvAdvertisement();
        if (!content.equals(this.self)) {
            block13: {
                RouteAdvertisement localra = this.getLocalRouteAdv();
                if (localra != null) {
                    try {
                        Document doc = localra.getDocument(MimeMediaType.XMLUTF8);
                        msge = new TextDocumentMessageElement(SRCROUTEADV_ELEMENT, (TextDocument)doc, null);
                        msg.addMessageElement("jxta", msge);
                    }
                    catch (Exception ez1) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block13;
                        LOG.warn((Object)("Could not create optional src route adv for " + content), (Throwable)ez1);
                    }
                }
            }
            msge = new StringMessageElement(CACHED_ELEMENT, Boolean.TRUE.toString(), null);
            msg.addMessageElement("jxta", msge);
            boolean found = false;
            SortedSet sortedSet = this.localView;
            synchronized (sortedSet) {
                found = this.localView.contains(content);
            }
            if (!found) {
                msge = new StringMessageElement(FAILURE_ELEMENT, Boolean.TRUE.toString(), null);
                msg.addMessageElement("jxta", msge);
            }
        } else if (this.closed) {
            msge = new StringMessageElement(FAILURE_ELEMENT, Boolean.TRUE.toString(), null);
            msg.addMessageElement("jxta", msge);
        }
        Document doc = padv.getDocument(MimeMediaType.XMLUTF8);
        String msgName = response ? RESPONSE_NAME : MESSAGE_NAME;
        msge = new TextDocumentMessageElement(msgName, (TextDocument)doc, null);
        msg.addMessageElement("jxta", msge);
        if (this.isEdgePeer) {
            msge = new StringMessageElement(EDGE_ELEMENT, Boolean.TRUE.toString(), null);
            msg.addMessageElement("jxta", msge);
        }
        if (requestResponse || this.getView().size() == 0) {
            msge = new StringMessageElement(RESPONSEWANTED_ELEMENT, Boolean.TRUE.toString(), null);
            msg.addMessageElement("jxta", msge);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFailure(PeerViewElement pve, boolean propagate) {
        block10: {
            if (pve == null) {
                throw new IllegalArgumentException("Null pve");
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Notified failure of " + pve));
            }
            PeerViewElement pveInSet = null;
            try {
                SortedSet sortedSet = this.localView;
                synchronized (sortedSet) {
                    PeerViewElement found;
                    SortedSet<PeerViewElement> tail = this.localView.tailSet(pve);
                    if (tail.isEmpty() || !pve.equals(found = tail.first())) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Notified failure of a non-existent" + pve));
                        }
                        return;
                    }
                    pveInSet = found;
                    tail.remove(pveInSet);
                }
                pveInSet.setPinned(false);
                this.updateFailedUpAndDown(pve);
                if (propagate) {
                    this.notifyFailureToOthers(pve);
                }
                this.generateEvent(12, pve);
            }
            catch (Exception ez) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block10;
                LOG.warn((Object)"Can not remove PeerViewElement from PeerView: ", (Throwable)ez);
            }
        }
        this.reschedule(true);
    }

    public void notifyFailure(ID pid) {
        SortedSet view = this.getView();
        if (view.size() == 0) {
            return;
        }
        Iterator peers = view.iterator();
        while (peers.hasNext()) {
            try {
                PeerViewElement pve = (PeerViewElement)peers.next();
                PeerID peerID = pve.getRdvAdvertisement().getPeerID();
                if (!peerID.equals(pid)) continue;
                this.notifyFailure(pve, true);
                break;
            }
            catch (Exception ez) {
                return;
            }
        }
    }

    public synchronized PeerViewElement getPeerViewElement(PeerID pid) {
        Iterator peers = this.getView().iterator();
        while (peers.hasNext()) {
            PeerViewElement peer = (PeerViewElement)peers.next();
            RdvAdvertisement adv = peer.getRdvAdvertisement();
            if (!adv.getPeerID().equals(pid)) continue;
            return peer;
        }
        return null;
    }

    public void kick() {
        PeerViewElement recipient;
        PeerViewElement refreshee;
        if (this.localView.size() == 0) {
            this.seed();
        }
        if ((refreshee = this.refreshRecipientStrategy.next()) != null) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Refresh " + refreshee));
            }
            this.timedSend(this.self, refreshee, false, 0L);
        }
        if ((recipient = this.kickRecipientStrategy.next()) == null) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"No recipient to send adv ");
            }
            this.reschedule(false);
            return;
        }
        PeerViewElement rpve = this.kickAdvertisementStrategy.next();
        if (rpve == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"No adv to send");
            }
            this.reschedule(false);
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Considering sending adv " + rpve + " to " + recipient));
        }
        if (rpve.equals(recipient)) {
            this.reschedule(false);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"adv to send is same as recipient: Nothing to do.");
            }
            return;
        }
        this.timedSend(rpve, recipient, false, 0L);
        this.reschedule(false);
    }

    private synchronized void reschedule(boolean now) {
        block6: {
            if (this.closed) {
                return;
            }
            try {
                if (now) {
                    this.bootLevel = 0;
                } else if (this.getView().size() == 0) {
                    this.incrementBootLevel();
                }
                KickerTask task = new KickerTask(this);
                this.timer.schedule((TimerTask)task, this.getKickInterval() * 1000L);
                this.scheduledTasks.add(task);
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block6;
                LOG.warn((Object)"Cannot set timer. RPV will not work.");
            }
        }
    }

    private void sendRandomByAdv(Vector rdvs, int maxNb, long delay) {
        if (rdvs == null || rdvs.size() == 0) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"No RDV peers to send queries");
            }
            return;
        }
        int counter = Math.min(maxNb, rdvs.size());
        while (counter-- > 0) {
            int i = this.random.nextInt(rdvs.size());
            RdvAdvertisement peer = (RdvAdvertisement)rdvs.remove(i);
            PeerViewElement pve = new PeerViewElement(this, this.endpoint, peer);
            this.timedSend(this.self, pve, false, delay);
        }
    }

    private void sendRandomByAddr(Vector rdvs, int maxNb, long delay) {
        if (rdvs == null) {
            throw new IllegalArgumentException("Null rdvs");
        }
        if (rdvs.size() == 0) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"No RDV peers to send queries");
            }
            return;
        }
        int counter = Math.min(maxNb, rdvs.size());
        while (counter-- > 0) {
            int i = this.random.nextInt(rdvs.size());
            EndpointAddress dest = (EndpointAddress)rdvs.remove(i);
            this.timedSend(this.self, dest, false, delay);
        }
    }

    private Vector getRdvPeers() {
        Enumeration rdvs;
        Vector<RdvAdvertisement> v = new Vector<RdvAdvertisement>();
        int retryCount = 0;
        while (this.discovery == null && retryCount < 10) {
            this.discovery = this.group.getDiscoveryService();
            ++retryCount;
            try {
                Thread.sleep(200L);
            }
            catch (Exception ez1) {
                // empty catch block
            }
        }
        if (this.discovery == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Discovery is not yet enabled.");
            }
            return v;
        }
        try {
            rdvs = this.discovery.getLocalAdvertisements(2, "RdvServiceName", this.serviceName);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"There is no RdvAdvertisement in local Discovery");
            }
            return v;
        }
        if (rdvs != null) {
            while (rdvs.hasMoreElements()) {
                RdvAdvertisement rdv;
                Advertisement adv = (Advertisement)rdvs.nextElement();
                if (!(adv instanceof RdvAdvertisement) || !(rdv = (RdvAdvertisement)adv).getGroupID().equals(this.group.getPeerGroupID())) continue;
                v.addElement(rdv);
            }
        }
        return v;
    }

    private void refreshSelf() {
        if (this.self == null) {
            return;
        }
        PeerAdvertisement newPadv = this.group.getPeerAdvertisement();
        int newModCount = newPadv.getModCount();
        if (this.lastPeerAdv != newPadv || this.lastModCount != newModCount) {
            this.lastPeerAdv = newPadv;
            this.lastModCount = newModCount;
            RdvAdvertisement adv = this.createLocalRdvAdvertisement();
            if (adv != null) {
                this.self.setRdvAdvertisement(adv);
            }
        }
    }

    private RouteAdvertisement getLocalRouteAdv() {
        RouteAdvertisement route = null;
        TextElement endpParam = (TextElement)((Object)this.lastPeerAdv.getServiceParam(PeerGroup.endpointClassID));
        if (endpParam == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"getMyLocalRoute: no Endpoint Params");
            }
            return this.makeLocalRouteAdv();
        }
        Enumeration paramChilds = endpParam.getChildren(RouteAdvertisement.getAdvertisementType());
        Element param = null;
        if (!paramChilds.hasMoreElements()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"getLocalRouteAdv: no Endpoint Route Adv");
            }
            return this.makeLocalRouteAdv();
        }
        param = (Element)paramChilds.nextElement();
        try {
            route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param);
            route.setDestPeerID(this.lastPeerAdv.getPeerID());
            return route;
        }
        catch (Exception ex) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"getMyLocalRoute: error extracting route", (Throwable)ex);
            }
            return this.makeLocalRouteAdv();
        }
    }

    private RouteAdvertisement makeLocalRouteAdv() {
        AccessPointAdvertisement apa = this.getLocalAccessPointAdv();
        RouteAdvertisement ra = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        ra.setDest(apa);
        ra.setDestPeerID(this.group.getPeerID());
        return ra;
    }

    private AccessPointAdvertisement getLocalAccessPointAdv() {
        Vector<String> localAddrs = new Vector<String>();
        Iterator it = this.endpoint.getAllMessageTransports();
        while (it != null && it.hasNext()) {
            try {
                MessageTransport t = (MessageTransport)it.next();
                MessageReceiver tp = null;
                try {
                    tp = (MessageReceiver)t;
                }
                catch (Exception ez2) {
                    continue;
                }
                Iterator itaddr = tp.getPublicAddresses();
                while (itaddr != null && itaddr.hasNext()) {
                    try {
                        EndpointAddress addr = (EndpointAddress)itaddr.next();
                        localAddrs.addElement(addr.toString());
                    }
                    catch (Exception ez2) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                        LOG.warn((Object)("Protocol.getLocalAddress failed with " + ez2));
                    }
                }
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Protocol.getLocalAddress failed with " + ez1));
            }
        }
        if (localAddrs.size() > 0) {
            AccessPointAdvertisement apa = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            apa.setPeerID(this.group.getPeerID());
            apa.setEndpointAddresses(localAddrs);
            return apa;
        }
        return null;
    }

    private RdvAdvertisement createLocalRdvAdvertisement() {
        try {
            RdvAdvertisement rdv = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(RdvAdvertisement.getAdvertisementType());
            rdv.setPeerID(this.group.getPeerID());
            rdv.setGroupID(this.group.getPeerGroupID());
            rdv.setServiceName(this.serviceName);
            rdv.setName(this.group.getPeerName());
            RouteAdvertisement ra = this.getLocalRouteAdv();
            rdv.setRouteAdv(ra);
            return rdv;
        }
        catch (Exception ez) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot create Local RdvAdvertisement: ", (Throwable)ez);
            }
            return null;
        }
    }

    private synchronized PeerViewElement getRandomPVE(PeerViewElement pruned) {
        SortedSet view = this.getView();
        view.remove(pruned);
        if (view.size() == 0) {
            return null;
        }
        PeerViewElement tmp = null;
        Object[] pvArr = view.toArray();
        tmp = (PeerViewElement)pvArr[this.random.nextInt(view.size())];
        return tmp;
    }

    private EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID = null;
        try {
            asID = IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
        }
        catch (MalformedURLException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        catch (UnknownServiceException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return this.mkAddress(asID, serv, parm);
    }

    private EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    public void addListener(PeerViewListener listener) {
        this.rpvListeners.addElement(listener);
    }

    public boolean removeListener(PeerViewListener listener) {
        return this.rpvListeners.removeElement(listener);
    }

    private void generateEvent(int type, PeerViewElement element2) {
        if (this.rpvListeners.size() > 0) {
            PeerViewEvent newevent = new PeerViewEvent(this, type, element2);
            int i = 0;
            while (i < this.rpvListeners.size()) {
                PeerViewListener pvl = (PeerViewListener)this.rpvListeners.elementAt(i);
                pvl.peerViewEvent(newevent);
                ++i;
            }
        }
    }

    private PipeAdvertisement getWirePipeAdvertisement(PeerGroup destGroup) {
        PipeAdvertisement adv = null;
        try {
            adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
            PipeID pipeId = IDFactory.newPipeID(destGroup.getPeerGroupID(), (SERVICE_NAME + this.group.getPeerGroupID().getUniqueValue().toString() + this.serviceName).getBytes());
            adv.setPipeID(pipeId);
            adv.setType("JxtaPropagate");
            adv.setName(SERVICE_NAME);
            return adv;
        }
        catch (Exception ez) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Cannot create Propagated PipeAdvertisement: ", (Throwable)ez);
            }
            return null;
        }
    }

    private void startListeningWirePipe(PeerGroup destGroup) {
        PipeService pipes;
        PipeAdvertisement localGroupWirePipeAdv;
        if (this.group.getPeerGroupID().equals(PeerGroupID.worldPeerGroupID)) {
            return;
        }
        if (this.localGroupWirePipeInputPipe == null && (localGroupWirePipeAdv = this.getWirePipeAdvertisement(this.group)) != null) {
            try {
                pipes = this.group.getPipeService();
                this.localGroupWirePipeInputPipe = pipes.createInputPipe(localGroupWirePipeAdv, new WirePipeListener(this));
                this.localGroupWirePipeOutputPipe = pipes.createOutputPipe(localGroupWirePipeAdv, 10000L);
                if (this.localGroupWirePipeOutputPipe == null && LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Cannot get OutputPipe for current group");
                }
            }
            catch (Exception ez) {
                this.updateStatus(1000L);
            }
        }
        if (destGroup == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"No peergroup to start listening on propagated pipe");
            }
            return;
        }
        if (destGroup.getPeerGroupID().equals(PeerGroupID.worldPeerGroupID)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"No listening on propagate pipe in WorldPeerGroup");
            }
            return;
        }
        if (this.wirePipeInputPipe != null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Already listening on propagate pipe in " + destGroup.getPeerGroupID().toString()));
            }
            return;
        }
        PipeAdvertisement wirePipeAdv = this.getWirePipeAdvertisement(destGroup);
        if (wirePipeAdv == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Will not be able to listen on advertising group");
            }
            return;
        }
        try {
            pipes = destGroup.getPipeService();
            this.wirePipeInputPipe = pipes.createInputPipe(wirePipeAdv, new WirePipeListener(this));
        }
        catch (Exception ez) {
            this.updateStatus(1000L);
            return;
        }
    }

    private void stopListeningWirePipe(PeerGroup destGroup) {
        if (this.localGroupWirePipeInputPipe != null) {
            this.localGroupWirePipeInputPipe.close();
        }
        if (destGroup == null) {
            return;
        }
        if (this.wirePipeInputPipe != null) {
            this.wirePipeInputPipe.close();
        }
    }

    private OutputPipe getAdvertisingOutputPipe(PeerGroup g) {
        if (g == null) {
            return null;
        }
        if (this.wirePipeOutputPipe != null) {
            return this.wirePipeOutputPipe;
        }
        PipeAdvertisement wirePipeAdv = this.getWirePipeAdvertisement(g);
        if (wirePipeAdv == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Will not be able to listen on group " + g.getPeerGroupID().toString()));
            }
            return null;
        }
        OutputPipe op = null;
        try {
            PipeService pipes = g.getPipeService();
            op = pipes.createOutputPipe(wirePipeAdv, 10000L);
            if (op == null && LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot get OutputPipe for advertising group");
            }
        }
        catch (Exception ez) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Cannot create Propagated OutputPipe: ", (Throwable)ez);
            }
            return null;
        }
        this.wirePipeOutputPipe = op;
        return op;
    }

    protected void sendMessageInGroup(OutputPipe op, Message msg) {
        if (op == null) {
            return;
        }
        try {
            op.send(msg);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"PeerView sent request on propagate pipe");
            }
            return;
        }
        catch (Exception ez) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot propagate message: ", (Throwable)ez);
            }
            return;
        }
    }

    private void queryAdvertisingGroup() {
        if (this.advertisingGroup != null) {
            OutputPipe op = this.getAdvertisingOutputPipe(this.advertisingGroup);
            if (op == null) {
                return;
            }
            Message msg = this.makeMessage(this.self, false, true);
            this.sendMessageInGroup(op, msg);
        }
    }

    private synchronized void scheduleAdvertisingGroupQuery(long delay) {
        if (this.closed) {
            return;
        }
        AdvertisingGroupQueryTask task = new AdvertisingGroupQueryTask(this);
        this.scheduledTasks.add(task);
        this.timer.schedule((TimerTask)task, delay * 1000L);
    }

    private void notifyFailureToOthers(PeerViewElement pve) {
        Message msg = this.makeMessage(pve, false, false);
        if (this.localGroupWirePipeOutputPipe == null) {
            return;
        }
        this.sendMessageInGroup(this.localGroupWirePipeOutputPipe, msg);
    }

    public synchronized PeerViewElement getUpPeer() {
        return this.upPeer;
    }

    public synchronized PeerViewElement getDownPeer() {
        return this.downPeer;
    }

    private synchronized void updateUpAndDownPeers(PeerViewElement pve) {
        if (this.closed) {
            return;
        }
        if (this.self.equals(pve)) {
            return;
        }
        if (this.self.compareTo(pve) < 0) {
            if (this.upPeer == null) {
                this.upPeer = pve;
                this.lastUpPeerUpdate = System.currentTimeMillis();
                return;
            }
            if (pve.compareTo(this.upPeer) < 0) {
                this.upPeer = pve;
                this.lastUpPeerUpdate = System.currentTimeMillis();
                return;
            }
            if (this.upPeer.equals(pve)) {
                this.lastUpPeerUpdate = System.currentTimeMillis();
                return;
            }
            return;
        }
        if (this.downPeer == null) {
            this.downPeer = pve;
            this.lastDownPeerUpdate = System.currentTimeMillis();
            return;
        }
        if (pve.compareTo(this.downPeer) > 0) {
            this.downPeer = pve;
            this.lastDownPeerUpdate = System.currentTimeMillis();
            return;
        }
        if (this.downPeer.equals(pve)) {
            this.lastDownPeerUpdate = System.currentTimeMillis();
            return;
        }
    }

    private synchronized void updateFailedUpAndDown(PeerViewElement pve) {
        if (this.closed) {
            return;
        }
        if (pve == null) {
            return;
        }
        if (this.downPeer != null && this.downPeer.equals(pve)) {
            try {
                SortedSet<PeerViewElement> downView = this.localView.headSet(this.self);
                if (downView != null && downView.size() > 0) {
                    this.downPeer = downView.last();
                    this.lastDownPeerUpdate = System.currentTimeMillis();
                } else {
                    this.downPeer = null;
                }
            }
            catch (Exception ez) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Cannot get down peer", (Throwable)ez);
                }
                this.downPeer = null;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                if (this.downPeer == null) {
                    LOG.debug((Object)"No DOWN peer");
                } else {
                    LOG.debug((Object)("downPeer is: " + this.downPeer.getRdvAdvertisement().getName()));
                    LOG.debug((Object)("           : " + this.downPeer.getRdvAdvertisement().getPeerID().toString()));
                }
            }
            return;
        }
        if (this.upPeer != null && this.upPeer.equals(pve)) {
            try {
                SortedSet<PeerViewElement> upView = this.localView.tailSet(this.self);
                if (upView != null && upView.size() > 0) {
                    this.upPeer = upView.first();
                    this.lastUpPeerUpdate = System.currentTimeMillis();
                } else {
                    this.upPeer = null;
                }
            }
            catch (Exception ez) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Cannot get up peer", (Throwable)ez);
                }
                this.upPeer = null;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                if (this.upPeer == null) {
                    LOG.debug((Object)"No UP peer");
                } else {
                    LOG.debug((Object)("upPeer is  : " + this.upPeer.getRdvAdvertisement().getName()));
                    LOG.debug((Object)("           : " + this.upPeer.getRdvAdvertisement().getPeerID().toString()));
                }
            }
            return;
        }
    }

    private synchronized void scheduleSendQueryToRelays(long delay) {
        RelayQueryTask task = new RelayQueryTask(this);
        this.scheduledTasks.add(task);
        this.timer.schedule((TimerTask)task, delay * 1000L);
    }

    private boolean sendQueryToRelays() {
        if (this.closed) {
            return true;
        }
        Vector relays = this.getRelays(this.group);
        if (relays == null) {
            return true;
        }
        boolean res = false;
        int i = 0;
        while (i < relays.size()) {
            block5: {
                try {
                    PeerID relayID = (PeerID)relays.elementAt(i);
                    EndpointAddress relayAddr = this.mkAddress(relayID, null, null);
                    this.timedSend(this.self, relayAddr, false, 0L);
                    res = true;
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                    LOG.warn((Object)"Unexpected error: ", (Throwable)ez1);
                }
            }
            ++i;
        }
        return res;
    }

    private Vector getRelays(PeerGroup myGroup) {
        if (!(myGroup instanceof RefPeerGroup)) {
            return null;
        }
        PeerGroup pgParent = ((RefPeerGroup)myGroup).getParentGroup();
        if (pgParent == null) {
            return null;
        }
        if (!(pgParent instanceof RefPeerGroup)) {
            return null;
        }
        PeerGroup pgGrandParent = ((RefPeerGroup)pgParent).getParentGroup();
        if (pgGrandParent == null) {
            try {
                EndpointService ep = myGroup.getEndpointService();
                Iterator it = ep.getAllMessageTransports();
                while (it.hasNext()) {
                    MessageTransport mt = (MessageTransport)it.next();
                    if (!(mt instanceof RelayClient)) continue;
                    RelayClient er = (RelayClient)mt;
                    Vector v = er.getActiveRelays(null);
                    if (v == null) {
                        return null;
                    }
                    Vector<PeerID> res = new Vector<PeerID>();
                    Enumeration e = v.elements();
                    while (e.hasMoreElements()) {
                        res.add(((AccessPointAdvertisement)e.nextElement()).getPeerID());
                    }
                    return res;
                }
                return null;
            }
            catch (Exception ez1) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Unexpected error: ", (Throwable)ez1);
                }
                return null;
            }
        }
        return this.getRelays(pgParent);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String[] access$202(PeerView x0, String[] x1) {
        x0.seedHosts = x1;
        return x1;
    }

    private final class RelayQueryTask
    extends TimerTask {
        private volatile PeerView pv = null;

        public RelayQueryTask(PeerView pv) {
            this.pv = pv;
        }

        public boolean cancel() {
            boolean res = super.cancel();
            this.pv = null;
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block14: {
                try {
                    PeerView holdIt = null;
                    while (true) {
                        if (PeerView.this.closed) {
                            return;
                        }
                        holdIt = this.pv;
                        RelayQueryTask relayQueryTask = this;
                        synchronized (relayQueryTask) {
                            holdIt = this.pv;
                            if (holdIt == null) {
                                return;
                            }
                            if (holdIt == null) {
                                return;
                            }
                            if (holdIt.sendQueryToRelays()) {
                                break;
                            }
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception ez1) {
                                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                    LOG.warn((Object)"Unexpected error: ", (Throwable)ez1);
                                }
                                break;
                            }
                        }
                    }
                    if (holdIt != null) {
                        holdIt.removeTask(this);
                    }
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block14;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }
    }

    private final class WatchdogTask
    extends TimerTask {
        private volatile PeerView pv = null;

        public WatchdogTask(PeerView pv) {
            this.pv = pv;
        }

        public void run() {
            block8: {
                try {
                    if (PeerView.this.closed) {
                        return;
                    }
                    PeerView holdIt = this.pv;
                    if (holdIt == null) {
                        return;
                    }
                    if (PeerView.this.upPeer != null) {
                        if (System.currentTimeMillis() - PeerView.this.lastUpPeerUpdate > 300000L) {
                            PeerView.this.notifyFailure(PeerView.this.upPeer, true);
                        } else {
                            holdIt.timedSend(holdIt.self, holdIt.upPeer, false, 0L);
                        }
                    }
                    if (PeerView.this.downPeer == null) break block8;
                    if (System.currentTimeMillis() - PeerView.this.lastDownPeerUpdate > 300000L) {
                        PeerView.this.notifyFailure(PeerView.this.downPeer, true);
                        break block8;
                    }
                    holdIt.timedSend(holdIt.self, holdIt.downPeer, false, 0L);
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block8;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }

        public boolean cancel() {
            boolean res = super.cancel();
            this.pv = null;
            return res;
        }
    }

    private final class AdvertisingGroupQueryTask
    extends TimerTask {
        private volatile PeerView pv = null;

        public AdvertisingGroupQueryTask(PeerView pv) {
            this.pv = pv;
        }

        public boolean cancel() {
            boolean res = super.cancel();
            this.pv = null;
            return res;
        }

        public void run() {
            block5: {
                try {
                    if (PeerView.this.closed) {
                        return;
                    }
                    PeerView holdIt = this.pv;
                    if (holdIt == null) {
                        return;
                    }
                    holdIt.queryAdvertisingGroup();
                    if (holdIt != null) {
                        holdIt.removeTask(this);
                    }
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block5;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }
    }

    private class WirePipeListener
    implements PipeMsgListener {
        PeerView pv = null;

        public WirePipeListener(PeerView pv) {
            this.pv = pv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pipeMsgEvent(PipeMsgEvent event) {
            Message msg = null;
            try {
                SortedSet view;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Received a PeerView message on propagated pipe in group");
                }
                msg = event.getMessage();
                int vs = 1;
                SortedSet sortedSet = view = this.pv.localView;
                synchronized (sortedSet) {
                    vs = view.size() + 1;
                }
                if (PeerView.this.random.nextInt(vs) >= PeerView.this.propagateAverageResponses) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Ignoring");
                    }
                    return;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Processing");
                }
                this.pv.processIncomingMessage(msg, null, null);
            }
            catch (Exception ez) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Cannot retrieve incoming message: ", (Throwable)ez);
                }
                return;
            }
        }
    }

    public static class UpdateStatusTask
    extends TimerTask {
        private volatile PeerView pv = null;

        public UpdateStatusTask(PeerView pv) {
            this.pv = pv;
        }

        public void run() {
            block2: {
                try {
                    this.pv.doUpdateStatus();
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block2;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }
    }

    private final class TimedSendTask
    extends TimerTask {
        private volatile PeerView pv = null;
        private PeerViewElement pve = null;
        private PeerViewElement destpve = null;
        private boolean response = false;
        private boolean tempPve = false;

        public TimedSendTask(PeerView pv, EndpointAddress dest, PeerViewElement pve, boolean response) {
            this.pv = pv;
            this.pve = pve;
            if (dest != null) {
                this.destpve = new PeerViewElement(pv, PeerView.this.endpoint, dest);
            }
            this.tempPve = true;
            this.response = response;
        }

        public TimedSendTask(PeerView pv, PeerViewElement destpve, PeerViewElement pve, boolean response) {
            this.pv = pv;
            this.destpve = destpve;
            this.pve = pve;
            this.response = response;
        }

        public synchronized boolean cancel() {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Canceling TimedSendTask for : " + this.pve));
            }
            boolean res = super.cancel();
            this.pv = null;
            this.pve = null;
            this.destpve = null;
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block15: {
                try {
                    PeerView holdIt;
                    if (PeerView.this.closed) {
                        return;
                    }
                    TimedSendTask timedSendTask = this;
                    synchronized (timedSendTask) {
                        holdIt = this.pv;
                        if (holdIt == null) {
                            return;
                        }
                        if (this.tempPve) {
                            if (PeerView.this.getView().size() > 0) {
                                if (this.destpve != null) {
                                    this.destpve.close();
                                }
                            } else {
                                boolean status = this.pv.send(this.pve, this.destpve, this.response, true);
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)("pv.send to destpve: " + this.destpve + " success : " + status));
                                }
                            }
                        } else {
                            boolean status = this.pv.send(this.pve, this.destpve, this.response);
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("pv.send to : " + this.destpve + " success : " + status));
                            }
                        }
                    }
                    if (holdIt != null) {
                        holdIt.removeTask(this);
                    }
                    this.destpve = null;
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block15;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }
    }

    private final class KickerTask
    extends TimerTask {
        private volatile PeerView pv = null;

        public KickerTask(PeerView pv) {
            this.pv = pv;
        }

        public void run() {
            block4: {
                try {
                    if (PeerView.this.closed) {
                        return;
                    }
                    PeerView holdIt = this.pv;
                    if (holdIt == null) {
                        return;
                    }
                    holdIt.kick();
                    holdIt.removeTask(this);
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block4;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }

        public boolean cancel() {
            boolean res = super.cancel();
            this.pv = null;
            return res;
        }
    }

    private final class ChangeListener
    implements PropertyChangeListener {
        private PeerView pv = null;

        ChangeListener(PeerView apv) {
            this.pv = apv;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String propName = ev.getPropertyName();
            if ("EdgePeer".equals(propName)) {
                this.pv.isEdgePeer = (Boolean)ev.getNewValue();
                this.pv.updateStatus(0L);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)(propName + " set to " + this.pv.isEdgePeer));
                }
            } else if ("BootstrapAddress".equals(propName)) {
                PeerView.access$202(this.pv, (String[])ev.getNewValue());
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)(propName + " set to ..."));
                    int i = 0;
                    while (i < this.pv.seedHosts.length) {
                        LOG.info((Object)("  " + this.pv.seedHosts[i]));
                        ++i;
                    }
                }
            } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)(propName + " property change not handled"));
            }
        }
    }
}

