/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rpv;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.id.ID;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PeerViewElement
implements Comparable,
MessengerEventListener,
OutgoingMessageEventListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$rendezvous$rpv$PeerViewElement == null ? (class$net$jxta$impl$rendezvous$rpv$PeerViewElement = PeerViewElement.class$("net.jxta.impl.rendezvous.rpv.PeerViewElement")) : class$net$jxta$impl$rendezvous$rpv$PeerViewElement).getName());
    private static final int MAXPENDING = 4;
    private int messagesInProgress = 0;
    private int created = 0;
    private RdvAdvertisement padv = null;
    private EndpointAddress destAddress = null;
    private RouteAdvertisement srcRouteAdv = null;
    private RouteAdvertisement altRoute = null;
    private boolean alive = true;
    private Messenger messenger = null;
    private PeerView peerview = null;
    private List pendingMessages = null;
    private EndpointService endpoint = null;
    private boolean pinned = false;
    private boolean messengerInProgress = false;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$rpv$PeerViewElement;

    private PeerViewElement() {
        throw new RuntimeException("Not allowed");
    }

    PeerViewElement(PeerView pv, EndpointService endpoint, InputStream in) {
        Advertisement adv = null;
        try {
            adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, in);
        }
        catch (IOException ex) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Could not create Advertisement from incoming Message", (Throwable)ex);
            }
            return;
        }
        if (!(adv instanceof RdvAdvertisement)) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Advertisement is not a RdvAdvertisement");
            }
            return;
        }
        this.init(pv, endpoint, (RdvAdvertisement)adv);
    }

    PeerViewElement(PeerView pv, EndpointService endpoint, RdvAdvertisement adv) {
        this.init(pv, endpoint, adv);
    }

    PeerViewElement(PeerView pv, EndpointService endpoint, EndpointAddress destAddress) {
        this.init(pv, endpoint, destAddress);
    }

    void init(PeerView pv, EndpointService endpoint, RdvAdvertisement adv) {
        this.created = (int)(System.currentTimeMillis() / 1000L);
        this.padv = adv;
        this.peerview = pv;
        this.endpoint = endpoint;
        this.destAddress = this.mkAddress(adv.getPeerID(), null, null);
    }

    void init(PeerView pv, EndpointService endpoint, EndpointAddress destAddress) {
        this.created = (int)(System.currentTimeMillis() / 1000L);
        this.peerview = pv;
        this.endpoint = endpoint;
        this.destAddress = destAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPinned(boolean pinned) {
        boolean closeIt = false;
        PeerViewElement peerViewElement = this;
        synchronized (peerViewElement) {
            this.pinned = pinned;
            if (!(this.messagesInProgress != 0 || pinned && this.alive)) {
                closeIt = true;
            }
        }
        if (closeIt) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageDone() {
        boolean closeIt = false;
        PeerViewElement peerViewElement = this;
        synchronized (peerViewElement) {
            --this.messagesInProgress;
            if (!(this.messagesInProgress != 0 || this.pinned && this.alive)) {
                closeIt = true;
            }
        }
        if (closeIt) {
            this.close();
        }
    }

    public void close() {
        if (this.messenger != null) {
            this.messenger.close();
        }
        this.setConnectivity(false);
        this.peerview.removePendingPve(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean messengerReady(MessengerEvent e) {
        boolean tryAltRoute = false;
        List sendMe = null;
        Messenger useMe = null;
        PeerViewElement peerViewElement = this;
        synchronized (peerViewElement) {
            this.messengerInProgress = false;
            if (this.messenger != null) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Strange redudant messengerReady " + e.getMessenger() + " event for " + this.destAddress));
                }
                return false;
            }
            useMe = e.getMessenger();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("async getMessenger to " + this.destAddress + "yielded " + useMe));
            }
            if (useMe != null) {
                this.messenger = useMe;
                if (this.altRoute != null) {
                    this.padv.setRouteAdv(this.altRoute);
                    this.altRoute = null;
                }
                sendMe = this.pendingMessages;
                this.pendingMessages = null;
            } else if (this.srcRouteAdv != null) {
                this.altRoute = (RouteAdvertisement)this.padv.getRouteAdv().clone();
                if (RouteAdvertisement.stichRoute(this.altRoute, this.srcRouteAdv)) {
                    tryAltRoute = true;
                    this.messengerInProgress = true;
                } else {
                    this.altRoute = null;
                    this.pendingMessages = null;
                }
                this.srcRouteAdv = null;
            } else {
                this.pendingMessages = null;
            }
        }
        if (useMe != null) {
            if (sendMe != null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sending pending messages to " + this.destAddress));
                }
                Iterator msgs = sendMe.iterator();
                while (msgs.hasNext()) {
                    PendingMessage pmsg = (PendingMessage)msgs.next();
                    useMe.sendMessage(pmsg.message, pmsg.serviceName, pmsg.serviceParam, this);
                }
                sendMe.clear();
            }
            return true;
        }
        if (tryAltRoute) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Initiating async getMessenger with altroute to " + this.destAddress));
            }
            if (this.endpoint.getMessenger(this, this.destAddress, this.altRoute)) {
                return false;
            }
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Could not initiate async getMessenger to " + this.destAddress));
            }
        }
        this.close();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Giving up on " + this.destAddress));
        }
        return false;
    }

    public void messageSendSucceeded(OutgoingMessageEvent e) {
        this.setConnectivity(true);
        this.messageDone();
    }

    public void messageSendFailed(OutgoingMessageEvent e) {
        this.setConnectivity(e.getFailure() == null);
        this.messageDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(Message msg, String sName, String sParam) {
        if (msg == null) {
            throw new IllegalArgumentException("Null message");
        }
        Messenger m = null;
        boolean pending = false;
        boolean in_progress = false;
        PeerViewElement peerViewElement = this;
        synchronized (peerViewElement) {
            in_progress = this.messengerInProgress;
            if (this.messenger == null) {
                this.messengerInProgress = true;
                boolean bl = pending = this.pendingMessages != null;
                if (!pending) {
                    this.pendingMessages = new ArrayList(4);
                    this.pendingMessages.add(new PendingMessage(msg, sName, sParam));
                } else if (this.pendingMessages.size() <= 4) {
                    this.pendingMessages.add(new PendingMessage(msg, sName, sParam));
                }
            } else {
                m = this.messenger;
            }
            ++this.messagesInProgress;
        }
        if (m != null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("sending straight to " + this.destAddress));
            }
            m.sendMessage(msg, sName, sParam, this);
            return true;
        }
        if (in_progress != pending && LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)("Pending and in_progress disagree (in_progress=" + in_progress + "pending=" + pending + ") for " + this.destAddress));
        }
        if (in_progress) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("async getMessenger already in progress to " + this.destAddress));
            }
            return true;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Initiating async getMessenger to " + this.destAddress));
        }
        if (!(in_progress = this.endpoint.getMessenger(this, this.destAddress, this.padv == null ? null : this.padv.getRouteAdv()))) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Could not initiate async getMessenger to " + this.destAddress));
            }
            this.peerview.removePendingPve(this);
            this.setConnectivity(false);
        }
        return true;
    }

    public synchronized RdvAdvertisement getRdvAdvertisement() {
        return this.padv;
    }

    public synchronized RdvAdvertisement setRdvAdvertisement(RdvAdvertisement adv) {
        RdvAdvertisement old = this.padv;
        this.padv = adv;
        this.destAddress = this.mkAddress(adv.getPeerID(), null, null);
        return old;
    }

    public synchronized RouteAdvertisement getSrcRouteAdvertisement() {
        return this.srcRouteAdv;
    }

    public synchronized RouteAdvertisement setSrcRouteAdvertisement(RouteAdvertisement adv) {
        if (this.padv == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Misshandling of PeerViewElement: attempt to set src route for element initialized with endpoint address.");
            }
            return null;
        }
        RouteAdvertisement old = this.srcRouteAdv;
        this.srcRouteAdv = adv;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectivity(boolean live) {
        boolean mustNotify = false;
        PeerViewElement peerViewElement = this;
        synchronized (peerViewElement) {
            mustNotify = this.alive && !live && this.pinned;
            this.alive = live;
        }
        if (mustNotify) {
            this.peerview.notifyFailure(this, true);
        }
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public int compareTo(Object other) {
        PeerViewElement pve = (PeerViewElement)other;
        int result = this.destAddress.getProtocolAddress().compareTo(pve.destAddress.getProtocolAddress());
        if (result != 0) {
            return result;
        }
        return this.destAddress.getProtocolName().compareTo(pve.destAddress.getProtocolName());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PeerViewElement)) {
            return false;
        }
        PeerViewElement pve = (PeerViewElement)other;
        return pve.destAddress.equals(this.destAddress);
    }

    public int hashCode() {
        return this.destAddress.hashCode();
    }

    public String toString() {
        return (this.padv == null ? this.destAddress.toString() : this.padv.getName()) + "[" + super.toString() + "][" + this.messenger + "]";
    }

    private EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class PendingMessage {
        public Message message;
        public String serviceName;
        public String serviceParam;

        PendingMessage(Message message, String serviceName, String serviceParam) {
            this.message = message;
            this.serviceName = serviceName;
            this.serviceParam = serviceParam;
        }
    }
}

