/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rpv;

import java.util.Iterator;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.impl.rendezvous.rpv.PeerViewStrategy;

class PeerViewRandomStrategy
implements PeerViewStrategy {
    private static Random random = null;
    private SortedSet set = null;
    private SortedSet copy = null;

    PeerViewRandomStrategy() {
        if (random == null) {
            random = new Random();
        }
    }

    public synchronized void initialize(SortedSet set) {
        this.set = set;
        this.copy = new TreeSet(set);
    }

    public synchronized void reset() {
        this.copy = new TreeSet(this.set);
    }

    public synchronized PeerViewElement next() {
        if (this.set.size() == 0) {
            return null;
        }
        if (this.copy.size() == 0) {
            this.reset();
            return this.next();
        }
        int i = random.nextInt();
        i = i < 0 ? -i : i;
        i %= this.copy.size();
        int n = 0;
        PeerViewElement pve = null;
        Iterator si = this.copy.iterator();
        while (si.hasNext()) {
            pve = (PeerViewElement)si.next();
            if (i != n++) continue;
            si.remove();
            break;
        }
        return pve;
    }
}

