/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver.resolverMeter;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.impl.meter.MetricUtilities;
import net.jxta.peer.PeerID;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class QueryDestinationMetric
implements DocumentSerializable {
    private PeerID peerID;
    private int errorWhileProcessingQuery;
    private int queryProcessed;
    private int errorWhileProcessingResponse;
    private int responseProcessed;
    private int responseSentViaUnicast;
    private int querySentViaUnicast;
    private int queryToUnregisteredHandler;
    private int responseToUnregisteredHandler;

    public QueryDestinationMetric(PeerID pid) {
        this.peerID = this.peerID;
    }

    public QueryDestinationMetric(QueryDestinationMetric prototype) {
        this.peerID = prototype.peerID;
    }

    public QueryDestinationMetric() {
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    void querySentViaUnicast() {
        ++this.querySentViaUnicast;
    }

    public int getQueriesSentViaUnicast() {
        return this.querySentViaUnicast;
    }

    void responseSentViaUnicast() {
        ++this.responseSentViaUnicast;
    }

    public int getResponsesSentViaUnicast() {
        return this.responseSentViaUnicast;
    }

    void responseToUnregisteredHandler() {
        ++this.responseToUnregisteredHandler;
    }

    public int getResponseToUnregisteredHandler() {
        return this.responseToUnregisteredHandler;
    }

    void responseProcessed() {
        ++this.responseProcessed;
    }

    public int getResponsesProcessed() {
        return this.responseProcessed;
    }

    void errorWhileProcessingResponse() {
        ++this.errorWhileProcessingResponse;
    }

    public int getErrorsWhileProcessingResponse() {
        return this.errorWhileProcessingResponse;
    }

    void queryProcessed() {
        ++this.queryProcessed;
    }

    public int getQueriesProcessed() {
        return this.queryProcessed;
    }

    void queryToUnregisteredHandler() {
        ++this.queryToUnregisteredHandler;
    }

    public int getQueryToUnregisteredHandler() {
        return this.queryToUnregisteredHandler;
    }

    void errorWhileProcessingQuery() {
        ++this.errorWhileProcessingQuery;
    }

    public int getErrorsWhileProcessingQuery() {
        return this.errorWhileProcessingQuery;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        if (this.peerID != null) {
            DocumentSerializableUtilities.addString(element2, "peerID", this.peerID.toString());
        }
        if (this.errorWhileProcessingQuery != 0) {
            DocumentSerializableUtilities.addInt(element2, "errorWhileProcessingQuery", this.errorWhileProcessingQuery);
        }
        if (this.queryProcessed != 0) {
            DocumentSerializableUtilities.addInt(element2, "queryProcessed", this.queryProcessed);
        }
        if (this.errorWhileProcessingResponse != 0) {
            DocumentSerializableUtilities.addInt(element2, "errorWhileProcessingResponse", this.errorWhileProcessingResponse);
        }
        if (this.responseProcessed != 0) {
            DocumentSerializableUtilities.addInt(element2, "responseProcessed", this.responseProcessed);
        }
        if (this.responseSentViaUnicast != 0) {
            DocumentSerializableUtilities.addInt(element2, "responseSentViaUnicast", this.responseSentViaUnicast);
        }
        if (this.querySentViaUnicast != 0) {
            DocumentSerializableUtilities.addInt(element2, "querySentViaUnicast", this.querySentViaUnicast);
        }
        if (this.queryToUnregisteredHandler != 0) {
            DocumentSerializableUtilities.addInt(element2, "queryToUnregisteredHandler", this.queryToUnregisteredHandler);
        }
        if (this.responseToUnregisteredHandler != 0) {
            DocumentSerializableUtilities.addInt(element2, "responseToUnregisteredHandler", this.responseToUnregisteredHandler);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("peerID")) {
                String peerIDText = DocumentSerializableUtilities.getString(childElement);
                this.peerID = MetricUtilities.getPeerIdFromString(peerIDText);
                continue;
            }
            if (tagName.equals("errorWhileProcessingQuery")) {
                this.errorWhileProcessingQuery = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("queryProcessed")) {
                this.queryProcessed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("errorWhileProcessingResponse")) {
                this.errorWhileProcessingResponse = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("responseProcessed")) {
                this.responseProcessed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("responseSentViaUnicast")) {
                this.responseSentViaUnicast = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("querySentViaUnicast")) {
                this.querySentViaUnicast = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("queryToUnregisteredHandler")) {
                this.queryToUnregisteredHandler = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (!tagName.equals("responseToUnregisteredHandler")) continue;
            this.responseToUnregisteredHandler = DocumentSerializableUtilities.getInt(childElement);
        }
    }

    public void mergeMetrics(QueryDestinationMetric otherQueryDestinationMetric) {
        this.errorWhileProcessingQuery += otherQueryDestinationMetric.errorWhileProcessingQuery;
        this.queryProcessed += otherQueryDestinationMetric.queryProcessed;
        this.errorWhileProcessingResponse += otherQueryDestinationMetric.errorWhileProcessingResponse;
        this.responseProcessed += otherQueryDestinationMetric.responseProcessed;
        this.responseSentViaUnicast += otherQueryDestinationMetric.responseSentViaUnicast;
        this.querySentViaUnicast += otherQueryDestinationMetric.querySentViaUnicast;
        this.queryToUnregisteredHandler += otherQueryDestinationMetric.queryToUnregisteredHandler;
        this.responseToUnregisteredHandler += otherQueryDestinationMetric.responseToUnregisteredHandler;
    }

    public int hashCode() {
        return this.peerID.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof QueryDestinationMetric) {
            QueryDestinationMetric otherQueryDestinationMetric = (QueryDestinationMetric)other;
            return this.peerID.equals(otherQueryDestinationMetric.peerID);
        }
        return false;
    }
}

