/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver.resolverMeter;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.impl.meter.GenericServiceMonitor;
import net.jxta.impl.resolver.resolverMeter.QueryHandlerMeter;
import net.jxta.impl.resolver.resolverMeter.QueryHandlerMetric;
import net.jxta.impl.resolver.resolverMeter.ResolverMeter;
import net.jxta.impl.resolver.resolverMeter.ResolverMetric;
import net.jxta.impl.resolver.resolverMeter.ResolverServiceMetric;
import net.jxta.impl.resolver.resolverMeter.ResolverServiceMonitorFilter;
import net.jxta.impl.resolver.resolverMeter.SrdiHandlerMeter;
import net.jxta.impl.resolver.resolverMeter.SrdiHandlerMetric;
import net.jxta.meter.ServiceMetric;
import net.jxta.meter.ServiceMonitorFilter;

public class ResolverServiceMonitor
extends GenericServiceMonitor {
    public static final String UNKNOWN_HANDLER = "--UNKNOWN-HANDLER--";
    private Hashtable queryHandlerMeters = new Hashtable();
    private Hashtable srdiHandlerMeters = new Hashtable();
    private Hashtable destinationMeters = new Hashtable();
    private Hashtable sourceMeters = new Hashtable();
    private ResolverMeter resolverMeter = new ResolverMeter(this);
    private ResolverServiceMetric cumulativeResolverServiceMetric;

    protected void init() {
        this.cumulativeResolverServiceMetric = (ResolverServiceMetric)this.getCumulativeServiceMetric();
        this.cumulativeResolverServiceMetric.setResolverMetric(this.resolverMeter.getCumulativeMetrics());
    }

    public ResolverMeter getResolverMeter() {
        return this.resolverMeter;
    }

    public synchronized QueryHandlerMeter registerQueryHandlerMeter(String handlerName) {
        QueryHandlerMeter queryHandlerMeter = (QueryHandlerMeter)this.queryHandlerMeters.get(handlerName);
        if (queryHandlerMeter == null) {
            queryHandlerMeter = this.addQueryHandlerMeter(handlerName, true);
        }
        queryHandlerMeter.setRegistered(true);
        return queryHandlerMeter;
    }

    public synchronized QueryHandlerMeter addQueryHandlerMeter(String handlerName, boolean registered) {
        QueryHandlerMeter queryHandlerMeter = new QueryHandlerMeter(handlerName, this);
        this.queryHandlerMeters.put(handlerName, queryHandlerMeter);
        this.cumulativeResolverServiceMetric.addQueryHandlerMetric(queryHandlerMeter.getCumulativeMetrics());
        queryHandlerMeter.setRegistered(registered);
        return queryHandlerMeter;
    }

    public synchronized QueryHandlerMeter unregisterQueryHandlerMeter(String handlerName) {
        QueryHandlerMeter queryHandlerMeter = this.getQueryHandlerMeter(handlerName);
        queryHandlerMeter.setRegistered(false);
        return queryHandlerMeter;
    }

    public QueryHandlerMeter getQueryHandlerMeter(String handlerName) {
        QueryHandlerMeter queryHandlerMeter = (QueryHandlerMeter)this.queryHandlerMeters.get(handlerName);
        if (queryHandlerMeter == null) {
            queryHandlerMeter = this.addQueryHandlerMeter(handlerName, false);
        }
        return queryHandlerMeter;
    }

    public synchronized SrdiHandlerMeter registerSrdiHandlerMeter(String handlerName) {
        SrdiHandlerMeter srdiHandlerMeter = (SrdiHandlerMeter)this.srdiHandlerMeters.get(handlerName);
        if (srdiHandlerMeter == null) {
            srdiHandlerMeter = this.addSrdiHandlerMeter(handlerName, true);
        }
        srdiHandlerMeter.setRegistered(true);
        return srdiHandlerMeter;
    }

    public synchronized SrdiHandlerMeter addSrdiHandlerMeter(String handlerName, boolean registered) {
        SrdiHandlerMeter srdiHandlerMeter = new SrdiHandlerMeter(handlerName);
        this.srdiHandlerMeters.put(handlerName, srdiHandlerMeter);
        this.cumulativeResolverServiceMetric.addSrdiHandlerMetric(srdiHandlerMeter.getCumulativeMetrics());
        srdiHandlerMeter.setRegistered(registered);
        return srdiHandlerMeter;
    }

    public synchronized SrdiHandlerMeter unregisterSrdiHandlerMeter(String handlerName) {
        SrdiHandlerMeter srdiHandlerMeter = this.getSrdiHandlerMeter(handlerName);
        srdiHandlerMeter.setRegistered(false);
        return srdiHandlerMeter;
    }

    public SrdiHandlerMeter getSrdiHandlerMeter(String handlerName) {
        SrdiHandlerMeter srdiHandlerMeter = (SrdiHandlerMeter)this.srdiHandlerMeters.get(handlerName);
        if (srdiHandlerMeter == null) {
            srdiHandlerMeter = this.addSrdiHandlerMeter(handlerName, false);
        }
        return srdiHandlerMeter;
    }

    protected ServiceMetric collectServiceMetrics() {
        ResolverServiceMetric resolverServiceMetric = (ResolverServiceMetric)this.createServiceMetric();
        boolean anyData = false;
        Enumeration e = this.queryHandlerMeters.elements();
        while (e.hasMoreElements()) {
            QueryHandlerMeter queryHandlerMeter = (QueryHandlerMeter)e.nextElement();
            QueryHandlerMetric queryHandlerMetric = queryHandlerMeter.collectMetrics();
            if (queryHandlerMetric == null) continue;
            resolverServiceMetric.addQueryHandlerMetric(queryHandlerMetric);
            anyData = true;
        }
        Enumeration e2 = this.srdiHandlerMeters.elements();
        while (e2.hasMoreElements()) {
            SrdiHandlerMeter srdiHandlerMeter = (SrdiHandlerMeter)e2.nextElement();
            SrdiHandlerMetric srdiHandlerMetric = srdiHandlerMeter.collectMetrics();
            if (srdiHandlerMetric == null) continue;
            resolverServiceMetric.addSrdiHandlerMetric(srdiHandlerMetric);
            anyData = true;
        }
        ResolverMetric resolverMetric = this.resolverMeter.collectMetrics();
        if (resolverMetric != null) {
            resolverServiceMetric.setResolverMetric(resolverMetric);
            anyData = true;
        }
        if (anyData) {
            return resolverServiceMetric;
        }
        return null;
    }

    public ServiceMetric getServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime, int pulseIndex, long reportRate) {
        int deltaReportRateIndex = this.monitorManager.getReportRateIndex(reportRate);
        ResolverServiceMetric origMetric = (ResolverServiceMetric)this.deltaServiceMetrics[deltaReportRateIndex];
        if (origMetric == null) {
            return null;
        }
        ResolverServiceMonitorFilter resolverServiceMonitorFilter = (ResolverServiceMonitorFilter)serviceMonitorFilter;
        return origMetric.shallowCopy(resolverServiceMonitorFilter);
    }

    public ServiceMetric getCumulativeServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime) {
        ResolverServiceMonitorFilter resolverServiceMonitorFilter = (ResolverServiceMonitorFilter)serviceMonitorFilter;
        ResolverServiceMetric origMetric = (ResolverServiceMetric)this.cumulativeServiceMetric;
        return origMetric.deepCopy(resolverServiceMonitorFilter);
    }
}

