/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleClassAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class AdvCooker {
    public static void printNewClassAndModuleID() {
        ModuleClassID mcid = IDFactory.newModuleClassID();
        ModuleSpecID msid = IDFactory.newModuleSpecID(mcid);
        System.out.println("public static final String ClassID = \"" + mcid + "\";");
        System.out.println("public static final String SpecID = \"" + msid + "\";");
    }

    public static void printNewClassAndModuleID(ModuleClassID baseClassID) {
        ModuleClassID mcid = IDFactory.newModuleClassID(baseClassID);
        ModuleSpecID msid = IDFactory.newModuleSpecID(mcid);
        System.out.println("public static final String ClassID = \"" + mcid + "\";");
        System.out.println("public static final String SpecID = \"" + msid + "\";");
    }

    public static ModuleClassID buildModuleClassID(String url) throws MalformedURLException, UnknownServiceException {
        return (ModuleClassID)IDFactory.fromURL(IDFactory.jxtaURL(url));
    }

    public static ModuleSpecID buildModuleSpecID(String url) throws MalformedURLException, UnknownServiceException {
        return (ModuleSpecID)IDFactory.fromURL(IDFactory.jxtaURL(url));
    }

    public static ModuleClassAdvertisement buildModuleClassAdvertisement(ModuleClassID mcid, String serviceName, String serviceDescription) {
        ModuleClassAdvertisement mcadv = (ModuleClassAdvertisement)AdvertisementFactory.newAdvertisement(ModuleClassAdvertisement.getAdvertisementType());
        mcadv.setName(serviceName);
        mcadv.setDescription(serviceDescription);
        mcadv.setModuleClassID(mcid);
        return mcadv;
    }

    public static ModuleSpecAdvertisement buildModuleSpecAdvertisement(ModuleSpecID msid, String moduleSpecName, String moduleSpecDescription) {
        return AdvCooker.buildModuleSpecAdvertisement(msid, moduleSpecName, moduleSpecDescription, null, null, null, null, null, null, null);
    }

    public static ModuleSpecAdvertisement buildModuleSpecAdvertisement(ModuleSpecID msid, String moduleSpecName, String moduleSpecDescription, String creator, String version, String specURI) {
        return AdvCooker.buildModuleSpecAdvertisement(msid, moduleSpecName, moduleSpecDescription, creator, version, specURI, null, null, null, null);
    }

    public static ModuleSpecAdvertisement buildModuleSpecAdvertisement(ModuleSpecID msid, String moduleSpecName, String moduleSpecDescription, String creator, String version, String specURI, PipeAdvertisement pipeAdv, ModuleSpecID proxySpecID, ModuleSpecID authorizationSpecID, StructuredDocument param) {
        ModuleSpecAdvertisement msadv = (ModuleSpecAdvertisement)AdvertisementFactory.newAdvertisement(ModuleSpecAdvertisement.getAdvertisementType());
        msadv.setModuleSpecID(msid);
        msadv.setName(moduleSpecName);
        msadv.setDescription(moduleSpecDescription);
        msadv.setCreator(creator == null ? "jxta.org" : creator);
        msadv.setVersion(version == null ? "Version 1.0" : version);
        msadv.setSpecURI(specURI == null ? "http://www.jxta.org/" + moduleSpecName : specURI);
        if (pipeAdv != null) {
            msadv.setPipeAdvertisement(pipeAdv);
        }
        if (proxySpecID != null) {
            msadv.setProxySpecID(proxySpecID);
        }
        if (authorizationSpecID != null) {
            msadv.setAuthSpecID(authorizationSpecID);
        }
        if (param != null) {
            msadv.setParam(param);
        }
        return msadv;
    }

    public static StructuredTextDocument buildCompat() {
        try {
            return (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(StdPeerGroup.stdCompatStatement.getMimeType(), StdPeerGroup.stdCompatStatement.getStream());
        }
        catch (Exception e) {
            return AdvCooker.buildCompat("JDK1.4", "V1.0 Ref Impl");
        }
    }

    public static StructuredTextDocument buildCompat(String efmt, String bind) {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Comp");
        TextElement e = doc.createElement("Efmt", efmt);
        doc.appendChild((Element)e);
        e = doc.createElement("Bind", bind);
        doc.appendChild((Element)e);
        return doc;
    }

    public static ModuleImplAdvertisement buildModuleImplAdvertisement(ModuleSpecID msid, String code, Element compat) {
        ModuleImplAdvertisement miadv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        miadv.setCompat(compat);
        miadv.setModuleSpecID(msid);
        miadv.setCode(code);
        miadv.setDescription(code + " Module, J2SE Implementation");
        miadv.setProvider("jxta.org");
        miadv.setUri("http://download.jxta.org");
        return miadv;
    }

    public static ModuleImplAdvertisement buildModuleImplAdvertisement(ModuleSpecID msid, String code, Element compat, String description, String provider, String uri) {
        ModuleImplAdvertisement miadv = AdvCooker.buildModuleImplAdvertisement(msid, code, compat);
        miadv.setDescription(description);
        miadv.setProvider(provider);
        miadv.setUri(uri);
        return miadv;
    }

    public static ModuleImplAdvertisement buildPeerGroupImplAdvertisement(StdPeerGroup parent, ModuleSpecID newGroupModuleSpecID, String newDescription, Hashtable newServices) throws IllegalArgumentException, Exception {
        Object newApps = null;
        Object newProtos = null;
        AdvCooker.typeCheckKeys(newServices);
        AdvCooker.typeCheckValues(newServices);
        ModuleImplAdvertisement implAdv = parent.getAllPurposePeerGroupImplAdvertisement();
        implAdv.setDescription(newDescription);
        implAdv.setModuleSpecID(newGroupModuleSpecID);
        TextElement paramElement = (TextElement)((Object)implAdv.getParam());
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(paramElement);
        Hashtable services = paramAdv.getServices();
        AdvCooker.typeCheckKeys(services);
        services = AdvCooker.mergeTables(services, newServices);
        paramAdv.setServices(services);
        paramElement = (TextElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        return implAdv;
    }

    public static ModuleImplAdvertisement buildPeerGroupImplAdvertisement(PeerGroup parent, ModuleSpecID newGroupModuleSpecID, String newDescription, Hashtable newServices, Hashtable newApps) throws IllegalArgumentException, Exception {
        Object newProtos = null;
        AdvCooker.typeCheckKeys(newServices);
        AdvCooker.typeCheckValues(newServices);
        AdvCooker.typeCheckKeys(newApps);
        AdvCooker.typeCheckValues(newApps);
        ModuleImplAdvertisement implAdv = parent.getAllPurposePeerGroupImplAdvertisement();
        implAdv.setDescription(newDescription);
        implAdv.setModuleSpecID(newGroupModuleSpecID);
        TextElement paramElement = (TextElement)((Object)implAdv.getParam());
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(paramElement);
        Hashtable services = paramAdv.getServices();
        AdvCooker.typeCheckKeys(services);
        services = AdvCooker.mergeTables(services, newServices);
        paramAdv.setServices(services);
        Hashtable apps = paramAdv.getApps();
        AdvCooker.typeCheckKeys(apps);
        apps = AdvCooker.mergeTables(apps, newApps);
        paramAdv.setApps(apps);
        paramElement = (TextElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        return implAdv;
    }

    public static ModuleImplAdvertisement buildPeerGroupImplAdvertisement(PeerGroup parent, ModuleSpecID newGroupModuleSpecID, String newDescription, Hashtable newServices, Hashtable newApps, Hashtable newProtos) throws IllegalArgumentException, Exception {
        AdvCooker.typeCheckKeys(newServices);
        AdvCooker.typeCheckValues(newServices);
        AdvCooker.typeCheckKeys(newApps);
        AdvCooker.typeCheckValues(newApps);
        AdvCooker.typeCheckKeys(newProtos);
        AdvCooker.typeCheckValues(newProtos);
        ModuleImplAdvertisement implAdv = parent.getAllPurposePeerGroupImplAdvertisement();
        implAdv.setDescription(newDescription);
        implAdv.setModuleSpecID(newGroupModuleSpecID);
        TextElement paramElement = (TextElement)((Object)implAdv.getParam());
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(paramElement);
        Hashtable services = paramAdv.getServices();
        AdvCooker.typeCheckKeys(services);
        services = AdvCooker.mergeTables(services, newServices);
        paramAdv.setServices(services);
        Hashtable apps = paramAdv.getApps();
        AdvCooker.typeCheckKeys(apps);
        apps = AdvCooker.mergeTables(apps, newApps);
        paramAdv.setApps(newApps);
        Hashtable protos = paramAdv.getProtos();
        AdvCooker.typeCheckKeys(protos);
        apps = AdvCooker.mergeTables(protos, newProtos);
        paramAdv.setProtos(newProtos);
        paramElement = (TextElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        return implAdv;
    }

    public static void typeCheckValues(Hashtable moduleTable) throws IllegalArgumentException {
        String badVal = "Module table value not a ModuleImplAdvertisement ";
        Enumeration keys = moduleTable.keys();
        while (keys.hasMoreElements()) {
            Object value = moduleTable.get(keys.nextElement());
            boolean legalValue = value instanceof ModuleImplAdvertisement;
            if (legalValue) continue;
            throw new IllegalArgumentException(badVal + value);
        }
    }

    public static void typeCheckKeys(Hashtable moduleTable) throws IllegalArgumentException {
        String badKey = "Module table key not a ModuleClassID ";
        Enumeration keys = moduleTable.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            boolean legalKey = key instanceof ModuleClassID;
            if (legalKey) continue;
            throw new IllegalArgumentException(badKey + key);
        }
    }

    private static Hashtable mergeTables(Hashtable oldServices, Hashtable newServices) {
        Hashtable mergedServices = new Hashtable(oldServices);
        Enumeration newKeys = newServices.keys();
        while (newKeys.hasMoreElements()) {
            ModuleClassID key = (ModuleClassID)newKeys.nextElement();
            Enumeration oldKeys = oldServices.keys();
            while (oldKeys.hasMoreElements()) {
                ModuleClassID oldkey = (ModuleClassID)oldKeys.nextElement();
                if (!oldkey.isOfSameBaseClass(key)) continue;
                mergedServices.remove(oldkey);
            }
            mergedServices.put(key, newServices.get(key));
        }
        return mergedServices;
    }
}

