/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.IOException;
import java.io.InputStream;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.InputStreamMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;

public class BidirectionalPipeService {
    PeerGroup peerGroup;
    DiscoveryService discoveryService;
    PipeService pipeService;

    public BidirectionalPipeService(PeerGroup peerGroup) {
        this.peerGroup = peerGroup;
        this.pipeService = peerGroup.getPipeService();
        this.discoveryService = peerGroup.getDiscoveryService();
    }

    public AcceptPipe bind(String pipeName) throws IOException {
        PipeAdvertisement inputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement("jxta:PipeAdvertisement");
        inputPipeAdv.setPipeID(IDFactory.newPipeID(this.peerGroup.getPeerGroupID()));
        inputPipeAdv.setName(pipeName + ".end1");
        InputPipe inputPipe = this.pipeService.createInputPipe(inputPipeAdv);
        this.discoveryService.publish(inputPipeAdv, 2);
        this.discoveryService.remotePublish((Advertisement)inputPipeAdv, 2);
        return new AcceptPipe(inputPipeAdv, inputPipe);
    }

    public AcceptPipe bind(PipeAdvertisement inputPipeAdv) throws IOException {
        AcceptPipe result = null;
        InputPipe inputPipe = this.pipeService.createInputPipe(inputPipeAdv);
        this.discoveryService.publish(inputPipeAdv, 2);
        this.discoveryService.remotePublish((Advertisement)inputPipeAdv, 2);
        result = new AcceptPipe(inputPipeAdv, inputPipe);
        return result;
    }

    public Pipe connect(PipeAdvertisement adv, int timeout) throws IOException {
        return this.connect(adv, timeout, null);
    }

    public Pipe connect(PipeAdvertisement adv, int timeout, PeerID remotePeer) throws IOException {
        PipeAdvertisement outputPipeAdv;
        Document inputPipeAdvDoc;
        OutputPipe connectToPipe = this.pipeService.createOutputPipe(adv, remotePeer, (long)(timeout / 2));
        PipeAdvertisement inputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement("jxta:PipeAdvertisement");
        inputPipeAdv.setPipeID(IDFactory.newPipeID(this.peerGroup.getPeerGroupID()));
        inputPipeAdv.setName(adv.getName() + ".in");
        InputPipe inputPipe = this.pipeService.createInputPipe(inputPipeAdv);
        Message msg = new Message();
        try {
            inputPipeAdvDoc = inputPipeAdv.getDocument(MimeMediaType.XMLUTF8);
        }
        catch (Exception e) {
            throw new IOException("Unable to create input pipe advertisement document.");
        }
        msg.addMessageElement("jxta", new StringMessageElement("InputPipePeer", this.peerGroup.getPeerID().getURL().toString(), null));
        msg.addMessageElement("jxta", new InputStreamMessageElement("InputPipeAdv", MimeMediaType.XMLUTF8, inputPipeAdvDoc.getStream(), null));
        connectToPipe.send(msg);
        try {
            msg = inputPipe.poll(timeout / 2);
            if (msg == null) {
                throw new IOException("Expecting bi-directional pipe confirmation.");
            }
            MessageElement ackConfirm = msg.getMessageElement("InputPipeAdvAck");
            if (ackConfirm == null) {
                throw new IOException("Expecting bi-directional pipe confirmation.");
            }
            InputStream in = ackConfirm.getStream();
            if (in == null) {
                throw new IOException("Expecting bi-directional pipe confirmation.");
            }
            outputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(ackConfirm.getMimeType(), in);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IOException("Did not receive expected bi-directional confirmation.");
        }
        OutputPipe outputPipe = this.pipeService.createOutputPipe(outputPipeAdv, timeout / 2);
        return new Pipe(inputPipe, outputPipe);
    }

    class PipeMsgListenerImpl
    implements PipeMsgListener {
        MessageListener msgListener;
        OutputPipe outputPipe;

        PipeMsgListenerImpl(MessageListener msgListener, OutputPipe outputPipe) {
            this.msgListener = msgListener;
            this.outputPipe = outputPipe;
        }

        public void pipeMsgEvent(PipeMsgEvent ev) {
            this.msgListener.messageReceived(ev.getMessage(), this.outputPipe);
        }
    }

    public static interface MessageListener {
        public void messageReceived(Message var1, OutputPipe var2);
    }

    public class Pipe {
        InputPipe inputPipe;
        OutputPipe outputPipe;
        MessageListener msgListener;

        Pipe(InputPipe inputPipe, OutputPipe outputPipe) {
            this.inputPipe = inputPipe;
            this.outputPipe = outputPipe;
        }

        public InputPipe getInputPipe() {
            return this.inputPipe;
        }

        public OutputPipe getOutputPipe() {
            return this.outputPipe;
        }
    }

    public class AcceptPipe {
        PipeAdvertisement acceptInputPipeAdv;
        InputPipe acceptInputPipe;
        boolean done;

        AcceptPipe(PipeAdvertisement acceptInputPipeAdv, InputPipe acceptInputPipe) {
            this.acceptInputPipeAdv = acceptInputPipeAdv;
            this.acceptInputPipe = acceptInputPipe;
            this.done = false;
        }

        public PipeAdvertisement getAdvertisement() {
            return this.acceptInputPipeAdv;
        }

        public Pipe accept(int timeout) throws IOException, InterruptedException {
            return this.accept(timeout, null);
        }

        public Pipe accept(int timeout, MessageListener ml) throws IOException, InterruptedException {
            Message msg = this.acceptInputPipe.poll(timeout / 2);
            if (msg == null) {
                throw new InterruptedException("Timed out in accept.");
            }
            if (this.done && null != msg.getMessageElement("jxta", "Close")) {
                throw new InterruptedException();
            }
            if (!this.done) {
                Document inputPipeAdvDoc;
                MessageElement advEl = msg.getMessageElement("jxta", "InputPipeAdv");
                InputStream in = advEl.getStream();
                PipeAdvertisement outputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(advEl.getMimeType(), in);
                PeerID remotePeer = null;
                try {
                    MessageElement peerEl = msg.getMessageElement("jxta", "InputPipePeer");
                    String remotePeerURI = peerEl.toString();
                    remotePeer = (PeerID)IDFactory.fromURL(IDFactory.jxtaURL(remotePeerURI));
                }
                catch (Exception e) {
                    // empty catch block
                }
                OutputPipe outputPipe = BidirectionalPipeService.this.pipeService.createOutputPipe(outputPipeAdv, remotePeer, (long)(timeout / 2));
                PipeAdvertisement inputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement("jxta:PipeAdvertisement");
                inputPipeAdv.setPipeID(IDFactory.newPipeID(BidirectionalPipeService.this.peerGroup.getPeerGroupID()));
                inputPipeAdv.setName(outputPipeAdv.getName() + ".out");
                InputPipe inputPipe = ml == null ? BidirectionalPipeService.this.pipeService.createInputPipe(inputPipeAdv) : BidirectionalPipeService.this.pipeService.createInputPipe(inputPipeAdv, new PipeMsgListenerImpl(ml, outputPipe));
                try {
                    inputPipeAdvDoc = inputPipeAdv.getDocument(MimeMediaType.XMLUTF8);
                }
                catch (Exception e) {
                    throw new IOException("Unable to create input pipe advertisement document.");
                }
                msg = new Message();
                msg.addMessageElement("jxta", new InputStreamMessageElement("InputPipeAdvAck", MimeMediaType.XMLUTF8, inputPipeAdvDoc.getStream(), null));
                System.out.println("Sending bidir pipe ack.");
                outputPipe.send(msg);
                return new Pipe(inputPipe, outputPipe);
            }
            throw new IOException("Pipe closed.");
        }

        public synchronized void close() {
            this.done = true;
            this.acceptInputPipe.close();
        }
    }
}

