/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.ArrayList;
import java.util.List;
import net.jxta.impl.util.TimeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class UnbiasedQueue {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$util$UnbiasedQueue == null ? (class$net$jxta$impl$util$UnbiasedQueue = UnbiasedQueue.class$("net.jxta.impl.util.UnbiasedQueue")) : class$net$jxta$impl$util$UnbiasedQueue).getName());
    protected static final int DEFAULT_MAX_OBJECTS = 100;
    protected static final boolean DROP_OLDEST_OBJECT = true;
    protected static final long DROPPED_OBJECT_WARNING_INTERVAL = 10000L;
    protected List queue = null;
    protected int maxObjects;
    protected volatile boolean closeFlag = false;
    protected boolean dropOldestObject = true;
    protected long numEnqueued = 0L;
    protected long sumOfQueueSizesEnqueue = 0L;
    protected long numDequeued = 0L;
    protected long sumOfQueueSizesDequeue = 0L;
    protected long numDropped = 0L;
    protected long nextDroppedWarn = 0L;
    static /* synthetic */ Class class$net$jxta$impl$util$UnbiasedQueue;

    public static UnbiasedQueue synchronizedQueue(UnbiasedQueue queue) {
        return new SynchronizedQueue(queue);
    }

    public UnbiasedQueue() {
        this(100, true);
    }

    public UnbiasedQueue(int maxsize, boolean dropOldest) {
        this(maxsize, dropOldest, new ArrayList());
    }

    public UnbiasedQueue(int maxsize, boolean dropOldest, List queue) {
        if (maxsize <= 0) {
            throw new IllegalArgumentException("size must be > 0");
        }
        if (null == queue) {
            throw new IllegalArgumentException("queue must be non-null");
        }
        this.maxObjects = maxsize;
        this.queue = queue;
        this.closeFlag = false;
        this.dropOldestObject = dropOldest;
    }

    public synchronized String toString() {
        return this.getClass().getName() + " :" + " size=" + this.getCurrentInQueue() + " capacity=" + this.getMaxQueueSize() + " enqueued=" + this.getNumEnqueued() + " avgAtEnqueue=" + this.getAvgInQueueAtEnqueue() + " dequeued=" + this.getNumDequeued() + " avgAtDequeue=" + this.getAvgInQueueAtDequeue();
    }

    public boolean isClosed() {
        return this.closeFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closeFlag = true;
        List list = this.queue;
        synchronized (list) {
            this.queue.notifyAll();
        }
    }

    public void clear() {
        this.numDropped += (long)this.queue.size();
        this.queue.clear();
    }

    public boolean push(Object obj) {
        if (this.queue.size() >= this.maxObjects) {
            return false;
        }
        ++this.numEnqueued;
        this.sumOfQueueSizesEnqueue += (long)this.queue.size();
        this.queue.add(obj);
        return true;
    }

    public boolean pushBack(Object obj) {
        if (this.queue.size() >= this.maxObjects) {
            return false;
        }
        ++this.numEnqueued;
        this.sumOfQueueSizesEnqueue += (long)this.queue.size();
        this.queue.add(0, obj);
        return true;
    }

    public boolean push(Object obj, long timeout) throws InterruptedException {
        return this.push3(obj, timeout, false);
    }

    public boolean pushBack(Object obj, long timeout) throws InterruptedException {
        return this.push3(obj, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean push3(Object obj, long timeout, boolean atHead) throws InterruptedException {
        if (0L == timeout) {
            timeout = 0x7FFFFFFFFFFFFFFFL;
        }
        absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(timeout);
        var7_5 = this.queue;
        synchronized (var7_5) {
            do {
                block9: {
                    if (this.isClosed()) {
                        return false;
                    }
                    if (this.queue.size() < this.maxObjects) break;
                    waitfor = TimeUtils.toRelativeTimeMillis(absoluteTimeOut);
                    if (waitfor > 0L) {
                        this.queue.wait(waitfor);
                        continue;
                    }
                    if (!this.dropOldestObject) break block9;
                    now = TimeUtils.timeNow();
                    if (now > this.nextDroppedWarn && UnbiasedQueue.LOG.isEnabledFor((Priority)Level.WARN)) {
                        UnbiasedQueue.LOG.warn((Object)("Queue full, dropped one or more elements. Now dropped " + this.numDropped + " elements."));
                        this.nextDroppedWarn = now + 10000L;
                    }
                    if (!atHead) ** GOTO lbl28
                    ++this.numEnqueued;
                    ++this.numDropped;
                    this.queue.notify();
                    return true;
lbl-1000:
                    // 1 sources

                    {
                        ++this.numDropped;
                        this.queue.remove(0);
lbl28:
                        // 2 sources

                        ** while (this.queue.size() >= this.maxObjects)
                    }
lbl29:
                    // 1 sources

                    continue;
                }
                return false;
            } while (!this.isClosed());
            pushed = atHead != false ? this.pushBack(obj) : this.push(obj);
            this.queue.notify();
            return pushed;
        }
    }

    public Object peek() {
        Object result = null;
        if (this.queue.isEmpty()) {
            return null;
        }
        result = this.queue.get(0);
        return result;
    }

    public Object pop() {
        Object result = null;
        if (this.queue.isEmpty()) {
            return null;
        }
        this.sumOfQueueSizesDequeue += (long)this.queue.size();
        ++this.numDequeued;
        result = this.queue.remove(0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pop(long timeout) throws InterruptedException {
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(timeout);
        Object result = null;
        List list = this.queue;
        synchronized (list) {
            long waitfor;
            while (null == (result = this.pop()) && !this.isClosed() && (waitfor = TimeUtils.toRelativeTimeMillis(absoluteTimeOut)) > 0L) {
                this.queue.wait(waitfor);
                if (!this.isClosed()) continue;
            }
            this.queue.notify();
        }
        return result;
    }

    public Object[] popMulti(int maxObjs) {
        if (maxObjs <= 0) {
            throw new IllegalArgumentException("maxObjs must be > 0");
        }
        maxObjs = Math.min(maxObjs, this.queue.size());
        Object[] result = new Object[maxObjs];
        int eachElement = 0;
        while (eachElement < maxObjs) {
            this.sumOfQueueSizesDequeue += (long)this.queue.size();
            ++this.numDequeued;
            result[eachElement] = this.queue.remove(0);
            ++eachElement;
        }
        return result;
    }

    public int getMaxQueueSize() {
        return this.maxObjects;
    }

    public void setMaxQueueSize(int maxObjs) {
        this.maxObjects = maxObjs;
    }

    public int getCurrentInQueue() {
        return this.queue.size();
    }

    public long getNumEnqueued() {
        return this.numEnqueued;
    }

    public double getAvgInQueueAtEnqueue() {
        if (this.numEnqueued > 0L) {
            return (double)this.sumOfQueueSizesEnqueue / (double)this.numEnqueued;
        }
        return Double.NaN;
    }

    public long getNumDequeued() {
        return this.numDequeued;
    }

    public double getAvgInQueueAtDequeue() {
        if (this.numDequeued > 0L) {
            return (double)this.sumOfQueueSizesDequeue / (double)this.numDequeued;
        }
        return Double.NaN;
    }

    public long getNumDropped() {
        return this.numDropped;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class SynchronizedQueue
    extends UnbiasedQueue {
        UnbiasedQueue innerqueue;

        public SynchronizedQueue(UnbiasedQueue queue) {
            this.innerqueue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isClosed() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.isClosed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                this.innerqueue.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                this.innerqueue.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean push(Object obj) {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean pushBack(Object obj) {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.pushBack(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean push(Object obj, long timeout) throws InterruptedException {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.push(obj, timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean pushBack(Object obj, long timeout) throws InterruptedException {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.pushBack(obj, timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object peek() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object pop() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object pop(long timeout) throws InterruptedException {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.pop(timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] popMulti(int maxObjs) {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.popMulti(maxObjs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getMaxQueueSize() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getMaxQueueSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMaxQueueSize(int maxObjs) {
            List list = this.innerqueue.queue;
            synchronized (list) {
                this.innerqueue.setMaxQueueSize(maxObjs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getCurrentInQueue() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getCurrentInQueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumEnqueued() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getNumEnqueued();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getAvgInQueueAtEnqueue() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getAvgInQueueAtEnqueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumDequeued() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getNumDequeued();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getAvgInQueueAtDequeue() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getAvgInQueueAtDequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumDropped() {
            List list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getNumDropped();
            }
        }
    }
}

