/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.pipe.reliable.FlowControl;

public class AdaptiveFlowControl
extends FlowControl {
    static final int DEFAULT_RWINDOW = 2;
    private int MAX_TENSION = 3;
    private int tension = 0;
    private long nextRwinChange = TimeUtils.timeNow();
    private long prevAveRTT = 10000L;
    private int RINGSZ = 8;
    private long[] ackTimeRing = new long[this.RINGSZ];
    private int currAckRingOff = 0;
    private int nbSamples = 0;
    private long currAvePeriod = 1L;
    private long prevAvePeriod = 1L;
    private long periodRangeSlow = Long.MAX_VALUE;
    private long periodRangeFast = this.periodRangeSlow / 3L * 2L;
    private volatile int rwindow = 0;
    private int numberACKed = 0;
    private int numberMissing = 0;
    private long currACKTime = TimeUtils.timeNow();
    private int prevHole = -2;
    private int btbHoles = 0;
    private int maxHoleRun = 0;
    boolean fastMode = true;
    int takeAchance = 0;

    public AdaptiveFlowControl() {
        this(2);
    }

    public AdaptiveFlowControl(int rwindow) {
        this.rwindow = rwindow;
    }

    public int getRwindow() {
        return this.rwindow;
    }

    public void ackEventBegin() {
        this.currACKTime = TimeUtils.timeNow();
        this.numberACKed = 0;
        this.numberMissing = 0;
        this.maxHoleRun = 0;
    }

    public void packetACKed(int seqnum) {
        if (this.btbHoles > this.maxHoleRun) {
            this.maxHoleRun = this.btbHoles;
        }
        this.btbHoles = 0;
        this.prevHole = -2;
        ++this.numberACKed;
    }

    public void packetMissing(int seqnum) {
        if (seqnum != this.prevHole + 1) {
            if (this.btbHoles > this.maxHoleRun) {
                this.maxHoleRun = this.btbHoles;
            }
            this.btbHoles = 0;
        }
        ++this.btbHoles;
        this.prevHole = seqnum;
        ++this.numberMissing;
    }

    public int ackEventEnd(int rQSize, long aveRTT, long lastRTT) {
        if (this.numberACKed > 0) {
            long oldest = this.ackTimeRing[this.currAckRingOff];
            if (this.nbSamples < this.RINGSZ) {
                if (this.nbSamples == 0) {
                    this.ackTimeRing[0] = this.currACKTime / 2L;
                }
                ++this.nbSamples;
                oldest = this.ackTimeRing[0];
            }
            this.ackTimeRing[this.currAckRingOff++] = this.currACKTime;
            if (this.currAckRingOff == this.RINGSZ) {
                this.currAckRingOff = 0;
            }
            this.prevAvePeriod = this.currAvePeriod;
            this.currAvePeriod = (this.currACKTime - oldest) / (long)this.nbSamples;
        }
        int oldSize = this.rwindow;
        if (TimeUtils.toRelativeTimeMillis(this.nextRwinChange) < 0L) {
            if (this.maxHoleRun < 4) {
                if (this.numberACKed > 0) {
                    if (this.currAvePeriod < this.periodRangeFast) {
                        this.periodRangeFast = this.currAvePeriod;
                        this.periodRangeSlow = this.periodRangeFast * 3L / 2L;
                        this.prevAveRTT = aveRTT;
                        this.tension = 0;
                    } else {
                        int compressionRatio100;
                        int pivot = 100;
                        long period = this.currAvePeriod <= 0L ? 1L : this.currAvePeriod;
                        long backupSign = (long)(10 * pivot) * (aveRTT - this.prevAveRTT) / ((long)pivot * period + Math.max((long)(compressionRatio100 = 90) * ((long)pivot * period - period * period) / 100L, 0L));
                        if (backupSign > 18L) {
                            --this.rwindow;
                            this.tension = this.MAX_TENSION;
                            this.fastMode = false;
                        } else if (backupSign < 1L && this.currAvePeriod >= this.periodRangeSlow) {
                            if (this.tension >= this.MAX_TENSION && this.takeAchance++ > 10) {
                                this.takeAchance = 0;
                                --this.tension;
                            }
                        } else {
                            this.takeAchance = 0;
                        }
                    }
                    if (this.tension < this.MAX_TENSION) {
                        ++this.tension;
                        ++this.rwindow;
                    }
                } else {
                    this.tension = this.MAX_TENSION;
                }
            } else {
                this.rwindow -= this.MAX_TENSION + 1;
                this.prevAveRTT = aveRTT;
                this.tension = this.MAX_TENSION;
                this.fastMode = false;
            }
            if (this.rwindow > rQSize) {
                this.rwindow = rQSize;
            }
            if (this.rwindow < 2) {
                this.rwindow = 2;
            }
            if (oldSize != this.rwindow) {
                this.nextRwinChange = this.fastMode && this.tension < this.MAX_TENSION ? TimeUtils.toAbsoluteTimeMillis(lastRTT / 10L) : TimeUtils.toAbsoluteTimeMillis(aveRTT * 2L);
            }
        }
        return this.rwindow;
    }
}

