/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.pipe.reliable.Defs;
import net.jxta.impl.util.pipe.reliable.Incoming;
import net.jxta.impl.util.pipe.reliable.Outgoing;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ReliableInputStream
extends InputStream
implements Incoming {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$util$pipe$reliable$ReliableInputStream == null ? (class$net$jxta$impl$util$pipe$reliable$ReliableInputStream = ReliableInputStream.class$("net.jxta.impl.util.pipe.reliable.ReliableInputStream")) : class$net$jxta$impl$util$pipe$reliable$ReliableInputStream).getName());
    private static final boolean DEBUGIO = false;
    private Outgoing outgoing;
    private volatile boolean closed = false;
    private boolean closing = false;
    private Record record = null;
    private volatile int sequenceNumber = 0;
    private List inputQueue = new ArrayList();
    static /* synthetic */ Class class$net$jxta$impl$util$pipe$reliable$ReliableInputStream;

    public ReliableInputStream(Outgoing outgoing) {
        this.outgoing = outgoing;
        this.record = new Record();
        this.sequenceNumber = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        super.close();
        List list = this.inputQueue;
        synchronized (list) {
            this.closed = true;
            this.inputQueue.clear();
            this.inputQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosing() throws IOException {
        List list = this.inputQueue;
        synchronized (list) {
            this.closing = true;
            this.inputQueue.notifyAll();
        }
    }

    public int read() throws IOException {
        int len;
        if (this.closed) {
            return -1;
        }
        byte[] a = new byte[1];
        while ((len = this.local_read(a, 0, 1)) >= 0) {
            if (len <= 0) continue;
            return a[0] & 0xFF;
        }
        this.close();
        return -1;
    }

    public int read(byte[] a, int offset, int length) throws IOException {
        if (this.closed) {
            return -1;
        }
        if (0 == length) {
            return 0;
        }
        int i = this.local_read(a, offset, length);
        if (i == -1) {
            this.close();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendACK(int seqnAck) {
        ArrayList<Integer> selectedAckList = new ArrayList<Integer>();
        List list = this.inputQueue;
        synchronized (list) {
            Iterator eachInQueue = this.inputQueue.iterator();
            while (eachInQueue.hasNext() && selectedAckList.size() < 100) {
                IQElt anIQElt = (IQElt)eachInQueue.next();
                if (anIQElt.seqnum <= seqnAck) continue;
                selectedAckList.add(new Integer(anIQElt.seqnum));
            }
        }
        this.sendACK(seqnAck, selectedAckList);
    }

    private void sendACK(int seqnAck, List sackList) {
        block4: {
            ByteArrayOutputStream bos = new ByteArrayOutputStream((1 + sackList.size()) * 4);
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeInt(seqnAck);
                Iterator eachSACK = sackList.iterator();
                while (eachSACK.hasNext()) {
                    int aSack = (Integer)eachSACK.next();
                    dos.writeInt(aSack);
                }
                dos.close();
                bos.close();
                Message ACKMsg = new Message();
                ByteArrayMessageElement elt = new ByteArrayMessageElement("ack", Defs.MIME_TYPE_ACK, bos.toByteArray(), null);
                ACKMsg.addMessageElement("jxtarel", elt);
                this.outgoing.send(ACKMsg);
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("SENT ACK, seqn#" + seqnAck + " and " + sackList.size() + " SACKs "));
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.INFO)) break block4;
                LOG.info((Object)"sendACK caught IOException:", (Throwable)e);
            }
        }
    }

    public void recv(Message msg) {
        this.queueIncomingMessage(msg);
    }

    public boolean hasNextMessage() {
        return !this.inputQueue.isEmpty();
    }

    public synchronized Message nextMessage() {
        MessageElement elt = this.dequeueMessage(this.sequenceNumber + 1);
        if (null == elt) {
            return null;
        }
        ++this.sequenceNumber;
        Message msg = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(elt.getBytes(false));
            msg = WireFormatMessageFactory.fromWire(bais, Defs.MIME_TYPE_MSG, null);
        }
        catch (IOException ex) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Could not deserialize message " + elt.getElementName() + ": " + ex.getMessage()));
            }
            return null;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueIncomingMessage(Message msg) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Queue Incoming Message begins for " + msg));
        }
        long startEnqueue = TimeUtils.timeNow();
        Message.ElementIterator e = msg.getMessageElements("jxtarel", Defs.MIME_TYPE_BLOCK);
        while (!this.closed && !this.closing && e.hasNext()) {
            MessageElement elt = (MessageElement)e.next();
            e.remove();
            int msgSeqn = 0;
            try {
                msgSeqn = Integer.parseInt(elt.getElementName());
            }
            catch (NumberFormatException n) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Discarding element (" + elt.getElementName() + ") Not one of ours."));
                continue;
            }
            IQElt newElt = new IQElt();
            newElt.seqnum = msgSeqn;
            newElt.elt = elt;
            newElt.ackd = false;
            if (newElt.seqnum <= this.sequenceNumber) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break;
                LOG.debug((Object)("RCVD OLD MESSAGE : Discard seqn#" + newElt.seqnum + " now at seqn#" + this.sequenceNumber));
                break;
            }
            List list = this.inputQueue;
            synchronized (list) {
                if (this.closing || this.closed) {
                    return;
                }
                int insertIndex = this.inputQueue.size();
                boolean duplicate = false;
                int j = 0;
                while (j < this.inputQueue.size()) {
                    IQElt iq = (IQElt)this.inputQueue.get(j);
                    if (newElt.seqnum < iq.seqnum) {
                        insertIndex = j;
                        break;
                    }
                    if (newElt.seqnum == iq.seqnum) {
                        duplicate = true;
                        break;
                    }
                    ++j;
                }
                if (duplicate) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("RCVD OLD MESSAGE :  Discard duplicate msg, seqn#" + newElt.seqnum));
                    }
                    break;
                }
                this.inputQueue.add(insertIndex, newElt);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Enqueued msg with seqn#" + newElt.seqnum + " at index " + insertIndex));
                }
                this.inputQueue.notifyAll();
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            long waited = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), startEnqueue);
            LOG.info((Object)("Queue Incoming Message for " + msg + " completed in " + waited + " msec."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private MessageElement dequeueMessage(int desiredSeqn) {
        IQElt iQ = null;
        long startDequeue = TimeUtils.timeNow();
        int wct = 0;
        long nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
        List list = this.inputQueue;
        // MONITORENTER : list
        while (!this.closed) {
            if (this.inputQueue.size() == 0) {
                if (this.closing) {
                    // MONITOREXIT : list
                    return null;
                }
                try {
                    ++wct;
                    this.inputQueue.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
                continue;
            }
            iQ = (IQElt)this.inputQueue.get(0);
            if (iQ.seqnum < desiredSeqn) {
                this.inputQueue.remove(0);
                continue;
            }
            if (iQ.seqnum != desiredSeqn) {
                if (TimeUtils.toRelativeTimeMillis(nextRetransRequest) < 0L) {
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("Trigger retransmission. Wanted seqn#" + desiredSeqn + " found seqn#" + iQ.seqnum));
                    }
                    this.sendACK(desiredSeqn - 1);
                    nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
                }
                try {
                    ++wct;
                    this.inputQueue.wait(1000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            this.inputQueue.remove(0);
            break;
        }
        // MONITOREXIT : list
        if (null == iQ) {
            return null;
        }
        this.sendACK(desiredSeqn);
        if (!LOG.isEnabledFor((Priority)Level.INFO)) return iQ.elt;
        long waited = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), startDequeue);
        LOG.info((Object)("DEQUEUED seqn#" + iQ.seqnum + " in " + waited + " msec on input queue"));
        if (wct <= 0) return iQ.elt;
        LOG.debug((Object)("DEQUEUE waited " + wct + " times on input queue"));
        return iQ.elt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int local_read(byte[] a, int offset, int length) throws IOException {
        Record record = this.record;
        synchronized (record) {
            int res;
            if (this.record.size == 0L || this.record.nextByte == this.record.size) {
                MessageElement elt;
                this.record.resetRecord();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("local_read: getting next data block at seqn#" + (this.sequenceNumber + 1)));
                }
                if (null == (elt = this.dequeueMessage(this.sequenceNumber + 1))) {
                    return -1;
                }
                ++this.sequenceNumber;
                this.record.size = elt.getByteLength();
                this.record.inputStream = elt.getStream();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("local_read: new seqn#" + this.sequenceNumber + ", bytes = " + this.record.size));
                }
            }
            long left = this.record.size - this.record.nextByte;
            int copyLen = (int)Math.min((long)length, left);
            int copied = 0;
            while ((res = this.record.inputStream.read(a, offset + copied, copyLen - copied)) >= 0 && (copied += res) < copyLen) {
            }
            this.record.nextByte += (long)copied;
            return copied;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IQElt {
        int seqnum;
        MessageElement elt;
        boolean ackd;

        private IQElt() {
        }
    }

    private static class Record {
        public InputStream inputStream = null;
        public long nextByte = 0L;
        public long size = 0L;

        public void resetRecord() {
            if (null != this.inputStream) {
                try {
                    this.inputStream.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            this.inputStream = null;
            this.nextByte = 0L;
            this.size = 0L;
        }
    }
}

