/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.pipe.reliable.Defs;
import net.jxta.impl.util.pipe.reliable.FixedFlowControl;
import net.jxta.impl.util.pipe.reliable.FlowControl;
import net.jxta.impl.util.pipe.reliable.Incoming;
import net.jxta.impl.util.pipe.reliable.Outgoing;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ReliableOutputStream
extends OutputStream
implements Incoming {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$util$pipe$reliable$ReliableOutputStream == null ? (class$net$jxta$impl$util$pipe$reliable$ReliableOutputStream = ReliableOutputStream.class$("net.jxta.impl.util.pipe.reliable.ReliableOutputStream")) : class$net$jxta$impl$util$pipe$reliable$ReliableOutputStream).getName());
    private static final int MAXRETRQSIZE = 100;
    private static final long initRTT = 10000L;
    private static final MessageElement RETELT = new StringMessageElement("retry", "RETRY", null);
    private volatile boolean closed = false;
    private volatile boolean closing = false;
    private volatile int sequenceNumber = 0;
    private volatile int maxACK = 0;
    private Outgoing outgoing = null;
    private Retransmitter retrThread = null;
    private volatile long aveRTT = 10000L;
    private volatile long remRTT = 0L;
    private boolean aveRTTreset = false;
    private int nACKS = 0;
    private int rttThreshold = 0;
    private volatile long RTO = 0L;
    private volatile long minRTO = 50000L;
    private volatile long maxRTO = 600000L;
    private volatile long lastACKTime = 0L;
    private volatile long sackRetransTime = 0L;
    List retrQ = new ArrayList();
    private int nIQTests = 0;
    private int aveIQSize = 0;
    private volatile int mrrIQFreeSpace = 0;
    private int rmaxQSize = 100;
    private final FlowControl fc;
    private volatile int rwindow = 0;
    static /* synthetic */ Class class$net$jxta$impl$util$pipe$reliable$ReliableOutputStream;

    public ReliableOutputStream(Outgoing outgoing) {
        this(outgoing, new FixedFlowControl(5));
    }

    public ReliableOutputStream(Outgoing outgoing, FlowControl fc) {
        this.outgoing = outgoing;
        this.RTO = this.maxRTO;
        this.mrrIQFreeSpace = this.rmaxQSize;
        this.rttThreshold = this.rmaxQSize;
        this.lastACKTime = TimeUtils.timeNow();
        this.sackRetransTime = TimeUtils.timeNow();
        this.fc = fc;
        this.rwindow = fc.getRwindow();
        this.retrThread = new Retransmitter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        super.close();
        this.closed = true;
        Retransmitter temp = this.retrThread;
        if (null != temp) {
            Retransmitter retransmitter = temp;
            synchronized (retransmitter) {
                temp.notifyAll();
            }
        }
        this.retrQ.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosing() {
        List list = this.retrQ;
        synchronized (list) {
            this.closing = true;
            this.retrQ.notifyAll();
        }
    }

    public void write(int c) throws IOException {
        byte[] a = new byte[]{(byte)(c & 0xFF)};
        this.write(a, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        if (b == null) {
            throw new IllegalArgumentException("buffer is null");
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] data = new byte[len];
        System.arraycopy(b, off, data, 0, len);
        Message jmsg = new Message();
        List list = this.retrQ;
        synchronized (list) {
            if (this.closing) {
                throw new IOException("broken connection");
            }
            ByteArrayMessageElement element2 = new ByteArrayMessageElement(Integer.toString(++this.sequenceNumber), Defs.MIME_TYPE_BLOCK, data, null);
            jmsg.addMessageElement("jxtarel", element2);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Reliable WRITE : seqn#" + this.sequenceNumber + " length=" + len));
            }
            int maxwait = Math.min((int)this.aveRTT, 200);
            int waitCt = Math.max(maxwait / 60, 1);
            if (this.retrQ.size() > 0) {
                RetrQElt elt = (RetrQElt)this.retrQ.get(0);
                long inQueue = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), elt.enqueuedAt);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("write : Retry queue idle for " + inQueue));
                }
                if (inQueue > this.outgoing.getMaxRetryAge()) {
                    if (inQueue > 2L * this.outgoing.getMaxRetryAge()) {
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("Closing stale connection " + this.outgoing));
                        }
                        this.outgoing.close();
                        this.closing = true;
                        this.retrQ.notifyAll();
                    } else if (this.retrQ.size() >= 100) {
                        waitCt = Integer.MAX_VALUE;
                    }
                }
            }
            while (!this.closed && !this.closing && this.retrQ.size() > Math.min(this.rwindow, this.mrrIQFreeSpace * 2)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("write() wait 60ms for ACK while enqueuing seqn#" + this.sequenceNumber + "\n\tremote IQ free space = " + this.mrrIQFreeSpace + "\n\tMIN free space to continue = " + this.rmaxQSize / 5 + "\n\tretQ.size()=" + this.retrQ.size()));
                }
                try {
                    this.retrQ.wait(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new IOException("stream is closed");
            }
            if (this.closing) {
                throw new IOException("broken connection");
            }
            RetrQElt r = new RetrQElt(this.sequenceNumber, (Message)jmsg.clone());
            this.retrQ.add(r);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Retrans Enqueue added seqn#" + this.sequenceNumber + " retQ.size()=" + this.retrQ.size()));
            }
        }
        this.outgoing.send(jmsg);
        --this.mrrIQFreeSpace;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("SENT : seqn#" + this.sequenceNumber + " length=" + len));
        }
    }

    public int send(Message msg) throws IOException {
        WireFormatMessage msgSerialized = WireFormatMessageFactory.toWire(msg, Defs.MIME_TYPE_MSG, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)msg.getByteLength());
        msgSerialized.sendToStream(baos);
        baos.close();
        byte[] msgData = baos.toByteArray();
        this.write(msgData, 0, msgData.length);
        return this.sequenceNumber;
    }

    public int getMaxAck() {
        return this.maxACK;
    }

    public int getSeqNumber() {
        return this.sequenceNumber;
    }

    public boolean isQueueFull() {
        return this.mrrIQFreeSpace < 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitQueueEvent(long timeout) throws InterruptedException {
        List list = this.retrQ;
        synchronized (list) {
            this.retrQ.wait(timeout);
        }
    }

    private void calcRTT(long dt, int msgSeqNum) {
        ++this.nACKS;
        if (this.nACKS == 1) {
            this.rttThreshold = this.sequenceNumber + 1;
        }
        if (msgSeqNum > this.rttThreshold) {
            if (!this.aveRTTreset) {
                this.aveRTT = dt;
                this.aveRTTreset = true;
            } else {
                long tmp = 8L * this.aveRTT + 8L * this.remRTT / 9L + dt;
                this.aveRTT = tmp / 9L;
                this.remRTT = tmp - this.aveRTT * 9L;
            }
        }
        this.RTO = this.aveRTT * 2L;
        this.RTO = Math.max(this.RTO, this.minRTO);
        this.RTO = Math.min(this.RTO, this.maxRTO);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("RTT = " + dt + "ms aveRTT = " + this.aveRTT + "ms" + " RTO = " + this.RTO + "ms"));
        }
    }

    private int calcAVEIQ(int iq) {
        int n = this.nIQTests++;
        this.aveIQSize = (n * this.aveIQSize + iq) / this.nIQTests;
        return this.aveIQSize;
    }

    public void recv(Message msg) {
        Message.ElementIterator eachACK = msg.getMessageElements("jxtarel", Defs.MIME_TYPE_ACK);
        while (eachACK.hasNext()) {
            MessageElement elt = (MessageElement)eachACK.next();
            eachACK.remove();
            int sackCount = (int)elt.getByteLength() / 4 - 1;
            try {
                DataInputStream dis = new DataInputStream(elt.getStream());
                int seqack = dis.readInt();
                int[] sacs = new int[sackCount];
                int eachSac = 0;
                while (eachSac < sackCount) {
                    sacs[eachSac] = dis.readInt();
                    ++eachSac;
                }
                Arrays.sort(sacs);
                this.ackReceived(seqack, sacs);
            }
            catch (IOException failed) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)"Failure processing ACK", (Throwable)failed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackReceived(int seqnum, int[] sackList) {
        int numberACKed = 0;
        long rttCalcDt = 0L;
        int rttCalcSeqnum = -1;
        long fallBackDt = 0L;
        int fallBackSeqnum = -1;
        List list = this.retrQ;
        synchronized (list) {
            this.lastACKTime = TimeUtils.timeNow();
            this.fc.ackEventBegin();
            this.maxACK = Math.max(this.maxACK, seqnum);
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                int y;
                StringBuffer dumpRETRQ = new StringBuffer("ACK RECEIVE : " + Integer.toString(seqnum));
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    dumpRETRQ.append('\n');
                }
                dumpRETRQ.append("\tRETRQ (size=" + this.retrQ.size() + ")");
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    dumpRETRQ.append(" : ");
                    y = 0;
                    while (y < this.retrQ.size()) {
                        if (0 != y) {
                            dumpRETRQ.append(", ");
                        }
                        RetrQElt r = (RetrQElt)this.retrQ.get(y);
                        dumpRETRQ.append(r.seqnum);
                        ++y;
                    }
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    dumpRETRQ.append('\n');
                }
                dumpRETRQ.append("\tSACKLIST (size=" + sackList.length + ")");
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    dumpRETRQ.append(" : ");
                    y = 0;
                    while (y < sackList.length) {
                        if (0 != y) {
                            dumpRETRQ.append(", ");
                        }
                        dumpRETRQ.append(sackList[y]);
                        ++y;
                    }
                }
                LOG.info((Object)dumpRETRQ);
            }
            Iterator eachRetryQueueEntry = this.retrQ.iterator();
            while (eachRetryQueueEntry.hasNext()) {
                RetrQElt r = (RetrQElt)eachRetryQueueEntry.next();
                if (r.seqnum > seqnum) break;
                eachRetryQueueEntry.remove();
                long enqueuetime = r.enqueuedAt;
                long dt = TimeUtils.toRelativeTimeMillis(this.lastACKTime, enqueuetime);
                if (r.marked == 0) {
                    if (dt > rttCalcDt) {
                        rttCalcDt = dt;
                        rttCalcSeqnum = r.seqnum;
                    }
                } else if ((dt /= (long)(r.marked + 1)) > fallBackDt) {
                    fallBackDt = dt;
                    fallBackSeqnum = r.seqnum;
                }
                this.fc.packetACKed(r.seqnum);
                r.msg.clear();
                r.msg = null;
                r = null;
                ++numberACKed;
            }
            if (numberACKed > 0) {
                this.outgoing.setLastAccessed(TimeUtils.timeNow());
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("SEQUENTIALLY ACKD SEQN = " + seqnum + ", (" + numberACKed + " acked)"));
            }
            this.mrrIQFreeSpace = this.rmaxQSize - sackList.length;
            int aveIQ = this.calcAVEIQ(sackList.length);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("remote IQ free space = " + this.mrrIQFreeSpace + " remote avg IQ occupancy = " + aveIQ));
            }
            int retrans = 0;
            if (sackList.length > 0) {
                Iterator eachRetrQElement = this.retrQ.iterator();
                int currentSACK = 0;
                while (eachRetrQElement.hasNext()) {
                    RetrQElt r = (RetrQElt)eachRetrQElement.next();
                    while (sackList[currentSACK] < r.seqnum) {
                        if (++currentSACK == sackList.length) break;
                    }
                    if (currentSACK == sackList.length) break;
                    if (sackList[currentSACK] == r.seqnum) {
                        this.fc.packetACKed(r.seqnum);
                        ++numberACKed;
                        eachRetrQElement.remove();
                        long enqueuetime = r.enqueuedAt;
                        long dt = TimeUtils.toRelativeTimeMillis(this.lastACKTime, enqueuetime);
                        if (r.marked == 0) {
                            if (dt > rttCalcDt) {
                                rttCalcDt = dt;
                                rttCalcSeqnum = r.seqnum;
                            }
                        } else if ((dt /= (long)(r.marked + 1)) > fallBackDt) {
                            fallBackDt = dt;
                            fallBackSeqnum = r.seqnum;
                        }
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("SACKD SEQN = " + r.seqnum));
                        }
                        r.msg.clear();
                        r.msg = null;
                        r = null;
                        continue;
                    }
                    if (seqnum >= r.seqnum) continue;
                    this.fc.packetMissing(r.seqnum);
                    ++retrans;
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)("RETR: Fill hole, SACK, seqn#" + r.seqnum + ", Window =" + retrans));
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("SELECTIVE ACKD (" + numberACKed + ") " + retrans + " retrans wanted"));
                }
            }
            if (rttCalcSeqnum != -1) {
                this.calcRTT(rttCalcDt, rttCalcSeqnum);
                this.rwindow = this.fc.ackEventEnd(this.rmaxQSize, this.aveRTT, rttCalcDt);
            } else if (fallBackSeqnum != -1 && fallBackDt > this.aveRTT) {
                this.calcRTT(fallBackDt, fallBackSeqnum);
                this.rwindow = this.fc.ackEventEnd(this.rmaxQSize, this.aveRTT, fallBackDt);
            }
            if (retrans > 0) {
                this.retransmit(Math.min(this.rwindow, retrans), this.lastACKTime);
                this.sackRetransTime = TimeUtils.timeNow();
            }
            this.retrQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int retransmit(int rwin, long triggerTime) {
        int numberToRetrans;
        ArrayList<RetrQElt> retransMsgs = new ArrayList<RetrQElt>();
        List list = this.retrQ;
        synchronized (list) {
            numberToRetrans = Math.min(this.retrQ.size(), rwin);
            if (numberToRetrans > 0 && LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("RETRANSMITING [nb2retrans = " + numberToRetrans + "]"));
            }
            int j = 0;
            while (j < numberToRetrans) {
                RetrQElt r = (RetrQElt)this.retrQ.get(j);
                if (!(r.marked == 0 ? TimeUtils.toRelativeTimeMillis(triggerTime, r.sentAt) < 6L * this.aveRTT / 5L : TimeUtils.toRelativeTimeMillis(triggerTime, r.sentAt) < this.aveRTT)) {
                    ++r.marked;
                    retransMsgs.add(r);
                }
                ++j;
            }
        }
        int retransmitted = 0;
        Iterator eachRetrans = retransMsgs.iterator();
        while (eachRetrans.hasNext()) {
            RetrQElt r = (RetrQElt)eachRetrans.next();
            eachRetrans.remove();
            try {
                Message sending;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("RETRANSMIT seqn#" + r.seqnum));
                }
                if (null == (sending = r.msg)) continue;
                sending = (Message)sending.clone();
                sending.replaceMessageElement("jxtarel", RETELT);
                if (!this.outgoing.send(sending)) break;
                r.sentAt = TimeUtils.timeNow();
                --this.mrrIQFreeSpace;
                ++retransmitted;
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break;
                LOG.debug((Object)("FAILED RETRANS seqn#" + r.seqnum), (Throwable)e);
                break;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("RETRANSMITED " + retransmitted + " of " + numberToRetrans));
        }
        return retransmitted;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Retransmitter
    implements Runnable {
        Thread th;
        int nAtThisRTO = 0;
        volatile int nretransmitted = 0;

        public Retransmitter() {
            this.th = new Thread((Runnable)this, "JXTA Reliable Retransmiter for " + ReliableOutputStream.this.outgoing);
            this.th.setDaemon(true);
            this.th.start();
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("RETRANS : STARTED Reliable Retransmit thread, RTO = " + ReliableOutputStream.this.RTO));
            }
        }

        public int getRetransCount() {
            return this.nretransmitted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int idleCounter = 0;
                while (!ReliableOutputStream.this.closed) {
                    long oldestInQueueWait;
                    long conn_idle = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), ReliableOutputStream.this.outgoing.getLastAccessed());
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("RETRANS : " + ReliableOutputStream.this.outgoing + " idle for " + conn_idle));
                    }
                    if (ReliableOutputStream.this.outgoing.getIdleTimeout() < conn_idle) {
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("RETRANS : Shutting down idle connection " + ReliableOutputStream.this.outgoing));
                        }
                        try {
                            ReliableOutputStream.this.outgoing.close();
                            ReliableOutputStream.this.setClosing();
                            return;
                        }
                        catch (IOException ignored) {
                            continue;
                        }
                    }
                    List list = ReliableOutputStream.this.retrQ;
                    synchronized (list) {
                        try {
                            ReliableOutputStream.this.retrQ.wait(ReliableOutputStream.this.RTO);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (ReliableOutputStream.this.closed) break;
                    long sinceLastSACKRetr = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), ReliableOutputStream.this.sackRetransTime);
                    if (sinceLastSACKRetr < ReliableOutputStream.this.RTO) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)("RETRANS : SACK retrans " + sinceLastSACKRetr + "ms ago"));
                        continue;
                    }
                    long sinceLastACK = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), ReliableOutputStream.this.lastACKTime);
                    List list2 = ReliableOutputStream.this.retrQ;
                    synchronized (list2) {
                        if (ReliableOutputStream.this.retrQ.size() > 0) {
                            RetrQElt elt = (RetrQElt)ReliableOutputStream.this.retrQ.get(0);
                            oldestInQueueWait = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), elt.enqueuedAt);
                        } else {
                            oldestInQueueWait = 0L;
                        }
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("RETRANS : Last ACK " + sinceLastACK + "ms ago. Age of oldest in Queue " + oldestInQueueWait + "ms"));
                    }
                    if (oldestInQueueWait > ReliableOutputStream.this.outgoing.getMaxRetryAge() * 2L) {
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("RETRANS : Shutting down stale connection " + ReliableOutputStream.this.outgoing));
                        }
                        try {
                            ReliableOutputStream.this.outgoing.close();
                            ReliableOutputStream.this.setClosing();
                            return;
                        }
                        catch (IOException ignored) {
                            continue;
                        }
                    }
                    long realWait = Math.max(oldestInQueueWait, sinceLastACK);
                    if (realWait >= ReliableOutputStream.this.RTO && oldestInQueueWait >= ReliableOutputStream.this.RTO) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("RETRANS : RTO RETRANSMISSION [" + ReliableOutputStream.this.rwindow + "]"));
                        }
                        int retransed = ReliableOutputStream.this.retransmit(ReliableOutputStream.this.rwindow, TimeUtils.timeNow());
                        this.nretransmitted += retransed;
                        this.nAtThisRTO += retransed;
                        if (retransed > 0 && realWait >= 2L * ReliableOutputStream.this.RTO && this.nAtThisRTO >= 2 * ReliableOutputStream.this.rwindow) {
                            ReliableOutputStream.this.RTO = realWait > ReliableOutputStream.this.maxRTO ? ReliableOutputStream.this.maxRTO : 2L * ReliableOutputStream.this.RTO;
                            this.nAtThisRTO = 0;
                        }
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)("RETRANS : RETRANSMISSION " + retransed + " retrans " + this.nAtThisRTO + " at this RTO (" + ReliableOutputStream.this.RTO + ") " + this.nretransmitted + " total retrans"));
                        continue;
                    }
                    if (++idleCounter == 2) {
                        ReliableOutputStream.this.RTO = ReliableOutputStream.this.minRTO;
                        idleCounter = 0;
                        this.nAtThisRTO = 0;
                    }
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)("RETRANS : IDLE : RTO=" + ReliableOutputStream.this.RTO + " WAIT=" + realWait));
                }
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"Retransmit thread closing");
                }
            }
            catch (Throwable all) {
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"STOPPED Retransmit thread");
            }
            ReliableOutputStream.this.retrThread = null;
            this.th = null;
        }
    }

    private static class RetrQElt {
        int seqnum;
        long enqueuedAt;
        volatile Message msg;
        int marked;
        long sentAt;

        public RetrQElt(int seqnum, Message msg) {
            this.seqnum = seqnum;
            this.msg = msg;
            this.sentAt = this.enqueuedAt = TimeUtils.timeNow();
            this.marked = 0;
        }
    }
}

