/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xindice.core.filer;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import net.jxta.impl.xindice.Debug;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeCorruptException;
import net.jxta.impl.xindice.core.filer.BTreeException;
import net.jxta.impl.xindice.core.filer.BTreeNotFoundException;
import net.jxta.impl.xindice.core.filer.Paged;
import net.jxta.impl.xindice.core.filer.Streamable;
import net.jxta.impl.xindice.core.indexer.IndexQuery;

public class BTree
extends Paged {
    protected static final byte LEAF = 1;
    protected static final byte BRANCH = 2;
    protected static final byte STREAM = 3;
    private Map cache = new WeakHashMap();
    private BTreeFileHeader fileHeader = (BTreeFileHeader)this.getFileHeader();
    private BTreeRootInfo rootInfo;
    private BTreeNode rootNode;

    public BTree() {
        this.fileHeader.setPageCount(1L);
        this.fileHeader.setTotalCount(1L);
    }

    public BTree(File file) {
        this();
        this.setFile(file);
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean open() throws DBException {
        if (super.open()) {
            long p = this.fileHeader.getRootPage();
            this.rootInfo = new BTreeRootInfo(p);
            this.rootNode = this.getBTreeNode(this.rootInfo, p, null);
            return true;
        }
        return false;
    }

    public boolean create() throws DBException {
        if (super.create()) {
            try {
                this.open();
                long p = this.fileHeader.getRootPage();
                this.rootInfo = new BTreeRootInfo(p);
                this.rootNode = new BTreeNode(this.rootInfo, this.getPage(p));
                this.rootNode.ph.setStatus((byte)1);
                this.rootNode.setValues(new Value[0]);
                this.rootNode.setPointers(new long[0]);
                this.rootNode.write();
                this.close();
                return true;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    public long addValue(Value value, long pointer) throws IOException, BTreeException {
        return this.getRootNode().addValue(value, pointer);
    }

    public long addValue(BTreeRootInfo root, Value value, long pointer) throws IOException, BTreeException {
        return this.getRootNode(root).addValue(value, pointer);
    }

    public long removeValue(Value value) throws IOException, BTreeException {
        return this.getRootNode().removeValue(value);
    }

    public long removeValue(BTreeRootInfo root, Value value) throws IOException, BTreeException {
        return this.getRootNode(root).removeValue(value);
    }

    public long findValue(Value value) throws IOException, BTreeException {
        return this.getRootNode().findValue(value);
    }

    public long findValue(BTreeRootInfo root, Value value) throws IOException, BTreeException {
        return this.getRootNode(root).findValue(value);
    }

    public void query(IndexQuery query, BTreeCallback callback) throws IOException, BTreeException {
        this.getRootNode().query(query, callback);
    }

    public void query(BTreeRootInfo root, IndexQuery query, BTreeCallback callback) throws IOException, BTreeException {
        this.getRootNode(root).query(query, callback);
    }

    protected final BTreeRootInfo createBTreeRoot(Value v) throws IOException, BTreeException {
        BTreeNode n = this.createBTreeNode(this.rootInfo, (byte)1, null);
        n.write();
        long position = n.page.getPageNum();
        this.addValue(v, position);
        return new BTreeRootInfo(v, position);
    }

    protected final BTreeRootInfo createBTreeRoot(BTreeRootInfo root, Value v) throws IOException, BTreeException {
        BTreeNode n = this.createBTreeNode(root, (byte)1, null);
        n.write();
        long position = n.page.getPageNum();
        this.addValue(v, position);
        return new BTreeRootInfo(root, v, position);
    }

    protected final BTreeRootInfo findBTreeRoot(Value v) throws IOException, BTreeException {
        long position = this.findValue(v);
        return new BTreeRootInfo(v, position);
    }

    protected final BTreeRootInfo findBTreeRoot(BTreeRootInfo root, Value v) throws IOException, BTreeException {
        long position = this.findValue(root, v);
        return new BTreeRootInfo(root, v, position);
    }

    protected final void setRootNode(BTreeRootInfo root, BTreeNode newRoot) throws IOException, BTreeException {
        BTreeRootInfo parent = root.getParent();
        if (parent == null) {
            this.rootNode = newRoot;
            long p = this.rootNode.page.getPageNum();
            this.rootInfo.setPage(p);
            this.fileHeader.setRootPage(p);
        } else {
            long p = newRoot.page.getPageNum();
            root.setPage(p);
            this.addValue(parent, root.name, p);
        }
    }

    protected final void setRootNode(BTreeNode rootNode) throws IOException, BTreeException {
        this.setRootNode(this.rootInfo, rootNode);
    }

    protected final BTreeNode getRootNode(BTreeRootInfo root) {
        if (root.page == this.rootInfo.page) {
            return this.rootNode;
        }
        return this.getBTreeNode(root, root.getPage(), null);
    }

    protected final BTreeNode getRootNode() {
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTreeNode getBTreeNode(BTreeRootInfo root, long page, BTreeNode parent) {
        try {
            BTreeNode node;
            BTree bTree = this;
            synchronized (bTree) {
                Long pNum = new Long(page);
                node = (BTreeNode)this.cache.get(pNum);
                if (node == null) {
                    Paged.Page p = this.getPage(pNum);
                    node = new BTreeNode(root, p, parent);
                } else {
                    node.root = root;
                    node.parent = parent;
                }
            }
            BTreeNode bTreeNode = node;
            synchronized (bTreeNode) {
                if (!node.isLoaded()) {
                    node.read();
                    node.setLoaded(true);
                }
            }
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    private BTreeNode createBTreeNode(BTreeRootInfo root, byte status, BTreeNode parent) {
        try {
            Paged.Page p = this.getFreePage();
            BTreeNode node = new BTreeNode(root, p, parent);
            node.ph.setStatus(status);
            node.setValues(new Value[0]);
            node.setPointers(new long[0]);
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Paged.FileHeader createFileHeader() {
        return new BTreeFileHeader();
    }

    public Paged.FileHeader createFileHeader(boolean read) throws IOException {
        return new BTreeFileHeader(read);
    }

    public Paged.FileHeader createFileHeader(long pageCount) {
        return new BTreeFileHeader(pageCount);
    }

    public Paged.FileHeader createFileHeader(long pageCount, int pageSize) {
        return new BTreeFileHeader(pageCount, pageSize);
    }

    public Paged.PageHeader createPageHeader() {
        return new BTreePageHeader();
    }

    protected class BTreePageHeader
    extends Paged.PageHeader {
        private short valueCount = 0;

        public BTreePageHeader() {
            super(BTree.this);
        }

        public BTreePageHeader(DataInputStream dis) throws IOException {
            super(BTree.this, dis);
        }

        public synchronized void read(DataInputStream dis) throws IOException {
            super.read(dis);
            if (this.getStatus() == 0) {
                return;
            }
            this.valueCount = dis.readShort();
        }

        public synchronized void write(DataOutputStream dos) throws IOException {
            super.write(dos);
            dos.writeShort(this.valueCount);
        }

        public final synchronized void setValueCount(short valueCount) {
            this.valueCount = valueCount;
            this.setDirty();
        }

        public final synchronized short getValueCount() {
            return this.valueCount;
        }

        public final synchronized short getPointerCount() {
            if (this.getStatus() == 2) {
                return (short)(this.valueCount + 1);
            }
            return this.valueCount;
        }
    }

    protected class BTreeFileHeader
    extends Paged.FileHeader {
        private long rootPage = 0L;

        public BTreeFileHeader() {
            super(BTree.this);
        }

        public BTreeFileHeader(long pageCount) {
            super((Paged)BTree.this, pageCount);
        }

        public BTreeFileHeader(long pageCount, int pageSize) {
            super(BTree.this, pageCount, pageSize);
        }

        public BTreeFileHeader(boolean read) throws IOException {
            super((Paged)BTree.this, read);
        }

        public synchronized void read(RandomAccessFile raf) throws IOException {
            super.read(raf);
            this.rootPage = raf.readLong();
        }

        public synchronized void write(RandomAccessFile raf) throws IOException {
            super.write(raf);
            raf.writeLong(this.rootPage);
        }

        public final synchronized void setRootPage(long rootPage) {
            this.rootPage = rootPage;
            this.setDirty();
        }

        public final synchronized long getRootPage() {
            return this.rootPage;
        }
    }

    private final class BTreeNode {
        private BTreeRootInfo root;
        private Paged.Page page;
        private BTreePageHeader ph;
        private Value[] values;
        private long[] ptrs;
        private BTreeNode parent;
        private boolean loaded;

        public BTreeNode(BTreeRootInfo root, Paged.Page page, BTreeNode parent) {
            this.root = root;
            this.page = page;
            this.parent = parent;
            this.ph = (BTreePageHeader)page.getPageHeader();
        }

        public BTreeNode(BTreeRootInfo root, Paged.Page page) {
            this.root = root;
            this.page = page;
            this.ph = (BTreePageHeader)page.getPageHeader();
        }

        public synchronized void setValues(Value[] values) {
            this.values = values;
            this.ph.setValueCount((short)values.length);
        }

        public synchronized Value[] getValues() {
            return this.values;
        }

        public synchronized void setPointers(long[] ptrs) {
            this.ptrs = ptrs;
        }

        public synchronized long[] getPointers() {
            return this.ptrs;
        }

        public synchronized boolean isLoaded() {
            return this.loaded;
        }

        public synchronized void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }

        public synchronized void read() throws IOException {
            Value v = BTree.this.readValue(this.page);
            DataInputStream is = new DataInputStream(v.getInputStream());
            this.values = new Value[this.ph.getValueCount()];
            int i = 0;
            while (i < this.values.length) {
                short valSize = is.readShort();
                byte[] b = new byte[valSize];
                is.read(b);
                this.values[i] = new Value(b);
                ++i;
            }
            this.ptrs = new long[this.ph.getPointerCount()];
            int i2 = 0;
            while (i2 < this.ptrs.length) {
                this.ptrs[i2] = is.readLong();
                ++i2;
            }
            BTree.this.cache.put(new Long(this.page.getPageNum()), this);
        }

        public synchronized void write() throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(BTree.this.fileHeader.getWorkSize());
            DataOutputStream os = new DataOutputStream(bos);
            int i = 0;
            while (i < this.values.length) {
                os.writeShort(this.values[i].getLength());
                this.values[i].streamTo(os);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.ptrs.length) {
                os.writeLong(this.ptrs[i2]);
                ++i2;
            }
            BTree.this.writeValue(this.page, new Value(bos.toByteArray()));
            BTree.this.cache.put(new Long(this.page.getPageNum()), this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BTreeNode getChildNode(int idx) {
            long loadPtr;
            BTreeRootInfo loadNode;
            boolean load;
            BTreeNode bTreeNode = this;
            synchronized (bTreeNode) {
                if (this.ph.getStatus() == 2 && idx >= 0 && idx < this.ptrs.length) {
                    load = true;
                    loadNode = this.root;
                    loadPtr = this.ptrs[idx];
                } else {
                    load = false;
                    loadNode = null;
                    loadPtr = 0L;
                }
            }
            if (load) {
                return BTree.this.getBTreeNode(loadNode, loadPtr, this);
            }
            return null;
        }

        public synchronized void getChildStream(int idx, Streamable stream) throws IOException {
            if (this.ph.getStatus() == 1 && idx >= 0 && idx < this.ptrs.length) {
                Value v = BTree.this.readValue(this.ptrs[idx]);
                DataInputStream dis = new DataInputStream(v.getInputStream());
                stream.read(dis);
            }
        }

        public synchronized long removeValue(Value value) throws IOException, BTreeException {
            int idx = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    idx = idx < 0 ? -(idx + 1) : idx + 1;
                    return this.getChildNode(idx).removeValue(value);
                }
                case 1: {
                    if (idx < 0) {
                        throw new BTreeNotFoundException("Value '" + value.toString() + "' doesn't exist");
                    }
                    long oldPtr = this.ptrs[idx];
                    this.setValues(Paged.deleteArrayValue(this.values, idx));
                    this.setPointers(Paged.deleteArrayLong(this.ptrs, idx));
                    this.write();
                    return oldPtr;
                }
            }
            throw new BTreeCorruptException("Invalid page type '" + this.ph.getStatus() + "' in removeValue");
        }

        public synchronized long addValue(Value value, long pointer) throws IOException, BTreeException {
            if (value == null) {
                throw new BTreeException(571, "Can't add a null Value");
            }
            int idx = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    idx = idx < 0 ? -(idx + 1) : idx + 1;
                    BTreeNode node = this.getChildNode(idx);
                    if (node != null) {
                        return node.addValue(value, pointer);
                    }
                    throw new BTreeCorruptException("Cannot add Value '" + value.toString() + "'");
                }
                case 1: {
                    if (idx >= 0) {
                        long oldPtr = this.ptrs[idx];
                        this.ptrs[idx] = pointer;
                        this.setValues(this.values);
                        this.setPointers(this.ptrs);
                        this.write();
                        return oldPtr;
                    }
                    idx = -(idx + 1);
                    boolean split = this.ph.getDataLen() + 6 + value.getLength() > BTree.this.fileHeader.getWorkSize();
                    this.setValues(Paged.insertArrayValue(this.values, value, idx));
                    this.setPointers(Paged.insertArrayLong(this.ptrs, pointer, idx));
                    if (split) {
                        this.split();
                    } else {
                        this.write();
                    }
                    return -1L;
                }
            }
            throw new BTreeCorruptException("Invalid Page Type In addValue");
        }

        public synchronized void promoteValue(Value value, long rightPointer) throws IOException, BTreeException {
            boolean split = this.ph.getDataLen() + 6 + value.getLength() > BTree.this.fileHeader.getWorkSize();
            int idx = Arrays.binarySearch(this.values, value);
            idx = idx < 0 ? -(idx + 1) : idx + 1;
            this.setValues(Paged.insertArrayValue(this.values, value, idx));
            this.setPointers(Paged.insertArrayLong(this.ptrs, rightPointer, idx + 1));
            if (split) {
                this.split();
            } else {
                this.write();
            }
        }

        public Value getSeparator(Value value1, Value value2) {
            int idx = value1.compareTo(value2);
            byte[] b = new byte[Math.abs(idx)];
            System.arraycopy(value2.getData(), 0, b, 0, b.length);
            return new Value(b);
        }

        public synchronized void split() throws IOException, BTreeException {
            Value separator;
            long[] rightPtrs;
            Value[] rightVals;
            long[] leftPtrs;
            Value[] leftVals;
            short vc = this.ph.getValueCount();
            int pivot = vc / 2;
            switch (this.ph.getStatus()) {
                case 2: {
                    leftVals = new Value[pivot];
                    leftPtrs = new long[leftVals.length + 1];
                    rightVals = new Value[vc - (pivot + 1)];
                    rightPtrs = new long[rightVals.length + 1];
                    System.arraycopy(this.values, 0, leftVals, 0, leftVals.length);
                    System.arraycopy(this.ptrs, 0, leftPtrs, 0, leftPtrs.length);
                    System.arraycopy(this.values, leftVals.length + 1, rightVals, 0, rightVals.length);
                    System.arraycopy(this.ptrs, leftPtrs.length, rightPtrs, 0, rightPtrs.length);
                    separator = this.values[leftVals.length];
                    break;
                }
                case 1: {
                    leftVals = new Value[pivot];
                    leftPtrs = new long[leftVals.length];
                    rightVals = new Value[vc - pivot];
                    rightPtrs = new long[rightVals.length];
                    System.arraycopy(this.values, 0, leftVals, 0, leftVals.length);
                    System.arraycopy(this.ptrs, 0, leftPtrs, 0, leftPtrs.length);
                    System.arraycopy(this.values, leftVals.length, rightVals, 0, rightVals.length);
                    System.arraycopy(this.ptrs, leftPtrs.length, rightPtrs, 0, rightPtrs.length);
                    separator = this.getSeparator(leftVals[leftVals.length - 1], rightVals[0]);
                    break;
                }
                default: {
                    throw new BTreeCorruptException("Invalid Page Type In split");
                }
            }
            this.setValues(leftVals);
            this.setPointers(leftPtrs);
            if (this.parent == null) {
                BTreeNode np = BTree.this.createBTreeNode(this.root, (byte)2, null);
                BTreeNode rNode = BTree.this.createBTreeNode(this.root, this.ph.getStatus(), np);
                rNode.setValues(rightVals);
                rNode.setPointers(rightPtrs);
                np.setValues(new Value[]{separator});
                np.setPointers(new long[]{this.page.getPageNum(), rNode.page.getPageNum()});
                this.parent = np;
                BTree.this.setRootNode(this.root, np);
                this.write();
                rNode.write();
                np.write();
            } else {
                BTreeNode rNode = BTree.this.createBTreeNode(this.root, this.ph.getStatus(), this.parent);
                rNode.setValues(rightVals);
                rNode.setPointers(rightPtrs);
                this.write();
                rNode.write();
                this.parent.promoteValue(separator, rNode.page.getPageNum());
            }
        }

        public synchronized long findValue(Value value) throws IOException, BTreeException {
            if (value == null) {
                throw new BTreeNotFoundException("Can't search on null Value");
            }
            int idx = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    idx = idx < 0 ? -(idx + 1) : idx + 1;
                    BTreeNode node = this.getChildNode(idx);
                    if (node != null) {
                        return node.findValue(value);
                    }
                    throw new BTreeNotFoundException("Value '" + value.toString() + "' doesn't exist");
                }
                case 1: {
                    if (idx < 0) {
                        throw new BTreeNotFoundException("Value '" + value.toString() + "' doesn't exist");
                    }
                    return this.ptrs[idx];
                }
            }
            throw new BTreeCorruptException("Invalid page type '" + this.ph.getStatus() + "' in findValue");
        }

        public synchronized void query(IndexQuery query, BTreeCallback callback) throws IOException, BTreeException {
            block54: {
                block53: {
                    if (query == null || query.getOperator() == 0) break block53;
                    Value[] qvals = query.getValues();
                    int leftIdx = Arrays.binarySearch(this.values, qvals[0]);
                    int rightIdx = qvals.length > 1 ? Arrays.binarySearch(this.values, qvals[qvals.length - 1]) : leftIdx;
                    switch (this.ph.getStatus()) {
                        case 2: {
                            leftIdx = leftIdx < 0 ? -(leftIdx + 1) : leftIdx + 1;
                            rightIdx = rightIdx < 0 ? -(rightIdx + 1) : rightIdx + 1;
                            switch (query.getOperator()) {
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        if (i >= leftIdx && i <= rightIdx) {
                                            this.getChildNode(i).query(query, callback);
                                        }
                                        ++i;
                                    }
                                    break block54;
                                }
                                case -7: 
                                case -6: 
                                case -5: 
                                case -4: {
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        if (i <= leftIdx || i >= rightIdx) {
                                            this.getChildNode(i).query(query, callback);
                                        }
                                        ++i;
                                    }
                                    break block54;
                                }
                                case 1: {
                                    this.getChildNode(leftIdx).query(query, callback);
                                    break;
                                }
                                case -2: 
                                case 3: {
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        if (i <= leftIdx) {
                                            this.getChildNode(i).query(query, callback);
                                        }
                                        ++i;
                                    }
                                    break block54;
                                }
                                case -3: 
                                case 2: {
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        if (i >= rightIdx) {
                                            this.getChildNode(i).query(query, callback);
                                        }
                                        ++i;
                                    }
                                    break block54;
                                }
                                default: {
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        this.getChildNode(i).query(query, callback);
                                        ++i;
                                    }
                                    break block54;
                                }
                            }
                            break block54;
                        }
                        case 1: {
                            switch (query.getOperator()) {
                                case 1: {
                                    if (leftIdx >= 0) {
                                        callback.indexInfo(this.values[leftIdx], this.ptrs[leftIdx]);
                                        break;
                                    }
                                    break block54;
                                }
                                case -1: {
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        if (i != leftIdx) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        ++i;
                                    }
                                    break block54;
                                }
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        if (i >= leftIdx && i <= rightIdx && query.testValue(this.values[i])) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        ++i;
                                    }
                                    break block54;
                                }
                                case -7: 
                                case -5: 
                                case -4: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        if ((i <= leftIdx || i >= rightIdx) && query.testValue(this.values[i])) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        ++i;
                                    }
                                    break block54;
                                }
                                case -2: 
                                case 3: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        if (i <= leftIdx && query.testValue(this.values[i])) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        ++i;
                                    }
                                    break block54;
                                }
                                case -3: 
                                case 2: {
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        if (i >= rightIdx && query.testValue(this.values[i])) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        ++i;
                                    }
                                    break block54;
                                }
                                default: {
                                    int i = 0;
                                    while (i < this.ptrs.length) {
                                        if (query.testValue(this.values[i])) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        ++i;
                                    }
                                    break block54;
                                }
                            }
                            break block54;
                        }
                        default: {
                            throw new BTreeCorruptException("Invalid Page Type In query");
                        }
                    }
                }
                switch (this.ph.getStatus()) {
                    case 2: {
                        int i = 0;
                        while (i < this.ptrs.length) {
                            this.getChildNode(i).query(query, callback);
                            ++i;
                        }
                        break;
                    }
                    case 1: {
                        int i = 0;
                        while (i < this.values.length) {
                            callback.indexInfo(this.values[i], this.ptrs[i]);
                            ++i;
                        }
                        break;
                    }
                    default: {
                        throw new BTreeCorruptException("Invalid Page Type In query");
                    }
                }
            }
        }
    }

    public final class BTreeRootInfo {
        private BTreeRootInfo parent;
        private Value name;
        private long page;

        public BTreeRootInfo(BTreeRootInfo parent, String name, long page) {
            this.parent = parent;
            this.name = new Value(name);
            this.page = page;
        }

        public BTreeRootInfo(BTreeRootInfo parent, Value name, long page) {
            this.parent = parent;
            this.name = name;
            this.page = page;
        }

        public BTreeRootInfo(String name, long page) {
            this.parent = BTree.this.rootInfo;
            this.name = new Value(name);
            this.page = page;
        }

        public BTreeRootInfo(Value name, long page) {
            this.parent = BTree.this.rootInfo;
            this.name = name;
            this.page = page;
        }

        private BTreeRootInfo(long page) {
            this.parent = null;
            this.name = null;
            this.page = page;
        }

        public synchronized BTreeRootInfo getParent() {
            return this.parent;
        }

        public synchronized Value getName() {
            return this.name;
        }

        public synchronized long getPage() {
            return this.page;
        }

        public synchronized void setPage(long page) {
            this.page = page;
        }
    }
}

