/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xindice.core.filer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.data.Record;
import net.jxta.impl.xindice.core.data.RecordSet;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTree;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeException;
import net.jxta.impl.xindice.core.filer.BTreeNotFoundException;
import net.jxta.impl.xindice.core.filer.Filer;
import net.jxta.impl.xindice.core.filer.FilerException;
import net.jxta.impl.xindice.core.filer.Paged;

public final class BTreeFiler
extends BTree
implements Filer {
    protected static final byte RECORD = 20;
    private static final short PAGESIZE = 4096;
    private static final short MAXKEYSIZE = 256;
    private BTreeFilerHeader fileHeader = (BTreeFilerHeader)this.getFileHeader();
    private static final int DBE_CANNOT_READ = 572;

    public void setLocation(String dir, String file) {
        this.setFile(new File(dir, file + ".tbl"));
    }

    public String getName() {
        return this.getFile().getName();
    }

    public boolean open() throws DBException {
        if (super.open()) {
            this.fileHeader.setMaxKeySize((short)256);
            return true;
        }
        return false;
    }

    public boolean create() throws DBException {
        this.fileHeader.setPageSize(4096);
        this.fileHeader.setMaxKeySize((short)256);
        return super.create();
    }

    public Record readRecord(Key key) throws DBException {
        if (key == null || key.equals("")) {
            return null;
        }
        this.checkOpened();
        try {
            long pos = this.findValue(key);
            Record record = this.readRecord(pos);
            record.setKey(key);
            return record;
        }
        catch (BTreeNotFoundException b) {
        }
        catch (BTreeException b) {
            throw b;
        }
        catch (IOException e) {
            throw new FilerException(572, "Can't read record '" + key + "': " + e.getMessage(), e);
        }
        return null;
    }

    public Record readRecord(long pos) throws DBException {
        this.checkOpened();
        try {
            Paged.Page startPage = this.getPage(pos);
            Value v = this.readValue(startPage);
            BTreeFilerPageHeader sph = (BTreeFilerPageHeader)startPage.getPageHeader();
            HashMap<String, Long> meta = new HashMap<String, Long>(4);
            meta.put("created", new Long(sph.getCreated()));
            meta.put("modified", new Long(sph.getModified()));
            meta.put("lifetime", new Long(sph.getLifetime()));
            meta.put("expiration", new Long(sph.getExpiration()));
            return new Record(null, v, meta);
        }
        catch (IOException e) {
            throw new FilerException(572, "Can't read record : " + e.getMessage(), e);
        }
    }

    public long writeRecord(Key key, Value value) throws DBException {
        return this.writeRecord(key, value, 0L, 0L);
    }

    public long writeRecord(Key key, Value value, long lifetime, long expiration) throws DBException {
        if (key == null || key.equals("")) {
            throw new FilerException(571, "Invalid key: '" + key + "'");
        }
        if (value == null) {
            throw new FilerException(571, "Invalid null value");
        }
        this.checkOpened();
        try {
            Paged.Page p;
            long pos = 0L;
            try {
                pos = this.findValue(key);
                p = this.getPage(pos);
            }
            catch (BTreeNotFoundException b) {
                p = this.getFreePage();
                pos = p.getPageNum();
                this.addValue(key, p.getPageNum());
                this.fileHeader.incRecordCount();
            }
            BTreeFilerPageHeader ph = (BTreeFilerPageHeader)p.getPageHeader();
            long t = System.currentTimeMillis();
            if (ph.getStatus() == 0) {
                ph.setCreated(t);
            }
            ph.setModified(t);
            ph.setLifetime(lifetime);
            ph.setExpiration(expiration);
            ph.setStatus((byte)20);
            this.writeValue(p, value);
            this.flush();
            return pos;
        }
        catch (IOException e) {
            throw new FilerException(571, "Can't write record '" + key + "': " + e.getMessage(), e);
        }
    }

    public long writeRecord(long pos, Value value) throws DBException {
        if (value == null) {
            throw new FilerException(571, "Invalid null value");
        }
        this.checkOpened();
        try {
            this.writeValue(pos, value);
            this.flush();
            return pos;
        }
        catch (IOException e) {
            throw new FilerException(571, "Can't write record '" + value + "': " + e.getMessage(), e);
        }
    }

    public boolean deleteRecord(Key key) throws DBException {
        if (key == null || key.equals("")) {
            return false;
        }
        this.checkOpened();
        try {
            long pos = this.findValue(key);
            Paged.Page p = this.getPage(pos);
            this.removeValue(key);
            this.unlinkPages(p.getPageNum());
            this.fileHeader.decRecordCount();
            this.flush();
            return true;
        }
        catch (BTreeNotFoundException b) {
        }
        catch (IOException e) {
            throw new FilerException(570, "Can't delete record '" + key + "': " + e.getMessage(), e);
        }
        return false;
    }

    public long getRecordCount() throws DBException {
        this.checkOpened();
        return this.fileHeader.getRecordCount();
    }

    public RecordSet getRecordSet() throws DBException {
        this.checkOpened();
        return new BTreeFilerRecordSet();
    }

    public void flush() throws DBException {
        super.flush();
    }

    public Paged.FileHeader createFileHeader() {
        return new BTreeFilerHeader();
    }

    public Paged.FileHeader createFileHeader(boolean read) throws IOException {
        return new BTreeFilerHeader(read);
    }

    public Paged.FileHeader createFileHeader(long pageCount) {
        return new BTreeFilerHeader(pageCount);
    }

    public Paged.FileHeader createFileHeader(long pageCount, int pageSize) {
        return new BTreeFilerHeader(pageCount, pageSize);
    }

    public Paged.PageHeader createPageHeader() {
        return new BTreeFilerPageHeader();
    }

    private final class BTreeFilerPageHeader
    extends BTree.BTreePageHeader {
        private long created = 0L;
        private long modified = 0L;
        private long lifetime = 0L;
        private long expiration = 0L;

        public BTreeFilerPageHeader() {
            super(BTreeFiler.this);
        }

        public BTreeFilerPageHeader(DataInputStream dis) throws IOException {
            super(BTreeFiler.this, dis);
        }

        public synchronized void read(DataInputStream dis) throws IOException {
            super.read(dis);
            if (this.getStatus() == 0) {
                return;
            }
            this.created = dis.readLong();
            this.modified = dis.readLong();
            this.lifetime = dis.readLong();
            this.expiration = dis.readLong();
        }

        public synchronized void write(DataOutputStream dos) throws IOException {
            super.write(dos);
            dos.writeLong(this.created);
            dos.writeLong(this.modified);
            dos.writeLong(this.lifetime);
            dos.writeLong(this.expiration);
        }

        public synchronized void setRecordLen(int recordLen) {
            BTreeFiler.this.fileHeader.setTotalBytes(BTreeFiler.this.fileHeader.totalBytes - (long)this.getRecordLen() + (long)recordLen);
            super.setRecordLen(recordLen);
        }

        public synchronized void setCreated(long created) {
            this.created = created;
            this.setDirty();
        }

        public synchronized long getCreated() {
            return this.created;
        }

        public synchronized void setModified(long modified) {
            this.modified = modified;
            this.setDirty();
        }

        public synchronized long getModified() {
            return this.modified;
        }

        public synchronized void setLifetime(long lifetime) {
            this.lifetime = lifetime;
            this.setDirty();
        }

        public synchronized long getLifetime() {
            return this.lifetime;
        }

        public synchronized void setExpiration(long expiration) {
            this.expiration = expiration;
            this.setDirty();
        }

        public synchronized long getExpiration() {
            return this.expiration;
        }
    }

    private final class BTreeFilerHeader
    extends BTree.BTreeFileHeader {
        private long totalBytes = 0L;

        public BTreeFilerHeader() {
            super(BTreeFiler.this);
        }

        public BTreeFilerHeader(long pageCount) {
            super((BTree)BTreeFiler.this, pageCount);
        }

        public BTreeFilerHeader(long pageCount, int pageSize) {
            super(BTreeFiler.this, pageCount, pageSize);
        }

        public BTreeFilerHeader(boolean read) throws IOException {
            super((BTree)BTreeFiler.this, read);
        }

        public synchronized void read(RandomAccessFile raf) throws IOException {
            super.read(raf);
            this.totalBytes = raf.readLong();
        }

        public synchronized void write(RandomAccessFile raf) throws IOException {
            super.write(raf);
            raf.writeLong(this.totalBytes);
        }

        public synchronized void setTotalBytes(long totalBytes) {
            this.totalBytes = totalBytes;
            this.setDirty();
        }

        public synchronized long getTotalBytes() {
            return this.totalBytes;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BTreeFilerRecordSet
    implements RecordSet,
    BTreeCallback {
        private List keys = new ArrayList();
        private Iterator enum;

        public BTreeFilerRecordSet() throws DBException {
            try {
                BTreeFiler.this.query(null, this);
                this.enum = this.keys.iterator();
            }
            catch (IOException e) {
                throw new FilerException(70, "Error generating RecordSet", e);
            }
        }

        public synchronized boolean indexInfo(Value value, long pointer) {
            this.keys.add(new Key(value));
            return true;
        }

        public synchronized Key getNextKey() {
            return (Key)this.enum.next();
        }

        public synchronized Record getNextRecord() throws DBException {
            return BTreeFiler.this.readRecord((Key)this.enum.next());
        }

        public synchronized Value getNextValue() throws DBException {
            return this.getNextRecord().getValue();
        }

        public synchronized boolean hasMoreRecords() {
            return this.enum.hasNext();
        }
    }
}

