/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.meter;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.exception.JxtaException;
import net.jxta.platform.ModuleClassID;
import net.jxta.util.JxtaUtilities;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class PeerMonitorInfo
implements DocumentSerializable {
    public static final PeerMonitorInfo NO_PEER_MONITOR_INFO = new PeerMonitorInfo(false, null, null, 0L, 0L);
    private boolean allowsMonitoring;
    private ModuleClassID[] moduleClassIDs;
    private long[] reportRates;
    private long lastResetTime;
    private long runningTime;

    public PeerMonitorInfo() {
    }

    public PeerMonitorInfo(boolean allowsMonitoring, ModuleClassID[] moduleClassIDs, long[] reportRates, long lastResetTime, long runningTime) {
        this.allowsMonitoring = allowsMonitoring;
        this.moduleClassIDs = moduleClassIDs;
        this.reportRates = reportRates;
        this.lastResetTime = lastResetTime;
        this.runningTime = runningTime;
    }

    public boolean allowsMonitoring() {
        return this.allowsMonitoring;
    }

    public long[] getReportRates() {
        return this.reportRates;
    }

    public ModuleClassID[] getModuleClassIDs() {
        return this.moduleClassIDs;
    }

    public long getLastResetTime() {
        return this.lastResetTime;
    }

    public long getRunningTime() {
        return this.runningTime;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addBoolean(element2, "allowsMonitoring", this.allowsMonitoring);
        DocumentSerializableUtilities.addLong(element2, "lastResetTime", this.lastResetTime);
        DocumentSerializableUtilities.addLong(element2, "runningTime", this.runningTime);
        if (this.allowsMonitoring) {
            DocumentSerializableUtilities.addInt(element2, "numModuleClassIDs", this.moduleClassIDs.length);
            int i = 0;
            while (i < this.moduleClassIDs.length) {
                ModuleClassID moduleClassID = this.moduleClassIDs[i];
                DocumentSerializableUtilities.addString(element2, "moduleClassID", moduleClassID.toString());
                ++i;
            }
            DocumentSerializableUtilities.addInt(element2, "numReportRates", this.reportRates.length);
            int i2 = 0;
            while (i2 < this.reportRates.length) {
                long reportRate = this.reportRates[i2];
                DocumentSerializableUtilities.addLong(element2, "reportRate", reportRate);
                ++i2;
            }
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        int numModuleClassIDs = DocumentSerializableUtilities.getInt(element2, "numModuleClassIDs", 0);
        this.moduleClassIDs = new ModuleClassID[numModuleClassIDs];
        int moduleClassIDIndex = 0;
        int numReportRates = DocumentSerializableUtilities.getInt(element2, "numReportRates", 0);
        this.reportRates = new long[numReportRates];
        int reportRateIndex = 0;
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            Element childElement = (Element)e.nextElement();
            String key = (String)childElement.getKey();
            if (key.equals("allowsMonitoring")) {
                this.allowsMonitoring = DocumentSerializableUtilities.getBoolean(childElement);
                continue;
            }
            if (key.equals("lastResetTime")) {
                this.lastResetTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (key.equals("runningTime")) {
                this.runningTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (key.equals("reportRate")) {
                long reportRate;
                this.reportRates[reportRateIndex] = reportRate = DocumentSerializableUtilities.getLong(childElement);
                ++reportRateIndex;
                continue;
            }
            if (!key.equals("moduleClassID")) continue;
            try {
                ModuleClassID moduleClassID;
                this.moduleClassIDs[moduleClassIDIndex] = moduleClassID = (ModuleClassID)JxtaUtilities.getIdFromString(DocumentSerializableUtilities.getString(childElement));
                ++moduleClassIDIndex;
            }
            catch (JxtaException jex) {
                throw new DocumentSerializationException("Can't get ModuleClassID", jex);
            }
        }
    }
}

