/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.peergroup;

import java.io.FileInputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import net.jxta.exception.JxtaError;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.IDFactory;
import net.jxta.impl.config.Config;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PeerGroupFactory {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$peergroup$PeerGroupFactory == null ? (class$net$jxta$peergroup$PeerGroupFactory = PeerGroupFactory.class$("net.jxta.peergroup.PeerGroupFactory")) : class$net$jxta$peergroup$PeerGroupFactory).getName());
    private static Class stdPeerGroupClass = null;
    private static Class platformClass = null;
    private static PeerGroupID netPGID = null;
    private static String netPGName = null;
    private static String netPGDesc = null;
    private static Class configurator = null;
    static /* synthetic */ Class class$net$jxta$peergroup$PeerGroupFactory;
    static /* synthetic */ Class class$net$jxta$peergroup$Configurator;

    public static void setStdPeerGroupClass(Class c) {
        stdPeerGroupClass = c;
    }

    public static void setPlatformClass(Class c) {
        platformClass = c;
    }

    public static void setNetPGDesc(String desc) {
        netPGDesc = desc;
    }

    public static void setNetPGName(String name) {
        netPGName = name;
    }

    public static void setNetPGID(PeerGroupID id) {
        netPGID = id;
    }

    public static Class getConfiguratorClass() {
        return configurator;
    }

    public static void setConfiguratorClass(Class c) {
        configurator = c;
    }

    public static PeerGroup newPeerGroup() {
        try {
            return (PeerGroup)stdPeerGroupClass.newInstance();
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"newInstace failed : ", (Throwable)e);
            }
            throw new JxtaError("No valid Standard PeerGroup class" + e);
        }
    }

    public static PeerGroup newPlatform() {
        PeerGroup plat = null;
        try {
            plat = (PeerGroup)platformClass.newInstance();
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                LOG.fatal((Object)"newInstace failed : ", (Throwable)e);
            }
            throw new JxtaError("No valid Platform class : " + e);
        }
        try {
            plat.init(null, PeerGroupID.worldPeerGroupID, null);
            return (PeerGroup)plat.getInterface();
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                LOG.fatal((Object)"Platform.init failed : ", e);
            }
            throw new JxtaError("Platform.init failed : " + e.toString());
        }
    }

    public static PeerGroup newNetPeerGroup(PeerGroup pg) throws PeerGroupException {
        try {
            PeerGroup newPg = pg.newGroup(netPGID, pg.getAllPurposePeerGroupImplAdvertisement(), netPGName, netPGDesc);
            return newPg;
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"newNetPeerGroup failed : ", e);
            }
            throw new PeerGroupException("newNetPeerGroup failed : " + e.toString());
        }
    }

    public static PeerGroup newNetPeerGroup() throws PeerGroupException {
        PeerGroup platformGroup = PeerGroupFactory.newPlatform();
        PeerGroup npg = PeerGroupFactory.newNetPeerGroup(platformGroup);
        platformGroup.unref();
        return npg;
    }

    private PeerGroupFactory() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String configurator = "net.jxta.impl.peergroup.DefaultConfigurator";
        try {
            String platformPGClassName = "net.jxta.impl.peergroup.Platform";
            String stdPGClassName = "net.jxta.impl.peergroup.StdPeerGroup";
            PeerGroupID netPGID = PeerGroupID.defaultNetPeerGroupID;
            String netPGName = "NetPeerGroup";
            String netPGDesc = "NetPeerGroup by default";
            try {
                ResourceBundle rsrcs = ResourceBundle.getBundle("net.jxta.impl.config");
                try {
                    platformPGClassName = rsrcs.getString("PlatformPeerGroupClassName").trim();
                }
                catch (Exception fine) {
                    // empty catch block
                }
                try {
                    stdPGClassName = rsrcs.getString("StdPeerGroupClassName").trim();
                }
                catch (Exception fine2) {
                    // empty catch block
                }
                try {
                    configurator = rsrcs.getString("ConfiguratorClassName").trim();
                }
                catch (Exception e) {
                    // empty catch block
                }
                PeerGroupID idTmp = (PeerGroupID)IDFactory.fromURL(IDFactory.jxtaURL("urn", "", rsrcs.getString("NetPeerGroupID").trim()));
                String nameTmp = rsrcs.getString("NetPeerGroupName").trim();
                String descTmp = rsrcs.getString("NetPeerGroupDesc").trim();
                netPGID = idTmp;
                netPGName = nameTmp;
                netPGDesc = descTmp;
            }
            catch (Exception nevermind) {
                // empty catch block
            }
            try {
                String propertiesName = Config.JXTA_HOME + "config.properties";
                PropertyResourceBundle rsrcs = new PropertyResourceBundle(new FileInputStream(propertiesName));
                try {
                    platformPGClassName = rsrcs.getString("PlatformPeerGroupClassName").trim();
                }
                catch (Exception fine) {
                    // empty catch block
                }
                try {
                    stdPGClassName = rsrcs.getString("StdPeerGroupClassName").trim();
                }
                catch (Exception fine2) {
                    // empty catch block
                }
                try {
                    configurator = rsrcs.getString("ConfiguratorClassName").trim();
                }
                catch (Exception e) {
                    // empty catch block
                }
                PeerGroupID idTmp = (PeerGroupID)IDFactory.fromURL(IDFactory.jxtaURL("urn", "", rsrcs.getString("NetPeerGroupID").trim()));
                String nameTmp = rsrcs.getString("NetPeerGroupName").trim();
                String descTmp = rsrcs.getString("NetPeerGroupDesc").trim();
                netPGID = idTmp;
                netPGName = nameTmp;
                netPGDesc = descTmp;
            }
            catch (Exception nevermind) {
                // empty catch block
            }
            PeerGroupFactory.setPlatformClass(Class.forName(platformPGClassName));
            PeerGroupFactory.setStdPeerGroupClass(Class.forName(stdPGClassName));
            PeerGroupFactory.setNetPGID(netPGID);
            PeerGroupFactory.setNetPGName(netPGName);
            PeerGroupFactory.setNetPGDesc(netPGDesc);
        }
        catch (Throwable e) {
            LOG.fatal((Object)"Could not initialize platform and standard peer group classes", e);
            System.exit(1);
        }
        Class<?> c = null;
        try {
            c = Class.forName(configurator);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (c != null && (class$net$jxta$peergroup$Configurator == null ? (class$net$jxta$peergroup$Configurator = PeerGroupFactory.class$("net.jxta.peergroup.Configurator")) : class$net$jxta$peergroup$Configurator).isAssignableFrom(c)) {
            PeerGroupFactory.setConfiguratorClass(c);
        }
    }
}

