/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.io.ByteArrayInputStream;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.RouteAdvertisement;

public abstract class RdvAdvertisement
extends ExtendableAdvertisement {
    public static final String NameTag = "Name";
    public static final String PeerIDTag = "RdvPeerId";
    public static final String GroupIDTag = "RdvGroupId";
    public static final String ServiceNameTag = "RdvServiceName";
    public static final String RouteTag = "RdvRoute";
    private String name = null;
    private PeerGroupID groupId = null;
    private PeerID peerId = null;
    private String serviceName = null;
    private RouteAdvertisement route = null;
    private ID hashID = null;

    public static String getAdvertisementType() {
        return "jxta:RdvAdvertisement";
    }

    public final String getBaseAdvType() {
        return RdvAdvertisement.getAdvertisementType();
    }

    public PeerGroupID getGroupID() {
        return this.groupId;
    }

    public void setGroupID(PeerGroupID id) {
        this.groupId = id;
    }

    public PeerID getPeerID() {
        return this.peerId;
    }

    public void setPeerID(PeerID id) {
        this.peerId = id;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String n) {
        this.serviceName = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public RouteAdvertisement getRouteAdv() {
        return this.route;
    }

    public void setRouteAdv(RouteAdvertisement route) {
        this.route = route;
    }

    public synchronized ID getID() {
        if (this.groupId == null) {
            throw new IllegalStateException("cannot build ID: no group id");
        }
        if (this.peerId == null) {
            throw new IllegalStateException("cannot build ID: no peer id");
        }
        if (this.serviceName == null) {
            throw new IllegalStateException("cannot build ID: no Service Name");
        }
        if (this.hashID == null) {
            try {
                String seed = RdvAdvertisement.getAdvertisementType() + this.groupId.toString() + this.serviceName + this.peerId.toString();
                ByteArrayInputStream in = new ByteArrayInputStream(seed.getBytes());
                this.hashID = IDFactory.newCodatID(this.groupId, seed.getBytes(), in);
            }
            catch (Exception ez) {
                throw new IllegalStateException("cannot build ID: " + ez.toString());
            }
        }
        return this.hashID;
    }
}

