/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.AccessPointAdvertisement;

public abstract class RouteAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private PeerID destPeer = null;
    private AccessPointAdvertisement dest = null;
    private Vector hops = new Vector();
    private ID hashID = null;

    public Object clone() {
        RouteAdvertisement a;
        try {
            a = (RouteAdvertisement)super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
        int size = this.hops.size();
        a.hops = new Vector(size);
        int i = 0;
        while (i < size) {
            a.hops.add(((AccessPointAdvertisement)this.hops.get(i)).clone());
            ++i;
        }
        return a;
    }

    public Object cloneOnlyPIDs() {
        RouteAdvertisement a;
        try {
            a = (RouteAdvertisement)super.clone();
            a.setDestEndpointAddresses(new Vector());
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
        int size = this.hops.size();
        a.hops = new Vector(size);
        int i = 0;
        while (i < size) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)((AccessPointAdvertisement)this.hops.get(i)).clone();
            ap.setEndpointAddresses(new Vector());
            a.hops.add(ap);
            ++i;
        }
        return a;
    }

    public static final String getAdvertisementType() {
        return "jxta:RA";
    }

    public final String getBaseAdvType() {
        return RouteAdvertisement.getAdvertisementType();
    }

    public synchronized ID getID() {
        if (this.hashID == null) {
            try {
                PeerID pid = this.dest.getPeerID();
                byte[] seed = RouteAdvertisement.getAdvertisementType().getBytes();
                ByteArrayInputStream in = new ByteArrayInputStream(pid.toString().getBytes());
                this.hashID = IDFactory.newCodatID((PeerGroupID)pid.getPeerGroupID(), seed, in);
            }
            catch (Exception ez) {
                return ID.nullID;
            }
        }
        return this.hashID;
    }

    public AccessPointAdvertisement getDest() {
        return this.dest;
    }

    public void setDest(AccessPointAdvertisement ap) {
        this.dest = ap;
        if (null != this.dest.getPeerID()) {
            this.setDestPeerID(this.dest.getPeerID());
        }
    }

    public Enumeration getHops() {
        return this.hops.elements();
    }

    public Vector getVectorHops() {
        return this.hops;
    }

    public void setHops(Vector hopsAccess) {
        this.hops = hopsAccess != null ? hopsAccess : new Vector();
    }

    public void addDestEndpointAddresses(Vector addresses) {
        this.dest.addEndpointAddresses(addresses);
    }

    public void removeDestEndpointAddresses(Vector addresses) {
        this.dest.removeEndpointAddresses(addresses);
    }

    public AccessPointAdvertisement getFirstHop() {
        if (this.hops == null || this.hops.isEmpty()) {
            return null;
        }
        return (AccessPointAdvertisement)this.hops.firstElement();
    }

    public void setFirstHop(AccessPointAdvertisement ap) {
        this.hops.add(0, ap);
    }

    public AccessPointAdvertisement getLastHop() {
        if (this.hops == null || this.hops.isEmpty()) {
            return null;
        }
        return (AccessPointAdvertisement)this.hops.lastElement();
    }

    public void setLastHop(AccessPointAdvertisement ap) {
        this.hops.addElement(ap);
    }

    public PeerID getDestPeerID() {
        return this.destPeer;
    }

    public void setDestPeerID(PeerID pid) {
        this.destPeer = pid;
        if (null != this.dest) {
            this.dest.setPeerID(pid);
        }
    }

    public void setDestEndpointAddresses(Vector ea) {
        this.dest.setEndpointAddresses(ea);
    }

    public Vector getDestEndpointAddresses() {
        return this.dest.getVectorEndpointAddresses();
    }

    public boolean containsHop(PeerID pid) {
        Enumeration e = this.hops.elements();
        while (e.hasMoreElements()) {
            AccessPointAdvertisement hop = (AccessPointAdvertisement)e.nextElement();
            PeerID hid = hop.getPeerID();
            if (hid == null || !pid.equals(hid)) continue;
            return true;
        }
        return false;
    }

    public boolean hasALoop() {
        Vector<PeerID> peers = new Vector<PeerID>();
        int i = 0;
        while (i < this.hops.size()) {
            try {
                PeerID pid = ((AccessPointAdvertisement)this.hops.elementAt(i)).getPeerID();
                if (pid == null) {
                    return true;
                }
                if (peers.contains(pid)) {
                    return true;
                }
                peers.add(pid);
            }
            catch (Exception ez1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int size() {
        return this.hops.size();
    }

    public AccessPointAdvertisement nextHop(PeerID pid) {
        AccessPointAdvertisement nextHop = null;
        if (this.hops == null || this.hops.size() == 0) {
            return null;
        }
        int index = 0;
        boolean found = false;
        Enumeration e = this.hops.elements();
        while (e.hasMoreElements()) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)e.nextElement();
            if (pid.toString().equals(ap.getPeerID().toString())) {
                found = true;
                break;
            }
            ++index;
        }
        if (!found) {
            try {
                nextHop = (AccessPointAdvertisement)this.hops.elementAt(0);
            }
            catch (Exception ez1) {
                return null;
            }
            return nextHop;
        }
        try {
            nextHop = (AccessPointAdvertisement)this.hops.elementAt(index + 1);
        }
        catch (Exception ez1) {
            return null;
        }
        return nextHop;
    }

    public String display() {
        StringBuffer routeBuf = new StringBuffer();
        routeBuf.append("Route to PID=");
        PeerID peerId = this.getDest().getPeerID();
        if (peerId == null) {
            routeBuf.append("Null Destination");
        } else {
            routeBuf.append(peerId.toString());
        }
        Enumeration e = this.getDest().getEndpointAddresses();
        while (e.hasMoreElements()) {
            try {
                routeBuf.append("\n Addr=" + (String)e.nextElement());
            }
            catch (ClassCastException ex) {
                routeBuf.append("\n Addr=bad address");
            }
        }
        int i = 1;
        Enumeration e2 = this.getHops();
        while (e2.hasMoreElements()) {
            if (i == 1) {
                routeBuf.append("\n Gateways = ");
            }
            if ((peerId = ((AccessPointAdvertisement)e2.nextElement()).getPeerID()) == null) {
                routeBuf.append("Null Hop");
                continue;
            }
            routeBuf.append("\n\t[" + i++ + "] " + peerId.toString());
        }
        return routeBuf.toString();
    }

    public boolean removeHop(PeerID pid) {
        Vector<AccessPointAdvertisement> newHops = new Vector<AccessPointAdvertisement>();
        Enumeration e = this.hops.elements();
        while (e.hasMoreElements()) {
            AccessPointAdvertisement hop = (AccessPointAdvertisement)e.nextElement();
            PeerID hid = hop.getPeerID();
            if (hid != null && pid.toString().equals(hid.toString())) continue;
            newHops.add(hop);
        }
        this.setHops(newHops);
        return true;
    }

    public AccessPointAdvertisement getHop(PeerID pid) {
        Enumeration e = this.hops.elements();
        while (e.hasMoreElements()) {
            AccessPointAdvertisement hop = (AccessPointAdvertisement)e.nextElement();
            PeerID hid = hop.getPeerID();
            if (hid == null || !pid.toString().equals(hid.toString())) continue;
            return (AccessPointAdvertisement)hop.clone();
        }
        return null;
    }

    public void replaceHop(AccessPointAdvertisement ap) {
        int index = 0;
        Enumeration e = this.hops.elements();
        while (e.hasMoreElements()) {
            AccessPointAdvertisement hop = (AccessPointAdvertisement)e.nextElement();
            PeerID hid = hop.getPeerID();
            if (hid == null || !ap.getPeerID().toString().equals(hid.toString())) continue;
            this.hops.setElementAt(ap, index);
            return;
        }
    }

    public void addEndpointAddressToHop(PeerID pid, EndpointAddress addr) {
        Vector<String> ea = new Vector<String>();
        ea.add(addr.toString());
        AccessPointAdvertisement oldHop = this.getHop(pid);
        if (oldHop != null && !oldHop.contains(addr)) {
            oldHop.addEndpointAddresses(ea);
            this.replaceHop(oldHop);
        }
    }

    public void removeEndpointAddressToHop(PeerID pid, EndpointAddress addr) {
        Vector<String> ea = new Vector<String>();
        ea.add(addr.toString());
        AccessPointAdvertisement oldHop = this.getHop(pid);
        if (oldHop != null && !oldHop.contains(addr)) {
            oldHop.removeEndpointAddresses(ea);
            if (oldHop.size() > 0) {
                this.replaceHop(oldHop);
            } else {
                this.removeHop(pid);
            }
        }
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target == null) {
            return false;
        }
        RouteAdvertisement route = null;
        try {
            route = (RouteAdvertisement)target;
        }
        catch (ClassCastException cce) {
            return false;
        }
        if (this.dest == null && route.getDest() == null) {
            return true;
        }
        if (this.dest == null || route.getDest() == null) {
            return false;
        }
        if (!this.dest.equals(route.getDest())) {
            return false;
        }
        if (this.hops.size() != route.size()) {
            return false;
        }
        int index = 0;
        Enumeration e = route.getHops();
        while (e.hasMoreElements()) {
            AccessPointAdvertisement hop = (AccessPointAdvertisement)e.nextElement();
            if (hop.equals((AccessPointAdvertisement)this.hops.elementAt(index++))) continue;
            return false;
        }
        return true;
    }

    public AccessPointAdvertisement getHop(int index) {
        if (index < 0) {
            return null;
        }
        if (index > this.hops.size() - 1) {
            return null;
        }
        return (AccessPointAdvertisement)((AccessPointAdvertisement)this.hops.elementAt(index)).clone();
    }

    public static RouteAdvertisement newRoute(PeerID destPid, PeerID firsthop, Vector hops) {
        RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
        if (destPid == null) {
            return null;
        }
        ap.setPeerID(destPid);
        route.setDest(ap);
        Enumeration e = hops.elements();
        while (e.hasMoreElements()) {
            ap = (AccessPointAdvertisement)e.nextElement();
            if (ap.getPeerID() != null) continue;
            return null;
        }
        route.setHops(hops);
        if (!(firsthop == null || (ap = route.getFirstHop()) != null && ap.getPeerID().equals(firsthop))) {
            ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(firsthop);
            route.setFirstHop(ap);
        }
        return route;
    }

    public static RouteAdvertisement newRoute(PeerID destPid, Vector hops) {
        return RouteAdvertisement.newRoute(destPid, null, hops);
    }

    public static boolean stichRoute(RouteAdvertisement newRoute, RouteAdvertisement firstLeg) {
        return RouteAdvertisement.stichRoute(newRoute, firstLeg, null);
    }

    public static boolean stichRoute(RouteAdvertisement newRoute, RouteAdvertisement firstLeg, PeerID localPeer) {
        if (newRoute.hasALoop()) {
            return false;
        }
        Vector hops = newRoute.getVectorHops();
        hops.ensureCapacity(firstLeg.getVectorHops().size() + 1 + hops.size());
        PeerID routerPid = firstLeg.getDest().getPeerID();
        if (newRoute.size() == 0 || !newRoute.getFirstHop().getPeerID().equals(routerPid)) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(routerPid);
            hops.add(0, ap);
        }
        hops.addAll(0, firstLeg.getVectorHops());
        RouteAdvertisement.cleanupLoop(newRoute, localPeer);
        return true;
    }

    public static void cleanupLoop(RouteAdvertisement route, PeerID localPeer) {
        int j;
        Vector hops = route.getVectorHops();
        Vector newHops = new Vector(hops.size());
        Object lastHop = null;
        if (hops.size() > 0) {
            lastHop = hops.elementAt(hops.size() - 1);
        }
        hops = ((RouteAdvertisement)route.cloneOnlyPIDs()).getVectorHops();
        int i = 0;
        while (i < hops.size()) {
            int loopAt = newHops.indexOf(hops.elementAt(i));
            if (loopAt != -1) {
                j = newHops.size();
                while (--j > loopAt) {
                    newHops.remove(j);
                }
            } else {
                newHops.add(hops.elementAt(i));
            }
            ++i;
        }
        if (localPeer != null) {
            int i2 = newHops.size();
            while (--i2 >= 0) {
                if (!localPeer.equals(((AccessPointAdvertisement)newHops.elementAt(i2)).getPeerID())) continue;
                j = 0;
                while (j <= i2) {
                    newHops.remove(0);
                    ++j;
                }
                break block2;
            }
        }
        if (lastHop != null && newHops.size() > 0) {
            newHops.setElementAt(lastHop, newHops.size() - 1);
        }
        route.setHops(newHops);
    }
}

