/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Enumeration;
import net.jxta.credential.Credential;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.InputStreamMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.impl.util.pipe.reliable.Defs;
import net.jxta.impl.util.pipe.reliable.OutgoingMsgrAdaptor;
import net.jxta.impl.util.pipe.reliable.ReliableInputStream;
import net.jxta.impl.util.pipe.reliable.ReliableOutputStream;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.socket.JxtaServerSocket;
import net.jxta.socket.JxtaSocketInputStream;
import net.jxta.socket.JxtaSocketOutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JxtaSocket
implements PipeMsgListener,
OutputPipeListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$socket$JxtaSocket == null ? (class$net$jxta$socket$JxtaSocket = JxtaSocket.class$("net.jxta.socket.JxtaSocket")) : class$net$jxta$socket$JxtaSocket).getName());
    protected PeerGroup group;
    protected PipeAdvertisement pipeAdv;
    protected PipeAdvertisement myPipeAdv;
    protected PipeService pipeSvc;
    protected PeerID peerid;
    protected InputPipe in;
    protected OutputPipe connectOutpipe;
    protected Messenger msgr;
    protected InputStream stream;
    protected int timeout = 60000;
    protected String closeLock = new String("closeLock");
    protected String acceptLock = new String("acceptLock");
    protected String instrLock = new String("instrLock");
    protected String finalLock = new String("finalLock");
    protected boolean closed = false;
    protected boolean bound = false;
    protected UnbiasedQueue queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue());
    protected Credential credential = null;
    protected StructuredDocument credentialDoc = null;
    protected boolean isStream = false;
    protected OutgoingMsgrAdaptor outgoing = null;
    protected ReliableInputStream ris = null;
    protected ReliableOutputStream ros = null;
    protected boolean waiting;
    private int outputBufferSize = 16384;
    private boolean osCreated = false;
    private InputStream currentMsgStream = null;
    static /* synthetic */ Class class$net$jxta$socket$JxtaSocket;

    public JxtaSocket() {
    }

    protected JxtaSocket(PeerGroup group, Messenger msgr, PipeAdvertisement pipe, boolean isStream) throws IOException {
        if (msgr == null) {
            throw new IOException("Null Messenger");
        }
        this.group = group;
        this.pipeAdv = pipe;
        this.pipeSvc = group.getPipeService();
        this.credentialDoc = JxtaSocket.getCredDoc(group);
        this.in = this.pipeSvc.createInputPipe(pipe, this);
        this.msgr = msgr;
        this.isStream = isStream;
        if (isStream) {
            this.createRis();
        }
        this.setBound();
    }

    public JxtaSocket(PeerGroup group, PipeAdvertisement pipeAd) throws IOException {
        this.group = group;
        this.pipeAdv = pipeAd;
        this.connect(group, pipeAd);
    }

    public JxtaSocket(PeerGroup group, PipeAdvertisement pipeAd, int timeout) throws IOException {
        this.group = group;
        this.pipeAdv = pipeAd;
        this.timeout = timeout;
        this.connect(group, pipeAd, timeout);
    }

    public JxtaSocket(PeerGroup group, PeerID peerid, PipeAdvertisement pipeAd, int timeout) throws IOException {
        this.group = group;
        this.pipeAdv = pipeAd;
        this.timeout = timeout;
        this.connect(group, peerid, pipeAd, timeout);
    }

    public JxtaSocket(PeerGroup group, PeerID peerid, PipeAdvertisement pipeAd, int timeout, boolean stream) throws IOException {
        this.group = group;
        this.pipeAdv = pipeAd;
        this.timeout = timeout;
        this.isStream = stream;
        this.connect(group, peerid, pipeAd, timeout);
    }

    public void create(boolean stream) throws IOException {
        if (this.isBound()) {
            throw new IOException("Socket already connected, it is not possible to change connection type");
        }
        this.isStream = stream;
    }

    public void connect(PeerGroup group, PipeAdvertisement pipeAd) throws IOException {
        this.connect(group, pipeAd, this.timeout);
    }

    public void connect(PeerGroup group, PipeAdvertisement pipeAd, int timeout) throws IOException {
        this.connect(group, null, pipeAd, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(PeerGroup group, PeerID peerid, PipeAdvertisement pipeAd, int timeout) throws IOException {
        block19: {
            this.group = group;
            this.pipeAdv = pipeAd;
            this.timeout = timeout;
            this.pipeSvc = group.getPipeService();
            this.myPipeAdv = JxtaServerSocket.newInputPipe(group, pipeAd);
            this.in = this.pipeSvc.createInputPipe(this.myPipeAdv, this);
            this.peerid = peerid;
            this.credentialDoc = JxtaSocket.getCredDoc(group);
            Message openMsg = this.createOpenMessage(group, this.myPipeAdv);
            long delay = 2000L;
            if (peerid == null) {
                this.pipeSvc.createOutputPipe(pipeAd, this);
            } else {
                this.pipeSvc.createOutputPipe(pipeAd, peerid, (OutputPipeListener)this);
            }
            while (true) {
                try {
                    String string = this.acceptLock;
                    synchronized (string) {
                        if (this.connectOutpipe != null) {
                            break;
                        }
                        if (delay >= (long)timeout) {
                            delay = timeout;
                        }
                        if (delay < 0L) {
                            break;
                        }
                        this.acceptLock.wait(delay);
                        timeout = (int)((long)timeout - delay);
                        if (timeout <= 0) {
                            break;
                        }
                        delay *= 2L;
                        continue;
                    }
                }
                catch (InterruptedException ie) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)"Interrupted", (Throwable)ie);
                    continue;
                }
                break;
            }
            if (this.connectOutpipe == null) {
                throw new IOException("connection timeout");
            }
            this.waiting = true;
            this.connectOutpipe.send(openMsg);
            try {
                String ie = this.finalLock;
                synchronized (ie) {
                    if (this.waiting) {
                        this.finalLock.wait(timeout);
                    }
                }
            }
            catch (InterruptedException ie) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block19;
                LOG.debug((Object)"Interrupted", (Throwable)ie);
            }
        }
        this.setBound();
    }

    protected static StructuredDocument getCredDoc(PeerGroup group) {
        block3: {
            try {
                MembershipService membership = group.getMembershipService();
                Enumeration enumeration = membership.getCurrentCredentials();
                if (enumeration.hasMoreElements()) {
                    Credential credential = (Credential)enumeration.nextElement();
                    return credential.getDocument(MimeMediaType.XMLUTF8);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"failed to get credential", (Throwable)e);
            }
        }
        return null;
    }

    protected Message createOpenMessage(PeerGroup group, PipeAdvertisement pipeAd) {
        Message msg = new Message();
        PeerAdvertisement peerAdv = group.getPeerAdvertisement();
        StructuredDocument credDoc = JxtaSocket.getCredDoc(group);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Requesting connection [isStream] :" + this.isStream));
        }
        try {
            msg.addMessageElement("JXTASOC", new InputStreamMessageElement("Cred", MimeMediaType.XMLUTF8, credDoc.getStream(), null));
            msg.addMessageElement("JXTASOC", new InputStreamMessageElement("reqPipe", MimeMediaType.XMLUTF8, pipeAd.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
            String streamStr = this.isStream ? "true" : "false";
            msg.addMessageElement("JXTASOC", new StringMessageElement("stream", streamStr, null));
            msg.addMessageElement("JXTASOC", new InputStreamMessageElement("remPeer", MimeMediaType.XMLUTF8, peerAdv.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
            return msg;
        }
        catch (Throwable t) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"error getting element stream", t);
            }
            return null;
        }
    }

    public void listen(int backlog) throws IOException {
        this.queue.setMaxQueueSize(backlog);
    }

    private void setBound() {
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    private void createRis() {
        if (this.outgoing == null) {
            this.outgoing = new OutgoingMsgrAdaptor(this.msgr, this.timeout);
        }
        if (this.ris == null) {
            this.ris = new ReliableInputStream(this.outgoing);
        }
    }

    public synchronized int getOutputStreamBufferSize() {
        return this.outputBufferSize;
    }

    public synchronized void setOutputStreamBufferSize(int size) throws IOException {
        if (this.osCreated) {
            throw new IOException("Can not reset buffersize, OutputStream is already created");
        }
        this.outputBufferSize = size;
    }

    public InputStream getInputStream() throws IOException {
        this.checkState();
        if (this.isStream) {
            if (this.outgoing == null) {
                this.outgoing = new OutgoingMsgrAdaptor(this.msgr, this.timeout);
            }
            if (this.ris == null) {
                throw new IOException("Reliable stream not initialized");
            }
        }
        return new JxtaSocketInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkState();
        if (this.isStream) {
            if (this.outgoing == null) {
                this.outgoing = new OutgoingMsgrAdaptor(this.msgr, this.timeout);
            }
            if (this.ros == null) {
                this.ros = new ReliableOutputStream(this.outgoing);
            }
        }
        this.osCreated = true;
        return new JxtaSocketOutputStream(this, this.outputBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        String string = this.closeLock;
        synchronized (string) {
            if (this.closed) {
                return;
            }
            this.bound = false;
            this.closed = true;
        }
        if (this.isStream) {
            long quitAt = System.currentTimeMillis() + (long)this.timeout;
            while (this.ros != null) {
                this.ros.setClosing();
                if (this.ros.getMaxAck() == this.ros.getSeqNumber()) break;
                long left = 0L;
                if (this.timeout != 0 && (left = quitAt - System.currentTimeMillis()) < 0L) {
                    this.sendClose();
                    this.closeCommon();
                    throw new IOException("Close timeout");
                }
                try {
                    this.ros.waitQueueEvent(left);
                }
                catch (InterruptedException ie) {
                    throw new IOException("Close interrupted");
                }
            }
            this.ris.close();
        }
        this.sendClose();
        this.closeCommon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFromRemote() throws IOException {
        String string = this.closeLock;
        synchronized (string) {
            if (this.closed) {
                return;
            }
            this.bound = false;
            this.closed = true;
        }
        this.closeCommon();
    }

    protected void closeCommon() throws IOException {
        if (this.isStream) {
            if (this.ros != null) {
                this.ros.close();
            }
            if (this.ris != null) {
                this.ris.setClosing();
            }
        }
        this.in.close();
        this.msgr.close();
        this.queue.close();
        this.in = null;
        this.msgr = null;
    }

    protected void setInputPipe(InputPipe in) {
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeMsgEvent(PipeMsgEvent event) {
        Object CredDoc;
        MessageElement element2;
        Message message;
        block30: {
            block29: {
                message = event.getMessage();
                if (message == null) {
                    return;
                }
                element2 = message.getMessageElement("JXTASOC", "remPipe");
                if (element2 != null) {
                    try {
                        PeerAdvertisement peerAdv = null;
                        CredDoc = null;
                        InputStream in = element2.getStream();
                        PipeAdvertisement pa = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(element2.getMimeType(), in);
                        element2 = message.getMessageElement("JXTASOC", "remPeer");
                        if (element2 == null) {
                            return;
                        }
                        in = element2.getStream();
                        peerAdv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(element2.getMimeType(), in);
                        element2 = message.getMessageElement("JXTASOC", "Cred");
                        if (element2 != null) {
                            in = element2.getStream();
                            CredDoc = StructuredDocumentFactory.newStructuredDocument(element2.getMimeType(), in);
                        }
                        if (!this.checkCred((StructuredDocument)CredDoc) && LOG.isEnabledFor((Priority)Level.ERROR)) {
                            LOG.error((Object)"Invalid response CredDoc, aborting connection");
                            return;
                        }
                        element2 = message.getMessageElement("JXTASOC", "stream");
                        if (element2 != null) {
                            this.isStream = element2.toString().equals("true");
                        }
                        this.msgr = JxtaSocket.lightweightOutputPipe(this.group, pa, peerAdv);
                        if (this.isStream) {
                            this.createRis();
                        }
                        String string = this.finalLock;
                        synchronized (string) {
                            this.waiting = false;
                            this.finalLock.notifyAll();
                        }
                    }
                    catch (IOException e) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block29;
                        LOG.error((Object)"failed to process response message", (Throwable)e);
                    }
                }
            }
            if ((element2 = message.getMessageElement("JXTASOC", "close")) != null) {
                try {
                    this.closeFromRemote();
                }
                catch (IOException ie) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block30;
                    LOG.error((Object)"failed during closeFromRemote", (Throwable)ie);
                }
            }
        }
        if (!this.isStream) {
            block31: {
                element2 = message.getMessageElement("JXTASOC", "data");
                if (element2 == null) {
                    return;
                }
                try {
                    this.queue.push(element2, -1L);
                }
                catch (InterruptedException e) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block31;
                    LOG.debug((Object)"Interrupted", (Throwable)e);
                }
            }
            return;
        }
        Message.ElementIterator i = message.getMessageElements("jxtarel", Defs.MIME_TYPE_ACK);
        if (i != null && i.hasNext()) {
            if (this.ros != null) {
                this.ros.recv(message);
            }
            return;
        }
        i = message.getMessageElements("jxtarel", Defs.MIME_TYPE_BLOCK);
        if (i != null && i.hasNext()) {
            try {
                CredDoc = this.finalLock;
                synchronized (CredDoc) {
                    while (this.waiting) {
                        this.finalLock.wait(this.timeout);
                    }
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (this.ris != null) {
                this.ris.recv(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputPipeEvent(OutputPipeEvent event) {
        OutputPipe op = event.getOutputPipe();
        if (op.getAdvertisement() == null && LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)"The output pipe has no internal pipe advertisement. Continueing anyway.");
        }
        if (op.getAdvertisement() == null || this.pipeAdv.equals(op.getAdvertisement())) {
            String string = this.acceptLock;
            synchronized (string) {
                if (this.connectOutpipe == null) {
                    this.connectOutpipe = op;
                    op = null;
                }
                this.acceptLock.notifyAll();
            }
            if (op != null) {
                op.close();
            }
        } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)("Unexpected OutputPipe :" + op));
        }
    }

    protected static Messenger lightweightOutputPipe(PeerGroup group, PipeAdvertisement pipeAdv, PeerAdvertisement peer) {
        EndpointAddress addr;
        EndpointService endpoint = group.getEndpointService();
        ID opId = pipeAdv.getPipeID();
        String destPeer = peer.getPeerID().getUniqueValue().toString();
        if (pipeAdv.getType().equals("JxtaUnicast")) {
            addr = new EndpointAddress("jxta", destPeer, "PipeService", opId.toString());
        } else if (pipeAdv.getType().equals("JxtaUnicastSecure")) {
            addr = new EndpointAddress("jxtatls", destPeer, "PipeService", opId.toString());
        } else {
            return null;
        }
        return endpoint.getMessenger(addr);
    }

    protected boolean checkCred(StructuredDocument cred) {
        return true;
    }

    private void sendClose() {
        block2: {
            Message msg = new Message();
            msg.addMessageElement("JXTASOC", new StringMessageElement("close", "close", null));
            try {
                this.msgr.sendMessage(msg);
            }
            catch (IOException ie) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"failed during close", (Throwable)ie);
            }
        }
    }

    public synchronized int getSoTimeout() throws IOException {
        this.checkState();
        return this.timeout;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.checkState();
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        String string = this.closeLock;
        synchronized (string) {
            return this.closed;
        }
    }

    protected void write(byte[] buf, int offset, int length) throws IOException {
        this.checkState();
        if (this.isStream) {
            this.ros.write(buf, offset, length);
            return;
        }
        byte[] bufCopy = new byte[length];
        System.arraycopy(buf, offset, bufCopy, 0, length);
        Message msg = new Message();
        msg.addMessageElement("JXTASOC", new ByteArrayMessageElement("data", MimeMediaType.AOS, bufCopy, offset, length, null));
        this.msgr.sendMessage(msg);
    }

    protected int read() throws IOException {
        this.checkState();
        if (this.isStream) {
            return this.ris.read();
        }
        int result = -1;
        InputStream in = this.getCurrentStream();
        if (in != null && (result = in.read()) == -1) {
            this.closeCurrentStream();
            result = this.read();
        }
        return result;
    }

    protected int read(byte[] b, int off, int len) throws IOException {
        this.checkState();
        if (this.isStream) {
            return this.ris.read(b, off, len);
        }
        int result = -1;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            result = 0;
        } else {
            InputStream in = this.getCurrentStream();
            if (in != null && (result = in.read(b, off, len)) == -1) {
                this.closeCurrentStream();
                result = this.read(b, off, len);
            }
        }
        return result;
    }

    protected int available() throws IOException {
        this.checkState();
        if (this.isStream) {
            return this.ris.available();
        }
        int result = 0;
        InputStream in = this.getCurrentStream();
        if (in != null) {
            result = in.available();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getCurrentStream() throws IOException {
        String string = this.instrLock;
        synchronized (string) {
            if (this.currentMsgStream == null) {
                MessageElement me;
                try {
                    me = (MessageElement)this.queue.pop(0L);
                }
                catch (InterruptedException e) {
                    throw new IOException(e.toString());
                }
                if (me != null) {
                    this.currentMsgStream = me.getStream();
                }
            }
            return this.currentMsgStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrentStream() throws IOException {
        String string = this.instrLock;
        synchronized (string) {
            if (this.currentMsgStream != null) {
                this.currentMsgStream.close();
                this.currentMsgStream = null;
            }
        }
    }

    private void checkState() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket not bound");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

