/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import net.jxta.credential.Credential;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.InputStreamMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.JxtaServerPipe;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JxtaBiDiPipe
implements PipeMsgListener,
OutputPipeListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$util$JxtaBiDiPipe == null ? (class$net$jxta$util$JxtaBiDiPipe = JxtaBiDiPipe.class$("net.jxta.util.JxtaBiDiPipe")) : class$net$jxta$util$JxtaBiDiPipe).getName());
    protected PeerGroup group;
    protected PipeAdvertisement pipeAdv;
    private PipeAdvertisement remotePipeAdv;
    private PeerID peerid;
    private PeerAdvertisement remotePeerAdv;
    protected PipeAdvertisement myPipeAdv;
    protected PipeService pipeSvc;
    protected InputPipe in;
    protected OutputPipe connectOutpipe;
    protected Messenger msgr;
    protected InputStream stream;
    private Object closeLock = new Object();
    private Object acceptLock = new Object();
    protected Object finalLock = new Object();
    protected boolean closed = false;
    protected boolean bound = false;
    protected PipeMsgListener listener;
    protected Credential credential = null;
    protected StructuredDocument credentialDoc = null;
    private int timeout = 120000;
    protected boolean waiting;
    private UnbiasedQueue queue;
    static /* synthetic */ Class class$net$jxta$util$JxtaBiDiPipe;

    protected JxtaBiDiPipe(PeerGroup group, Messenger msgr, PipeAdvertisement pipe) throws IOException {
        this.group = group;
        this.pipeAdv = pipe;
        this.pipeSvc = group.getPipeService();
        this.credentialDoc = JxtaBiDiPipe.getCredDoc(group);
        this.in = this.pipeSvc.createInputPipe(pipe, this);
        this.msgr = msgr;
        this.queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue());
        this.setBound();
    }

    public JxtaBiDiPipe() {
    }

    public JxtaBiDiPipe(PeerGroup group, PipeAdvertisement pipeAd, PipeMsgListener listener) throws IOException {
        this.connect(group, null, pipeAd, this.timeout, listener);
    }

    public JxtaBiDiPipe(PeerGroup group, PipeAdvertisement pipeAd, int timeout, PipeMsgListener listener) throws IOException {
        this.connect(group, null, pipeAd, timeout, listener);
    }

    public void connect(PeerGroup group, PipeAdvertisement pipeAd) throws IOException {
        this.connect(group, pipeAd, this.timeout);
    }

    public void connect(PeerGroup group, PipeAdvertisement pipeAd, int timeout) throws IOException {
        this.connect(group, null, pipeAd, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(PeerGroup group, PeerID peerid, PipeAdvertisement pipeAd, int timeout, PipeMsgListener listener) throws IOException {
        block21: {
            Message openMsg;
            block20: {
                this.pipeAdv = pipeAd;
                this.group = group;
                this.listener = listener;
                this.pipeSvc = group.getPipeService();
                this.timeout = timeout;
                this.peerid = peerid;
                this.myPipeAdv = JxtaServerPipe.newInputPipe(group, pipeAd);
                this.in = this.pipeSvc.createInputPipe(this.myPipeAdv, this);
                this.credentialDoc = JxtaBiDiPipe.getCredDoc(group);
                openMsg = this.createOpenMessage(group, this.myPipeAdv);
                if (peerid == null) {
                    this.pipeSvc.createOutputPipe(pipeAd, this);
                } else {
                    this.pipeSvc.createOutputPipe(pipeAd, peerid, (OutputPipeListener)this);
                }
                try {
                    Object object = this.acceptLock;
                    synchronized (object) {
                        if (this.connectOutpipe == null) {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Waiting for " + timeout + " msec"));
                            }
                            this.acceptLock.wait(timeout);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block20;
                    LOG.debug((Object)"Interrupted", (Throwable)ie);
                }
            }
            if (this.connectOutpipe == null) {
                throw new IOException("connection timeout");
            }
            this.waiting = true;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Sending a backchannel message");
            }
            this.connectOutpipe.send(openMsg);
            try {
                Object ie = this.finalLock;
                synchronized (ie) {
                    if (this.waiting) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Waiting for " + timeout + " msec for back channel to be established"));
                        }
                        this.finalLock.wait(timeout);
                        if (this.msgr == null) {
                            throw new IOException("connection timeout");
                        }
                    }
                }
            }
            catch (InterruptedException ie) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block21;
                LOG.debug((Object)"Interrupted", (Throwable)ie);
            }
        }
        if (listener == null) {
            this.queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue());
        }
        this.setBound();
    }

    protected static StructuredDocument getCredDoc(PeerGroup group) {
        block3: {
            try {
                MembershipService membership = group.getMembershipService();
                Enumeration enumeration = membership.getCurrentCredentials();
                if (enumeration.hasMoreElements()) {
                    Credential credential = (Credential)enumeration.nextElement();
                    return credential.getDocument(MimeMediaType.XMLUTF8);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block3;
                LOG.error((Object)"failed to get credential", (Throwable)e);
            }
        }
        return null;
    }

    protected Message createOpenMessage(PeerGroup group, PipeAdvertisement pipeAd) {
        Message msg = new Message();
        PeerAdvertisement peerAdv = group.getPeerAdvertisement();
        StructuredDocument credDoc = JxtaBiDiPipe.getCredDoc(group);
        try {
            msg.addMessageElement("JXTABIP", new InputStreamMessageElement("Cred", MimeMediaType.XMLUTF8, credDoc.getStream(), null));
            msg.addMessageElement("JXTABIP", new InputStreamMessageElement("reqPipe", MimeMediaType.XMLUTF8, pipeAd.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
            msg.addMessageElement("JXTABIP", new InputStreamMessageElement("remPeer", MimeMediaType.XMLUTF8, peerAdv.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
            return msg;
        }
        catch (Throwable t) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"error getting element stream", t);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accept(JxtaBiDiPipe s) throws IOException {
        block8: {
            if (this.closed) {
                throw new IOException("Pipe is closed");
            }
            if (!this.isBound()) {
                throw new IOException("Pipe is not bound yet");
            }
            try {
                Object object = this.acceptLock;
                synchronized (object) {
                    if (this.connectOutpipe == null) {
                        this.acceptLock.wait(this.timeout);
                    }
                }
            }
            catch (InterruptedException ie) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block8;
                LOG.debug((Object)"Interrupted", (Throwable)ie);
            }
        }
    }

    void setBound() {
        this.bound = true;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Pipe Bound :true");
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public InputPipe getInputPipe() throws IOException {
        return this.in;
    }

    public Messenger getMessenger() throws IOException {
        if (this.msgr == null) {
            int count = -1;
            while (this.msgr == null && !this.closed) {
                if (++count * 500 >= this.timeout) {
                    throw new IOException("JxtaBiDiPipe timed out");
                }
                this.waiter(500);
            }
        }
        if (this.closed) {
            throw new IOException("JxtaBiDiPipe is closed");
        }
        return this.msgr;
    }

    protected synchronized void waiter(int timeMilisecs) {
        try {
            this.wait(timeMilisecs);
        }
        catch (Exception e) {
            LOG.error((Object)"error waiting", (Throwable)e);
        }
    }

    public PeerAdvertisement getRemotePeerAdvertisement() {
        return this.remotePeerAdv;
    }

    public PipeAdvertisement getRemotePipeAdvertisement() {
        return this.remotePipeAdv;
    }

    protected void setRemotePeerAdvertisement(PeerAdvertisement peer) {
        this.remotePeerAdv = peer;
    }

    protected void setRemotePipeAdvertisement(PipeAdvertisement pipe) {
        this.remotePipeAdv = pipe;
    }

    public void close() throws IOException {
        this.sendClose();
        this.closePipe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closePipe() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.in.close();
            this.msgr.close();
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Pipe close complete");
        }
        this.closed = true;
    }

    protected void setInputPipe(InputPipe in) {
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeMsgEvent(PipeMsgEvent event) {
        MessageElement element2;
        Message message = event.getMessage();
        if (message == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Empty event");
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Pipe message arrived");
        }
        if ((element2 = message.getMessageElement("JXTABIP", "remPipe")) != null) {
            block26: {
                try {
                    StructuredDocument CredDoc = null;
                    InputStream in = element2.getStream();
                    this.remotePipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(element2.getMimeType(), in);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Recevied a pipe Advertisement :" + this.remotePipeAdv.getName()));
                    }
                    if ((element2 = message.getMessageElement("JXTABIP", "remPeer")) != null) {
                        in = element2.getStream();
                        this.remotePeerAdv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(element2.getMimeType(), in);
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Recevied an Peer Advertisement :" + this.remotePeerAdv.getName()));
                        }
                    } else {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)" BAD connect response");
                        }
                        return;
                    }
                    element2 = message.getMessageElement("JXTABIP", "Cred");
                    if (element2 != null) {
                        in = element2.getStream();
                        CredDoc = StructuredDocumentFactory.newStructuredDocument(element2.getMimeType(), in);
                    }
                    if ((CredDoc == null || !this.checkCred(CredDoc)) && LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"BAD CredDoc");
                        return;
                    }
                    this.msgr = JxtaBiDiPipe.lightweightOutputPipe(this.group, this.remotePipeAdv, this.remotePeerAdv);
                    Object object = this.finalLock;
                    synchronized (object) {
                        this.waiting = false;
                        this.finalLock.notifyAll();
                    }
                }
                catch (IOException e) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block26;
                    LOG.debug((Object)"failed to get credential", (Throwable)e);
                }
            }
            return;
        }
        element2 = message.getMessageElement("JXTABIP", "close");
        if (element2 != null) {
            block27: {
                try {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"Recevied a pipe close request, closing pipes");
                    }
                    this.closePipe();
                }
                catch (IOException ie) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block27;
                    LOG.warn((Object)"failed during close", (Throwable)ie);
                }
            }
            return;
        }
        if (this.listener == null) {
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"push message onto queue");
                }
                this.queue.push(event, -1L);
            }
            catch (InterruptedException ie) {}
        } else {
            this.dequeue();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"calling message listener");
            }
            this.listener.pipeMsgEvent(event);
        }
    }

    private void dequeue() {
        while (this.queue != null && this.queue.getCurrentInQueue() > 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"dequeing messages onto message listener");
            }
            this.listener.pipeMsgEvent((PipeMsgEvent)this.queue.pop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputPipeEvent(OutputPipeEvent event) {
        OutputPipe op = event.getOutputPipe();
        if (op.getAdvertisement() == null) {
            LOG.warn((Object)"The output pipe has no internal pipe advertisement. Continueing anyway.");
        }
        if (op.getAdvertisement() == null || this.pipeAdv.equals(op.getAdvertisement())) {
            Object object = this.acceptLock;
            synchronized (object) {
                this.connectOutpipe = op;
                this.acceptLock.notifyAll();
            }
        } else {
            LOG.warn((Object)"Invalid OutputPipe, OutputPipe does not match");
        }
    }

    protected static Messenger lightweightOutputPipe(PeerGroup group, PipeAdvertisement pipeAdv, PeerAdvertisement peer) {
        EndpointAddress addr;
        EndpointService endpoint = group.getEndpointService();
        ID opId = pipeAdv.getPipeID();
        String destPeer = peer.getPeerID().getUniqueValue().toString();
        if (pipeAdv.getType().equals("JxtaUnicast")) {
            addr = new EndpointAddress("jxta", destPeer, "PipeService", opId.toString());
        } else if (pipeAdv.getType().equals("JxtaUnicastSecure")) {
            addr = new EndpointAddress("jxtatls", destPeer, "PipeService", opId.toString());
        } else {
            return null;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Creating a lightweightOutputPipe()");
        }
        return endpoint.getMessenger(addr);
    }

    protected boolean checkCred(StructuredDocument cred) {
        return true;
    }

    private void sendClose() {
        block2: {
            Message msg = new Message();
            msg.addMessageElement("JXTABIP", new StringMessageElement("close", "close", null));
            try {
                this.msgr.sendMessage(msg);
            }
            catch (IOException ie) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                LOG.error((Object)"failed during close", (Throwable)ie);
            }
        }
    }

    public PipeMsgListener getListener() {
        return this.listener;
    }

    public void setListener(PipeMsgListener listener) {
        this.listener = listener;
        this.dequeue();
    }

    public Message getMessage(int timeout) throws InterruptedException {
        if (this.queue == null || this.listener != null) {
            return null;
        }
        PipeMsgEvent ev = (PipeMsgEvent)this.queue.pop(timeout);
        if (ev != null) {
            return ev.getMessage();
        }
        return null;
    }

    public PipeAdvertisement getPipeAdvertisement() {
        return this.pipeAdv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

