/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.endpoint.InputStreamMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.id.IDFactory;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.JxtaBiDiPipe;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JxtaServerPipe
implements PipeMsgListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$util$JxtaServerPipe == null ? (class$net$jxta$util$JxtaServerPipe = JxtaServerPipe.class$("net.jxta.util.JxtaServerPipe")) : class$net$jxta$util$JxtaServerPipe).getName());
    public static final String nameSpace = "JXTABIP";
    public static final String credTag = "Cred";
    public static final String reqPipeTag = "reqPipe";
    public static final String remPeerTag = "remPeer";
    public static final String remPipeTag = "remPipe";
    public static final String closeTag = "close";
    private PeerGroup group;
    private InputPipe serverPipe;
    private PipeAdvertisement pipeadv;
    private int backlog = 50;
    private int timeout = 120000;
    private Object closeLock = new Object();
    private UnbiasedQueue queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue());
    private boolean created = false;
    private boolean bound = false;
    private boolean closed = false;
    private boolean stop = false;
    static /* synthetic */ Class class$net$jxta$util$JxtaServerPipe;

    public JxtaServerPipe(PeerGroup group, PipeAdvertisement pipeadv) throws IOException {
        this(group, pipeadv, 50);
    }

    public JxtaServerPipe(PeerGroup group, PipeAdvertisement pipeadv, int backlog, int timeout) throws IOException {
        this(group, pipeadv, backlog);
        this.timeout = timeout;
    }

    public JxtaServerPipe(PeerGroup group, PipeAdvertisement pipeadv, int backlog) throws IOException {
        this.group = group;
        this.pipeadv = pipeadv;
        this.backlog = backlog;
        this.queue.setMaxQueueSize(backlog);
        PipeService pipeSvc = group.getPipeService();
        this.serverPipe = pipeSvc.createInputPipe(pipeadv, this);
        this.setBound();
    }

    public void bind(PeerGroup group, PipeAdvertisement pipeadv) throws IOException {
        this.group = group;
        this.pipeadv = pipeadv;
        PipeService pipeSvc = group.getPipeService();
        this.serverPipe = pipeSvc.createInputPipe(pipeadv, this);
        this.setBound();
    }

    public void bind(PeerGroup group, PipeAdvertisement pipeadv, int backlog) throws IOException {
        this.backlog = backlog;
        this.bind(group, pipeadv);
    }

    public JxtaBiDiPipe accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        try {
            do {
                Message msg;
                if ((msg = (Message)this.queue.pop(this.timeout)) == null) {
                    throw new SocketException("timed out");
                }
                JxtaBiDiPipe socket = this.processMessage(msg);
                if (socket == null) continue;
                return socket;
            } while (this.timeout <= 0);
            throw new SocketException("timed out");
        }
        catch (InterruptedException ie) {
            block6: {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block6;
                LOG.debug((Object)"Interrupted", (Throwable)ie);
            }
            return null;
        }
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public PipeAdvertisement getPipeAdv() {
        return this.pipeadv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.created) {
                this.stop = true;
                this.serverPipe.close();
            }
            this.closed = true;
        }
    }

    void setBound() {
        this.bound = true;
    }

    void setCreated() {
        this.created = true;
    }

    public synchronized int getPipeTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.timeout;
    }

    public synchronized void setPipeTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        block3: {
            Message message = event.getMessage();
            if (message == null) {
                return;
            }
            try {
                this.queue.push(message, -1L);
            }
            catch (InterruptedException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block3;
                LOG.debug((Object)"Interrupted", (Throwable)e);
            }
        }
    }

    private JxtaBiDiPipe processMessage(Message msg) {
        block7: {
            PipeAdvertisement outputPipeAdv = null;
            PeerAdvertisement peerAdv = null;
            StructuredDocument CredDoc = null;
            try {
                Messenger msgr;
                InputStream in;
                MessageElement el = msg.getMessageElement(nameSpace, credTag);
                if (el != null) {
                    in = el.getStream();
                    CredDoc = StructuredDocumentFactory.newStructuredDocument(el.getMimeType(), in);
                }
                if (CredDoc == null || !this.checkCred(CredDoc)) {
                    return null;
                }
                el = msg.getMessageElement(nameSpace, reqPipeTag);
                if (el != null) {
                    in = el.getStream();
                    outputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(el.getMimeType(), in);
                }
                if ((el = msg.getMessageElement(nameSpace, remPeerTag)) != null) {
                    in = el.getStream();
                    peerAdv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(el.getMimeType(), in);
                }
                if ((msgr = JxtaBiDiPipe.lightweightOutputPipe(this.group, outputPipeAdv, peerAdv)) != null) {
                    PipeAdvertisement newpipe = JxtaServerPipe.newInputPipe(this.group, outputPipeAdv);
                    JxtaBiDiPipe newsoc = new JxtaBiDiPipe(this.group, msgr, newpipe);
                    newsoc.setRemotePeerAdvertisement(peerAdv);
                    newsoc.setRemotePipeAdvertisement(outputPipeAdv);
                    this.sendResponseMessage(this.group, msgr, newpipe);
                    return newsoc;
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block7;
                LOG.debug((Object)"IOException occured", (Throwable)e);
            }
        }
        return null;
    }

    private void sendResponseMessage(PeerGroup group, Messenger msgr, PipeAdvertisement pipeAd) throws IOException {
        block2: {
            Message msg = new Message();
            PeerAdvertisement peerAdv = group.getPeerAdvertisement();
            StructuredDocument credDoc = JxtaBiDiPipe.getCredDoc(group);
            try {
                msg.addMessageElement(nameSpace, new InputStreamMessageElement(credTag, MimeMediaType.XMLUTF8, credDoc.getStream(), null));
                msg.addMessageElement(nameSpace, new InputStreamMessageElement(remPipeTag, MimeMediaType.XMLUTF8, pipeAd.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
                msg.addMessageElement(nameSpace, new InputStreamMessageElement(remPeerTag, MimeMediaType.XMLUTF8, peerAdv.getDocument(MimeMediaType.XMLUTF8).getStream(), null));
                msgr.sendMessage(msg);
            }
            catch (Throwable t) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                LOG.debug((Object)"error getting element stream", t);
            }
        }
    }

    private boolean checkCred(StructuredDocument cred) {
        return true;
    }

    protected static PipeAdvertisement newInputPipe(PeerGroup group, PipeAdvertisement pipeadv) {
        PipeAdvertisement adv = null;
        adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        adv.setPipeID(IDFactory.newPipeID(group.getPeerGroupID()));
        adv.setName(pipeadv.getName());
        adv.setType(pipeadv.getType());
        return adv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

