/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import net.jxta.exception.JxtaException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.PipeID;

public class JxtaUtilities {
    private static ResourceBundle userResourceBundle;
    public static Enumeration EMPTY_ENUMERATOR;
    public static Iterator EMPTY_ITERATOR;
    private static DateFormat timeFormatter;

    public static ID getIdFromString(String urlText) throws JxtaException {
        try {
            return IDFactory.fromURL(IDFactory.jxtaURL(urlText));
        }
        catch (Exception e) {
            throw new JxtaException("Unable to convert to an ID: " + urlText, e);
        }
    }

    public static ID getIdFromString(String protocol, String host, String file) throws JxtaException {
        try {
            return IDFactory.fromURL(IDFactory.jxtaURL(protocol, host, file));
        }
        catch (Exception e) {
            throw new JxtaException("Unable to convert to an ID: " + protocol + ", " + host + ", " + file, e);
        }
    }

    public static PipeID createPipeID(PeerGroup peerGroup) {
        return IDFactory.newPipeID(peerGroup.getPeerGroupID());
    }

    public static String prettyTime() {
        return JxtaUtilities.prettyTime(System.currentTimeMillis());
    }

    public static String prettyTime(long time) {
        Date date = new Date(time);
        return timeFormatter.format(date);
    }

    public static ResourceBundle getUserResourceBundle() {
        if (userResourceBundle == null) {
            userResourceBundle = ResourceBundle.getBundle("net.jxta.user");
        }
        return userResourceBundle;
    }

    static {
        EMPTY_ENUMERATOR = new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
        EMPTY_ITERATOR = new Iterator(){

            public boolean hasNext() {
                return false;
            }

            public Object next() {
                return null;
            }

            public void remove() {
            }
        };
        timeFormatter = DateFormat.getTimeInstance();
    }
}

