/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;

public final class MessageUtilities {
    private MessageUtilities() {
    }

    public static void addInt(Message message, String tagName, int value) {
        StringMessageElement stringMessageElement = new StringMessageElement(tagName, Integer.toString(value), null);
        message.addMessageElement(stringMessageElement);
    }

    public static int getInt(Message message, String tagName, int defaultValue) {
        StringMessageElement stringMessageElement = (StringMessageElement)message.getMessageElement(tagName);
        if (stringMessageElement != null) {
            return Integer.parseInt(stringMessageElement.toString());
        }
        return defaultValue;
    }

    public static void addLong(Message message, String tagName, long value) {
        StringMessageElement stringMessageElement = new StringMessageElement(tagName, Long.toString(value), null);
        message.addMessageElement(stringMessageElement);
    }

    public static long getLong(Message message, String tagName, long defaultValue) {
        StringMessageElement stringMessageElement = (StringMessageElement)message.getMessageElement(tagName);
        if (stringMessageElement != null) {
            return Long.parseLong(stringMessageElement.toString());
        }
        return defaultValue;
    }

    public static void addDouble(Message message, String tagName, double value) {
        StringMessageElement stringMessageElement = new StringMessageElement(tagName, Double.toString(value), null);
        message.addMessageElement(stringMessageElement);
    }

    public static double getDouble(Message message, String tagName, double defaultValue) {
        StringMessageElement stringMessageElement = (StringMessageElement)message.getMessageElement(tagName);
        if (stringMessageElement != null) {
            return Double.parseDouble(stringMessageElement.toString());
        }
        return defaultValue;
    }

    public static void addBoolean(Message message, String tagName, boolean value) {
        StringMessageElement stringMessageElement = new StringMessageElement(tagName, value ? "true" : "false", null);
        message.addMessageElement(stringMessageElement);
    }

    public static boolean getBoolean(Message message, String tagName, boolean defaultValue) {
        StringMessageElement stringMessageElement = (StringMessageElement)message.getMessageElement(tagName);
        if (stringMessageElement != null) {
            return "true".equals(stringMessageElement.toString());
        }
        return defaultValue;
    }

    public static void addString(Message message, String tagName, String value) {
        StringMessageElement stringMessageElement = new StringMessageElement(tagName, value, null);
        message.addMessageElement(stringMessageElement);
    }

    public static String getString(Message message, String tagName, String defaultValue) {
        MessageElement stringMessageElement = message.getMessageElement(tagName);
        if (stringMessageElement != null) {
            return stringMessageElement.toString();
        }
        return defaultValue;
    }
}

